/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui.changes;

import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.diff.chains.AsyncDiffRequestChain;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.comparison.ComparisonManagerImpl;
import com.intellij.diff.comparison.ComparisonPolicy;
import com.intellij.diff.comparison.iterables.DiffIterable;
import com.intellij.diff.comparison.iterables.DiffIterableUtil;
import com.intellij.diff.tools.util.text.LineOffsets;
import com.intellij.diff.tools.util.text.LineOffsetsUtil;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUserDataKeysEx;
import com.intellij.diff.util.Range;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NonEmptyActionGroup;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.diff.impl.GenericDataProvider;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.actions.diff.ChangeDiffRequestProducer;
import com.intellij.openapi.vcs.ex.RangesBuilder;
import com.intellij.openapi.vcs.history.VcsDiffUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewSupport;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewSupportImpl;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewResolvedThreadsToggleAction;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewThreadsReloadAction;
import org.jetbrains.plugins.github.pullrequest.comment.action.GHPRDiffReviewThreadsToggleAction;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangeDiffData;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangesProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRDiffRequestChainProducer;
import org.jetbrains.plugins.github.util.ChangeDiffRequestProducerFactory;
import org.jetbrains.plugins.github.util.DiffRequestChainProducer;
import org.jetbrains.plugins.github.util.GHToolbarLabelAction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B7\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ \u0010\u0013\u001a\u0012\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u0015\u0012\u0004\u0012\u00020\u00160\u00142\u0006\u0010\u0017\u001a\u00020\u0018H\u0014J\u001a\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0016\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00180 H\u0016J\u001a\u0010!\u001a\u0004\u0018\u00010\"2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002JJ\u0010#\u001a\u0018\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00160\u0015\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00142\u0006\u0010$\u001a\u00020%2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u001c0'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020)0'H\u0002R\u0018\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u0010X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006*"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRDiffRequestChainProducer;", "Lorg/jetbrains/plugins/github/util/DiffRequestChainProducer;", "project", "Lcom/intellij/openapi/project/Project;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "changeProducerFactory", "Lorg/jetbrains/plugins/github/util/ChangeDiffRequestProducerFactory;", "getChangeProducerFactory$intellij_vcs_github", "()Lorg/jetbrains/plugins/github/util/ChangeDiffRequestProducerFactory;", "createCustomContext", "", "Lcom/intellij/openapi/util/Key;", "", "change", "Lcom/intellij/openapi/vcs/changes/Change;", "getDiffComputer", "Lcom/intellij/diff/util/DiffUserDataKeysEx$DiffComputer;", "changesProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProvider;", "getRequestChain", "Lcom/intellij/diff/chains/DiffRequestChain;", "changes", "Lcom/intellij/openapi/ListSelection;", "getReviewSupport", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHPRDiffReviewSupport;", "loadRequestDataKeys", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "changesProviderFuture", "Ljava/util/concurrent/CompletableFuture;", "fetchFuture", "Ljava/lang/Void;", "intellij.vcs.github"})
public class GHPRDiffRequestChainProducer
implements DiffRequestChainProducer {
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRDataProvider dataProvider;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final GHUser currentUser;
    @NotNull
    private final ChangeDiffRequestProducerFactory changeProducerFactory;

    public GHPRDiffRequestChainProducer(@NotNull Project project, @NotNull GHPRDataProvider dataProvider, @NotNull IconsProvider<String> avatarIconsProvider, @NotNull GHPRRepositoryDataService repositoryDataService, @NotNull GHUser currentUser) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        this.project = project;
        this.dataProvider = dataProvider;
        this.avatarIconsProvider = avatarIconsProvider;
        this.repositoryDataService = repositoryDataService;
        this.currentUser = currentUser;
        this.changeProducerFactory = new ChangeDiffRequestProducerFactory(this){
            @NotNull
            private final GHPRChangesDataProvider changesData;
            @NotNull
            private final CompletableFuture<GHPRChangesProvider> changesProviderFuture;
            private final CompletableFuture<Void> fetchFuture;
            final /* synthetic */ GHPRDiffRequestChainProducer this$0;
            {
                this.this$0 = $receiver;
                this.changesData = GHPRDiffRequestChainProducer.access$getDataProvider$p($receiver).getChangesData();
                this.changesProviderFuture = this.changesData.loadChanges();
                CompletableFuture[] completableFutureArray = new CompletableFuture[]{this.changesData.fetchBaseBranch(), this.changesData.fetchHeadBranch()};
                this.fetchFuture = CompletableFuture.allOf(completableFutureArray);
            }

            @NotNull
            public final GHPRChangesDataProvider getChangesData() {
                return this.changesData;
            }

            @NotNull
            public final CompletableFuture<GHPRChangesProvider> getChangesProviderFuture() {
                return this.changesProviderFuture;
            }

            public final CompletableFuture<Void> getFetchFuture() {
                return this.fetchFuture;
            }

            @Nullable
            public DiffRequestProducer create(@Nullable Project project, @NotNull Change change) {
                Intrinsics.checkNotNullParameter((Object)change, (String)"change");
                ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                if (progressIndicator == null) {
                    progressIndicator = (ProgressIndicator)new EmptyProgressIndicator();
                }
                ProgressIndicator indicator = progressIndicator;
                CompletableFuture<Void> completableFuture = this.fetchFuture;
                Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"fetchFuture");
                Map changeDataKeys = GHPRDiffRequestChainProducer.access$loadRequestDataKeys(this.this$0, indicator, change, this.changesProviderFuture, completableFuture);
                Map<Key<?>, Object> customDataKeys = this.this$0.createCustomContext(change);
                return (DiffRequestProducer)ChangeDiffRequestProducer.create((Project)project, (Change)change, (Map)MapsKt.plus((Map)changeDataKeys, customDataKeys));
            }
        };
    }

    @NotNull
    public final ChangeDiffRequestProducerFactory getChangeProducerFactory$intellij_vcs_github() {
        return this.changeProducerFactory;
    }

    @Override
    @NotNull
    public DiffRequestChain getRequestChain(@NotNull ListSelection<Change> changes) {
        Intrinsics.checkNotNullParameter(changes, (String)"changes");
        return (DiffRequestChain)new AsyncDiffRequestChain(changes, this){
            final /* synthetic */ ListSelection<Change> $changes;
            final /* synthetic */ GHPRDiffRequestChainProducer this$0;
            {
                this.$changes = $changes;
                this.this$0 = $receiver;
            }

            @NotNull
            protected ListSelection<? extends DiffRequestProducer> loadRequestProducers() {
                ListSelection listSelection = this.$changes.map(arg_0 -> getRequestChain.1.loadRequestProducers$lambda$0((Function1)new Function1<Change, DiffRequestProducer>(this.this$0){
                    final /* synthetic */ GHPRDiffRequestChainProducer this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    @Nullable
                    public final DiffRequestProducer invoke(Change change) {
                        ChangeDiffRequestProducerFactory changeDiffRequestProducerFactory = this.this$0.getChangeProducerFactory$intellij_vcs_github();
                        Project project = GHPRDiffRequestChainProducer.access$getProject$p(this.this$0);
                        Intrinsics.checkNotNullExpressionValue((Object)change, (String)"change");
                        return changeDiffRequestProducerFactory.create(project, change);
                    }
                }, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)listSelection, (String)"override fun getRequestC\u2026ange) }\n      }\n    }\n  }");
                return listSelection;
            }

            private static final DiffRequestProducer loadRequestProducers$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (DiffRequestProducer)$tmp0.invoke(p0);
            }
        };
    }

    @NotNull
    protected Map<Key<?>, Object> createCustomContext(@NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return MapsKt.emptyMap();
    }

    private final Map<Key<? extends Object>, Object> loadRequestDataKeys(ProgressIndicator indicator, Change change, CompletableFuture<GHPRChangesProvider> changesProviderFuture, CompletableFuture<Void> fetchFuture) {
        GHPRDiffReviewSupport reviewSupport;
        GHPRChangesProvider changesProvider = (GHPRChangesProvider)ProgressIndicatorUtils.awaitWithCheckCanceled((Future)changesProviderFuture, (ProgressIndicator)indicator);
        ProgressIndicatorUtils.awaitWithCheckCanceled((Future)fetchFuture, (ProgressIndicator)indicator);
        Map requestDataKeys = new LinkedHashMap();
        VcsDiffUtil.putFilePathsIntoChangeContext((Change)change, (Map)requestDataKeys);
        Intrinsics.checkNotNullExpressionValue((Object)changesProvider, (String)"changesProvider");
        DiffUserDataKeysEx.DiffComputer diffComputer = this.getDiffComputer(changesProvider, change);
        if (diffComputer != null) {
            Map map2 = requestDataKeys;
            Key key = DiffUserDataKeysEx.CUSTOM_DIFF_COMPUTER;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"CUSTOM_DIFF_COMPUTER");
            map2.put(key, diffComputer);
        }
        if ((reviewSupport = this.getReviewSupport(changesProvider, change)) != null) {
            GenericDataProvider genericDataProvider;
            requestDataKeys.put(GHPRDiffReviewSupport.Companion.getKEY(), reviewSupport);
            Map map3 = requestDataKeys;
            Key key = DiffUserDataKeys.DATA_PROVIDER;
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"DATA_PROVIDER");
            Object object = key;
            GenericDataProvider $this$loadRequestDataKeys_u24lambda_u240 = genericDataProvider = new GenericDataProvider();
            boolean bl = false;
            $this$loadRequestDataKeys_u24lambda_u240.putData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER(), (Object)this.dataProvider);
            $this$loadRequestDataKeys_u24lambda_u240.putData(GHPRDiffReviewSupport.Companion.getDATA_KEY(), (Object)reviewSupport);
            map3.put(object, genericDataProvider);
            object = new NonEmptyActionGroup();
            Key $this$loadRequestDataKeys_u24lambda_u241 = object;
            boolean bl2 = false;
            $this$loadRequestDataKeys_u24lambda_u241.setPopup(true);
            $this$loadRequestDataKeys_u24lambda_u241.getTemplatePresentation().setText(GithubBundle.message("pull.request.diff.view.options", new Object[0]));
            $this$loadRequestDataKeys_u24lambda_u241.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
            $this$loadRequestDataKeys_u24lambda_u241.add((AnAction)new GHPRDiffReviewThreadsToggleAction());
            $this$loadRequestDataKeys_u24lambda_u241.add((AnAction)new GHPRDiffReviewResolvedThreadsToggleAction());
            Key viewOptionsGroup = object;
            object = requestDataKeys;
            Key key2 = DiffUserDataKeys.CONTEXT_ACTIONS;
            Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"CONTEXT_ACTIONS");
            genericDataProvider = key2;
            Object object2 = new AnAction[4];
            String string = GithubBundle.message("pull.request.diff.review.label", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.diff.review.label\")");
            object2[0] = (AnAction)new GHToolbarLabelAction(string);
            object2[1] = (AnAction)viewOptionsGroup;
            object2[2] = (AnAction)new GHPRDiffReviewThreadsReloadAction();
            object2[3] = ActionManager.getInstance().getAction("Github.PullRequest.Review.Submit");
            object2 = CollectionsKt.listOf((Object[])object2);
            object.put(genericDataProvider, object2);
        }
        return requestDataKeys;
    }

    private final GHPRDiffReviewSupport getReviewSupport(GHPRChangesProvider changesProvider, Change change) {
        GHPRChangeDiffData gHPRChangeDiffData = changesProvider.findChangeDiffData(change);
        if (gHPRChangeDiffData == null) {
            return null;
        }
        GHPRChangeDiffData diffData = gHPRChangeDiffData;
        return new GHPRDiffReviewSupportImpl(this.project, this.dataProvider.getReviewData(), this.dataProvider.getDetailsData(), this.avatarIconsProvider, this.repositoryDataService, diffData, this.currentUser);
    }

    private final DiffUserDataKeysEx.DiffComputer getDiffComputer(GHPRChangesProvider changesProvider, Change change) {
        Object object = changesProvider.findChangeDiffData(change);
        if (object == null || (object = ((GHPRChangeDiffData)object).getDiffRangesWithoutContext()) == null) {
            return null;
        }
        Object diffRanges2 = object;
        return (arg_0, arg_1, arg_2, arg_3, arg_4) -> GHPRDiffRequestChainProducer.getDiffComputer$lambda$3((List)diffRanges2, change, arg_0, arg_1, arg_2, arg_3, arg_4);
    }

    /*
     * WARNING - void declaration
     */
    private static final List getDiffComputer$lambda$3(List $diffRanges, Change $change, CharSequence text1, CharSequence text2, ComparisonPolicy policy, boolean innerChanges, ProgressIndicator indicator) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)$diffRanges, (String)"$diffRanges");
        Intrinsics.checkNotNullParameter((Object)$change, (String)"$change");
        Intrinsics.checkNotNullParameter((Object)text1, (String)"text1");
        Intrinsics.checkNotNullParameter((Object)text2, (String)"text2");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        ComparisonManagerImpl comparisonManagerImpl = ComparisonManagerImpl.getInstanceImpl();
        Intrinsics.checkNotNullExpressionValue((Object)comparisonManagerImpl, (String)"getInstanceImpl()");
        ComparisonManagerImpl comparisonManager = comparisonManagerImpl;
        LineOffsets lineOffsets = LineOffsetsUtil.create((CharSequence)text1);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets, (String)"create(text1)");
        LineOffsets lineOffsets1 = lineOffsets;
        LineOffsets lineOffsets2 = LineOffsetsUtil.create((CharSequence)text2);
        Intrinsics.checkNotNullExpressionValue((Object)lineOffsets2, (String)"create(text2)");
        LineOffsets lineOffsets22 = lineOffsets2;
        if (!RangesBuilder.isValidRanges((CharSequence)text1, (CharSequence)text2, (LineOffsets)lineOffsets1, (LineOffsets)lineOffsets22, (List)$diffRanges)) {
            throw new IllegalStateException(("Invalid diff line ranges for change " + $change).toString());
        }
        DiffIterable diffIterable = DiffIterableUtil.create((List)$diffRanges, (int)lineOffsets1.getLineCount(), (int)lineOffsets22.getLineCount());
        Intrinsics.checkNotNullExpressionValue((Object)diffIterable, (String)"create(diffRanges, lineO\u2026, lineOffsets2.lineCount)");
        DiffIterable iterable = diffIterable;
        Iterable iterable2 = DiffIterableUtil.iterateAll((DiffIterable)iterable);
        Intrinsics.checkNotNullExpressionValue((Object)iterable2, (String)"iterateAll(iterable)");
        Iterable $this$map$iv = iterable2;
        boolean $i$f$map = false;
        Iterable iterable3 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Pair pair = (Pair)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(comparisonManager.compareLinesInner((Range)it.first, text1, text2, lineOffsets1, lineOffsets22, policy, innerChanges, indicator));
        }
        return CollectionsKt.flatten((Iterable)((List)destination$iv$iv));
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRDiffRequestChainProducer $this) {
        return $this.project;
    }

    public static final /* synthetic */ GHPRDataProvider access$getDataProvider$p(GHPRDiffRequestChainProducer $this) {
        return $this.dataProvider;
    }

    public static final /* synthetic */ Map access$loadRequestDataKeys(GHPRDiffRequestChainProducer $this, ProgressIndicator indicator, Change change, CompletableFuture changesProviderFuture, CompletableFuture fetchFuture) {
        return $this.loadRequestDataKeys(indicator, change, changesProviderFuture, fetchFuture);
    }
}

