/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.ui;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHSimpleLoadingModel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\b\u0010\b\u001a\u00020\tH\u0016J*\u0010\n\u001a\b\u0012\u0004\u0012\u00028\u00000\u000b2\u0006\u0010\f\u001a\u00020\u00072\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00028\u00000\u000eH\u0007J\b\u0010\u000f\u001a\u00020\tH\u0007R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/ui/GHIOExecutorLoadingModel;", "T", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHSimpleLoadingModel;", "Lcom/intellij/openapi/Disposable;", "parentDisposable", "(Lcom/intellij/openapi/Disposable;)V", "currentProgressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "dispose", "", "load", "Ljava/util/concurrent/CompletableFuture;", "progressIndicator", "task", "Lkotlin/Function1;", "reset", "intellij.vcs.github"})
public final class GHIOExecutorLoadingModel<T>
extends GHSimpleLoadingModel<T>
implements Disposable {
    @Nullable
    private ProgressIndicator currentProgressIndicator;

    public GHIOExecutorLoadingModel(@NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
    }

    @RequiresEdt
    @NotNull
    public final CompletableFuture<T> load(@NotNull ProgressIndicator progressIndicator, @NotNull Function1<? super ProgressIndicator, ? extends T> task2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        if (Disposer.isDisposed((Disposable)this)) {
            CompletableFuture completableFuture = CompletableFuture.failedFuture(new ProcessCanceledException());
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"failedFuture(ProcessCanceledException())");
            return completableFuture;
        }
        ProgressIndicator progressIndicator2 = this.currentProgressIndicator;
        if (progressIndicator2 != null) {
            progressIndicator2.cancel();
        }
        this.currentProgressIndicator = progressIndicator;
        this.setError(null);
        this.setLoading(true);
        ((GHLoadingModel.StateChangeListener)this.getEventDispatcher().getMulticaster()).onLoadingStarted();
        ProgressManager progressManager = ProgressManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)progressManager, (String)"getInstance()");
        return CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)CompletableFutureUtil.errorOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)CompletableFutureUtil.INSTANCE.submitIOTask(progressManager, progressIndicator, task2), null, (Function1)new Function1<T, T>(progressIndicator, this){
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ GHIOExecutorLoadingModel<T> this$0;
            {
                this.$progressIndicator = $progressIndicator;
                this.this$0 = $receiver;
                super(1);
            }

            public final T invoke(T it) {
                if (this.$progressIndicator.isCanceled()) {
                    return it;
                }
                this.this$0.setResult(it);
                this.this$0.setResultAvailable(true);
                return it;
            }
        }, (int)1, null), null, (Function1)((Function1)new Function1<Throwable, Unit>(progressIndicator, this){
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ GHIOExecutorLoadingModel<T> this$0;
            {
                this.$progressIndicator = $progressIndicator;
                this.this$0 = $receiver;
                super(1);
            }

            public final void invoke(@NotNull Throwable it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (this.$progressIndicator.isCanceled() || CompletableFutureUtil.INSTANCE.isCancellation(it)) {
                    return;
                }
                this.this$0.setError(it);
                this.this$0.setResultAvailable(false);
            }
        }), (int)1, null), null, (Function0)((Function0)new Function0<Unit>(progressIndicator, this){
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ GHIOExecutorLoadingModel<T> this$0;
            {
                this.$progressIndicator = $progressIndicator;
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.$progressIndicator.isCanceled()) {
                    return;
                }
                this.this$0.setLoading(false);
                GHIOExecutorLoadingModel.access$setCurrentProgressIndicator$p(this.this$0, null);
                ((GHLoadingModel.StateChangeListener)this.this$0.getEventDispatcher().getMulticaster()).onLoadingCompleted();
            }
        }), (int)1, null);
    }

    @RequiresEdt
    public final void reset() {
        ProgressIndicator progressIndicator = this.currentProgressIndicator;
        if (progressIndicator != null) {
            progressIndicator.cancel();
        }
        this.currentProgressIndicator = null;
        this.setLoading(false);
        this.setResult(null);
        this.setResultAvailable(false);
        this.setError(null);
        ((GHLoadingModel.StateChangeListener)this.getEventDispatcher().getMulticaster()).onReset();
    }

    public void dispose() {
        this.reset();
    }

    public static final /* synthetic */ void access$setCurrentProgressIndicator$p(GHIOExecutorLoadingModel $this, ProgressIndicator progressIndicator) {
        $this.currentProgressIndicator = progressIndicator;
    }
}

