/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.service;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import java.util.concurrent.CompletableFuture;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHBranchProtectionRules;
import org.jetbrains.plugins.github.api.data.GHRepositoryPermissionLevel;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubPullRequestMergeMethod;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestMergeabilityData;
import org.jetbrains.plugins.github.pullrequest.GHPRStatisticsCollector;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityState;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMergeabilityStateBuilder;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRStateService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHServiceUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 '2\u00020\u0001:\u0001'B/\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u001e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J(\u0010\u0016\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00170\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J8\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u00192\b\u0010\u001e\u001a\u0004\u0018\u00010\u0017H\u0016J\u001e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J:\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\"2\u0006\u0010#\u001a\u00020\u0019H\u0016J&\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010#\u001a\u00020\u0019H\u0016J\u001e\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J:\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00190\"2\u0006\u0010#\u001a\u00020\u0019H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006("}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateServiceImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;", "progressManager", "Lcom/intellij/openapi/progress/ProgressManager;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "requestExecutor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "repoPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "(Lcom/intellij/openapi/progress/ProgressManager;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;Lorg/jetbrains/plugins/github/api/GithubServerPath;Lorg/jetbrains/plugins/github/api/GHRepositoryPath;)V", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "close", "Ljava/util/concurrent/CompletableFuture;", "", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "loadBranchProtectionRules", "Lorg/jetbrains/plugins/github/api/data/GHBranchProtectionRules;", "baseBranch", "", "loadMergeabilityState", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMergeabilityState;", "headRefOid", "prHtmlUrl", "baseBranchProtectionRules", "markReadyForReview", "merge", "commitMessage", "Lkotlin/Pair;", "currentHeadRef", "rebaseMerge", "reopen", "squashMerge", "Companion", "intellij.vcs.github"})
public final class GHPRStateServiceImpl
implements GHPRStateService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProgressManager progressManager;
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GithubApiRequestExecutor requestExecutor;
    @NotNull
    private final GithubServerPath serverPath;
    @NotNull
    private final GHRepositoryPath repoPath;
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private static final Logger LOG;

    public GHPRStateServiceImpl(@NotNull ProgressManager progressManager, @NotNull GHPRSecurityService securityService, @NotNull GithubApiRequestExecutor requestExecutor, @NotNull GithubServerPath serverPath, @NotNull GHRepositoryPath repoPath) {
        Intrinsics.checkNotNullParameter((Object)progressManager, (String)"progressManager");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)requestExecutor, (String)"requestExecutor");
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)repoPath, (String)"repoPath");
        this.progressManager = progressManager;
        this.securityService = securityService;
        this.requestExecutor = requestExecutor;
        this.serverPath = serverPath;
        this.repoPath = repoPath;
        this.repository = new GHRepositoryCoordinates(this.serverPath, this.repoPath);
    }

    @Override
    @NotNull
    public CompletableFuture<GHBranchProtectionRules> loadBranchProtectionRules(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String baseBranch) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)baseBranch, (String)"baseBranch");
        if (!this.securityService.currentUserHasPermissionLevel(GHRepositoryPermissionLevel.WRITE)) {
            CompletableFuture<Object> completableFuture = CompletableFuture.completedFuture(null);
            Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"completedFuture(null)");
            return completableFuture;
        }
        return CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHBranchProtectionRules>(this, baseBranch){
            final /* synthetic */ GHPRStateServiceImpl this$0;
            final /* synthetic */ String $baseBranch;
            {
                this.this$0 = $receiver;
                this.$baseBranch = $baseBranch;
                super(1);
            }

            @Nullable
            public final GHBranchProtectionRules invoke(@NotNull ProgressIndicator it) {
                GHBranchProtectionRules gHBranchProtectionRules;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    gHBranchProtectionRules = GHPRStateServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.Branches.getProtection(GHPRStateServiceImpl.access$getRepository$p(this.this$0), this.$baseBranch));
                }
                catch (Exception e) {
                    if (!(e instanceof ProcessCanceledException)) {
                        GHPRStateServiceImpl.access$getLOG$cp().info("Error occurred while loading branch protection rules for " + this.$baseBranch, (Throwable)e);
                    }
                    gHBranchProtectionRules = null;
                }
                return gHBranchProtectionRules;
            }
        });
    }

    @Override
    @NotNull
    public CompletableFuture<GHPRMergeabilityState> loadMergeabilityState(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String headRefOid, @NotNull String prHtmlUrl, @Nullable GHBranchProtectionRules baseBranchProtectionRules) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)headRefOid, (String)"headRefOid");
        Intrinsics.checkNotNullParameter((Object)prHtmlUrl, (String)"prHtmlUrl");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, GHPRMergeabilityState>(this, pullRequestId, headRefOid, prHtmlUrl, baseBranchProtectionRules){
            final /* synthetic */ GHPRStateServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ String $headRefOid;
            final /* synthetic */ String $prHtmlUrl;
            final /* synthetic */ GHBranchProtectionRules $baseBranchProtectionRules;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                this.$headRefOid = $headRefOid;
                this.$prHtmlUrl = $prHtmlUrl;
                this.$baseBranchProtectionRules = $baseBranchProtectionRules;
                super(1);
            }

            @NotNull
            public final GHPRMergeabilityState invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPullRequestMergeabilityData gHPullRequestMergeabilityData = (GHPullRequestMergeabilityData)GHPRStateServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.INSTANCE.mergeabilityData(GHPRStateServiceImpl.access$getRepository$p(this.this$0), this.$pullRequestId.getNumber()));
                if (gHPullRequestMergeabilityData == null) {
                    throw new IllegalStateException(("Could not find pull request " + this.$pullRequestId + ".number").toString());
                }
                GHPullRequestMergeabilityData mergeabilityData = gHPullRequestMergeabilityData;
                GHPRMergeabilityStateBuilder builder = new GHPRMergeabilityStateBuilder(this.$headRefOid, this.$prHtmlUrl, mergeabilityData);
                if (this.$baseBranchProtectionRules != null) {
                    builder.withRestrictions(GHPRStateServiceImpl.access$getSecurityService$p(this.this$0), this.$baseBranchProtectionRules);
                }
                return builder.build();
            }
        }), LOG, "Error occurred while loading mergeability state data for PR " + pullRequestId.getNumber());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> close(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Unit>(this, pullRequestId){
            final /* synthetic */ GHPRStateServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                super(1);
            }

            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPRStateServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.PullRequests.update$default(GHPRStateServiceImpl.access$getServerPath$p(this.this$0), GHPRStateServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRStateServiceImpl.access$getRepoPath$p(this.this$0).getRepository(), this.$pullRequestId.getNumber(), null, null, GithubIssueState.closed, null, null, 432, null));
            }
        }), LOG, "Error occurred while closing PR " + pullRequestId.getNumber());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> reopen(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Unit>(this, pullRequestId){
            final /* synthetic */ GHPRStateServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                super(1);
            }

            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPRStateServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.PullRequests.update$default(GHPRStateServiceImpl.access$getServerPath$p(this.this$0), GHPRStateServiceImpl.access$getRepoPath$p(this.this$0).getOwner(), GHPRStateServiceImpl.access$getRepoPath$p(this.this$0).getRepository(), this.$pullRequestId.getNumber(), null, null, GithubIssueState.open, null, null, 432, null));
            }
        }), LOG, "Error occurred while reopening PR " + pullRequestId.getNumber());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> markReadyForReview(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Unit>(this, pullRequestId){
            final /* synthetic */ GHPRStateServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                super(1);
            }

            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPRStateServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, (GithubApiRequest)GHGQLRequests.PullRequest.INSTANCE.markReadyForReview(GHPRStateServiceImpl.access$getRepository$p(this.this$0), this.$pullRequestId.getId()));
            }
        }), LOG, "Error occurred while marking PR " + pullRequestId.getNumber() + " ready fro review");
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> merge(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull Pair<String, String> commitMessage, @NotNull String currentHeadRef) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter(commitMessage, (String)"commitMessage");
        Intrinsics.checkNotNullParameter((Object)currentHeadRef, (String)"currentHeadRef");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Unit>(this, pullRequestId, commitMessage, currentHeadRef){
            final /* synthetic */ GHPRStateServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ Pair<String, String> $commitMessage;
            final /* synthetic */ String $currentHeadRef;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                this.$commitMessage = $commitMessage;
                this.$currentHeadRef = $currentHeadRef;
                super(1);
            }

            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPRStateServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.PullRequests.merge(GHPRStateServiceImpl.access$getServerPath$p(this.this$0), GHPRStateServiceImpl.access$getRepoPath$p(this.this$0), this.$pullRequestId.getNumber(), (String)this.$commitMessage.getFirst(), (String)this.$commitMessage.getSecond(), this.$currentHeadRef));
                GHPRStatisticsCollector.INSTANCE.logMergedEvent(GithubPullRequestMergeMethod.merge);
            }
        }), LOG, "Error occurred while merging PR " + pullRequestId.getNumber());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> rebaseMerge(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull String currentHeadRef) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)currentHeadRef, (String)"currentHeadRef");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Unit>(this, pullRequestId, currentHeadRef){
            final /* synthetic */ GHPRStateServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ String $currentHeadRef;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                this.$currentHeadRef = $currentHeadRef;
                super(1);
            }

            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPRStateServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.PullRequests.rebaseMerge(GHPRStateServiceImpl.access$getServerPath$p(this.this$0), GHPRStateServiceImpl.access$getRepoPath$p(this.this$0), this.$pullRequestId.getNumber(), this.$currentHeadRef));
                GHPRStatisticsCollector.INSTANCE.logMergedEvent(GithubPullRequestMergeMethod.rebase);
            }
        }), LOG, "Error occurred while rebasing PR " + pullRequestId.getNumber());
    }

    @Override
    @NotNull
    public CompletableFuture<Unit> squashMerge(@NotNull ProgressIndicator progressIndicator, @NotNull GHPRIdentifier pullRequestId, @NotNull Pair<String, String> commitMessage, @NotNull String currentHeadRef) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter(commitMessage, (String)"commitMessage");
        Intrinsics.checkNotNullParameter((Object)currentHeadRef, (String)"currentHeadRef");
        return GHServiceUtil.INSTANCE.logError(CompletableFutureUtil.INSTANCE.submitIOTask(this.progressManager, progressIndicator, (Function1)new Function1<ProgressIndicator, Unit>(this, pullRequestId, commitMessage, currentHeadRef){
            final /* synthetic */ GHPRStateServiceImpl this$0;
            final /* synthetic */ GHPRIdentifier $pullRequestId;
            final /* synthetic */ Pair<String, String> $commitMessage;
            final /* synthetic */ String $currentHeadRef;
            {
                this.this$0 = $receiver;
                this.$pullRequestId = $pullRequestId;
                this.$commitMessage = $commitMessage;
                this.$currentHeadRef = $currentHeadRef;
                super(1);
            }

            public final void invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                GHPRStateServiceImpl.access$getRequestExecutor$p(this.this$0).execute(it, GithubApiRequests.Repos.PullRequests.squashMerge(GHPRStateServiceImpl.access$getServerPath$p(this.this$0), GHPRStateServiceImpl.access$getRepoPath$p(this.this$0), this.$pullRequestId.getNumber(), (String)this.$commitMessage.getFirst(), (String)this.$commitMessage.getSecond(), this.$currentHeadRef));
                GHPRStatisticsCollector.INSTANCE.logMergedEvent(GithubPullRequestMergeMethod.squash);
            }
        }), LOG, "Error occurred while squash-merging PR " + pullRequestId.getNumber());
    }

    public static final /* synthetic */ GithubApiRequestExecutor access$getRequestExecutor$p(GHPRStateServiceImpl $this) {
        return $this.requestExecutor;
    }

    public static final /* synthetic */ GHRepositoryCoordinates access$getRepository$p(GHPRStateServiceImpl $this) {
        return $this.repository;
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    public static final /* synthetic */ GHPRSecurityService access$getSecurityService$p(GHPRStateServiceImpl $this) {
        return $this.securityService;
    }

    public static final /* synthetic */ GithubServerPath access$getServerPath$p(GHPRStateServiceImpl $this) {
        return $this.serverPath;
    }

    public static final /* synthetic */ GHRepositoryPath access$getRepoPath$p(GHPRStateServiceImpl $this) {
        return $this.repoPath;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRStateService.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateServiceImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

