/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data.provider;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.diff.util.Side;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.util.messages.MessageBus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHActor;
import org.jetbrains.plugins.github.api.data.GHCommitHash;
import org.jetbrains.plugins.github.api.data.GHNode;
import org.jetbrains.plugins.github.api.data.GHNodes;
import org.jetbrains.plugins.github.api.data.GHPullRequestReviewEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestPendingReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewComment;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewCommentState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewCommentWithPendingReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewState;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewThread;
import org.jetbrains.plugins.github.api.data.request.GHPullRequestDraftReviewComment;
import org.jetbrains.plugins.github.api.data.request.GHPullRequestDraftReviewThread;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataOperationsListener;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRReviewService;
import org.jetbrains.plugins.github.util.LazyCancellableBackgroundProcessValue;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u009c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0012\u0018\u00002\u00020\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ(\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001dH\u0016J@\u0010\u0017\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010!\u001a\u00020\u001d2\u0006\u0010\"\u001a\u00020#H\u0016J\u001e\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00022\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0(H\u0016J\u001e\u0010)\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00022\f\u0010'\u001a\b\u0012\u0004\u0012\u00020%0(H\u0016J\b\u0010*\u001a\u00020+H\u0016JT\u0010,\u001a\b\u0012\u0004\u0012\u00020\f0\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010-\u001a\u0004\u0018\u00010.2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001d2\b\u0010 \u001a\u0004\u0018\u00010\u001d2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u000200\u0018\u00010\u000e2\u000e\u00101\u001a\n\u0012\u0004\u0012\u000202\u0018\u00010\u000eH\u0016JH\u00103\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u001d2\u0006\u0010\u001e\u001a\u00020\u001d2\u0006\u00104\u001a\u00020#2\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u00020#2\u0006\u0010!\u001a\u00020\u001dH\u0016J \u00108\u001a\n\u0012\u0006\b\u0001\u0012\u0002090\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001dH\u0016J\"\u0010;\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001090\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010<\u001a\u00020%H\u0016J\u0015\u0010=\u001a\u000f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u0018\u00a2\u0006\u0002\b\u0012H\u0016J\u0019\u0010>\u001a\u0013\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u0018\u00a2\u0006\u0002\b\u0012H\u0016J\b\u0010?\u001a\u00020%H\u0016J\b\u0010@\u001a\u00020%H\u0016J\u001e\u0010A\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u001dH\u0016J4\u0010C\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001090\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010-\u001a\u00020.2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0016J\u001e\u0010D\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010B\u001a\u00020\u001dH\u0016J&\u0010E\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010:\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u001dH\u0016J&\u0010G\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00182\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u001dH\u0016J\u001e\u0010H\u001a\b\u0012\u0004\u0012\u0002HI0\u0018\"\u0004\b\u0000\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0018H\u0002J\u001e\u0010J\u001a\b\u0012\u0004\u0012\u0002HI0\u0018\"\u0004\b\u0000\u0010I*\b\u0012\u0004\u0012\u0002HI0\u0018H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\n\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u000e0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0010\u001a\u00070\u0011\u00a2\u0006\u0002\b\u00128VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\u0016\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006K"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProviderImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "Lcom/intellij/openapi/Disposable;", "reviewService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewService;", "pullRequestId", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "messageBus", "Lcom/intellij/util/messages/MessageBus;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewService;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;Lcom/intellij/util/messages/MessageBus;)V", "pendingReviewRequestValue", "Lorg/jetbrains/plugins/github/util/LazyCancellableBackgroundProcessValue;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestPendingReview;", "reviewThreadsRequestValue", "", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "submitReviewCommentDocument", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "getSubmitReviewCommentDocument", "()Lcom/intellij/openapi/editor/Document;", "submitReviewCommentDocument$delegate", "Lkotlin/Lazy;", "addComment", "Ljava/util/concurrent/CompletableFuture;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewComment;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "replyToCommentId", "", "body", "reviewId", "commitSha", "fileName", "diffLine", "", "addPendingReviewListener", "", "disposable", "listener", "Lkotlin/Function0;", "addReviewThreadsListener", "canComment", "", "createReview", "event", "Lorg/jetbrains/plugins/github/api/data/GHPullRequestReviewEvent;", "comments", "Lorg/jetbrains/plugins/github/api/data/request/GHPullRequestDraftReviewComment;", "threads", "Lorg/jetbrains/plugins/github/api/data/request/GHPullRequestDraftReviewThread;", "createThread", "line", "side", "Lcom/intellij/diff/util/Side;", "startLine", "deleteComment", "", "commentId", "deleteReview", "dispose", "loadPendingReview", "loadReviewThreads", "resetPendingReview", "resetReviewThreads", "resolveThread", "id", "submitReview", "unresolveThread", "updateComment", "newText", "updateReviewBody", "dropReviews", "T", "notifyReviews", "intellij.vcs.github"})
public final class GHPRReviewDataProviderImpl
implements GHPRReviewDataProvider,
Disposable {
    @NotNull
    private final GHPRReviewService reviewService;
    @NotNull
    private final GHPRIdentifier pullRequestId;
    @NotNull
    private final MessageBus messageBus;
    @NotNull
    private final Lazy submitReviewCommentDocument$delegate;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<GHPullRequestPendingReview> pendingReviewRequestValue;
    @NotNull
    private final LazyCancellableBackgroundProcessValue<List<GHPullRequestReviewThread>> reviewThreadsRequestValue;

    public GHPRReviewDataProviderImpl(@NotNull GHPRReviewService reviewService, @NotNull GHPRIdentifier pullRequestId, @NotNull MessageBus messageBus2) {
        Intrinsics.checkNotNullParameter((Object)reviewService, (String)"reviewService");
        Intrinsics.checkNotNullParameter((Object)pullRequestId, (String)"pullRequestId");
        Intrinsics.checkNotNullParameter((Object)messageBus2, (String)"messageBus");
        this.reviewService = reviewService;
        this.pullRequestId = pullRequestId;
        this.messageBus = messageBus2;
        this.submitReviewCommentDocument$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)submitReviewCommentDocument.2.INSTANCE);
        this.pendingReviewRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<GHPullRequestPendingReview>>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<GHPullRequestPendingReview> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).loadPendingReview(it, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0));
            }
        });
        this.reviewThreadsRequestValue = LazyCancellableBackgroundProcessValue.Companion.create((Function1)new Function1<ProgressIndicator, CompletableFuture<List<? extends GHPullRequestReviewThread>>>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final CompletableFuture<List<GHPullRequestReviewThread>> invoke(@NotNull ProgressIndicator it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).loadReviewThreads(it, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0));
            }
        });
    }

    @Override
    @NotNull
    public Document getSubmitReviewCommentDocument() {
        Lazy lazy = this.submitReviewCommentDocument$delegate;
        return (Document)lazy.getValue();
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestPendingReview> loadPendingReview() {
        Object object = this.pendingReviewRequestValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"pendingReviewRequestValue.value");
        return (CompletableFuture)object;
    }

    @Override
    public void resetPendingReview() {
        this.pendingReviewRequestValue.drop();
    }

    @Override
    @NotNull
    public CompletableFuture<List<GHPullRequestReviewThread>> loadReviewThreads() {
        Object object = this.reviewThreadsRequestValue.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"reviewThreadsRequestValue.value");
        return (CompletableFuture)object;
    }

    @Override
    public void resetReviewThreads() {
        this.reviewThreadsRequestValue.drop();
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestPendingReview> createReview(@NotNull ProgressIndicator progressIndicator, @Nullable GHPullRequestReviewEvent event, @Nullable String body2, @Nullable String commitSha, @Nullable List<GHPullRequestDraftReviewComment> comments, @Nullable List<GHPullRequestDraftReviewThread> threads) {
        Collection collection;
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        CompletableFuture<GHPullRequestPendingReview> future2 = this.notifyReviews(this.reviewService.createReview(progressIndicator, this.pullRequestId, event, body2, commitSha, comments, threads));
        if (event == null) {
            this.pendingReviewRequestValue.overrideProcess(CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, future2, null, (Function1)createReview.1.INSTANCE, (int)1, null));
        }
        return ((collection = (Collection)comments) == null || collection.isEmpty()) && ((collection = (Collection)threads) == null || collection.isEmpty()) ? future2 : this.dropReviews(future2);
    }

    @Override
    @NotNull
    public CompletableFuture<? extends Object> submitReview(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull GHPullRequestReviewEvent event, @Nullable String body2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)((Object)event), (String)"event");
        CompletableFuture<? extends Object> future2 = this.reviewService.submitReview(progressIndicator, this.pullRequestId, reviewId, event, body2);
        this.pendingReviewRequestValue.overrideProcess(CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, future2, null, (Function1)submitReview.1.INSTANCE, (int)1, null));
        return this.notifyReviews(this.dropReviews(future2));
    }

    @Override
    @NotNull
    public CompletableFuture<String> updateReviewBody(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        return CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, this.reviewService.updateReviewBody(progressIndicator, reviewId, newText), null, (Function1)((Function1)new Function1<GHPullRequestReview, String>(this, reviewId, newText){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            final /* synthetic */ String $reviewId;
            final /* synthetic */ String $newText;
            {
                this.this$0 = $receiver;
                this.$reviewId = $reviewId;
                this.$newText = $newText;
                super(1);
            }

            @NotNull
            public final String invoke(@NotNull GHPullRequestReview it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                ((GHPRDataOperationsListener)GHPRReviewDataProviderImpl.access$getMessageBus$p(this.this$0).syncPublisher(GHPRDataOperationsListener.Companion.getTOPIC())).onReviewUpdated(this.$reviewId, this.$newText);
                return it.getBody();
            }
        }), (int)1, null);
    }

    @Override
    @NotNull
    public CompletableFuture<? extends Object> deleteReview(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        CompletableFuture<? extends Object> future2 = this.reviewService.deleteReview(progressIndicator, this.pullRequestId, reviewId);
        this.pendingReviewRequestValue.combineResult(future2, (Function2)new Function2<GHPullRequestPendingReview, ?, GHPullRequestPendingReview>(reviewId){
            final /* synthetic */ String $reviewId;
            {
                this.$reviewId = $reviewId;
                super(2);
            }

            @Nullable
            public final GHPullRequestPendingReview invoke(@Nullable GHPullRequestPendingReview pendingReview, @Nullable Object object) {
                if (pendingReview != null && Intrinsics.areEqual((Object)pendingReview.getId(), (Object)this.$reviewId)) {
                    throw new ProcessCanceledException();
                }
                return pendingReview;
            }
        });
        return this.notifyReviews(this.dropReviews(future2));
    }

    @Override
    public boolean canComment() {
        return this.reviewService.canComment();
    }

    @Override
    @NotNull
    public CompletableFuture<? extends GHPullRequestReviewComment> addComment(@NotNull ProgressIndicator progressIndicator, @NotNull String reviewId, @NotNull String body2, @NotNull String commitSha, @NotNull String fileName, int diffLine) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        CompletableFuture<GHPullRequestReviewCommentWithPendingReview> future2 = this.reviewService.addComment(progressIndicator, reviewId, body2, commitSha, fileName, diffLine);
        this.pendingReviewRequestValue.overrideProcess(CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, future2, null, (Function1)addComment.1.INSTANCE, (int)1, null));
        return this.notifyReviews(this.dropReviews(future2));
    }

    @Override
    @NotNull
    public CompletableFuture<? extends GHPullRequestReviewComment> addComment(@NotNull ProgressIndicator progressIndicator, @NotNull String replyToCommentId, @NotNull String body2) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)replyToCommentId, (String)"replyToCommentId");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        CompletionStage completionStage = ((CompletableFuture)this.pendingReviewRequestValue.getValue()).thenCompose(arg_0 -> GHPRReviewDataProviderImpl.addComment$lambda$0((Function1)new Function1<GHPullRequestPendingReview, CompletionStage<GHPullRequestReviewCommentWithPendingReview>>(this, progressIndicator, replyToCommentId, body2){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ String $replyToCommentId;
            final /* synthetic */ String $body;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$replyToCommentId = $replyToCommentId;
                this.$body = $body;
                super(1);
            }

            public final CompletionStage<GHPullRequestReviewCommentWithPendingReview> invoke(@Nullable GHPullRequestPendingReview it) {
                CompletionStage completionStage;
                String reviewId;
                GHPullRequestPendingReview gHPullRequestPendingReview = it;
                String string = reviewId = gHPullRequestPendingReview != null ? gHPullRequestPendingReview.getId() : null;
                if (reviewId == null) {
                    completionStage = GHPRReviewDataProvider.createReview$default(this.this$0, this.$progressIndicator, null, null, null, null, null, 62, null).thenCompose(arg_0 -> addComment.2.invoke$lambda$0((Function1)new Function1<GHPullRequestPendingReview, CompletionStage<GHPullRequestReviewCommentWithPendingReview>>(this.this$0, this.$progressIndicator, this.$replyToCommentId, this.$body){
                        final /* synthetic */ GHPRReviewDataProviderImpl this$0;
                        final /* synthetic */ ProgressIndicator $progressIndicator;
                        final /* synthetic */ String $replyToCommentId;
                        final /* synthetic */ String $body;
                        {
                            this.this$0 = $receiver;
                            this.$progressIndicator = $progressIndicator;
                            this.$replyToCommentId = $replyToCommentId;
                            this.$body = $body;
                            super(1);
                        }

                        public final CompletionStage<GHPullRequestReviewCommentWithPendingReview> invoke(GHPullRequestPendingReview review2) {
                            CompletionStage completionStage = GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).addComment(this.$progressIndicator, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0), review2.getId(), this.$replyToCommentId, this.$body).thenCompose(arg_0 -> addComment.1.invoke$lambda$0((Function1)new Function1<GHPullRequestReviewCommentWithPendingReview, CompletionStage<GHPullRequestReviewCommentWithPendingReview>>(this.this$0, this.$progressIndicator, review2){
                                final /* synthetic */ GHPRReviewDataProviderImpl this$0;
                                final /* synthetic */ ProgressIndicator $progressIndicator;
                                final /* synthetic */ GHPullRequestPendingReview $review;
                                {
                                    this.this$0 = $receiver;
                                    this.$progressIndicator = $progressIndicator;
                                    this.$review = $review;
                                    super(1);
                                }

                                public final CompletionStage<GHPullRequestReviewCommentWithPendingReview> invoke(GHPullRequestReviewCommentWithPendingReview comment) {
                                    return this.this$0.submitReview(this.$progressIndicator, this.$review.getId(), GHPullRequestReviewEvent.COMMENT, null).thenApply(arg_0 -> addComment.1.invoke$lambda$0(comment, arg_0));
                                }

                                private static final GHPullRequestReviewCommentWithPendingReview invoke$lambda$0(GHPullRequestReviewCommentWithPendingReview $comment, Object it) {
                                    return $comment;
                                }
                            }, arg_0));
                            Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun addComment(\u2026views()\n      }\n    }\n  }");
                            return GHPRReviewDataProviderImpl.access$notifyReviews(this.this$0, GHPRReviewDataProviderImpl.access$dropReviews(this.this$0, (CompletableFuture)completionStage));
                        }

                        private static final CompletionStage invoke$lambda$0(Function1 $tmp0, Object p0) {
                            Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                            return (CompletionStage)$tmp0.invoke(p0);
                        }
                    }, arg_0));
                } else {
                    CompletableFuture<GHPullRequestReviewCommentWithPendingReview> future2 = GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).addComment(this.$progressIndicator, GHPRReviewDataProviderImpl.access$getPullRequestId$p(this.this$0), reviewId, this.$replyToCommentId, this.$body);
                    GHPRReviewDataProviderImpl.access$getPendingReviewRequestValue$p(this.this$0).overrideProcess(CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, future2, null, (Function1)addComment.2.INSTANCE, (int)1, null));
                    completionStage = GHPRReviewDataProviderImpl.access$notifyReviews(this.this$0, GHPRReviewDataProviderImpl.access$dropReviews(this.this$0, future2));
                }
                return completionStage;
            }

            private static final CompletionStage invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (CompletionStage)$tmp0.invoke(p0);
            }
        }, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"override fun addComment(\u2026views()\n      }\n    }\n  }");
        return completionStage;
    }

    @Override
    @NotNull
    public CompletableFuture<? extends Object> deleteComment(@NotNull ProgressIndicator progressIndicator, @NotNull String commentId) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        CompletableFuture<GHPullRequestPendingReview> future2 = this.reviewService.deleteComment(progressIndicator, this.pullRequestId, commentId);
        this.pendingReviewRequestValue.overrideProcess(CompletableFutureUtil.handleOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, future2, null, (Function2)((Function2)new Function2<GHPullRequestPendingReview, Throwable, GHPullRequestPendingReview>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(2);
            }

            @Nullable
            public final GHPullRequestPendingReview invoke(@Nullable GHPullRequestPendingReview result, @Nullable Throwable error) {
                block3: {
                    block2: {
                        if (error != null) break block2;
                        GHPullRequestPendingReview gHPullRequestPendingReview = result;
                        if ((gHPullRequestPendingReview != null ? gHPullRequestPendingReview.getState() : null) != GHPullRequestReviewState.PENDING) break block2;
                        Integer n = result.getComments().getTotalCount();
                        if (n != null && n == 0) break block3;
                    }
                    ((GHPRDataOperationsListener)GHPRReviewDataProviderImpl.access$getMessageBus$p(this.this$0).syncPublisher(GHPRDataOperationsListener.Companion.getTOPIC())).onReviewsChanged();
                    throw new ProcessCanceledException();
                }
                return null;
            }
        }), (int)1, null));
        this.reviewThreadsRequestValue.combineResult(future2, (Function2)new Function2<List<? extends GHPullRequestReviewThread>, GHPullRequestPendingReview, List<? extends GHPullRequestReviewThread>>(commentId){
            final /* synthetic */ String $commentId;
            {
                this.$commentId = $commentId;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GHPullRequestReviewThread> invoke(@NotNull List<GHPullRequestReviewThread> list, @NotNull GHPullRequestPendingReview gHPullRequestPendingReview) {
                void $this$mapNotNullTo$iv$iv;
                void $this$mapNotNull$iv;
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)gHPullRequestPendingReview, (String)"<anonymous parameter 1>");
                Iterable iterable = list;
                String string = this.$commentId;
                boolean $i$f$mapNotNull = false;
                void var6_6 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                Iterator<T> iterator = $this$forEach$iv$iv$iv.iterator();
                while (iterator.hasNext()) {
                    GHPullRequestReviewThread it$iv$iv;
                    void $this$filterTo$iv$iv;
                    T element$iv$iv$iv;
                    T element$iv$iv = element$iv$iv$iv = iterator.next();
                    boolean bl = false;
                    GHPullRequestReviewThread it = (GHPullRequestReviewThread)element$iv$iv;
                    boolean bl2 = false;
                    Iterable $this$filter$iv = it.getComments();
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv2 : $this$filterTo$iv$iv) {
                        GHPullRequestReviewComment comment = (GHPullRequestReviewComment)element$iv$iv2;
                        boolean bl3 = false;
                        if (!(!Intrinsics.areEqual((Object)comment.getId(), (Object)string))) continue;
                        destination$iv$iv2.add(element$iv$iv2);
                    }
                    List comments = (List)destination$iv$iv2;
                    if ((comments.isEmpty() ? null : new GHPullRequestReviewThread(it.getId(), it.isResolved(), it.isOutdated(), it.getPath(), it.getSide(), it.getLine(), it.getStartLine(), new GHNodes<T>(comments, null, 2, null))) == null) continue;
                    it$iv$iv = it$iv$iv;
                    boolean bl4 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                return (List)destination$iv$iv;
            }
        });
        return future2;
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewComment> updateComment(@NotNull ProgressIndicator progressIndicator, @NotNull String commentId, @NotNull String newText) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
        Intrinsics.checkNotNullParameter((Object)newText, (String)"newText");
        CompletableFuture<GHPullRequestReviewComment> future2 = this.reviewService.updateComment(progressIndicator, this.pullRequestId, commentId, newText);
        this.reviewThreadsRequestValue.combineResult(future2, (Function2)new Function2<List<? extends GHPullRequestReviewThread>, GHPullRequestReviewComment, List<? extends GHPullRequestReviewThread>>(commentId){
            final /* synthetic */ String $commentId;
            {
                this.$commentId = $commentId;
                super(2);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public final List<GHPullRequestReviewThread> invoke(@NotNull List<GHPullRequestReviewThread> list, @NotNull GHPullRequestReviewComment newComment) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter(list, (String)"list");
                Intrinsics.checkNotNullParameter((Object)newComment, (String)"newComment");
                Iterable iterable = list;
                String string = this.$commentId;
                boolean $i$f$map = false;
                void var6_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    Collection<void> collection;
                    void $this$mapTo$iv$iv2;
                    void $this$map$iv2;
                    void it;
                    GHPullRequestReviewThread gHPullRequestReviewThread = (GHPullRequestReviewThread)item$iv$iv;
                    Collection collection2 = destination$iv$iv;
                    boolean bl = false;
                    Iterable iterable2 = it.getComments();
                    Integer n = it.getStartLine();
                    int n2 = it.getLine();
                    Side side = it.getSide();
                    String string2 = it.getPath();
                    boolean bl2 = it.isOutdated();
                    boolean bl3 = it.isResolved();
                    String string3 = it.getId();
                    boolean $i$f$map2 = false;
                    void var22_22 = $this$map$iv2;
                    Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv2 : $this$mapTo$iv$iv2) {
                        GHPullRequestReviewComment gHPullRequestReviewComment;
                        void comment;
                        GHPullRequestReviewComment gHPullRequestReviewComment2 = (GHPullRequestReviewComment)item$iv$iv2;
                        collection = destination$iv$iv2;
                        boolean bl4 = false;
                        if (Intrinsics.areEqual((Object)comment.getId(), (Object)string)) {
                            GHNode gHNode;
                            String string4 = comment.getId();
                            long l = comment.getDatabaseId();
                            String string5 = comment.getUrl();
                            GHActor gHActor = comment.getAuthor();
                            String string6 = newComment.getBody();
                            Date date = comment.getCreatedAt();
                            GHPullRequestReviewCommentState gHPullRequestReviewCommentState = comment.getState();
                            GHCommitHash gHCommitHash = comment.getCommit();
                            GHCommitHash gHCommitHash2 = comment.getOriginalCommit();
                            GHNode gHNode2 = comment.getReplyTo();
                            String string7 = comment.getDiffHunk();
                            if (comment.getReviewId() != null) {
                                void it2;
                                String string8 = string7;
                                GHNode gHNode3 = gHNode2;
                                GHCommitHash gHCommitHash3 = gHCommitHash2;
                                GHCommitHash gHCommitHash4 = gHCommitHash;
                                GHPullRequestReviewCommentState gHPullRequestReviewCommentState2 = gHPullRequestReviewCommentState;
                                Date date2 = date;
                                String string9 = string6;
                                GHActor gHActor2 = gHActor;
                                String string10 = string5;
                                long l2 = l;
                                String string11 = string4;
                                boolean bl5 = false;
                                GHNode gHNode4 = new GHNode((String)it2);
                                string4 = string11;
                                l = l2;
                                string5 = string10;
                                gHActor = gHActor2;
                                string6 = string9;
                                date = date2;
                                gHPullRequestReviewCommentState = gHPullRequestReviewCommentState2;
                                gHCommitHash = gHCommitHash4;
                                gHCommitHash2 = gHCommitHash3;
                                gHNode2 = gHNode3;
                                string7 = string8;
                                gHNode = gHNode4;
                            } else {
                                gHNode = null;
                            }
                            boolean bl6 = comment.getViewerCanUpdate();
                            boolean bl7 = comment.getViewerCanDelete();
                            GHNode gHNode5 = gHNode;
                            String string12 = string7;
                            GHNode gHNode6 = gHNode2;
                            GHCommitHash gHCommitHash5 = gHCommitHash2;
                            GHCommitHash gHCommitHash6 = gHCommitHash;
                            GHPullRequestReviewCommentState gHPullRequestReviewCommentState3 = gHPullRequestReviewCommentState;
                            Date date3 = date;
                            String string13 = string6;
                            GHActor gHActor3 = gHActor;
                            String string14 = string5;
                            long l3 = l;
                            String string15 = string4;
                            gHPullRequestReviewComment = new GHPullRequestReviewComment(string15, l3, string14, gHActor3, string13, date3, gHPullRequestReviewCommentState3, gHCommitHash6, gHCommitHash5, gHNode6, string12, gHNode5, bl7, bl6);
                        } else {
                            gHPullRequestReviewComment = comment;
                        }
                        collection.add((void)gHPullRequestReviewComment);
                    }
                    collection = (List)destination$iv$iv2;
                    DefaultConstructorMarker defaultConstructorMarker = null;
                    int n3 = 2;
                    Integer n4 = null;
                    Collection<void> collection3 = collection;
                    GHNodes<T> gHNodes = new GHNodes<T>((List)collection3, n4, n3, defaultConstructorMarker);
                    Integer n5 = n;
                    int n6 = n2;
                    Side side2 = side;
                    String string16 = string2;
                    boolean bl8 = bl2;
                    boolean bl9 = bl3;
                    String string17 = string3;
                    collection2.add(new GHPullRequestReviewThread(string17, bl9, bl8, string16, side2, n6, n5, gHNodes));
                }
                return (List)destination$iv$iv;
            }
        });
        return future2;
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewThread> createThread(@NotNull ProgressIndicator progressIndicator, @Nullable String reviewId, @NotNull String body2, int line, @NotNull Side side, int startLine, @NotNull String fileName) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)body2, (String)"body");
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
        CompletableFuture<GHPullRequestReviewThread> completableFuture = reviewId == null ? GHPRReviewDataProvider.createReview$default(this, progressIndicator, null, null, null, null, null, 62, null).thenCompose(arg_0 -> GHPRReviewDataProviderImpl.createThread$lambda$1((Function1)new Function1<GHPullRequestPendingReview, CompletionStage<GHPullRequestReviewThread>>(this, progressIndicator, body2, line, side, startLine, fileName){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            final /* synthetic */ ProgressIndicator $progressIndicator;
            final /* synthetic */ String $body;
            final /* synthetic */ int $line;
            final /* synthetic */ Side $side;
            final /* synthetic */ int $startLine;
            final /* synthetic */ String $fileName;
            {
                this.this$0 = $receiver;
                this.$progressIndicator = $progressIndicator;
                this.$body = $body;
                this.$line = $line;
                this.$side = $side;
                this.$startLine = $startLine;
                this.$fileName = $fileName;
                super(1);
            }

            public final CompletionStage<GHPullRequestReviewThread> invoke(GHPullRequestPendingReview review2) {
                return GHPRReviewDataProviderImpl.access$getReviewService$p(this.this$0).addThread(this.$progressIndicator, review2.getId(), this.$body, this.$line, this.$side, this.$startLine, this.$fileName).thenCompose(arg_0 -> createThread.1.invoke$lambda$0((Function1)new Function1<GHPullRequestReviewThread, CompletionStage<GHPullRequestReviewThread>>(this.this$0, this.$progressIndicator, review2){
                    final /* synthetic */ GHPRReviewDataProviderImpl this$0;
                    final /* synthetic */ ProgressIndicator $progressIndicator;
                    final /* synthetic */ GHPullRequestPendingReview $review;
                    {
                        this.this$0 = $receiver;
                        this.$progressIndicator = $progressIndicator;
                        this.$review = $review;
                        super(1);
                    }

                    public final CompletionStage<GHPullRequestReviewThread> invoke(GHPullRequestReviewThread thread) {
                        return this.this$0.submitReview(this.$progressIndicator, this.$review.getId(), GHPullRequestReviewEvent.COMMENT, null).thenApply(arg_0 -> createThread.1.invoke$lambda$0(thread, arg_0));
                    }

                    private static final GHPullRequestReviewThread invoke$lambda$0(GHPullRequestReviewThread $thread, Object it) {
                        return $thread;
                    }
                }, arg_0));
            }

            private static final CompletionStage invoke$lambda$0(Function1 $tmp0, Object p0) {
                Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                return (CompletionStage)$tmp0.invoke(p0);
            }
        }, arg_0)) : this.reviewService.addThread(progressIndicator, reviewId, body2, line, side, startLine, fileName);
        Intrinsics.checkNotNullExpressionValue(completableFuture, (String)"override fun createThrea\u2026ews().notifyReviews()\n  }");
        return this.notifyReviews(this.dropReviews(completableFuture));
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewThread> resolveThread(@NotNull ProgressIndicator progressIndicator, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CompletableFuture<GHPullRequestReviewThread> future2 = this.reviewService.resolveThread(progressIndicator, this.pullRequestId, id);
        this.reviewThreadsRequestValue.combineResult(future2, resolveThread.1.INSTANCE);
        return future2;
    }

    @Override
    @NotNull
    public CompletableFuture<GHPullRequestReviewThread> unresolveThread(@NotNull ProgressIndicator progressIndicator, @NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)progressIndicator, (String)"progressIndicator");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        CompletableFuture<GHPullRequestReviewThread> future2 = this.reviewService.unresolveThread(progressIndicator, this.pullRequestId, id);
        this.reviewThreadsRequestValue.combineResult(future2, unresolveThread.1.INSTANCE);
        return future2;
    }

    private final <T> CompletableFuture<T> notifyReviews(CompletableFuture<T> $this$notifyReviews) {
        return CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, $this$notifyReviews, null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                ((GHPRDataOperationsListener)GHPRReviewDataProviderImpl.access$getMessageBus$p(this.this$0).syncPublisher(GHPRDataOperationsListener.Companion.getTOPIC())).onReviewsChanged();
            }
        }), (int)1, null);
    }

    private final <T> CompletableFuture<T> dropReviews(CompletableFuture<T> $this$dropReviews) {
        return CompletableFutureUtil.completionOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, $this$dropReviews, null, (Function0)((Function0)new Function0<Unit>(this){
            final /* synthetic */ GHPRReviewDataProviderImpl this$0;
            {
                this.this$0 = $receiver;
                super(0);
            }

            public final void invoke() {
                GHPRReviewDataProviderImpl.access$getReviewThreadsRequestValue$p(this.this$0).drop();
            }
        }), (int)1, null);
    }

    @Override
    public void addReviewThreadsListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.reviewThreadsRequestValue.addDropEventListener(disposable, listener2);
    }

    @Override
    public void addPendingReviewListener(@NotNull Disposable disposable, @NotNull Function0<Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.pendingReviewRequestValue.addDropEventListener(disposable, listener2);
    }

    public void dispose() {
        this.pendingReviewRequestValue.drop();
        this.reviewThreadsRequestValue.drop();
    }

    private static final CompletionStage addComment$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    private static final CompletionStage createThread$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (CompletionStage)$tmp0.invoke(p0);
    }

    public static final /* synthetic */ MessageBus access$getMessageBus$p(GHPRReviewDataProviderImpl $this) {
        return $this.messageBus;
    }

    public static final /* synthetic */ CompletableFuture access$notifyReviews(GHPRReviewDataProviderImpl $this, CompletableFuture $receiver) {
        return $this.notifyReviews($receiver);
    }

    public static final /* synthetic */ CompletableFuture access$dropReviews(GHPRReviewDataProviderImpl $this, CompletableFuture $receiver) {
        return $this.dropReviews($receiver);
    }

    public static final /* synthetic */ GHPRReviewService access$getReviewService$p(GHPRReviewDataProviderImpl $this) {
        return $this.reviewService;
    }

    public static final /* synthetic */ GHPRIdentifier access$getPullRequestId$p(GHPRReviewDataProviderImpl $this) {
        return $this.pullRequestId;
    }

    public static final /* synthetic */ LazyCancellableBackgroundProcessValue access$getPendingReviewRequestValue$p(GHPRReviewDataProviderImpl $this) {
        return $this.pendingReviewRequestValue;
    }

    public static final /* synthetic */ LazyCancellableBackgroundProcessValue access$getReviewThreadsRequestValue$p(GHPRReviewDataProviderImpl $this) {
        return $this.reviewThreadsRequestValue;
    }
}

