/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFileHistory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 \u001f2\u00020\u0001:\u0002\u001f B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0016\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0004H\u0016J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0019\u001a\u00020\u0004H\u0016J.\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u001b\u001a\u00020\u00042\u0006\u0010\u001c\u001a\u00020\u00042\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u0018H\u0016R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\b\u00a8\u0006!"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMutableLinearFileHistory;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFileHistory;", "commitHashes", "", "", "(Ljava/util/List;)V", "firstKnownFilePath", "getFirstKnownFilePath", "()Ljava/lang/String;", "history", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMutableLinearFileHistory$Entry;", "lastKnownFilePath", "getLastKnownFilePath", "append", "", "commitSha", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "compare", "", "commitSha1", "commitSha2", "contains", "", "filePath", "getPatches", "parent", "child", "includeFirstKnownPatch", "includeLastPatch", "Companion", "Entry", "intellij.vcs.github"})
public final class GHPRMutableLinearFileHistory
implements GHPRFileHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, Entry> history;

    public GHPRMutableLinearFileHistory(@NotNull List<String> commitHashes) {
        Intrinsics.checkNotNullParameter(commitHashes, (String)"commitHashes");
        this.history = new LinkedHashMap();
        for (String sha : commitHashes) {
            this.history.put(sha, new Entry(null));
        }
    }

    @Nullable
    public final String getFirstKnownFilePath() {
        Entry entry;
        Object v0;
        block2: {
            Iterable iterable = this.history.values();
            for (Object t : iterable) {
                Entry it = (Entry)t;
                boolean bl = false;
                if (!(it.getPatch() != null)) continue;
                v0 = t;
                break block2;
            }
            v0 = null;
        }
        if ((entry = (Entry)v0) == null || (entry = entry.getPatch()) == null) {
            throw new IllegalStateException("Empty history".toString());
        }
        return entry.getBeforeName();
    }

    @Nullable
    public final String getLastKnownFilePath() {
        Iterable iterable = this.history.values();
        Object var3_2 = null;
        for (Object t : iterable) {
            Entry it = (Entry)t;
            boolean bl = false;
            if (!(it.getPatch() != null)) continue;
            var3_2 = t;
        }
        Entry entry = var3_2;
        if (entry == null || (entry = entry.getPatch()) == null) {
            throw new IllegalStateException("Empty history".toString());
        }
        String lastFilePath = entry.getAfterName();
        String string = lastFilePath;
        if (string == null) {
            string = this.getFirstKnownFilePath();
        }
        return string;
    }

    public final void append(@NotNull String commitSha, @NotNull TextFilePatch patch) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)patch, (String)"patch");
        Entry entry = this.history.get(commitSha);
        boolean bl2 = bl = entry != null && entry.getPatch() == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.history.put(commitSha, new Entry(patch));
    }

    @Override
    public boolean contains(@NotNull String commitSha, @NotNull String filePath) {
        Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String lastPath = null;
        for (Map.Entry<String, Entry> entry : this.history.entrySet()) {
            String sha = entry.getKey();
            Entry entry2 = entry.getValue();
            String entryPath = entry2.getFilePath();
            if (entryPath != null) {
                lastPath = entryPath;
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)commitSha) || !Intrinsics.areEqual((Object)lastPath, (Object)filePath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int compare(@NotNull String commitSha1, @NotNull String commitSha2) {
        Intrinsics.checkNotNullParameter((Object)commitSha1, (String)"commitSha1");
        Intrinsics.checkNotNullParameter((Object)commitSha2, (String)"commitSha2");
        if (Intrinsics.areEqual((Object)commitSha1, (Object)commitSha2)) {
            return 0;
        }
        Iterator<Map.Entry<String, Entry>> iterator = this.history.entrySet().iterator();
        while (iterator.hasNext()) {
            String sha = iterator.next().getKey();
            if (Intrinsics.areEqual((Object)sha, (Object)commitSha1)) {
                return -1;
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)commitSha2)) continue;
            return 1;
        }
        throw new IllegalStateException("Unknown commit sha".toString());
    }

    @Override
    @NotNull
    public List<TextFilePatch> getPatches(@NotNull String parent, @NotNull String child, boolean includeFirstKnownPatch, boolean includeLastPatch) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)child, (String)"child");
        List patches = new ArrayList();
        boolean foundParent = false;
        TextFilePatch lastFound = null;
        for (Map.Entry<String, Entry> entry : this.history.entrySet()) {
            TextFilePatch it;
            String sha = entry.getKey();
            Entry entry2 = entry.getValue();
            if (!foundParent) {
                if (entry2.getPatch() != null) {
                    lastFound = entry2.getPatch();
                }
                if (!Intrinsics.areEqual((Object)sha, (Object)parent)) continue;
                foundParent = true;
                if (includeFirstKnownPatch) continue;
                TextFilePatch textFilePatch = entry2.getPatch();
                if (textFilePatch == null && (textFilePatch = lastFound) == null) {
                    throw new IllegalStateException("Original patch was not found".toString());
                }
                TextFilePatch patchToAdd = textFilePatch;
                patches.add(patchToAdd);
                continue;
            }
            if (includeLastPatch) {
                if (Intrinsics.areEqual((Object)sha, (Object)child)) break;
                if (entry2.getPatch() != null) {
                    boolean bl = false;
                    patches.add(it);
                }
                continue;
            }
            if (entry2.getPatch() != null) {
                boolean bl = false;
                patches.add(it);
            }
            if (!Intrinsics.areEqual((Object)sha, (Object)child)) continue;
            break;
        }
        return patches;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004R\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMutableLinearFileHistory$Entry;", "", "patch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)V", "filePath", "", "getFilePath", "()Ljava/lang/String;", "getPatch", "()Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "intellij.vcs.github"})
    private static final class Entry {
        @Nullable
        private final TextFilePatch patch;
        @Nullable
        private final String filePath;

        public Entry(@Nullable TextFilePatch patch) {
            TextFilePatch textFilePatch = this.patch = patch;
            this.filePath = textFilePatch != null ? Companion.getFilePath(textFilePatch) : null;
        }

        @Nullable
        public final TextFilePatch getPatch() {
            return this.patch;
        }

        @Nullable
        public final String getFilePath() {
            return this.filePath;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0018\u0010\u0003\u001a\u00020\u0004*\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRMutableLinearFileHistory$Companion;", "", "()V", "filePath", "", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "getFilePath", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)Ljava/lang/String;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final String getFilePath(TextFilePatch $this$filePath) {
            String string = $this$filePath.getAfterName();
            if (string == null) {
                string = $this$filePath.getBeforeName();
            }
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

