/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.diff.editor.DiffEditorTabFilesManager;
import com.intellij.diff.editor.DiffVirtualFileBase;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.testFramework.LightVirtualFileBase;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.EventListener;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.GHNewPRCombinedDiffPreviewVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHNewPRDiffVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRCombinedDiffPreviewVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFile;
import org.jetbrains.plugins.github.pullrequest.GHPRStatisticsCollector;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.SimpleGHPRIdentifier;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001:\u00010B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J3\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192!\u0010\u001a\u001a\u001d\u0012\u0013\u0012\u00110\u000f\u00a2\u0006\f\b\u001c\u0012\b\b\u001d\u0012\u0004\b\b(\u001e\u0012\u0004\u0012\u00020\u00170\u001bH\u0016J\u0018\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J \u0010#\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010!\u001a\u00020\"H\u0016J \u0010%\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\"2\u0006\u0010!\u001a\u00020\"H\u0016J\u0018\u0010'\u001a\u00020\u00172\u0006\u0010 \u001a\u00020\t2\u0006\u0010!\u001a\u00020\"H\u0016J \u0010(\u001a\u00020\u000b2\u0006\u0010 \u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\"H\u0016J\u0018\u0010)\u001a\u00020\u000b2\u0006\u0010$\u001a\u00020\u00142\u0006\u0010&\u001a\u00020\"H\u0016J\b\u0010*\u001a\u00020\u0017H\u0016J\u0012\u0010+\u001a\u0004\u0018\u00010\u000b2\u0006\u0010 \u001a\u00020\tH\u0016J\u0012\u0010,\u001a\u0004\u0018\u00010\u000f2\u0006\u0010 \u001a\u00020\tH\u0016J\u0010\u0010-\u001a\u00020\u00172\u0006\u0010.\u001a\u00020/H\u0016RP\u0010\u0007\u001aD\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f* \u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\r\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u000e\u001aD\u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f \f* \u0012\t\u0012\u00070\t\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000f0\u000f0\r\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0010\u001a\u0015\u0012\f\u0012\n \f*\u0004\u0018\u00010\u00120\u00120\u0011\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000RP\u0010\u0015\u001aD\u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b \f* \u0012\t\u0012\u00070\u0014\u00a2\u0006\u0002\b\n\u0012\f\u0012\n \f*\u0004\u0018\u00010\u000b0\u000b0\r\u00a2\u0006\u0002\b\n0\b\u00a2\u0006\u0002\b\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00061"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManagerImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;)V", "diffFiles", "", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "Lorg/jetbrains/annotations/NotNull;", "Lcom/intellij/diff/editor/DiffVirtualFileBase;", "kotlin.jvm.PlatformType", "", "files", "Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile;", "filesEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManagerImpl$FileListener;", "id", "", "newPRDiffFiles", "addBeforeTimelineFileOpenedListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "file", "createAndOpenDiffFile", "pullRequest", "requestFocus", "", "createAndOpenDiffPreviewFile", "sourceId", "createAndOpenNewPRDiffPreviewFile", "combinedDiff", "createAndOpenTimelineFile", "createOrGetDiffFile", "createOrGetNewPRDiffFile", "dispose", "findDiffFile", "findTimelineFile", "updateTimelineFilePresentation", "details", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "FileListener", "intellij.vcs.github"})
public final class GHPRFilesManagerImpl
implements GHPRFilesManager {
    @NotNull
    private final Project project;
    @NotNull
    private final GHRepositoryCoordinates repository;
    @NotNull
    private final String id;
    @NotNull
    private final EventDispatcher<FileListener> filesEventDispatcher;
    @NotNull
    private final Map<GHPRIdentifier, GHPRTimelineVirtualFile> files;
    @NotNull
    private final Map<GHPRIdentifier, DiffVirtualFileBase> diffFiles;
    @NotNull
    private Map<String, DiffVirtualFileBase> newPRDiffFiles;

    public GHPRFilesManagerImpl(@NotNull Project project, @NotNull GHRepositoryCoordinates repository) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        this.project = project;
        this.repository = repository;
        this.id = String.valueOf(System.currentTimeMillis());
        EventDispatcher eventDispatcher = EventDispatcher.create(FileListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(FileListener::class.java)");
        this.filesEventDispatcher = eventDispatcher;
        Map map2 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createWeakValueMap<GHPRI\u2026HPRTimelineVirtualFile>()");
        this.files = map2;
        Map map3 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map3, (String)"createWeakValueMap<GHPRI\u2026r, DiffVirtualFileBase>()");
        this.diffFiles = map3;
        Map map4 = ContainerUtil.createWeakValueMap();
        Intrinsics.checkNotNullExpressionValue((Object)map4, (String)"createWeakValueMap<String, DiffVirtualFileBase>()");
        this.newPRDiffFiles = map4;
    }

    @Override
    @NotNull
    public DiffVirtualFileBase createOrGetNewPRDiffFile(@NotNull String sourceId, boolean combinedDiff) {
        DiffVirtualFileBase diffVirtualFileBase;
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Map<String, DiffVirtualFileBase> $this$getOrPut$iv = this.newPRDiffFiles;
        boolean $i$f$getOrPut = false;
        DiffVirtualFileBase value$iv = $this$getOrPut$iv.get(sourceId);
        if (value$iv == null) {
            boolean bl = false;
            DiffVirtualFileBase answer$iv = (DiffVirtualFileBase)(combinedDiff ? new GHNewPRCombinedDiffPreviewVirtualFile(sourceId, this.id, this.project, this.repository) : new GHNewPRDiffVirtualFile(this.id, this.project, this.repository));
            $this$getOrPut$iv.put(sourceId, answer$iv);
            diffVirtualFileBase = answer$iv;
        } else {
            diffVirtualFileBase = value$iv;
        }
        return diffVirtualFileBase;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DiffVirtualFileBase createOrGetDiffFile(@NotNull GHPRIdentifier pullRequest, @NotNull String sourceId, boolean combinedDiff) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Map<GHPRIdentifier, DiffVirtualFileBase> map2 = this.diffFiles;
        SimpleGHPRIdentifier key$iv = new SimpleGHPRIdentifier(pullRequest);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            DiffVirtualFileBase answer$iv = (DiffVirtualFileBase)(combinedDiff ? new GHPRCombinedDiffPreviewVirtualFile(sourceId, this.id, this.project, this.repository, pullRequest) : new GHPRDiffVirtualFile(this.id, this.project, this.repository, pullRequest));
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        return (DiffVirtualFileBase)object;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createAndOpenTimelineFile(@NotNull GHPRIdentifier pullRequest, boolean requestFocus) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        Map<GHPRIdentifier, GHPRTimelineVirtualFile> map2 = this.files;
        SimpleGHPRIdentifier key$iv = new SimpleGHPRIdentifier(pullRequest);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            GHPRTimelineVirtualFile answer$iv = new GHPRTimelineVirtualFile(this.id, this.project, this.repository, pullRequest);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        GHPRTimelineVirtualFile it = (GHPRTimelineVirtualFile)((Object)object);
        boolean bl = false;
        ((FileListener)this.filesEventDispatcher.getMulticaster()).onBeforeFileOpened(it);
        FileEditorManager.getInstance((Project)this.project).openFile((VirtualFile)it, requestFocus);
        GHPRStatisticsCollector.INSTANCE.logTimelineOpened(this.project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void createAndOpenDiffFile(@NotNull GHPRIdentifier pullRequest, boolean requestFocus) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        Map<GHPRIdentifier, DiffVirtualFileBase> map2 = this.diffFiles;
        SimpleGHPRIdentifier key$iv = new SimpleGHPRIdentifier(pullRequest);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            DiffVirtualFileBase answer$iv = (DiffVirtualFileBase)new GHPRDiffVirtualFile(this.id, this.project, this.repository, pullRequest);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        DiffVirtualFileBase it = (DiffVirtualFileBase)object;
        boolean bl = false;
        DiffEditorTabFilesManager.Companion.getInstance(this.project).showDiffFile((VirtualFile)it, requestFocus);
        GHPRStatisticsCollector.INSTANCE.logDiffOpened(this.project);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public DiffVirtualFileBase createAndOpenDiffPreviewFile(@NotNull GHPRIdentifier pullRequest, @NotNull String sourceId, boolean requestFocus) {
        Object object;
        void $this$getOrPut$iv;
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Map<GHPRIdentifier, Object> map2 = this.diffFiles;
        SimpleGHPRIdentifier key$iv = new SimpleGHPRIdentifier(pullRequest);
        boolean $i$f$getOrPut = false;
        Object value$iv = $this$getOrPut$iv.get(key$iv);
        if (value$iv == null) {
            boolean bl = false;
            DiffVirtualFileBase answer$iv = (DiffVirtualFileBase)new GHPRCombinedDiffPreviewVirtualFile(sourceId, this.id, this.project, this.repository, pullRequest);
            $this$getOrPut$iv.put(key$iv, answer$iv);
            object = answer$iv;
        } else {
            object = value$iv;
        }
        map2 = object;
        DiffVirtualFileBase it = (DiffVirtualFileBase)map2;
        boolean bl = false;
        DiffEditorTabFilesManager.Companion.getInstance(this.project).showDiffFile((VirtualFile)it, requestFocus);
        GHPRStatisticsCollector.INSTANCE.logDiffOpened(this.project);
        return (DiffVirtualFileBase)map2;
    }

    @Override
    @NotNull
    public DiffVirtualFileBase createAndOpenNewPRDiffPreviewFile(@NotNull String sourceId, boolean combinedDiff, boolean requestFocus) {
        DiffVirtualFileBase diffVirtualFileBase;
        DiffVirtualFileBase diffVirtualFileBase2;
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Map<String, DiffVirtualFileBase> $this$getOrPut$iv = this.newPRDiffFiles;
        boolean $i$f$getOrPut = false;
        DiffVirtualFileBase value$iv = $this$getOrPut$iv.get(sourceId);
        if (value$iv == null) {
            boolean bl = false;
            DiffVirtualFileBase answer$iv = (DiffVirtualFileBase)(combinedDiff ? new GHNewPRCombinedDiffPreviewVirtualFile(sourceId, this.id, this.project, this.repository) : new GHNewPRDiffVirtualFile(this.id, this.project, this.repository));
            $this$getOrPut$iv.put(sourceId, answer$iv);
            diffVirtualFileBase2 = answer$iv;
        } else {
            diffVirtualFileBase2 = value$iv;
        }
        DiffVirtualFileBase it = diffVirtualFileBase = diffVirtualFileBase2;
        boolean bl = false;
        DiffEditorTabFilesManager.Companion.getInstance(this.project).showDiffFile((VirtualFile)it, requestFocus);
        GHPRStatisticsCollector.INSTANCE.logDiffOpened(this.project);
        return diffVirtualFileBase;
    }

    @Override
    @Nullable
    public GHPRTimelineVirtualFile findTimelineFile(@NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        return this.files.get(new SimpleGHPRIdentifier(pullRequest));
    }

    @Override
    @Nullable
    public DiffVirtualFileBase findDiffFile(@NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        return this.diffFiles.get(new SimpleGHPRIdentifier(pullRequest));
    }

    @Override
    public void updateTimelineFilePresentation(@NotNull GHPullRequestShort details2) {
        Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
        GHPRTimelineVirtualFile file = this.findTimelineFile(details2);
        if (file != null) {
            file.setDetails(details2);
            FileEditorManagerEx.getInstanceEx((Project)this.project).updateFilePresentation((VirtualFile)file);
        }
    }

    @Override
    public void addBeforeTimelineFileOpenedListener(@NotNull Disposable disposable, @NotNull Function1<? super GHPRTimelineVirtualFile, Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.filesEventDispatcher.addListener((EventListener)new FileListener(listener2){
            final /* synthetic */ Function1<GHPRTimelineVirtualFile, Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void onBeforeFileOpened(@NotNull GHPRTimelineVirtualFile file) {
                Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
                this.$listener.invoke((Object)((Object)file));
            }
        }, disposable);
    }

    public void dispose() {
        for (Object file : CollectionsKt.plus((Collection)CollectionsKt.plus(this.files.values(), (Iterable)this.diffFiles.values()), (Iterable)this.newPRDiffFiles.values())) {
            FileEditorManager.getInstance((Project)this.project).closeFile((VirtualFile)file);
            ((LightVirtualFileBase)file).setValid(false);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManagerImpl$FileListener;", "Ljava/util/EventListener;", "onBeforeFileOpened", "", "file", "Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineVirtualFile;", "intellij.vcs.github"})
    private static interface FileListener
    extends EventListener {
        public void onBeforeFileOpened(@NotNull GHPRTimelineVirtualFile var1);
    }
}

