/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusFactory;
import com.intellij.util.messages.MessageBusOwner;
import java.util.EventListener;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHIssueComment;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReview;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffRequestModelImpl;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProviderRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRChangesDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataOperationsListener;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRStateDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRStateDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRViewedStateDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRViewedStateDataProviderImpl;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRChangesService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCommentService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRDetailsService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRFilesService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRReviewService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRStateService;
import org.jetbrains.plugins.github.util.DisposalCountingHolder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u0000\u0018\u00002\u00020\u0001:\u0001+BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0018\u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000f\u00a2\u0006\u0002\u0010\u0013J$\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\u0012\u0010#\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u00020 0\u000fH\u0016J\u0018\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\"2\u0006\u0010'\u001a\u00020\u0010H\u0002J\b\u0010(\u001a\u00020 H\u0016J\u0012\u0010)\u001a\u0004\u0018\u00010\u00172\u0006\u0010'\u001a\u00020\u0010H\u0017J\u0018\u0010*\u001a\u00020\u00172\u0006\u0010'\u001a\u00020\u00102\u0006\u0010!\u001a\u00020\"H\u0017R \u0010\u0014\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00160\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\u001a\u001a\u0015\u0012\f\u0012\n \u001d*\u0004\u0018\u00010\u001c0\u001c0\u001b\u00a2\u0006\u0002\b\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepositoryImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;", "detailsService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;", "stateService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;", "reviewService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewService;", "filesService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRFilesService;", "commentService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCommentService;", "changesService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;", "timelineLoaderFactory", "Lkotlin/Function1;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "(Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRStateService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRReviewService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRFilesService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCommentService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRChangesService;Lkotlin/jvm/functions/Function1;)V", "cache", "", "Lorg/jetbrains/plugins/github/util/DisposalCountingHolder;", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "isDisposed", "", "providerDetailsLoadedEventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepositoryImpl$DetailsLoadedListener;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "addDetailsLoadedListener", "", "disposable", "Lcom/intellij/openapi/Disposable;", "listener", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "createDataProvider", "parentDisposable", "id", "dispose", "findDataProvider", "getDataProvider", "DetailsLoadedListener", "intellij.vcs.github"})
public final class GHPRDataProviderRepositoryImpl
implements GHPRDataProviderRepository {
    @NotNull
    private final GHPRDetailsService detailsService;
    @NotNull
    private final GHPRStateService stateService;
    @NotNull
    private final GHPRReviewService reviewService;
    @NotNull
    private final GHPRFilesService filesService;
    @NotNull
    private final GHPRCommentService commentService;
    @NotNull
    private final GHPRChangesService changesService;
    @NotNull
    private final Function1<GHPRIdentifier, GHListLoader<GHPRTimelineItem>> timelineLoaderFactory;
    private boolean isDisposed;
    @NotNull
    private final Map<GHPRIdentifier, DisposalCountingHolder<GHPRDataProvider>> cache;
    @NotNull
    private final EventDispatcher<DetailsLoadedListener> providerDetailsLoadedEventDispatcher;

    public GHPRDataProviderRepositoryImpl(@NotNull GHPRDetailsService detailsService, @NotNull GHPRStateService stateService, @NotNull GHPRReviewService reviewService, @NotNull GHPRFilesService filesService, @NotNull GHPRCommentService commentService, @NotNull GHPRChangesService changesService, @NotNull Function1<? super GHPRIdentifier, ? extends GHListLoader<GHPRTimelineItem>> timelineLoaderFactory) {
        Intrinsics.checkNotNullParameter((Object)detailsService, (String)"detailsService");
        Intrinsics.checkNotNullParameter((Object)stateService, (String)"stateService");
        Intrinsics.checkNotNullParameter((Object)reviewService, (String)"reviewService");
        Intrinsics.checkNotNullParameter((Object)filesService, (String)"filesService");
        Intrinsics.checkNotNullParameter((Object)commentService, (String)"commentService");
        Intrinsics.checkNotNullParameter((Object)changesService, (String)"changesService");
        Intrinsics.checkNotNullParameter(timelineLoaderFactory, (String)"timelineLoaderFactory");
        this.detailsService = detailsService;
        this.stateService = stateService;
        this.reviewService = reviewService;
        this.filesService = filesService;
        this.commentService = commentService;
        this.changesService = changesService;
        this.timelineLoaderFactory = timelineLoaderFactory;
        this.cache = new LinkedHashMap();
        EventDispatcher eventDispatcher = EventDispatcher.create(DetailsLoadedListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)eventDispatcher, (String)"create(DetailsLoadedListener::class.java)");
        this.providerDetailsLoadedEventDispatcher = eventDispatcher;
    }

    @Override
    @RequiresEdt
    @NotNull
    public GHPRDataProvider getDataProvider(@NotNull GHPRIdentifier id, @NotNull Disposable disposable) {
        DisposalCountingHolder<GHPRDataProvider> disposalCountingHolder;
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (this.isDisposed) {
            throw new IllegalStateException("Already disposed");
        }
        Map<GHPRIdentifier, DisposalCountingHolder<GHPRDataProvider>> $this$getOrPut$iv = this.cache;
        boolean $i$f$getOrPut = false;
        DisposalCountingHolder<GHPRDataProvider> value$iv = $this$getOrPut$iv.get(id);
        if (value$iv == null) {
            DisposalCountingHolder disposalCountingHolder2;
            boolean bl = false;
            DisposalCountingHolder it = disposalCountingHolder2 = new DisposalCountingHolder((Function1)new Function1<Disposable, GHPRDataProvider>(this, id){
                final /* synthetic */ GHPRDataProviderRepositoryImpl this$0;
                final /* synthetic */ GHPRIdentifier $id;
                {
                    this.this$0 = $receiver;
                    this.$id = $id;
                    super(1);
                }

                @NotNull
                public final GHPRDataProvider invoke(@NotNull Disposable it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    return GHPRDataProviderRepositoryImpl.access$createDataProvider(this.this$0, it, this.$id);
                }
            });
            boolean bl2 = false;
            Disposer.register((Disposable)it, () -> GHPRDataProviderRepositoryImpl.getDataProvider$lambda$2$lambda$1$lambda$0(this, id));
            DisposalCountingHolder answer$iv = disposalCountingHolder2;
            $this$getOrPut$iv.put(id, answer$iv);
            disposalCountingHolder = answer$iv;
        } else {
            disposalCountingHolder = value$iv;
        }
        return disposalCountingHolder.acquireValue(disposable);
    }

    @Override
    @RequiresEdt
    @Nullable
    public GHPRDataProvider findDataProvider(@NotNull GHPRIdentifier id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        DisposalCountingHolder<GHPRDataProvider> disposalCountingHolder = this.cache.get(id);
        return disposalCountingHolder != null ? disposalCountingHolder.getValue() : null;
    }

    public void dispose() {
        this.isDisposed = true;
        Iterable $this$forEach$iv = CollectionsKt.toList((Iterable)this.cache.values());
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Disposable p0 = (Disposable)element$iv;
            boolean bl = false;
            Disposer.dispose((Disposable)p0);
        }
    }

    private final GHPRDataProvider createDataProvider(Disposable parentDisposable, GHPRIdentifier id) {
        DisposalCountingHolder<GHListLoader<GHPRTimelineItem>> disposalCountingHolder;
        GHPRDetailsDataProviderImpl gHPRDetailsDataProviderImpl;
        MessageBus messageBus2 = MessageBusFactory.newMessageBus((MessageBusOwner)new MessageBusOwner(parentDisposable){
            final /* synthetic */ Disposable $parentDisposable;
            {
                this.$parentDisposable = $parentDisposable;
            }

            public boolean isDisposed() {
                return Disposer.isDisposed((Disposable)this.$parentDisposable);
            }

            @NotNull
            public Void createListener(@NotNull ListenerDescriptor descriptor) {
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                throw new UnsupportedOperationException();
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)messageBus2, (String)"parentDisposable: Dispos\u2026erationException()\n    })");
        MessageBus messageBus3 = messageBus2;
        Disposer.register((Disposable)parentDisposable, (Disposable)((Disposable)messageBus3));
        GHPRDetailsDataProviderImpl $this$createDataProvider_u24lambda_u243 = gHPRDetailsDataProviderImpl = new GHPRDetailsDataProviderImpl(this.detailsService, id, messageBus3);
        boolean bl = false;
        $this$createDataProvider_u24lambda_u243.addDetailsLoadedListener(parentDisposable, (Function0<Unit>)((Function0)new Function0<Unit>($this$createDataProvider_u24lambda_u243, this){
            final /* synthetic */ GHPRDetailsDataProviderImpl $this_apply;
            final /* synthetic */ GHPRDataProviderRepositoryImpl this$0;
            {
                this.$this_apply = $receiver;
                this.this$0 = $receiver2;
                super(0);
            }

            public final void invoke() {
                block0: {
                    GHPullRequest gHPullRequest = this.$this_apply.getLoadedDetails();
                    if (gHPullRequest == null) break block0;
                    GHPullRequest gHPullRequest2 = gHPullRequest;
                    GHPRDataProviderRepositoryImpl gHPRDataProviderRepositoryImpl = this.this$0;
                    GHPullRequest it = gHPullRequest2;
                    boolean bl = false;
                    ((DetailsLoadedListener)GHPRDataProviderRepositoryImpl.access$getProviderDetailsLoadedEventDispatcher$p(gHPRDataProviderRepositoryImpl).getMulticaster()).onDetailsLoaded(it);
                }
            }
        }));
        Disposable it = gHPRDetailsDataProviderImpl;
        boolean bl2 = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)it);
        GHPRDetailsDataProviderImpl detailsData2 = gHPRDetailsDataProviderImpl;
        Disposable it2 = it = new GHPRStateDataProviderImpl(this.stateService, id, messageBus3, detailsData2);
        boolean bl3 = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)it2);
        Disposable stateData = it;
        Disposable it3 = it2 = new GHPRChangesDataProviderImpl(this.changesService, id, detailsData2);
        boolean bl4 = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)it3);
        Disposable changesData = it2;
        Disposable it4 = it3 = new GHPRReviewDataProviderImpl(this.reviewService, id, messageBus3);
        boolean bl5 = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)it4);
        Disposable reviewData = it3;
        Disposable it5 = it4 = new GHPRViewedStateDataProviderImpl(this.filesService, id);
        boolean bl6 = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)it5);
        Disposable viewedStateData = it4;
        GHPRCommentsDataProviderImpl commentsData = new GHPRCommentsDataProviderImpl(this.commentService, id, messageBus3);
        DisposalCountingHolder<GHListLoader<GHPRTimelineItem>> it6 = disposalCountingHolder = new DisposalCountingHolder<GHListLoader<GHPRTimelineItem>>((Function1)new Function1<Disposable, GHListLoader<GHPRTimelineItem>>(this, id, messageBus3){
            final /* synthetic */ GHPRDataProviderRepositoryImpl this$0;
            final /* synthetic */ GHPRIdentifier $id;
            final /* synthetic */ MessageBus $messageBus;
            {
                this.this$0 = $receiver;
                this.$id = $id;
                this.$messageBus = $messageBus;
                super(1);
            }

            @NotNull
            public final GHListLoader<GHPRTimelineItem> invoke(@NotNull Disposable timelineDisposable) {
                Intrinsics.checkNotNullParameter((Object)timelineDisposable, (String)"timelineDisposable");
                Object object = GHPRDataProviderRepositoryImpl.access$getTimelineLoaderFactory$p(this.this$0).invoke((Object)this.$id);
                MessageBus messageBus2 = this.$messageBus;
                GHListLoader loader2 = (GHListLoader)object;
                boolean bl = false;
                messageBus2.connect(timelineDisposable).subscribe(GHPRDataOperationsListener.Companion.getTOPIC(), (Object)new GHPRDataOperationsListener(loader2){
                    final /* synthetic */ GHListLoader<GHPRTimelineItem> $loader;
                    {
                        this.$loader = $loader;
                    }

                    public void onStateChanged() {
                        this.$loader.loadMore(true);
                    }

                    public void onMetadataChanged() {
                        this.$loader.loadMore(true);
                    }

                    public void onCommentAdded() {
                        this.$loader.loadMore(true);
                    }

                    public void onCommentUpdated(@NotNull String commentId, @NotNull String newBody) {
                        GHIssueComment comment;
                        Object v0;
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
                            Intrinsics.checkNotNullParameter((Object)newBody, (String)"newBody");
                            Iterable iterable = this.$loader.getLoadedData();
                            for (T t : iterable) {
                                GHPRTimelineItem it = (GHPRTimelineItem)t;
                                boolean bl = false;
                                if (!(it instanceof GHIssueComment && Intrinsics.areEqual((Object)((GHIssueComment)it).getId(), (Object)commentId))) continue;
                                v0 = t;
                                break block2;
                            }
                            v0 = null;
                        }
                        Object var4_8 = v0;
                        GHIssueComment gHIssueComment = comment = var4_8 instanceof GHIssueComment ? (GHIssueComment)var4_8 : null;
                        if (comment != null) {
                            GHIssueComment newComment = new GHIssueComment(commentId, comment.getAuthor(), newBody, comment.getCreatedAt(), comment.getViewerCanDelete(), comment.getViewerCanUpdate());
                            this.$loader.updateData(newComment);
                        }
                        this.$loader.loadMore(true);
                    }

                    public void onCommentDeleted(@NotNull String commentId) {
                        Intrinsics.checkNotNullParameter((Object)commentId, (String)"commentId");
                        this.$loader.removeData((Function1<GHPRTimelineItem, Boolean>)((Function1)new Function1<GHPRTimelineItem, Boolean>(commentId){
                            final /* synthetic */ String $commentId;
                            {
                                this.$commentId = $commentId;
                                super(1);
                            }

                            @NotNull
                            public final Boolean invoke(@NotNull GHPRTimelineItem it) {
                                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                                return it instanceof GHIssueComment && Intrinsics.areEqual((Object)((GHIssueComment)it).getId(), (Object)this.$commentId);
                            }
                        }));
                        this.$loader.loadMore(true);
                    }

                    public void onReviewsChanged() {
                        this.$loader.loadMore(true);
                    }

                    public void onReviewUpdated(@NotNull String reviewId, @NotNull String newBody) {
                        GHPullRequestReview review2;
                        Object v0;
                        block2: {
                            Intrinsics.checkNotNullParameter((Object)reviewId, (String)"reviewId");
                            Intrinsics.checkNotNullParameter((Object)newBody, (String)"newBody");
                            Iterable iterable = this.$loader.getLoadedData();
                            for (T t : iterable) {
                                GHPRTimelineItem it = (GHPRTimelineItem)t;
                                boolean bl = false;
                                if (!(it instanceof GHPullRequestReview && Intrinsics.areEqual((Object)((GHPullRequestReview)it).getId(), (Object)reviewId))) continue;
                                v0 = t;
                                break block2;
                            }
                            v0 = null;
                        }
                        Object var4_8 = v0;
                        GHPullRequestReview gHPullRequestReview = review2 = var4_8 instanceof GHPullRequestReview ? (GHPullRequestReview)var4_8 : null;
                        if (review2 != null) {
                            GHPullRequestReview newReview = new GHPullRequestReview(reviewId, review2.getUrl(), review2.getAuthor(), newBody, review2.getState(), review2.getCreatedAt(), review2.getViewerCanUpdate());
                            this.$loader.updateData(newReview);
                        }
                        this.$loader.loadMore(true);
                    }
                });
                Disposer.register((Disposable)timelineDisposable, (Disposable)loader2);
                return (GHListLoader)object;
            }
        });
        boolean bl7 = false;
        Disposer.register((Disposable)parentDisposable, (Disposable)it6);
        DisposalCountingHolder<GHListLoader<GHPRTimelineItem>> timelineLoaderHolder2 = disposalCountingHolder;
        messageBus3.connect(stateData).subscribe(GHPRDataOperationsListener.Companion.getTOPIC(), (Object)new GHPRDataOperationsListener((GHPRStateDataProviderImpl)stateData){
            final /* synthetic */ GHPRStateDataProviderImpl $stateData;
            {
                this.$stateData = $stateData;
            }

            public void onReviewsChanged() {
                this.$stateData.reloadMergeabilityState();
            }
        });
        return new GHPRDataProviderImpl(id, detailsData2, (GHPRStateDataProvider)stateData, (GHPRChangesDataProvider)changesData, commentsData, (GHPRReviewDataProvider)reviewData, (GHPRViewedStateDataProvider)viewedStateData, timelineLoaderHolder2, new GHPRDiffRequestModelImpl());
    }

    @Override
    public void addDetailsLoadedListener(@NotNull Disposable disposable, @NotNull Function1<? super GHPullRequest, Unit> listener2) {
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        Intrinsics.checkNotNullParameter(listener2, (String)"listener");
        this.providerDetailsLoadedEventDispatcher.addListener((EventListener)new DetailsLoadedListener(listener2){
            final /* synthetic */ Function1<GHPullRequest, Unit> $listener;
            {
                this.$listener = $listener;
            }

            public void onDetailsLoaded(@NotNull GHPullRequest details2) {
                Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
                this.$listener.invoke((Object)details2);
            }
        }, disposable);
    }

    private static final void getDataProvider$lambda$2$lambda$1$lambda$0(GHPRDataProviderRepositoryImpl this$0, GHPRIdentifier $id) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$id, (String)"$id");
        this$0.cache.remove($id);
    }

    public static final /* synthetic */ Function1 access$getTimelineLoaderFactory$p(GHPRDataProviderRepositoryImpl $this) {
        return $this.timelineLoaderFactory;
    }

    public static final /* synthetic */ GHPRDataProvider access$createDataProvider(GHPRDataProviderRepositoryImpl $this, Disposable parentDisposable, GHPRIdentifier id) {
        return $this.createDataProvider(parentDisposable, id);
    }

    public static final /* synthetic */ EventDispatcher access$getProviderDetailsLoadedEventDispatcher$p(GHPRDataProviderRepositoryImpl $this) {
        return $this.providerDetailsLoadedEventDispatcher;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bb\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\u0006\u00c0\u0006\u0001"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepositoryImpl$DetailsLoadedListener;", "Ljava/util/EventListener;", "onDetailsLoaded", "", "details", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequest;", "intellij.vcs.github"})
    private static interface DetailsLoadedListener
    extends EventListener {
        public void onDetailsLoaded(@NotNull GHPullRequest var1);
    }
}

