/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffRequestModel;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataProviderRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRListUpdatesChecker;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRCreationService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRDetailsService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B_\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0010\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\u0002\u0010\u0018J\b\u0010/\u001a\u000200H\u0016R\u001b\u0010\u0010\u001a\f\u0012\u0004\u0012\u00020\u00120\u0011j\u0002`\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010$R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0013\u0010'\u001a\u00070\u0001\u00a2\u0006\u0002\b(X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.\u00a8\u00061"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "Lcom/intellij/openapi/Disposable;", "listLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListLoader;", "listUpdatesChecker", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;", "dataProviderRepository", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "creationService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;", "detailsService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "filesManager", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "newPRDiffModel", "Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffRequestModel;", "(Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListLoader;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffRequestModel;)V", "getAvatarIconsProvider", "()Lcom/intellij/collaboration/ui/icon/IconsProvider;", "getCreationService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRCreationService;", "getDataProviderRepository", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataProviderRepository;", "getDetailsService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRDetailsService;", "getFilesManager", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "getListLoader", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListLoader;", "getListUpdatesChecker", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRListUpdatesChecker;", "listenersDisposable", "Lorg/jetbrains/annotations/NotNull;", "getNewPRDiffModel", "()Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffRequestModel;", "getRepositoryDataService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "getSecurityService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "dispose", "", "intellij.vcs.github"})
public final class GHPRDataContext
implements Disposable {
    @NotNull
    private final GHPRListLoader listLoader;
    @NotNull
    private final GHPRListUpdatesChecker listUpdatesChecker;
    @NotNull
    private final GHPRDataProviderRepository dataProviderRepository;
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final GHPRCreationService creationService;
    @NotNull
    private final GHPRDetailsService detailsService;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final GHPRFilesManager filesManager;
    @NotNull
    private final GHPRDiffRequestModel newPRDiffModel;
    @NotNull
    private final Disposable listenersDisposable;

    public GHPRDataContext(@NotNull GHPRListLoader listLoader, @NotNull GHPRListUpdatesChecker listUpdatesChecker, @NotNull GHPRDataProviderRepository dataProviderRepository2, @NotNull GHPRSecurityService securityService, @NotNull GHPRRepositoryDataService repositoryDataService, @NotNull GHPRCreationService creationService, @NotNull GHPRDetailsService detailsService, @NotNull IconsProvider<String> avatarIconsProvider, @NotNull GHPRFilesManager filesManager, @NotNull GHPRDiffRequestModel newPRDiffModel) {
        Intrinsics.checkNotNullParameter((Object)listLoader, (String)"listLoader");
        Intrinsics.checkNotNullParameter((Object)listUpdatesChecker, (String)"listUpdatesChecker");
        Intrinsics.checkNotNullParameter((Object)dataProviderRepository2, (String)"dataProviderRepository");
        Intrinsics.checkNotNullParameter((Object)securityService, (String)"securityService");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        Intrinsics.checkNotNullParameter((Object)creationService, (String)"creationService");
        Intrinsics.checkNotNullParameter((Object)detailsService, (String)"detailsService");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)filesManager, (String)"filesManager");
        Intrinsics.checkNotNullParameter((Object)newPRDiffModel, (String)"newPRDiffModel");
        this.listLoader = listLoader;
        this.listUpdatesChecker = listUpdatesChecker;
        this.dataProviderRepository = dataProviderRepository2;
        this.securityService = securityService;
        this.repositoryDataService = repositoryDataService;
        this.creationService = creationService;
        this.detailsService = detailsService;
        this.avatarIconsProvider = avatarIconsProvider;
        this.filesManager = filesManager;
        this.newPRDiffModel = newPRDiffModel;
        Disposable disposable = Disposer.newDisposable((String)"GH PR context listeners disposable");
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(\"GH PR con\u2026xt listeners disposable\")");
        this.listenersDisposable = disposable;
        this.listLoader.addDataListener(this.listenersDisposable, new GHListLoader.ListDataListener(){

            @Override
            public void onDataAdded(int startIdx) {
                this.getListUpdatesChecker().start();
            }

            @Override
            public void onAllDataRemoved() {
                this.getListUpdatesChecker().stop();
            }
        });
        this.dataProviderRepository.addDetailsLoadedListener(this.listenersDisposable, (Function1<? super GHPullRequest, Unit>)((Function1)new Function1<GHPullRequest, Unit>(){

            public final void invoke(@NotNull GHPullRequest details2) {
                Intrinsics.checkNotNullParameter((Object)details2, (String)"details");
                this.getListLoader().updateData(details2);
                this.getFilesManager().updateTimelineFilePresentation(details2);
            }
        }));
        this.filesManager.addBeforeTimelineFileOpenedListener(this.listenersDisposable, (Function1<? super GHPRTimelineVirtualFile, Unit>)((Function1)new Function1<GHPRTimelineVirtualFile, Unit>(){

            public final void invoke(@NotNull GHPRTimelineVirtualFile file) {
                GHPullRequestShort details2;
                GHPullRequestShort gHPullRequestShort;
                Object v0;
                block3: {
                    Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
                    Iterable iterable = this.getListLoader().getLoadedData();
                    for (Object t : iterable) {
                        GHPullRequestShort it = (GHPullRequestShort)t;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getId(), (Object)file.getPullRequest().getId())) continue;
                        v0 = t;
                        break block3;
                    }
                    v0 = null;
                }
                if ((gHPullRequestShort = (GHPullRequestShort)v0) == null) {
                    Object object = this.getDataProviderRepository().findDataProvider(file.getPullRequest());
                    gHPullRequestShort = object != null && (object = object.getDetailsData()) != null ? object.getLoadedDetails() : null;
                }
                if ((details2 = gHPullRequestShort) != null) {
                    this.getFilesManager().updateTimelineFilePresentation(details2);
                }
            }
        }));
    }

    @NotNull
    public final GHPRListLoader getListLoader() {
        return this.listLoader;
    }

    @NotNull
    public final GHPRListUpdatesChecker getListUpdatesChecker() {
        return this.listUpdatesChecker;
    }

    @NotNull
    public final GHPRDataProviderRepository getDataProviderRepository() {
        return this.dataProviderRepository;
    }

    @NotNull
    public final GHPRSecurityService getSecurityService() {
        return this.securityService;
    }

    @NotNull
    public final GHPRRepositoryDataService getRepositoryDataService() {
        return this.repositoryDataService;
    }

    @NotNull
    public final GHPRCreationService getCreationService() {
        return this.creationService;
    }

    @NotNull
    public final GHPRDetailsService getDetailsService() {
        return this.detailsService;
    }

    @NotNull
    public final IconsProvider<String> getAvatarIconsProvider() {
        return this.avatarIconsProvider;
    }

    @NotNull
    public final GHPRFilesManager getFilesManager() {
        return this.filesManager;
    }

    @NotNull
    public final GHPRDiffRequestModel getNewPRDiffModel() {
        return this.newPRDiffModel;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.filesManager);
        Disposer.dispose((Disposable)this.listenersDisposable);
        Disposer.dispose((Disposable)this.dataProviderRepository);
        Disposer.dispose((Disposable)this.listLoader);
        Disposer.dispose((Disposable)this.listUpdatesChecker);
        Disposer.dispose((Disposable)this.repositoryDataService);
    }
}

