/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.google.common.graph.Graph;
import com.google.common.graph.SuccessorsFunction;
import com.google.common.graph.Traverser;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.FilePatch;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.HashingStrategy;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHCommit;
import org.jetbrains.plugins.github.pullrequest.data.GHCommitWithPatches;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangeDiffData;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangesProvider;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFileHistory;
import org.jetbrains.plugins.github.pullrequest.data.GHPRGraphFileHistory;
import org.jetbrains.plugins.github.pullrequest.data.GHPRMutableLinearFileHistory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\r\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 62\u00020\u0001:\u00016BW\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\u0006\u0010\t\u001a\u00020\b\u0012*\u0010\n\u001a&\u0012\u0004\u0012\u00020\b\u0012\u001c\u0012\u001a\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f0\u000b\u00a2\u0006\u0002\u0010\u000fJ \u0010!\u001a\u00020\u00122\u0006\u0010\"\u001a\u00020\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010$\u001a\u00020\u000eH\u0002J\u0012\u0010%\u001a\u0004\u0018\u00010\u001b2\u0006\u0010&\u001a\u00020\u0012H\u0016J\u001a\u0010'\u001a\u0004\u0018\u00010\u00122\u0006\u0010(\u001a\u00020\u00052\u0006\u0010)\u001a\u00020\u0005H\u0016J,\u0010*\u001a\u0004\u0018\u00010\u000e2\f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000e0,2\b\u0010-\u001a\u0004\u0018\u00010\u00052\b\u0010.\u001a\u0004\u0018\u00010\u0005H\u0002J \u0010/\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u000100\u0012\u0006\u0012\u0004\u0018\u0001000\f2\u0006\u0010$\u001a\u00020\u000eH\u0002J\u001c\u00101\u001a\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002040\u000bH\u0002J\u001c\u00105\u001a\u0002022\u0012\u00103\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u0002040\u000bH\u0002R\u001a\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R&\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00120\r0\u0016X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018RV\u0010\u0019\u001aJ\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001b0\u001b \u001a*#\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u00120\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001b0\u001b0\u000b\u00a2\u0006\u0002\b\u001c0\u0016\u00a2\u0006\u0002\b\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001d\u001a\u00020\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProviderImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProvider;", "repository", "Lgit4idea/repo/GitRepository;", "mergeBaseRef", "", "commitsGraph", "Lcom/google/common/graph/Graph;", "Lorg/jetbrains/plugins/github/api/data/GHCommit;", "lastCommit", "patchesByCommits", "", "Lkotlin/Pair;", "", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "(Lgit4idea/repo/GitRepository;Ljava/lang/String;Lcom/google/common/graph/Graph;Lorg/jetbrains/plugins/github/api/data/GHCommit;Ljava/util/Map;)V", "changes", "", "Lcom/intellij/openapi/vcs/changes/Change;", "getChanges", "()Ljava/util/List;", "changesByCommits", "", "getChangesByCommits", "()Ljava/util/Map;", "diffDataByChange", "kotlin.jvm.PlatformType", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData;", "Lorg/jetbrains/annotations/NotNull;", "linearHistory", "", "getLinearHistory", "()Z", "createChangeFromPatch", "beforeRef", "afterRef", "patch", "findChangeDiffData", "change", "findCumulativeChange", "commitSha", "filePath", "findPatchByFilePaths", "patches", "", "beforePath", "afterPath", "getPatchPaths", "Lcom/intellij/openapi/vcs/FilePath;", "initForHistoryWithMerges", "", "commitsBySha", "Lorg/jetbrains/plugins/github/pullrequest/data/GHCommitWithPatches;", "initForLinearHistory", "Companion", "intellij.vcs.github"})
public final class GHPRChangesProviderImpl
implements GHPRChangesProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final String mergeBaseRef;
    @NotNull
    private final GHCommit lastCommit;
    @NotNull
    private final List<Change> changes;
    @NotNull
    private final Map<String, List<Change>> changesByCommits;
    private final boolean linearHistory;
    @NotNull
    private final Map<Change, GHPRChangeDiffData> diffDataByChange;
    @NotNull
    private static final Logger LOG;

    /*
     * WARNING - void declaration
     */
    public GHPRChangesProviderImpl(@NotNull GitRepository repository, @NotNull String mergeBaseRef, @NotNull Graph<GHCommit> commitsGraph, @NotNull GHCommit lastCommit, @NotNull Map<GHCommit, ? extends Pair<? extends List<? extends FilePatch>, ? extends List<? extends FilePatch>>> patchesByCommits) {
        boolean bl;
        boolean bl2;
        LinkedHashMap commitsBySha;
        block9: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
            Intrinsics.checkNotNullParameter((Object)mergeBaseRef, (String)"mergeBaseRef");
            Intrinsics.checkNotNullParameter(commitsGraph, (String)"commitsGraph");
            Intrinsics.checkNotNullParameter((Object)lastCommit, (String)"lastCommit");
            Intrinsics.checkNotNullParameter(patchesByCommits, (String)"patchesByCommits");
            this.repository = repository;
            this.mergeBaseRef = mergeBaseRef;
            this.lastCommit = lastCommit;
            this.changes = new ArrayList();
            this.changesByCommits = new LinkedHashMap();
            Map map2 = CollectionFactory.createCustomHashingStrategyMap((HashingStrategy)((HashingStrategy)new HashingStrategy<Change>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public boolean equals(@Nullable Change o1, @Nullable Change o2) {
                    if (!Intrinsics.areEqual((Object)o1, (Object)o2)) return false;
                    Change change = o1;
                    Change change2 = o2;
                    if (!Intrinsics.areEqual((Object)(change != null ? change.getBeforeRevision() : null), (Object)(change2 != null ? change2.getBeforeRevision() : null))) return false;
                    Change change3 = o1;
                    Change change4 = o2;
                    if (!Intrinsics.areEqual((Object)(change3 != null ? change3.getAfterRevision() : null), (Object)(change4 != null ? change4.getAfterRevision() : null))) return false;
                    return true;
                }

                public int hashCode(@Nullable Change change) {
                    Object[] objectArray = new Object[3];
                    objectArray[0] = change;
                    Change change2 = change;
                    objectArray[1] = change2 != null ? change2.getBeforeRevision() : null;
                    Change change3 = change;
                    objectArray[2] = change3 != null ? change3.getAfterRevision() : null;
                    return Objects.hash(objectArray);
                }
            }));
            Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createCustomHashingStrat\u2026ange?.afterRevision)\n  })");
            this.diffDataByChange = map2;
            commitsBySha = new LinkedHashMap();
            Iterable iterable = Traverser.forGraph((SuccessorsFunction)((SuccessorsFunction)commitsGraph)).depthFirstPostOrder((Object)this.lastCommit);
            Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"forGraph(commitsGraph).d\u2026irstPostOrder(lastCommit)");
            Iterable $this$forEach$iv = iterable;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                GHCommit it = (GHCommit)element$iv;
                boolean bl3 = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                Pair pair = (Pair)MapsKt.getValue(patchesByCommits, (Object)it);
                List commitPatches = (List)pair.component1();
                List cumulativePatches = (List)pair.component2();
                ((Map)commitsBySha).put(it.getOid(), new GHCommitWithPatches(it, commitPatches, cumulativePatches));
            }
            Collection collection = commitsBySha.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"commitsBySha.values");
            $this$forEach$iv = collection;
            GHPRChangesProviderImpl gHPRChangesProviderImpl = this;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl2 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    int n;
                    GHCommitWithPatches commit = (GHCommitWithPatches)element$iv;
                    boolean bl4 = false;
                    Iterable $this$count$iv = commit.getParents();
                    boolean $i$f$count = false;
                    if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                        n = 0;
                    } else {
                        int count$iv = 0;
                        for (Object element$iv2 : $this$count$iv) {
                            String it = (String)element$iv2;
                            boolean bl5 = false;
                            if (!((Map)commitsBySha).containsKey(it) || ++count$iv >= 0) continue;
                            CollectionsKt.throwCountOverflow();
                        }
                        n = count$iv;
                    }
                    if (n <= 1) continue;
                    bl2 = false;
                    break block9;
                }
                bl2 = true;
            }
        }
        gHPRChangesProviderImpl.linearHistory = bl = bl2;
        if (this.getLinearHistory()) {
            this.initForLinearHistory(commitsBySha);
        } else {
            this.initForHistoryWithMerges(commitsBySha);
        }
    }

    @Override
    @NotNull
    public List<Change> getChanges() {
        return this.changes;
    }

    @Override
    @NotNull
    public Map<String, List<Change>> getChangesByCommits() {
        return this.changesByCommits;
    }

    @Override
    public boolean getLinearHistory() {
        return this.linearHistory;
    }

    @Override
    @Nullable
    public GHPRChangeDiffData findChangeDiffData(@NotNull Change change) {
        Intrinsics.checkNotNullParameter((Object)change, (String)"change");
        return this.diffDataByChange.get(change);
    }

    @Override
    @Nullable
    public Change findCumulativeChange(@NotNull String commitSha, @NotNull String filePath) {
        Object v0;
        block1: {
            Intrinsics.checkNotNullParameter((Object)commitSha, (String)"commitSha");
            Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
            Iterable iterable = this.diffDataByChange.entrySet();
            for (Object t : iterable) {
                Map.Entry it = (Map.Entry)t;
                boolean bl = false;
                if (!(it.getValue() instanceof GHPRChangeDiffData.Cumulative && ((GHPRChangeDiffData)it.getValue()).contains(commitSha, filePath))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        Map.Entry entry = v0;
        return entry != null ? (Change)entry.getKey() : null;
    }

    /*
     * WARNING - void declaration
     */
    private final void initForLinearHistory(Map<String, GHCommitWithPatches> commitsBySha) {
        void $this$mapKeysTo$iv$iv;
        Map.Entry cumulativePatch;
        String string;
        Object fileHistory;
        Object commitChanges;
        Object object;
        void $this$mapTo$iv$iv;
        Collection<GHCommitWithPatches> commitsWithPatches = commitsBySha.values();
        Map fileHistoriesByLastKnownFilePath = new LinkedHashMap();
        String previousCommitSha = this.mergeBaseRef;
        Iterable $this$map$iv = commitsWithPatches;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            GHCommitWithPatches gHCommitWithPatches = (GHCommitWithPatches)item$iv$iv;
            object = destination$iv$iv;
            boolean bl = false;
            object.add(it.getSha());
        }
        List commitsHashes = (List)destination$iv$iv;
        for (GHCommitWithPatches commitWithPatches : commitsWithPatches) {
            String commitSha = commitWithPatches.getSha();
            commitChanges = new ArrayList();
            for (FilePatch patch : commitWithPatches.getCommitPatches()) {
                GHPRMutableLinearFileHistory historyBefore;
                GHPRMutableLinearFileHistory gHPRMutableLinearFileHistory;
                GHPRMutableLinearFileHistory gHPRMutableLinearFileHistory2;
                Object it;
                Change change = this.createChangeFromPatch(previousCommitSha, commitSha, patch);
                commitChanges.add(change);
                if (!(patch instanceof TextFilePatch)) continue;
                String beforePath = ((TextFilePatch)patch).getBeforeName();
                String afterPath = ((TextFilePatch)patch).getAfterName();
                String string2 = beforePath;
                if (string2 != null) {
                    it = string2;
                    boolean bl = false;
                    gHPRMutableLinearFileHistory2 = (GHPRMutableLinearFileHistory)fileHistoriesByLastKnownFilePath.remove(it);
                } else {
                    gHPRMutableLinearFileHistory2 = null;
                }
                if ((gHPRMutableLinearFileHistory = (historyBefore = gHPRMutableLinearFileHistory2)) == null) {
                    gHPRMutableLinearFileHistory = new GHPRMutableLinearFileHistory(commitsHashes);
                }
                Object $this$initForLinearHistory_u24lambda_u246 = it = gHPRMutableLinearFileHistory;
                boolean bl = false;
                ((GHPRMutableLinearFileHistory)$this$initForLinearHistory_u24lambda_u246).append(commitSha, (TextFilePatch)patch);
                fileHistory = it;
                if (afterPath != null) {
                    fileHistoriesByLastKnownFilePath.put(afterPath, fileHistory);
                }
                String firstKnownPath = ((GHPRMutableLinearFileHistory)fileHistory).getFirstKnownFilePath();
                string = this.findPatchByFilePaths((Collection<? extends FilePatch>)commitWithPatches.getCumulativePatches(), firstKnownPath, afterPath);
                Object object2 = cumulativePatch = string instanceof TextFilePatch ? (TextFilePatch)string : null;
                if (cumulativePatch == null) {
                    LOG.debug("Unable to find cumulative patch for commit patch");
                    continue;
                }
                this.diffDataByChange.put(change, new GHPRChangeDiffData.Commit(commitSha, GHPRChangesProviderImpl.Companion.getFilePath(patch), (TextFilePatch)patch, (TextFilePatch)cumulativePatch, (GHPRFileHistory)fileHistory));
            }
            this.getChangesByCommits().put(commitWithPatches.getCommit().getOid(), (List<Change>)commitChanges);
            previousCommitSha = commitSha;
        }
        Map $this$mapKeys$iv = fileHistoriesByLastKnownFilePath;
        boolean $i$f$mapKeys = false;
        commitChanges = $this$mapKeys$iv;
        Map destination$iv$iv2 = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapKeys$iv.size()));
        boolean $i$f$mapKeysTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapKeysTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            void it;
            fileHistory = (Map.Entry)element$iv$iv$iv;
            object = destination$iv$iv2;
            boolean bl = false;
            cumulativePatch = (Map.Entry)element$iv$iv$iv;
            string = ((GHPRMutableLinearFileHistory)it.getValue()).getLastKnownFilePath();
            Object object3 = object;
            boolean bl2 = false;
            Object v = it$iv$iv.getValue();
            object3.put(string, v);
        }
        Map fileHistoriesBySummaryFilePath = destination$iv$iv2;
        for (FilePatch patch : ((GHCommitWithPatches)MapsKt.getValue(commitsBySha, (Object)this.lastCommit.getOid())).getCumulativePatches()) {
            Change change = this.createChangeFromPatch(this.mergeBaseRef, this.lastCommit.getOid(), patch);
            this.getChanges().add(change);
            if (!(patch instanceof TextFilePatch)) continue;
            String filePath = GHPRChangesProviderImpl.Companion.getFilePath(patch);
            GHPRMutableLinearFileHistory fileHistory2 = (GHPRMutableLinearFileHistory)fileHistoriesBySummaryFilePath.get(filePath);
            if (fileHistory2 == null) {
                LOG.debug("Unable to find file history for cumulative patch for " + filePath);
                continue;
            }
            this.diffDataByChange.put(change, new GHPRChangeDiffData.Cumulative(this.lastCommit.getOid(), filePath, (TextFilePatch)patch, fileHistory2));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void initForHistoryWithMerges(Map<String, GHCommitWithPatches> commitsBySha) {
        for (GHCommitWithPatches commitWithPatches : commitsBySha.values()) {
            void $this$mapTo$iv$iv;
            String string;
            Object v0;
            Object object2;
            block5: {
                Iterable iterable = commitWithPatches.getParents();
                for (Object object2 : iterable) {
                    String it = (String)object2;
                    boolean bl = false;
                    if (!commitsBySha.containsKey(it)) continue;
                    v0 = object2;
                    break block5;
                }
                v0 = null;
            }
            if ((string = (String)v0) == null) {
                string = this.mergeBaseRef;
            }
            String previousCommitSha = string;
            String commitSha = commitWithPatches.getSha();
            Iterable $this$map$iv = commitWithPatches.getCommitPatches();
            boolean $i$f$map = false;
            object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FilePatch filePatch = (FilePatch)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(this.createChangeFromPatch(previousCommitSha, commitSha, (FilePatch)it));
            }
            List commitChanges = (List)destination$iv$iv;
            this.getChangesByCommits().put(commitWithPatches.getCommit().getOid(), commitChanges);
        }
        for (FilePatch patch : ((GHCommitWithPatches)MapsKt.getValue(commitsBySha, (Object)this.lastCommit.getOid())).getCumulativePatches()) {
            Change change = this.createChangeFromPatch(this.mergeBaseRef, this.lastCommit.getOid(), patch);
            this.getChanges().add(change);
            if (!(patch instanceof TextFilePatch)) continue;
            this.diffDataByChange.put(change, new GHPRChangeDiffData.Cumulative(this.lastCommit.getOid(), GHPRChangesProviderImpl.Companion.getFilePath(patch), (TextFilePatch)patch, new GHPRGraphFileHistory(commitsBySha, this.lastCommit, GHPRChangesProviderImpl.Companion.getFilePath(patch))));
        }
    }

    private final Change createChangeFromPatch(String beforeRef, String afterRef, FilePatch patch) {
        ContentRevision contentRevision;
        ContentRevision contentRevision2;
        Project project = this.repository.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"repository.project");
        Project project2 = project;
        Pair<FilePath, FilePath> pair = this.getPatchPaths(patch);
        FilePath beforePath = (FilePath)pair.component1();
        FilePath afterPath = (FilePath)pair.component2();
        FilePath filePath = beforePath;
        if (filePath != null) {
            FilePath it = filePath;
            boolean bl = false;
            contentRevision2 = GitContentRevision.createRevision((FilePath)it, (VcsRevisionNumber)((VcsRevisionNumber)new GitRevisionNumber(beforeRef)), (Project)project2);
        } else {
            contentRevision2 = null;
        }
        ContentRevision beforeRevision = contentRevision2;
        FilePath filePath2 = afterPath;
        if (filePath2 != null) {
            FilePath it = filePath2;
            boolean bl = false;
            contentRevision = GitContentRevision.createRevision((FilePath)it, (VcsRevisionNumber)((VcsRevisionNumber)new GitRevisionNumber(afterRef)), (Project)project2);
        } else {
            contentRevision = null;
        }
        ContentRevision afterRevision = contentRevision;
        return new Change(beforeRevision, afterRevision);
    }

    private final Pair<FilePath, FilePath> getPatchPaths(FilePatch patch) {
        FilePath filePath;
        FilePath filePath2;
        String it;
        String beforeName = patch.isNewFile() ? null : patch.getBeforeName();
        String afterName = patch.isDeletedFile() ? null : patch.getAfterName();
        String string = beforeName;
        if (string != null) {
            it = string;
            boolean bl = false;
            filePath2 = VcsUtil.getFilePath((VirtualFile)this.repository.getRoot(), (String)it);
        } else {
            filePath2 = null;
        }
        String string2 = afterName;
        if (string2 != null) {
            it = string2;
            FilePath filePath3 = filePath2;
            boolean bl = false;
            filePath = VcsUtil.getFilePath((VirtualFile)this.repository.getRoot(), (String)it);
            filePath2 = filePath3;
        } else {
            filePath = null;
        }
        return TuplesKt.to((Object)filePath2, filePath);
    }

    private final FilePatch findPatchByFilePaths(Collection<? extends FilePatch> patches, String beforePath, String afterPath) {
        Object v0;
        block1: {
            Iterable iterable = patches;
            for (Object t : iterable) {
                FilePatch it = (FilePatch)t;
                boolean bl = false;
                if (!(afterPath != null && Intrinsics.areEqual((Object)it.getAfterName(), (Object)afterPath) || afterPath == null && Intrinsics.areEqual((Object)it.getBeforeName(), (Object)beforePath))) continue;
                v0 = t;
                break block1;
            }
            v0 = null;
        }
        return v0;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(GHPRChangesProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(T::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0006\u001a\u00020\u0007*\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangesProviderImpl$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "filePath", "", "Lcom/intellij/openapi/diff/impl/patch/FilePatch;", "getFilePath", "(Lcom/intellij/openapi/diff/impl/patch/FilePatch;)Ljava/lang/String;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        private final String getFilePath(FilePatch $this$filePath) {
            String string = $this$filePath.getAfterName();
            if (string == null) {
                string = $this$filePath.getBeforeName();
            }
            Intrinsics.checkNotNull((Object)string);
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

