/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.data;

import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangedFileLinesMapper;
import org.jetbrains.plugins.github.util.GHPatchHunkUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001f\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0016\u00a2\u0006\u0002\u0010\nJ\u001e\u0010\u000b\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0016J&\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0002J\u001e\u0010\u000e\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0006\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0006H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangedFileLinesMapperImpl;", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangedFileLinesMapper;", "diff", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "(Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;)V", "findDiffLine", "", "side", "Lcom/intellij/diff/util/Side;", "fileLineIndex", "(Lcom/intellij/diff/util/Side;I)Ljava/lang/Integer;", "findFileLocation", "Lkotlin/Pair;", "diffLineIndex", "findHunkWithOffset", "Lcom/intellij/openapi/diff/impl/patch/PatchHunk;", "intellij.vcs.github"})
public final class GHPRChangedFileLinesMapperImpl
implements GHPRChangedFileLinesMapper {
    @NotNull
    private final TextFilePatch diff;

    public GHPRChangedFileLinesMapperImpl(@NotNull TextFilePatch diff) {
        Intrinsics.checkNotNullParameter((Object)diff, (String)"diff");
        this.diff = diff;
    }

    @Override
    @Nullable
    public Integer findDiffLine(@NotNull Side side, int fileLineIndex) {
        Intrinsics.checkNotNullParameter((Object)side, (String)"side");
        Pair<PatchHunk, Integer> pair = this.findHunkWithOffset(side, fileLineIndex);
        if (pair == null) {
            return null;
        }
        Pair<PatchHunk, Integer> pair2 = pair;
        PatchHunk hunk = (PatchHunk)pair2.component1();
        int offset = ((Number)pair2.component2()).intValue();
        Integer n = GHPatchHunkUtil.INSTANCE.findHunkLineIndexFromFileSideLineIndex(hunk, side, fileLineIndex);
        if (n == null) {
            return null;
        }
        int hunkLineIndex = n;
        return offset + hunkLineIndex;
    }

    private final Pair<PatchHunk, Integer> findHunkWithOffset(Side side, int fileLineIndex) {
        int diffLineCounter = 0;
        for (PatchHunk hunk : this.diff.getHunks()) {
            Intrinsics.checkNotNullExpressionValue((Object)hunk, (String)"hunk");
            Range range = GHPatchHunkUtil.INSTANCE.getRange(hunk);
            int start = side.select(range.start1, range.start2);
            int end = side.select(range.end1, range.end2);
            boolean bl = start <= fileLineIndex ? fileLineIndex < end : false;
            if (bl) {
                return TuplesKt.to((Object)hunk, (Object)diffLineCounter);
            }
            int hunkLinesCount = GHPatchHunkUtil.INSTANCE.getHunkLinesCount(hunk);
            diffLineCounter += hunkLinesCount;
        }
        return null;
    }

    @Override
    @Nullable
    public Pair<Side, Integer> findFileLocation(int diffLineIndex) {
        Pair<PatchHunk, Integer> pair = this.findHunkWithOffset(diffLineIndex);
        if (pair == null) {
            return null;
        }
        Pair<PatchHunk, Integer> pair2 = pair;
        PatchHunk hunk = (PatchHunk)pair2.component1();
        int offset = ((Number)pair2.component2()).intValue();
        int hunkLineIndex = diffLineIndex - offset;
        if (hunkLineIndex == 0) {
            return null;
        }
        return GHPatchHunkUtil.INSTANCE.findSideFileLineFromHunkLineIndex(hunk, hunkLineIndex);
    }

    private final Pair<PatchHunk, Integer> findHunkWithOffset(int diffLineIndex) {
        int diffLineCounter = 0;
        for (PatchHunk hunk : this.diff.getHunks()) {
            Intrinsics.checkNotNullExpressionValue((Object)hunk, (String)"hunk");
            int hunkLinesCount = GHPatchHunkUtil.INSTANCE.getHunkLinesCount(hunk);
            if (diffLineIndex >= (diffLineCounter += hunkLinesCount)) continue;
            return TuplesKt.to((Object)hunk, (Object)(diffLineCounter - hunkLinesCount));
        }
        return null;
    }
}

