/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.ui;

import com.intellij.openapi.project.Project;
import com.intellij.ui.components.panels.VerticalLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.plugins.github.pullrequest.comment.GHMarkdownToHtmlConverter;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestedChange;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestedChangeApplier;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewSuggestedChangeComponentFactory;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRSuggestedChangeHelper;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00142\u00020\u0001:\u0003\u0012\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001e\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "markdownConverter", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHMarkdownToHtmlConverter;", "createCommentComponent", "Ljavax/swing/JComponent;", "commentBody", "", "createCommentWithSuggestedChangeComponent", "thread", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "suggestedChange", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestedChange;", "suggestedChangeHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;", "CommentBlock", "CommentType", "Companion", "intellij.vcs.github"})
public final class GHPRReviewCommentComponentFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private final GHMarkdownToHtmlConverter markdownConverter;
    @NotNull
    private static final String SUGGESTED_CHANGE_START_TAG = "<code class=\"language-suggestion\">";
    @NotNull
    private static final String SUGGESTED_CHANGE_END_TAG = "</code>";

    public GHPRReviewCommentComponentFactory(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.markdownConverter = new GHMarkdownToHtmlConverter(this.project);
    }

    @NotNull
    public final JComponent createCommentComponent(@NotNull String commentBody) {
        Intrinsics.checkNotNullParameter((Object)commentBody, (String)"commentBody");
        String htmlBody = this.markdownConverter.convertMarkdown(commentBody);
        return (JComponent)((Object)new HtmlEditorPane(htmlBody));
    }

    @NotNull
    public final JComponent createCommentWithSuggestedChangeComponent(@NotNull GHPRReviewThreadModel thread, @NotNull GHSuggestedChange suggestedChange, @NotNull GHPRSuggestedChangeHelper suggestedChangeHelper) {
        JPanel jPanel;
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)suggestedChange, (String)"suggestedChange");
        Intrinsics.checkNotNullParameter((Object)suggestedChangeHelper, (String)"suggestedChangeHelper");
        String htmlBody = this.markdownConverter.convertMarkdownWithSuggestedChange(suggestedChange);
        String content2 = StringsKt.removeSuffix((String)StringsKt.removePrefix((String)htmlBody, (CharSequence)"<body>"), (CharSequence)"</body>");
        List<CommentBlock> commentBlocks = Companion.collectCommentBlocks(content2);
        GHSuggestedChangeApplier suggestedChangeApplier = new GHSuggestedChangeApplier(this.project, suggestedChangeHelper.getRepository(), suggestedChange);
        GHPRReviewSuggestedChangeComponentFactory suggestedChangeComponent = new GHPRReviewSuggestedChangeComponentFactory(this.project, thread, suggestedChangeApplier, suggestedChangeHelper);
        JPanel $this$createCommentWithSuggestedChangeComponent_u24lambda_u241 = jPanel = new JPanel((LayoutManager)new VerticalLayout(0));
        boolean bl = false;
        $this$createCommentWithSuggestedChangeComponent_u24lambda_u241.setOpaque(false);
        Iterable $this$forEach$iv = commentBlocks;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CommentBlock it = (CommentBlock)element$iv;
            boolean bl2 = false;
            switch (WhenMappings.$EnumSwitchMapping$0[it.getCommentType().ordinal()]) {
                case 1: {
                    $this$createCommentWithSuggestedChangeComponent_u24lambda_u241.add((Component)((Object)new HtmlEditorPane(it.getContent())));
                    break;
                }
                case 2: {
                    $this$createCommentWithSuggestedChangeComponent_u24lambda_u241.add(suggestedChangeComponent.create(it.getContent()));
                }
            }
        }
        return jPanel;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0087\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentType;", "", "(Ljava/lang/String;I)V", "COMMENT", "SUGGESTED_CHANGE", "intellij.vcs.github"})
    @VisibleForTesting
    public static final class CommentType
    extends Enum<CommentType> {
        public static final /* enum */ CommentType COMMENT = new CommentType();
        public static final /* enum */ CommentType SUGGESTED_CHANGE = new CommentType();
        private static final /* synthetic */ CommentType[] $VALUES;

        public static CommentType[] values() {
            return (CommentType[])$VALUES.clone();
        }

        public static CommentType valueOf(String value) {
            return Enum.valueOf(CommentType.class, value);
        }

        static {
            $VALUES = commentTypeArray = new CommentType[]{CommentType.COMMENT, CommentType.SUGGESTED_CHANGE};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0005H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentBlock;", "", "commentType", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentType;", "content", "", "(Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentType;Ljava/lang/String;)V", "getCommentType", "()Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentType;", "getContent", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.vcs.github"})
    @VisibleForTesting
    public static final class CommentBlock {
        @NotNull
        private final CommentType commentType;
        @NotNull
        private final String content;

        public CommentBlock(@NotNull CommentType commentType, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)((Object)commentType), (String)"commentType");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            this.commentType = commentType;
            this.content = content2;
        }

        @NotNull
        public final CommentType getCommentType() {
            return this.commentType;
        }

        @NotNull
        public final String getContent() {
            return this.content;
        }

        @NotNull
        public final CommentType component1() {
            return this.commentType;
        }

        @NotNull
        public final String component2() {
            return this.content;
        }

        @NotNull
        public final CommentBlock copy(@NotNull CommentType commentType, @NotNull String content2) {
            Intrinsics.checkNotNullParameter((Object)((Object)commentType), (String)"commentType");
            Intrinsics.checkNotNullParameter((Object)content2, (String)"content");
            return new CommentBlock(commentType, content2);
        }

        public static /* synthetic */ CommentBlock copy$default(CommentBlock commentBlock, CommentType commentType, String string, int n, Object object) {
            if ((n & 1) != 0) {
                commentType = commentBlock.commentType;
            }
            if ((n & 2) != 0) {
                string = commentBlock.content;
            }
            return commentBlock.copy(commentType, string);
        }

        @NotNull
        public String toString() {
            return "CommentBlock(commentType=" + this.commentType + ", content=" + this.content + ")";
        }

        public int hashCode() {
            int result = this.commentType.hashCode();
            result = result * 31 + this.content.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommentBlock)) {
                return false;
            }
            CommentBlock commentBlock = (CommentBlock)other;
            if (this.commentType != commentBlock.commentType) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.content, (Object)commentBlock.content);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0002J\u0016\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\u00072\u0006\u0010\t\u001a\u00020\u0004H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$Companion;", "", "()V", "SUGGESTED_CHANGE_END_TAG", "", "SUGGESTED_CHANGE_START_TAG", "collectCommentBlockRanges", "", "Lkotlin/ranges/IntRange;", "comment", "collectCommentBlocks", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponentFactory$CommentBlock;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @NotNull
        public final List<CommentBlock> collectCommentBlocks(@NotNull String comment) {
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            List<IntRange> commentBlockRanges = this.collectCommentBlockRanges(comment);
            boolean isSuggestedChange = false;
            List result = new ArrayList();
            for (IntRange range : commentBlockRanges) {
                if (range.getLast() > range.getFirst()) {
                    CommentBlock commentBlock;
                    if (isSuggestedChange) {
                        String string = comment.substring(range.getFirst(), range.getLast());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        commentBlock = new CommentBlock(CommentType.SUGGESTED_CHANGE, string);
                    } else {
                        String string = comment.substring(range.getFirst(), range.getLast());
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        commentBlock = new CommentBlock(CommentType.COMMENT, string);
                    }
                    CommentBlock commentBlock2 = commentBlock;
                    result.add(commentBlock2);
                }
                isSuggestedChange = !isSuggestedChange;
            }
            return result;
        }

        /*
         * WARNING - void declaration
         */
        private final List<IntRange> collectCommentBlockRanges(String comment) {
            List list;
            Object[] objectArray = new Integer[]{0};
            List indexes = CollectionsKt.mutableListOf((Object[])objectArray);
            int startIndex = StringsKt.indexOf$default((CharSequence)comment, (String)GHPRReviewCommentComponentFactory.SUGGESTED_CHANGE_START_TAG, (int)0, (boolean)false, (int)6, null);
            int endIndex = StringsKt.indexOf$default((CharSequence)comment, (String)GHPRReviewCommentComponentFactory.SUGGESTED_CHANGE_END_TAG, (int)0, (boolean)false, (int)6, null) + 7;
            while (startIndex >= 0) {
                indexes.add(startIndex);
                indexes.add(endIndex);
                startIndex = StringsKt.indexOf$default((CharSequence)comment, (String)GHPRReviewCommentComponentFactory.SUGGESTED_CHANGE_START_TAG, (int)(startIndex + 1), (boolean)false, (int)4, null);
                endIndex = StringsKt.indexOf$default((CharSequence)comment, (String)GHPRReviewCommentComponentFactory.SUGGESTED_CHANGE_END_TAG, (int)(endIndex + 1), (boolean)false, (int)4, null) + 7;
            }
            indexes.add(comment.length());
            Iterable $this$zipWithNext$iv = indexes;
            boolean $i$f$zipWithNext = false;
            Iterator iterator$iv = $this$zipWithNext$iv.iterator();
            if (!iterator$iv.hasNext()) {
                list = CollectionsKt.emptyList();
            } else {
                List result$iv = new ArrayList();
                Object current$iv = iterator$iv.next();
                while (iterator$iv.hasNext()) {
                    void end;
                    void start;
                    Object next$iv = iterator$iv.next();
                    int n = ((Number)next$iv).intValue();
                    int n2 = ((Number)current$iv).intValue();
                    List list2 = result$iv;
                    boolean bl = false;
                    list2.add(new IntRange((int)start, (int)end));
                    current$iv = next$iv;
                }
                list = result$iv;
            }
            return list;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[CommentType.values().length];
            try {
                nArray[CommentType.COMMENT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[CommentType.SUGGESTED_CHANGE.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

