/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment.ui;

import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.icons.AllIcons;
import com.intellij.ide.BrowserUtil;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.HtmlBuilder;
import com.intellij.ui.components.ActionLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.panels.VerticalLayout;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.InlineIconButton;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.concurrent.CompletableFuture;
import javax.swing.JComponent;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference0Impl;
import net.miginfocom.layout.AC;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewCommentState;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestedChange;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewCommentComponentFactory;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewCommentModel;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewThreadModel;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.ui.GHEditableHtmlPaneHandle;
import org.jetbrains.plugins.github.pullrequest.ui.GHTextActions;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRSuggestedChangeHelper;
import org.jetbrains.plugins.github.ui.util.GHUIUtil;
import org.jetbrains.plugins.github.ui.util.HtmlEditorPane;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001aB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JJ\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014JN\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00040\u00162\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\f2\u0010\u0010\r\u001a\f\u0012\u0004\u0012\u00020\u000f0\u000ej\u0002`\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0017\u001a\u00020\u0014J\b\u0010\u0018\u001a\u00020\u0019H\u0002\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponent;", "", "()V", "create", "Ljavax/swing/JComponent;", "project", "Lcom/intellij/openapi/project/Project;", "thread", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "comment", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentModel;", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "suggestedChangeHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;", "showResolvedMarker", "", "factory", "Lkotlin/Function1;", "showResolvedMarkerOnFirstComment", "getMaxWidth", "", "Controller", "intellij.vcs.github"})
public final class GHPRReviewCommentComponent {
    @NotNull
    public static final GHPRReviewCommentComponent INSTANCE = new GHPRReviewCommentComponent();

    private GHPRReviewCommentComponent() {
    }

    @NotNull
    public final JComponent create(@NotNull Project project, @NotNull GHPRReviewThreadModel thread, @NotNull GHPRReviewCommentModel comment, @NotNull GHPRReviewDataProvider reviewDataProvider, @NotNull IconsProvider<String> avatarIconsProvider, @NotNull GHPRSuggestedChangeHelper suggestedChangeHelper, boolean showResolvedMarker) {
        JComponent jComponent;
        ActionLink actionLink;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)reviewDataProvider, (String)"reviewDataProvider");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)suggestedChangeHelper, (String)"suggestedChangeHelper");
        Object $this$create_u24lambda_u240 = actionLink = new ActionLink("", (Function1)new Function1<ActionEvent, Unit>(comment){
            final /* synthetic */ GHPRReviewCommentModel $comment;
            {
                this.$comment = $comment;
                super(1);
            }

            public final void invoke(@NotNull ActionEvent it) {
                block0: {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    String string = this.$comment.getAuthorLinkUrl();
                    if (string == null) break block0;
                    String it2 = string;
                    boolean bl = false;
                    BrowserUtil.browse((String)it2);
                }
            }
        });
        boolean bl = false;
        $this$create_u24lambda_u240.setIcon(avatarIconsProvider.getIcon((Object)comment.getAuthorAvatarUrl(), 20));
        $this$create_u24lambda_u240.putClientProperty((Object)"AuxEditorComponent", (Object)true);
        ActionLink avatarLabel2 = actionLink;
        Object $this$create_u24lambda_u241 = $this$create_u24lambda_u240 = new HtmlEditorPane();
        boolean bl2 = false;
        $this$create_u24lambda_u241.setForeground(UIUtil.getContextHelpForeground());
        $this$create_u24lambda_u241.putClientProperty((Object)"AuxEditorComponent", (Object)true);
        Object titlePane = $this$create_u24lambda_u240;
        Object $this$create_u24lambda_u242 = $this$create_u24lambda_u241 = new JBLabel(" " + GithubBundle.message("pull.request.review.comment.pending", new Object[0]) + " ", UIUtil.ComponentStyle.SMALL);
        boolean bl3 = false;
        $this$create_u24lambda_u242.setForeground(UIUtil.getContextHelpForeground());
        $this$create_u24lambda_u242.setBackground(JBUI.CurrentTheme.Validator.warningBackgroundColor());
        JBLabel pendingLabel = $this$create_u24lambda_u241.andOpaque();
        $this$create_u24lambda_u242 = new JBLabel(" " + GithubBundle.message("pull.request.review.comment.resolved", new Object[0]) + " ", UIUtil.ComponentStyle.SMALL);
        Object $this$create_u24lambda_u243 = $this$create_u24lambda_u242;
        boolean bl4 = false;
        $this$create_u24lambda_u243.setForeground(UIUtil.getContextHelpForeground());
        $this$create_u24lambda_u243.setBackground(UIUtil.getPanelBackground());
        JBLabel resolvedLabel = $this$create_u24lambda_u242.andOpaque();
        Object $this$create_u24lambda_u244 = $this$create_u24lambda_u243 = new JPanel((LayoutManager)new VerticalLayout(8, -1));
        boolean bl5 = false;
        ((JComponent)$this$create_u24lambda_u244).putClientProperty("AuxEditorComponent", true);
        ((JComponent)$this$create_u24lambda_u244).setOpaque(false);
        Object commentPanel = $this$create_u24lambda_u243;
        Intrinsics.checkNotNullExpressionValue((Object)pendingLabel, (String)"pendingLabel");
        JComponent jComponent2 = (JComponent)pendingLabel;
        Intrinsics.checkNotNullExpressionValue((Object)resolvedLabel, (String)"resolvedLabel");
        new Controller(project, thread, comment, suggestedChangeHelper, (HtmlEditorPane)((Object)titlePane), jComponent2, (JComponent)resolvedLabel, (JComponent)commentPanel, showResolvedMarker);
        GHEditableHtmlPaneHandle editablePaneHandle2 = new GHEditableHtmlPaneHandle(project, (JComponent)commentPanel, (Function0<String>)((Function0)new PropertyReference0Impl(comment){

            @Nullable
            public Object get() {
                return ((GHPRReviewCommentModel)this.receiver).getBody();
            }
        }), (Function1<? super String, ? extends CompletableFuture<? extends Object>>)((Function1)new Function1<String, CompletableFuture<? extends Object>>(reviewDataProvider, comment){
            final /* synthetic */ GHPRReviewDataProvider $reviewDataProvider;
            final /* synthetic */ GHPRReviewCommentModel $comment;
            {
                this.$reviewDataProvider = $reviewDataProvider;
                this.$comment = $comment;
                super(1);
            }

            @NotNull
            public final CompletableFuture<? extends Object> invoke(@NotNull String it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                return this.$reviewDataProvider.updateComment((ProgressIndicator)new EmptyProgressIndicator(), this.$comment.getId(), it);
            }
        }));
        InlineIconButton $this$create_u24lambda_u245 = bl5 = GHTextActions.INSTANCE.createEditButton(editablePaneHandle2);
        boolean bl6 = false;
        $this$create_u24lambda_u245.setVisible(comment.getCanBeUpdated());
        InlineIconButton editButton = bl5;
        JComponent $this$create_u24lambda_u246 = jComponent = GHTextActions.INSTANCE.createDeleteButton((Function0<? extends CompletableFuture<? extends Object>>)((Function0)new Function0<CompletableFuture<? extends Object>>(reviewDataProvider, comment){
            final /* synthetic */ GHPRReviewDataProvider $reviewDataProvider;
            final /* synthetic */ GHPRReviewCommentModel $comment;
            {
                this.$reviewDataProvider = $reviewDataProvider;
                this.$comment = $comment;
                super(0);
            }

            @NotNull
            public final CompletableFuture<? extends Object> invoke() {
                return this.$reviewDataProvider.deleteComment((ProgressIndicator)new EmptyProgressIndicator(), this.$comment.getId());
            }
        }));
        boolean bl7 = false;
        $this$create_u24lambda_u246.setVisible(comment.getCanBeDeleted());
        JComponent deleteButton2 = jComponent;
        JComponent $this$create_u24lambda_u247 = jComponent = new JPanel(null);
        boolean bl8 = false;
        $this$create_u24lambda_u247.setOpaque(false);
        $this$create_u24lambda_u247.setLayout((LayoutManager)new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill(), new AC().gap(String.valueOf(JBUIScale.scale((int)8)))));
        $this$create_u24lambda_u247.add((Component)avatarLabel2, new CC().pushY());
        $this$create_u24lambda_u247.add((Component)titlePane, new CC().minWidth("0").split(5).alignX("left").pushX());
        $this$create_u24lambda_u247.add((Component)pendingLabel, new CC().hideMode(3).alignX("left"));
        $this$create_u24lambda_u247.add((Component)resolvedLabel, new CC().hideMode(3).alignX("left"));
        $this$create_u24lambda_u247.add((Component)editButton, new CC().hideMode(3).gapBefore(String.valueOf(JBUIScale.scale((int)12))));
        $this$create_u24lambda_u247.add((Component)deleteButton2, new CC().hideMode(3).gapBefore(String.valueOf(JBUIScale.scale((int)8))));
        $this$create_u24lambda_u247.add((Component)editablePaneHandle2.getPanel(), new CC().newline().skip().push().minWidth("0").minHeight("0").growX().maxWidth(String.valueOf(INSTANCE.getMaxWidth())));
        return jComponent;
    }

    public static /* synthetic */ JComponent create$default(GHPRReviewCommentComponent gHPRReviewCommentComponent, Project project, GHPRReviewThreadModel gHPRReviewThreadModel, GHPRReviewCommentModel gHPRReviewCommentModel, GHPRReviewDataProvider gHPRReviewDataProvider, IconsProvider iconsProvider, GHPRSuggestedChangeHelper gHPRSuggestedChangeHelper, boolean bl, int n, Object object) {
        if ((n & 0x40) != 0) {
            bl = true;
        }
        return gHPRReviewCommentComponent.create(project, gHPRReviewThreadModel, gHPRReviewCommentModel, gHPRReviewDataProvider, (IconsProvider<String>)iconsProvider, gHPRSuggestedChangeHelper, bl);
    }

    private final int getMaxWidth() {
        return GHUIUtil.INSTANCE.getPRTimelineWidth() - JBUIScale.scale((int)20) + AllIcons.Actions.Close.getIconWidth();
    }

    @NotNull
    public final Function1<GHPRReviewCommentModel, JComponent> factory(@NotNull Project project, @NotNull GHPRReviewThreadModel thread, @NotNull GHPRReviewDataProvider reviewDataProvider, @NotNull IconsProvider<String> avatarIconsProvider, @NotNull GHPRSuggestedChangeHelper suggestedChangeHelper, boolean showResolvedMarkerOnFirstComment) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
        Intrinsics.checkNotNullParameter((Object)reviewDataProvider, (String)"reviewDataProvider");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)suggestedChangeHelper, (String)"suggestedChangeHelper");
        return (Function1)new Function1<GHPRReviewCommentModel, JComponent>(project, thread, reviewDataProvider, avatarIconsProvider, suggestedChangeHelper, showResolvedMarkerOnFirstComment){
            final /* synthetic */ Project $project;
            final /* synthetic */ GHPRReviewThreadModel $thread;
            final /* synthetic */ GHPRReviewDataProvider $reviewDataProvider;
            final /* synthetic */ IconsProvider<String> $avatarIconsProvider;
            final /* synthetic */ GHPRSuggestedChangeHelper $suggestedChangeHelper;
            final /* synthetic */ boolean $showResolvedMarkerOnFirstComment;
            {
                this.$project = $project;
                this.$thread = $thread;
                this.$reviewDataProvider = $reviewDataProvider;
                this.$avatarIconsProvider = $avatarIconsProvider;
                this.$suggestedChangeHelper = $suggestedChangeHelper;
                this.$showResolvedMarkerOnFirstComment = $showResolvedMarkerOnFirstComment;
                super(1);
            }

            @NotNull
            public final JComponent invoke(@NotNull GHPRReviewCommentModel comment) {
                Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
                return GHPRReviewCommentComponent.INSTANCE.create(this.$project, this.$thread, comment, this.$reviewDataProvider, this.$avatarIconsProvider, this.$suggestedChangeHelper, this.$showResolvedMarkerOnFirstComment);
            }
        };
    }

    public static /* synthetic */ Function1 factory$default(GHPRReviewCommentComponent gHPRReviewCommentComponent, Project project, GHPRReviewThreadModel gHPRReviewThreadModel, GHPRReviewDataProvider gHPRReviewDataProvider, IconsProvider iconsProvider, GHPRSuggestedChangeHelper gHPRSuggestedChangeHelper, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = true;
        }
        return gHPRReviewCommentComponent.factory(project, gHPRReviewThreadModel, gHPRReviewDataProvider, (IconsProvider<String>)iconsProvider, gHPRSuggestedChangeHelper, bl);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\r\u0012\u0006\u0010\u000f\u001a\u00020\r\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentComponent$Controller;", "", "project", "Lcom/intellij/openapi/project/Project;", "thread", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;", "comment", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentModel;", "suggestedChangeHelper", "Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;", "titlePane", "Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane;", "pendingLabel", "Ljavax/swing/JComponent;", "resolvedLabel", "commentPanel", "showResolvedMarker", "", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewThreadModel;Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewCommentModel;Lorg/jetbrains/plugins/github/pullrequest/ui/changes/GHPRSuggestedChangeHelper;Lorg/jetbrains/plugins/github/ui/util/HtmlEditorPane;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Ljavax/swing/JComponent;Z)V", "update", "", "intellij.vcs.github"})
    private static final class Controller {
        @NotNull
        private final Project project;
        @NotNull
        private final GHPRReviewThreadModel thread;
        @NotNull
        private final GHPRReviewCommentModel comment;
        @NotNull
        private final GHPRSuggestedChangeHelper suggestedChangeHelper;
        @NotNull
        private final HtmlEditorPane titlePane;
        @NotNull
        private final JComponent pendingLabel;
        @NotNull
        private final JComponent resolvedLabel;
        @NotNull
        private final JComponent commentPanel;
        private final boolean showResolvedMarker;

        public Controller(@NotNull Project project, @NotNull GHPRReviewThreadModel thread, @NotNull GHPRReviewCommentModel comment, @NotNull GHPRSuggestedChangeHelper suggestedChangeHelper, @NotNull HtmlEditorPane titlePane, @NotNull JComponent pendingLabel, @NotNull JComponent resolvedLabel, @NotNull JComponent commentPanel, boolean showResolvedMarker) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)thread, (String)"thread");
            Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
            Intrinsics.checkNotNullParameter((Object)suggestedChangeHelper, (String)"suggestedChangeHelper");
            Intrinsics.checkNotNullParameter((Object)((Object)titlePane), (String)"titlePane");
            Intrinsics.checkNotNullParameter((Object)pendingLabel, (String)"pendingLabel");
            Intrinsics.checkNotNullParameter((Object)resolvedLabel, (String)"resolvedLabel");
            Intrinsics.checkNotNullParameter((Object)commentPanel, (String)"commentPanel");
            this.project = project;
            this.thread = thread;
            this.comment = comment;
            this.suggestedChangeHelper = suggestedChangeHelper;
            this.titlePane = titlePane;
            this.pendingLabel = pendingLabel;
            this.resolvedLabel = resolvedLabel;
            this.commentPanel = commentPanel;
            this.showResolvedMarker = showResolvedMarker;
            this.comment.addChangesListener((Function0<Unit>)((Function0)new Function0<Unit>(){

                public final void invoke() {
                    this.update();
                }
            }));
            this.update();
        }

        private final void update() {
            String string;
            JComponent jComponent;
            GHPRReviewCommentComponentFactory commentComponentFactory = new GHPRReviewCommentComponentFactory(this.project);
            if (GHSuggestedChange.Companion.containsSuggestedChange(this.comment.getBody())) {
                Integer n = this.thread.getStartLine();
                GHSuggestedChange suggestedChange = GHSuggestedChange.Companion.create(this.comment.getBody(), this.thread.getDiffHunk(), this.thread.getFilePath(), n != null ? n.intValue() : this.thread.getLine(), this.thread.getLine());
                jComponent = commentComponentFactory.createCommentWithSuggestedChangeComponent(this.thread, suggestedChange, this.suggestedChangeHelper);
            } else {
                jComponent = commentComponentFactory.createCommentComponent(this.comment.getBody());
            }
            JComponent commentComponent = jComponent;
            this.commentPanel.removeAll();
            this.commentPanel.add(commentComponent);
            HtmlBuilder htmlBuilder = new HtmlBuilder();
            String string2 = this.comment.getAuthorLinkUrl();
            if (string2 == null) {
                string2 = "";
            }
            if ((string = this.comment.getAuthorUsername()) == null) {
                String string3 = GithubBundle.message("user.someone", new Object[0]);
                string = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"user.someone\")");
            }
            String string4 = htmlBuilder.appendLink(string2, string).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"HtmlBuilder()\n        .a\u2026ne\"))\n        .toString()");
            String authorLink = string4;
            switch (WhenMappings.$EnumSwitchMapping$0[this.comment.getState().ordinal()]) {
                case 1: {
                    this.pendingLabel.setVisible(true);
                    this.titlePane.setBody(authorLink);
                    break;
                }
                case 2: {
                    this.pendingLabel.setVisible(false);
                    Object[] objectArray = new Object[]{authorLink, GHUIUtil.INSTANCE.formatActionDate(this.comment.getDateCreated())};
                    String string5 = GithubBundle.message("pull.request.review.commented", objectArray);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"pull.request.re\u2026ate(comment.dateCreated))");
                    this.titlePane.setBody(string5);
                }
            }
            this.resolvedLabel.setVisible(this.comment.isFirstInResolvedThread() && this.showResolvedMarker);
        }

        @Metadata(mv={1, 7, 1}, k=3, xi=48)
        public final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[GHPullRequestReviewCommentState.values().length];
                try {
                    nArray[GHPullRequestReviewCommentState.PENDING.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[GHPullRequestReviewCommentState.SUBMITTED.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }
}

