/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment;

import com.intellij.openapi.diff.impl.patch.ApplyPatchStatus;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchLine;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.diff.impl.patch.apply.GenericPatchApplier;
import com.intellij.openapi.diff.impl.patch.formove.PatchApplier;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.LocalFilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsImplUtil;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitOptions;
import git4idea.index.GitIndexUtil;
import git4idea.repo.GitRepository;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.pullrequest.comment.GHSuggestedChange;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\f\u001a\u00020\rJ\u000e\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0010H\u0002J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0006\u001a\u00020\u0007H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\t\u001a\u00070\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestedChangeApplier;", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lgit4idea/repo/GitRepository;", "suggestedChange", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestedChange;", "(Lcom/intellij/openapi/project/Project;Lgit4idea/repo/GitRepository;Lorg/jetbrains/plugins/github/pullrequest/comment/GHSuggestedChange;)V", "virtualBaseDir", "Lcom/intellij/openapi/vfs/VirtualFile;", "Lorg/jetbrains/annotations/NotNull;", "applySuggestedChange", "Lcom/intellij/openapi/diff/impl/patch/ApplyPatchStatus;", "commitSuggestedChanges", "commitMessage", "", "createLocalFilePath", "Lcom/intellij/openapi/vcs/LocalFilePath;", "filename", "createSuggestedChangePatch", "Lcom/intellij/openapi/diff/impl/patch/TextFilePatch;", "createSuggestedChangePatchHunk", "Lcom/intellij/openapi/diff/impl/patch/PatchHunk;", "intellij.vcs.github"})
public final class GHSuggestedChangeApplier {
    @NotNull
    private final Project project;
    @NotNull
    private final GitRepository repository;
    @NotNull
    private final GHSuggestedChange suggestedChange;
    @NotNull
    private final VirtualFile virtualBaseDir;

    public GHSuggestedChangeApplier(@NotNull Project project, @NotNull GitRepository repository, @NotNull GHSuggestedChange suggestedChange) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)suggestedChange, (String)"suggestedChange");
        this.project = project;
        this.repository = repository;
        this.suggestedChange = suggestedChange;
        VirtualFile virtualFile = this.repository.getRoot();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"repository.root");
        this.virtualBaseDir = virtualFile;
    }

    @NotNull
    public final ApplyPatchStatus applySuggestedChange() {
        TextFilePatch suggestedChangePatch = this.createSuggestedChangePatch(this.suggestedChange);
        PatchApplier patchApplier = new PatchApplier(this.project, this.virtualBaseDir, CollectionsKt.listOf((Object)suggestedChangePatch), null, null);
        ApplyPatchStatus applyPatchStatus = patchApplier.execute(true, false);
        Intrinsics.checkNotNullExpressionValue((Object)applyPatchStatus, (String)"patchApplier.execute(true, false)");
        return applyPatchStatus;
    }

    private final PatchHunk createSuggestedChangePatchHunk(GHSuggestedChange suggestedChange) {
        String it;
        List<String> suggestedChangeContent = suggestedChange.cutSuggestedChangeContent();
        PatchHunk suggestedChangePatchHunk = new PatchHunk(suggestedChange.getStartLine(), suggestedChange.getEndLine(), suggestedChange.getStartLine(), suggestedChange.getStartLine() + suggestedChangeContent.size() - 1);
        Iterable $this$forEach$iv = suggestedChange.cutContextContent();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            suggestedChangePatchHunk.addLine(new PatchLine(PatchLine.Type.CONTEXT, it));
        }
        $this$forEach$iv = suggestedChange.cutChangedContent();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            suggestedChangePatchHunk.addLine(new PatchLine(PatchLine.Type.REMOVE, it));
        }
        $this$forEach$iv = suggestedChangeContent;
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            it = (String)element$iv;
            boolean bl = false;
            suggestedChangePatchHunk.addLine(new PatchLine(PatchLine.Type.ADD, it));
        }
        return suggestedChangePatchHunk;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ApplyPatchStatus commitSuggestedChanges(@NotNull String commitMessage) {
        Intrinsics.checkNotNullParameter((Object)commitMessage, (String)"commitMessage");
        TextFilePatch suggestedChangePatch = this.createSuggestedChangePatch(this.suggestedChange);
        PatchApplier patchApplier = new PatchApplier(this.project, this.virtualBaseDir, CollectionsKt.listOf((Object)suggestedChangePatch), null, null);
        ApplyPatchStatus patchStatus = patchApplier.execute(true, false);
        if (patchStatus == ApplyPatchStatus.ALREADY_APPLIED) {
            Intrinsics.checkNotNullExpressionValue((Object)patchStatus, (String)"patchStatus");
            return patchStatus;
        }
        String string = suggestedChangePatch.getBeforeName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"suggestedChangePatch.beforeName");
        LocalFilePath beforeLocalFilePath = this.createLocalFilePath(string);
        String string2 = suggestedChangePatch.getAfterName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"suggestedChangePatch.afterName");
        LocalFilePath afterLocalFilePath = this.createLocalFilePath(string2);
        byte[] bytes = GitFileUtils.getFileContent((Project)this.project, (VirtualFile)this.virtualBaseDir, (String)"HEAD", (String)suggestedChangePatch.getBeforeName());
        String string3 = VcsImplUtil.loadTextFromBytes((Project)this.project, (byte[])bytes, (FilePath)((FilePath)beforeLocalFilePath));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"loadTextFromBytes(projec\u2026tes, beforeLocalFilePath)");
        String revisionContent = string3;
        GenericPatchApplier.AppliedPatch appliedPatch = GenericPatchApplier.apply((CharSequence)revisionContent, (List)suggestedChangePatch.getHunks());
        if (appliedPatch == null || appliedPatch.status != ApplyPatchStatus.SUCCESS) {
            GenericPatchApplier.AppliedPatch appliedPatch2 = appliedPatch;
            Object object = appliedPatch2 != null ? appliedPatch2.status : null;
            if (object == null) {
                object = ApplyPatchStatus.FAILURE;
            }
            return object;
        }
        VirtualFile virtualFile = beforeLocalFilePath.getVirtualFile();
        if (virtualFile == null) {
            return ApplyPatchStatus.FAILURE;
        }
        VirtualFile virtualFile2 = virtualFile;
        byte[] fileContent = GitCheckinEnvironment.convertDocumentContentToBytesWithBOM((GitRepository)this.repository, (String)appliedPatch.patchedText, (VirtualFile)virtualFile2);
        GitIndexUtil.StagedFile stagedFile = GitIndexUtil.listStaged((GitRepository)this.repository, (FilePath)((FilePath)beforeLocalFilePath));
        if (stagedFile == null) {
            return ApplyPatchStatus.FAILURE;
        }
        GitIndexUtil.StagedFile stagedFile2 = stagedFile;
        GitIndexUtil.write((GitRepository)this.repository, (FilePath)((FilePath)beforeLocalFilePath), (byte[])fileContent, (boolean)stagedFile2.isExecutable());
        GitCheckinEnvironment.ChangedPath suggestedChangedPath = new GitCheckinEnvironment.ChangedPath((FilePath)beforeLocalFilePath, (FilePath)afterLocalFilePath);
        File file = GitCheckinEnvironment.createCommitMessageFile((Project)this.project, (VirtualFile)this.virtualBaseDir, (String)commitMessage);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"createCommitMessageFile(\u2026alBaseDir, commitMessage)");
        File commitMessageFile = file;
        List list = GitCheckinEnvironment.commitUsingIndex((Project)this.project, (GitRepository)this.repository, (Collection)CollectionsKt.listOf((Object)suggestedChangedPath), (Set)SetsKt.setOf((Object)suggestedChangedPath), (File)commitMessageFile, (GitCommitOptions)new GitCommitOptions(false, false, false, null, null, false, 63, null));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"commitUsingIndex(project\u2026File, GitCommitOptions())");
        List exceptions = list;
        if (!((Collection)exceptions).isEmpty()) {
            void $this$toTypedArray$iv;
            void $this$flatMapTo$iv$iv;
            Iterable $this$flatMap$iv = exceptions;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                VcsException it = (VcsException)((Object)element$iv$iv);
                boolean bl = false;
                String[] stringArray = it.getMessages();
                Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"it.messages");
                Iterable list$iv$iv = ArraysKt.toList((Object[])stringArray);
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv;
            boolean $i$f$toTypedArray = false;
            void thisCollection$iv = $this$toTypedArray$iv;
            String[] messages = thisCollection$iv.toArray(new String[0]);
            GithubUtil.LOG.error("Failed to commit suggested change", Arrays.copyOf(messages, messages.length));
            return ApplyPatchStatus.FAILURE;
        }
        return ApplyPatchStatus.SUCCESS;
    }

    private final TextFilePatch createSuggestedChangePatch(GHSuggestedChange suggestedChange) {
        TextFilePatch textFilePatch;
        PatchHunk suggestedChangePatchHunk = this.createSuggestedChangePatchHunk(suggestedChange);
        TextFilePatch $this$createSuggestedChangePatch_u24lambda_u244 = textFilePatch = new TextFilePatch(Charset.defaultCharset());
        boolean bl = false;
        $this$createSuggestedChangePatch_u24lambda_u244.setBeforeName(suggestedChange.getFilePath());
        $this$createSuggestedChangePatch_u24lambda_u244.setAfterName(suggestedChange.getFilePath());
        $this$createSuggestedChangePatch_u24lambda_u244.addHunk(suggestedChangePatchHunk);
        return textFilePatch;
    }

    private final LocalFilePath createLocalFilePath(String filename) {
        String[] stringArray = new String[]{filename};
        return new LocalFilePath(Path.of(this.virtualBaseDir.getPath(), stringArray), false);
    }
}

