/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.comment;

import com.intellij.collaboration.ui.SingleValueModel;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.diff.tools.fragmented.UnifiedDiffViewer;
import com.intellij.diff.tools.simple.SimpleOnesideDiffViewer;
import com.intellij.diff.tools.util.base.DiffViewerBase;
import com.intellij.diff.tools.util.side.TwosideTextDiffViewer;
import com.intellij.diff.util.Range;
import com.intellij.diff.util.Side;
import com.intellij.execution.process.ProcessIOExecutorService;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diff.impl.patch.PatchHunk;
import com.intellij.openapi.diff.impl.patch.PatchReader;
import com.intellij.openapi.diff.impl.patch.TextFilePatch;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.Delegates;
import kotlin.properties.ObservableProperty;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHCommitHash;
import org.jetbrains.plugins.github.api.data.GHUser;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestPendingReview;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestReviewThread;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewSupport;
import org.jetbrains.plugins.github.pullrequest.comment.GHPRDiffReviewThreadMapping;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRDiffEditorReviewComponentsFactoryImpl;
import org.jetbrains.plugins.github.pullrequest.comment.ui.GHPRReviewProcessModelImpl;
import org.jetbrains.plugins.github.pullrequest.comment.viewer.GHPRSimpleOnesideDiffViewerReviewThreadsHandler;
import org.jetbrains.plugins.github.pullrequest.comment.viewer.GHPRTwosideDiffViewerReviewThreadsHandler;
import org.jetbrains.plugins.github.pullrequest.comment.viewer.GHPRUnifiedDiffViewerReviewThreadsHandler;
import org.jetbrains.plugins.github.pullrequest.data.GHPRChangeDiffData;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.ui.GHCompletableFutureLoadingModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHLoadingModel;
import org.jetbrains.plugins.github.pullrequest.ui.GHSimpleLoadingModel;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRCreateDiffCommentParametersHelper;
import org.jetbrains.plugins.github.pullrequest.ui.changes.GHPRSuggestedChangeHelper;
import org.jetbrains.plugins.github.util.GHPatchHunkUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0010\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J\u0018\u0010+\u001a\u00020,2\u000e\u0010-\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00180.H\u0002J\u001c\u0010/\u001a\u00020,2\u0012\u0010-\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c0.H\u0002J\u0010\u00100\u001a\u00020,2\u0006\u00101\u001a\u000202H\u0016J\u0010\u00103\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\u0010\u00106\u001a\u00020,2\u0006\u00104\u001a\u000205H\u0002J\u0012\u00107\u001a\u0004\u0018\u00010\u001d2\u0006\u00108\u001a\u000209H\u0002J\b\u0010:\u001a\u00020,H\u0016J\b\u0010;\u001a\u00020,H\u0002R\u0018\u0010\b\u001a\f\u0012\u0004\u0012\u00020\n0\tj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0015R\u0018\u0010\u0016\u001a\f\u0012\u0006\u0012\u0004\u0018\u00010\u0018\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001b\u001a\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001d0\u001c\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001e\u001a\u0010\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u001d\u0018\u00010\u001c0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R+\u0010!\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00148V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b%\u0010&\u001a\u0004\b\"\u0010\u0015\"\u0004\b#\u0010$R+\u0010'\u001a\u00020\u00142\u0006\u0010 \u001a\u00020\u00148V@VX\u0096\u008e\u0002\u00a2\u0006\u0012\n\u0004\b*\u0010&\u001a\u0004\b(\u0010\u0015\"\u0004\b)\u0010$\u00a8\u0006<"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/comment/GHPRDiffReviewSupportImpl;", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHPRDiffReviewSupport;", "project", "Lcom/intellij/openapi/project/Project;", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "detailsDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "diffData", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData;", "currentUser", "Lorg/jetbrains/plugins/github/api/data/GHUser;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;Lcom/intellij/collaboration/ui/icon/IconsProvider;Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRChangeDiffData;Lorg/jetbrains/plugins/github/api/data/GHUser;)V", "isLoadingReviewData", "", "()Z", "pendingReviewLoadingModel", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHSimpleLoadingModel;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestPendingReview;", "reviewProcessModel", "Lorg/jetbrains/plugins/github/pullrequest/comment/ui/GHPRReviewProcessModelImpl;", "reviewThreadsLoadingModel", "", "Lorg/jetbrains/plugins/github/pullrequest/comment/GHPRDiffReviewThreadMapping;", "reviewThreadsModel", "Lcom/intellij/collaboration/ui/SingleValueModel;", "<set-?>", "showResolvedReviewThreads", "getShowResolvedReviewThreads", "setShowResolvedReviewThreads", "(Z)V", "showResolvedReviewThreads$delegate", "Lkotlin/properties/ReadWriteProperty;", "showReviewThreads", "getShowReviewThreads", "setShowReviewThreads", "showReviewThreads$delegate", "doLoadPendingReview", "", "model", "Lorg/jetbrains/plugins/github/pullrequest/ui/GHCompletableFutureLoadingModel;", "doLoadReviewThreads", "install", "viewer", "Lcom/intellij/diff/tools/util/base/DiffViewerBase;", "loadPendingReview", "disposable", "Lcom/intellij/openapi/Disposable;", "loadReviewThreads", "mapThread", "thread", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestReviewThread;", "reloadReviewData", "updateReviewThreads", "intellij.vcs.github"})
public final class GHPRDiffReviewSupportImpl
implements GHPRDiffReviewSupport {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRReviewDataProvider reviewDataProvider;
    @NotNull
    private final GHPRDetailsDataProvider detailsDataProvider;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final GHPRChangeDiffData diffData;
    @NotNull
    private final GHUser currentUser;
    @Nullable
    private GHSimpleLoadingModel<GHPullRequestPendingReview> pendingReviewLoadingModel;
    @NotNull
    private final GHPRReviewProcessModelImpl reviewProcessModel;
    @Nullable
    private GHSimpleLoadingModel<List<GHPRDiffReviewThreadMapping>> reviewThreadsLoadingModel;
    @NotNull
    private final SingleValueModel<List<GHPRDiffReviewThreadMapping>> reviewThreadsModel;
    @NotNull
    private final ReadWriteProperty showReviewThreads$delegate;
    @NotNull
    private final ReadWriteProperty showResolvedReviewThreads$delegate;

    public GHPRDiffReviewSupportImpl(@NotNull Project project, @NotNull GHPRReviewDataProvider reviewDataProvider, @NotNull GHPRDetailsDataProvider detailsDataProvider, @NotNull IconsProvider<String> avatarIconsProvider, @NotNull GHPRRepositoryDataService repositoryDataService, @NotNull GHPRChangeDiffData diffData, @NotNull GHUser currentUser) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)reviewDataProvider, (String)"reviewDataProvider");
        Intrinsics.checkNotNullParameter((Object)detailsDataProvider, (String)"detailsDataProvider");
        Intrinsics.checkNotNullParameter(avatarIconsProvider, (String)"avatarIconsProvider");
        Intrinsics.checkNotNullParameter((Object)repositoryDataService, (String)"repositoryDataService");
        Intrinsics.checkNotNullParameter((Object)diffData, (String)"diffData");
        Intrinsics.checkNotNullParameter((Object)currentUser, (String)"currentUser");
        this.project = project;
        this.reviewDataProvider = reviewDataProvider;
        this.detailsDataProvider = detailsDataProvider;
        this.avatarIconsProvider = avatarIconsProvider;
        this.repositoryDataService = repositoryDataService;
        this.diffData = diffData;
        this.currentUser = currentUser;
        this.reviewProcessModel = new GHPRReviewProcessModelImpl();
        this.reviewThreadsModel = new SingleValueModel(null);
        Delegates delegates = Delegates.INSTANCE;
        Boolean initialValue$iv = true;
        boolean $i$f$observable = false;
        this.showReviewThreads$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ GHPRDiffReviewSupportImpl this$0;
            {
                this.this$0 = gHPRDiffReviewSupportImpl;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                ((Boolean)newValue).booleanValue();
                ((Boolean)oldValue).booleanValue();
                boolean bl = false;
                GHPRDiffReviewSupportImpl.access$updateReviewThreads(this.this$0);
            }
        };
        Delegates this_$iv = Delegates.INSTANCE;
        initialValue$iv = false;
        $i$f$observable = false;
        this.showResolvedReviewThreads$delegate = (ReadWriteProperty)new ObservableProperty<Boolean>((Object)initialValue$iv, this){
            final /* synthetic */ GHPRDiffReviewSupportImpl this$0;
            {
                this.this$0 = gHPRDiffReviewSupportImpl;
                super($initialValue);
            }

            /*
             * Ignored method signature, as it can't be verified against descriptor
             */
            protected void afterChange(@NotNull KProperty property, Object oldValue, Object newValue) {
                Intrinsics.checkNotNullParameter((Object)property, (String)"property");
                ((Boolean)newValue).booleanValue();
                ((Boolean)oldValue).booleanValue();
                boolean bl = false;
                GHPRDiffReviewSupportImpl.access$updateReviewThreads(this.this$0);
            }
        };
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isLoadingReviewData() {
        boolean bl;
        GHSimpleLoadingModel<List<GHPRDiffReviewThreadMapping>> gHSimpleLoadingModel = this.reviewThreadsLoadingModel;
        if (gHSimpleLoadingModel != null) {
            if (gHSimpleLoadingModel.getLoading()) {
                return true;
            }
            bl = false;
        } else {
            bl = false;
        }
        if (bl) return true;
        GHSimpleLoadingModel<GHPullRequestPendingReview> gHSimpleLoadingModel2 = this.pendingReviewLoadingModel;
        if (gHSimpleLoadingModel2 == null) return false;
        if (!gHSimpleLoadingModel2.getLoading()) return false;
        return true;
    }

    @Override
    public boolean getShowReviewThreads() {
        return (Boolean)this.showReviewThreads$delegate.getValue((Object)this, $$delegatedProperties[0]);
    }

    @Override
    public void setShowReviewThreads(boolean bl) {
        this.showReviewThreads$delegate.setValue((Object)this, $$delegatedProperties[0], (Object)bl);
    }

    @Override
    public boolean getShowResolvedReviewThreads() {
        return (Boolean)this.showResolvedReviewThreads$delegate.getValue((Object)this, $$delegatedProperties[1]);
    }

    @Override
    public void setShowResolvedReviewThreads(boolean bl) {
        this.showResolvedReviewThreads$delegate.setValue((Object)this, $$delegatedProperties[1], (Object)bl);
    }

    @Override
    public void install(@NotNull DiffViewerBase viewer) {
        Intrinsics.checkNotNullParameter((Object)viewer, (String)"viewer");
        SingleValueModel diffRangesModel = new SingleValueModel(this.reviewDataProvider.canComment() ? this.diffData.getDiffRanges() : null);
        if (this.reviewDataProvider.canComment()) {
            this.loadPendingReview((Disposable)viewer);
            Ref.BooleanRef rangesInstalled = new Ref.BooleanRef();
            this.reviewProcessModel.addAndInvokeChangesListener(() -> GHPRDiffReviewSupportImpl.install$lambda$2(this, rangesInstalled, diffRangesModel));
        }
        this.loadReviewThreads((Disposable)viewer);
        GHPRCreateDiffCommentParametersHelper createCommentParametersHelper = new GHPRCreateDiffCommentParametersHelper(this.diffData.getCommitSha(), this.diffData.getFilePath(), this.diffData.getLinesMapper());
        GHPRSuggestedChangeHelper suggestedChangesHelper = new GHPRSuggestedChangeHelper(this.project, (Disposable)viewer, this.repositoryDataService.getRemoteCoordinates().getRepository(), this.reviewDataProvider, this.detailsDataProvider);
        GHPRDiffEditorReviewComponentsFactoryImpl componentsFactory = new GHPRDiffEditorReviewComponentsFactoryImpl(this.project, this.reviewDataProvider, this.avatarIconsProvider, createCommentParametersHelper, suggestedChangesHelper, this.currentUser);
        boolean cumulative = this.diffData instanceof GHPRChangeDiffData.Cumulative;
        DiffViewerBase diffViewerBase = viewer;
        if (diffViewerBase instanceof SimpleOnesideDiffViewer) {
            new GHPRSimpleOnesideDiffViewerReviewThreadsHandler(this.reviewProcessModel, (SingleValueModel<List<Range>>)diffRangesModel, this.reviewThreadsModel, (SimpleOnesideDiffViewer)viewer, componentsFactory, cumulative);
        } else if (diffViewerBase instanceof UnifiedDiffViewer) {
            new GHPRUnifiedDiffViewerReviewThreadsHandler(this.reviewProcessModel, (SingleValueModel<List<Range>>)diffRangesModel, this.reviewThreadsModel, (UnifiedDiffViewer)viewer, componentsFactory, cumulative);
        } else if (diffViewerBase instanceof TwosideTextDiffViewer) {
            new GHPRTwosideDiffViewerReviewThreadsHandler(this.reviewProcessModel, (SingleValueModel<List<Range>>)diffRangesModel, this.reviewThreadsModel, (TwosideTextDiffViewer)viewer, componentsFactory, cumulative);
        } else {
            return;
        }
    }

    @Override
    public void reloadReviewData() {
        this.reviewDataProvider.resetPendingReview();
        this.reviewDataProvider.resetReviewThreads();
    }

    private final void loadPendingReview(Disposable disposable) {
        GHCompletableFutureLoadingModel<GHPullRequestPendingReview> gHCompletableFutureLoadingModel;
        GHCompletableFutureLoadingModel<GHPullRequestPendingReview> it = gHCompletableFutureLoadingModel = new GHCompletableFutureLoadingModel<GHPullRequestPendingReview>(disposable);
        boolean bl = false;
        it.addStateChangeListener(new GHLoadingModel.StateChangeListener(it, this){
            final /* synthetic */ GHCompletableFutureLoadingModel<GHPullRequestPendingReview> $it;
            final /* synthetic */ GHPRDiffReviewSupportImpl this$0;
            {
                this.$it = $it;
                this.this$0 = $receiver;
            }

            public void onLoadingCompleted() {
                if (this.$it.getResultAvailable()) {
                    GHPRDiffReviewSupportImpl.access$getReviewProcessModel$p(this.this$0).populatePendingReviewData((GHPullRequestPendingReview)this.$it.getResult());
                }
            }
        });
        GHCompletableFutureLoadingModel<GHPullRequestPendingReview> loadingModel2 = gHCompletableFutureLoadingModel;
        this.pendingReviewLoadingModel = loadingModel2;
        this.doLoadPendingReview(loadingModel2);
        this.reviewDataProvider.addPendingReviewListener(disposable, (Function0<Unit>)((Function0)new Function0<Unit>(this, loadingModel2){
            final /* synthetic */ GHPRDiffReviewSupportImpl this$0;
            final /* synthetic */ GHCompletableFutureLoadingModel<GHPullRequestPendingReview> $loadingModel;
            {
                this.this$0 = $receiver;
                this.$loadingModel = $loadingModel;
                super(0);
            }

            public final void invoke() {
                GHPRDiffReviewSupportImpl.access$getReviewProcessModel$p(this.this$0).clearPendingReviewData();
                GHPRDiffReviewSupportImpl.access$doLoadPendingReview(this.this$0, this.$loadingModel);
            }
        }));
    }

    private final void doLoadPendingReview(GHCompletableFutureLoadingModel<GHPullRequestPendingReview> model2) {
        model2.setFuture(this.reviewDataProvider.loadPendingReview());
    }

    private final void loadReviewThreads(Disposable disposable) {
        GHCompletableFutureLoadingModel<List<GHPRDiffReviewThreadMapping>> gHCompletableFutureLoadingModel;
        GHCompletableFutureLoadingModel<List<GHPRDiffReviewThreadMapping>> $this$loadReviewThreads_u24lambda_u244 = gHCompletableFutureLoadingModel = new GHCompletableFutureLoadingModel<List<GHPRDiffReviewThreadMapping>>(disposable);
        boolean bl = false;
        $this$loadReviewThreads_u24lambda_u244.addStateChangeListener(new GHLoadingModel.StateChangeListener(this){
            final /* synthetic */ GHPRDiffReviewSupportImpl this$0;
            {
                this.this$0 = $receiver;
            }

            public void onLoadingCompleted() {
                GHPRDiffReviewSupportImpl.access$updateReviewThreads(this.this$0);
            }
        });
        GHCompletableFutureLoadingModel<List<GHPRDiffReviewThreadMapping>> loadingModel2 = gHCompletableFutureLoadingModel;
        this.reviewThreadsLoadingModel = loadingModel2;
        this.doLoadReviewThreads(loadingModel2);
        this.reviewDataProvider.addReviewThreadsListener(disposable, (Function0<Unit>)((Function0)new Function0<Unit>(this, loadingModel2){
            final /* synthetic */ GHPRDiffReviewSupportImpl this$0;
            final /* synthetic */ GHCompletableFutureLoadingModel<List<GHPRDiffReviewThreadMapping>> $loadingModel;
            {
                this.this$0 = $receiver;
                this.$loadingModel = $loadingModel;
                super(0);
            }

            public final void invoke() {
                GHPRDiffReviewSupportImpl.access$doLoadReviewThreads(this.this$0, this.$loadingModel);
            }
        }));
    }

    private final void doLoadReviewThreads(GHCompletableFutureLoadingModel<List<GHPRDiffReviewThreadMapping>> model2) {
        model2.setFuture((CompletableFuture<List<GHPRDiffReviewThreadMapping>>)this.reviewDataProvider.loadReviewThreads().thenApplyAsync(arg_0 -> GHPRDiffReviewSupportImpl.doLoadReviewThreads$lambda$5(this, arg_0), (Executor)ProcessIOExecutorService.INSTANCE));
    }

    private final GHPRDiffReviewThreadMapping mapThread(GHPullRequestReviewThread thread) {
        Pair<Side, Integer> pair;
        Object object = thread.getOriginalCommit();
        if (object == null || (object = ((GHCommitHash)object).getOid()) == null) {
            return null;
        }
        Object originalCommitSha = object;
        if (!this.diffData.contains((String)originalCommitSha, thread.getPath())) {
            return null;
        }
        GHPRChangeDiffData gHPRChangeDiffData = this.diffData;
        if (gHPRChangeDiffData instanceof GHPRChangeDiffData.Cumulative) {
            pair = TuplesKt.to((Object)thread.getSide(), (Object)(thread.getLine() - 1));
        } else if (gHPRChangeDiffData instanceof GHPRChangeDiffData.Commit) {
            int unmappedLine;
            PatchReader patchReader = new PatchReader((CharSequence)GHPatchHunkUtil.INSTANCE.createPatchFromHunk(thread.getPath(), thread.getDiffHunk()));
            patchReader.readTextPatches();
            List list = ((TextFilePatch)patchReader.getTextPatches().get(0)).getHunks();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"patchReader.textPatches[0].hunks");
            PatchHunk patchHunk = (PatchHunk)CollectionsKt.lastOrNull((List)list);
            if (patchHunk == null) {
                return null;
            }
            PatchHunk patchHunk2 = patchHunk;
            int position = GHPatchHunkUtil.INSTANCE.getHunkLinesCount(patchHunk2) - 1;
            Pair<Side, Integer> pair2 = GHPatchHunkUtil.INSTANCE.findSideFileLineFromHunkLineIndex(patchHunk2, position);
            if (pair2 == null) {
                return null;
            }
            Pair<Side, Integer> pair3 = pair2;
            Side unmappedSide = (Side)pair3.component1();
            pair = ((GHPRChangeDiffData.Commit)this.diffData).mapPosition((String)originalCommitSha, unmappedSide, unmappedLine = ((Number)pair3.component2()).intValue());
            if (pair == null) {
                return null;
            }
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Pair<Side, Integer> pair4 = pair;
        Side side = (Side)pair4.component1();
        int line = ((Number)pair4.component2()).intValue();
        return new GHPRDiffReviewThreadMapping(side, line, thread);
    }

    /*
     * WARNING - void declaration
     */
    private final void updateReviewThreads() {
        List list;
        GHSimpleLoadingModel<List<GHPRDiffReviewThreadMapping>> gHSimpleLoadingModel = this.reviewThreadsLoadingModel;
        if (gHSimpleLoadingModel == null) {
            return;
        }
        GHSimpleLoadingModel<List<GHPRDiffReviewThreadMapping>> loadingModel2 = gHSimpleLoadingModel;
        if (loadingModel2.getLoading()) {
            return;
        }
        SingleValueModel<List<GHPRDiffReviewThreadMapping>> singleValueModel = this.reviewThreadsModel;
        if (this.getShowReviewThreads()) {
            List<GHPRDiffReviewThreadMapping> list2 = loadingModel2.getResult();
            if (list2 != null) {
                void $this$filterTo$iv$iv;
                void $this$filter$iv;
                Iterable iterable = list2;
                SingleValueModel<List<GHPRDiffReviewThreadMapping>> singleValueModel2 = singleValueModel;
                boolean $i$f$filter = false;
                void var4_5 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    GHPRDiffReviewThreadMapping it = (GHPRDiffReviewThreadMapping)element$iv$iv;
                    boolean bl = false;
                    if (!(this.getShowResolvedReviewThreads() || !it.getThread().isResolved())) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                singleValueModel = singleValueModel2;
            } else {
                list = null;
            }
        } else {
            list = null;
        }
        singleValueModel.setValue(list);
    }

    private static final void install$lambda$2(GHPRDiffReviewSupportImpl this$0, Ref.BooleanRef $rangesInstalled, SingleValueModel $diffRangesModel) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$rangesInstalled, (String)"$rangesInstalled");
        Intrinsics.checkNotNullParameter((Object)$diffRangesModel, (String)"$diffRangesModel");
        if (this$0.reviewProcessModel.isActual() && !$rangesInstalled.element) {
            $diffRangesModel.setValue(this$0.diffData.getDiffRanges());
            $rangesInstalled.element = true;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static final List doLoadReviewThreads$lambda$5(GHPRDiffReviewSupportImpl this$0, List it) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        Iterable $this$mapNotNull$iv = it;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GHPRDiffReviewThreadMapping it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            GHPullRequestReviewThread p0 = (GHPullRequestReviewThread)element$iv$iv;
            boolean bl2 = false;
            if (this$0.mapThread(p0) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public static final /* synthetic */ GHPRReviewProcessModelImpl access$getReviewProcessModel$p(GHPRDiffReviewSupportImpl $this) {
        return $this.reviewProcessModel;
    }

    public static final /* synthetic */ void access$doLoadPendingReview(GHPRDiffReviewSupportImpl $this, GHCompletableFutureLoadingModel model2) {
        $this.doLoadPendingReview(model2);
    }

    public static final /* synthetic */ void access$doLoadReviewThreads(GHPRDiffReviewSupportImpl $this, GHCompletableFutureLoadingModel model2) {
        $this.doLoadReviewThreads(model2);
    }

    public static final /* synthetic */ void access$updateReviewThreads(GHPRDiffReviewSupportImpl $this) {
        $this.updateReviewThreads();
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GHPRDiffReviewSupportImpl.class, "showReviewThreads", "getShowReviewThreads()Z", 0))), (KProperty)Reflection.mutableProperty1((MutablePropertyReference1)((MutablePropertyReference1)new MutablePropertyReference1Impl(GHPRDiffReviewSupportImpl.class, "showResolvedReviewThreads", "getShowResolvedReviewThreads()Z", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

