/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest.action;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.ui.laf.darcula.ui.DarculaButtonUI;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.actions.IncrementalFindAction;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.panels.HorizontalBox;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.InlineIconButton;
import com.intellij.util.ui.JBDimension;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.JButtonAction;
import com.intellij.util.ui.UIUtil;
import icons.CollaborationToolsIcons;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.concurrent.CompletableFuture;
import javax.swing.AbstractButton;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import net.miginfocom.layout.CC;
import net.miginfocom.layout.LC;
import net.miginfocom.swing.MigLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GHNodes;
import org.jetbrains.plugins.github.api.data.GHPullRequestReviewEvent;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestPendingReview;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.action.GHPRReviewSubmitAction;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.ui.component.GHHtmlErrorPanel;
import org.jetbrains.plugins.github.ui.component.GHSimpleErrorPanelModel;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u001a\u0010\u0015\u001a\f0\u0016\u00a2\u0006\u0002\b\u0017\u00a2\u0006\u0002\b\u00182\u0006\u0010\u0019\u001a\u00020\u0016H\u0002J\u0017\u0010\u001a\u001a\u00020\u00162\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0003\u00a2\u0006\u0002\u0010\u001dJ\u0010\u0010\u001e\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u001f\u001a\u00020\u00042\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#H\u0014\u00a8\u0006%"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GHPRReviewSubmitAction;", "Lcom/intellij/util/ui/JButtonAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "createPopupComponent", "Lcom/intellij/openapi/ui/ComponentContainer;", "reviewDataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "document", "Lcom/intellij/openapi/editor/Document;", "cancelActionListener", "Ljava/awt/event/ActionListener;", "pendingReview", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestPendingReview;", "viewerIsAuthor", "", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "getPrefix", "", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "place", "getText", "pendingComments", "", "(Ljava/lang/Integer;)Ljava/lang/String;", "update", "updateButtonFromPresentation", "button", "Ljavax/swing/JButton;", "presentation", "Lcom/intellij/openapi/actionSystem/Presentation;", "Companion", "intellij.vcs.github"})
public final class GHPRReviewSubmitAction
extends JButtonAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PROP_PREFIX = "PREFIX";

    public GHPRReviewSubmitAction() {
        super("\u2026", GithubBundle.message("pull.request.review.submit.action.description", new Object[0]), null, 4, null);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.EDT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        GHPRDataProvider dataProvider = (GHPRDataProvider)e.getData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        if (dataProvider == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        GHPRReviewDataProvider reviewData = dataProvider.getReviewData();
        GHPullRequest details2 = dataProvider.getDetailsData().getLoadedDetails();
        e.getPresentation().setVisible(true);
        CompletableFuture<GHPullRequestPendingReview> pendingReviewFuture = reviewData.loadPendingReview();
        e.getPresentation().setEnabled(pendingReviewFuture.isDone() && details2 != null);
        Presentation presentation = e.getPresentation();
        String string = e.getPlace();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.place");
        presentation.putClientProperty(PROP_PREFIX, (Object)this.getPrefix(string));
        if (e.getPresentation().isEnabledAndVisible()) {
            GHPullRequestPendingReview gHPullRequestPendingReview;
            try {
                gHPullRequestPendingReview = pendingReviewFuture.getNow(null);
            }
            catch (Exception e2) {
                gHPullRequestPendingReview = null;
            }
            GHPullRequestPendingReview review2 = gHPullRequestPendingReview;
            boolean pendingReview = review2 != null;
            Object object = review2;
            Integer comments = object != null && (object = ((GHPullRequestPendingReview)object).getComments()) != null ? ((GHNodes)object).getTotalCount() : null;
            e.getPresentation().setText(this.getText(comments));
            e.getPresentation().putClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY, (Object)pendingReview);
        }
    }

    private final String getPrefix(String place) {
        String string = Intrinsics.areEqual((Object)place, (Object)"DiffToolbar") ? GithubBundle.message("pull.request.review.submit", new Object[0]) : GithubBundle.message("pull.request.review.submit.review", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (place == ActionPlace\u2026st.review.submit.review\")");
        return string;
    }

    @NlsSafe
    private final String getText(Integer pendingComments) {
        StringBuilder builder = new StringBuilder();
        if (pendingComments != null) {
            builder.append(" (" + pendingComments + ")");
        }
        builder.append("\u2026");
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GHPullRequestPendingReview gHPullRequestPendingReview;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Object object = e.getRequiredData(GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"e.getRequiredData(GHPRAc\u2026LL_REQUEST_DATA_PROVIDER)");
        GHPRDataProvider dataProvider = (GHPRDataProvider)object;
        GHPullRequest gHPullRequest = dataProvider.getDetailsData().getLoadedDetails();
        if (gHPullRequest == null) {
            return;
        }
        GHPullRequest details2 = gHPullRequest;
        GHPRReviewDataProvider reviewDataProvider = dataProvider.getReviewData();
        CompletableFuture<GHPullRequestPendingReview> pendingReviewFuture = reviewDataProvider.loadPendingReview();
        if (!pendingReviewFuture.isDone()) {
            return;
        }
        try {
            gHPullRequestPendingReview = pendingReviewFuture.getNow(null);
        }
        catch (Exception e2) {
            gHPullRequestPendingReview = null;
        }
        GHPullRequestPendingReview pendingReview = gHPullRequestPendingReview;
        JComponent jComponent = (JComponent)e.getPresentation().getClientProperty(CustomComponentAction.COMPONENT_KEY);
        if (jComponent == null) {
            return;
        }
        JComponent parentComponent = jComponent;
        Ref.ObjectRef cancelRunnable = new Ref.ObjectRef();
        ActionListener cancelActionListener = arg_0 -> GHPRReviewSubmitAction.actionPerformed$lambda$0(cancelRunnable, arg_0);
        ComponentContainer container = this.createPopupComponent(reviewDataProvider, reviewDataProvider.getSubmitReviewCommentDocument(), cancelActionListener, pendingReview, details2.getViewerDidAuthor());
        JBPopup jBPopup = JBPopupFactory.getInstance().createComponentPopupBuilder(container.getComponent(), container.getPreferredFocusableComponent()).setFocusable(true).setRequestFocus(true).setResizable(true).createPopup();
        Intrinsics.checkNotNullExpressionValue((Object)jBPopup, (String)"getInstance()\n      .cre\u2026rue)\n      .createPopup()");
        JBPopup popup = jBPopup;
        cancelRunnable.element = new Function0<Unit>(popup){
            final /* synthetic */ JBPopup $popup;
            {
                this.$popup = $popup;
                super(0);
            }

            public final void invoke() {
                this.$popup.cancel();
            }
        };
        popup.showUnderneathOf((Component)parentComponent);
    }

    private final ComponentContainer createPopupComponent(GHPRReviewDataProvider reviewDataProvider, Document document, ActionListener cancelActionListener, GHPullRequestPendingReview pendingReview, boolean viewerIsAuthor) {
        return new ComponentContainer(document, viewerIsAuthor, pendingReview, reviewDataProvider, cancelActionListener){
            @NotNull
            private final EditorTextField editor;
            @NotNull
            private final GHSimpleErrorPanelModel errorModel;
            @Nullable
            private final JButton approveButton;
            @Nullable
            private final JButton rejectButton;
            @NotNull
            private final JButton commentButton;
            @Nullable
            private final InlineIconButton discardButton;
            final /* synthetic */ Document $document;
            final /* synthetic */ boolean $viewerIsAuthor;
            final /* synthetic */ GHPullRequestPendingReview $pendingReview;
            final /* synthetic */ GHPRReviewDataProvider $reviewDataProvider;
            final /* synthetic */ ActionListener $cancelActionListener;
            {
                InlineIconButton inlineIconButton;
                GHPullRequestPendingReview $this$commentButton_u24lambda_u242;
                JButton jButton;
                JButton $this$rejectButton_u24lambda_u241;
                JButton jButton2;
                JButton $this$approveButton_u24lambda_u240;
                createPopupComponent.1 var10_8;
                JButton jButton3;
                this.$document = $document;
                this.$viewerIsAuthor = $viewerIsAuthor;
                this.$pendingReview = $pendingReview;
                this.$reviewDataProvider = $reviewDataProvider;
                this.$cancelActionListener = $cancelActionListener;
                this.editor = this.createEditor($document);
                String string = GithubBundle.message("pull.request.review.submit.error", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.review.submit.error\")");
                this.errorModel = new GHSimpleErrorPanelModel(string);
                createPopupComponent.1 v1 = this;
                if (!$viewerIsAuthor) {
                    JButton jButton4 = jButton3 = new JButton(GithubBundle.message("pull.request.review.submit.approve.button", new Object[0]));
                    var10_8 = v1;
                    boolean bl = false;
                    $this$approveButton_u24lambda_u240.addActionListener(this.createSubmitButtonActionListener(GHPullRequestReviewEvent.APPROVE));
                    v1 = var10_8;
                    jButton2 = jButton3;
                } else {
                    jButton2 = null;
                }
                v1.approveButton = jButton2;
                createPopupComponent.1 v3 = this;
                if (!$viewerIsAuthor) {
                    $this$approveButton_u24lambda_u240 = jButton3 = new JButton(GithubBundle.message("pull.request.review.submit.request.changes", new Object[0]));
                    var10_8 = v3;
                    boolean bl = false;
                    $this$rejectButton_u24lambda_u241.addActionListener(this.createSubmitButtonActionListener(GHPullRequestReviewEvent.REQUEST_CHANGES));
                    v3 = var10_8;
                    jButton = jButton3;
                } else {
                    jButton = null;
                }
                v3.rejectButton = jButton;
                $this$rejectButton_u24lambda_u241 = jButton3 = new JButton(GithubBundle.message("pull.request.review.submit.comment.button", new Object[0]));
                var10_8 = this;
                boolean bl = false;
                ((JComponent)((Object)$this$commentButton_u24lambda_u242)).setToolTipText(GithubBundle.message("pull.request.review.submit.comment.description", new Object[0]));
                ((AbstractButton)((Object)$this$commentButton_u24lambda_u242)).addActionListener(this.createSubmitButtonActionListener(GHPullRequestReviewEvent.COMMENT));
                var10_8.commentButton = jButton3;
                createPopupComponent.1 v5 = this;
                GHPullRequestPendingReview gHPullRequestPendingReview = $pendingReview;
                if (gHPullRequestPendingReview != null) {
                    void review2;
                    $this$commentButton_u24lambda_u242 = gHPullRequestPendingReview;
                    var10_8 = v5;
                    boolean bl2 = false;
                    Icon icon = CollaborationToolsIcons.Delete;
                    Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Delete");
                    InlineIconButton button = new InlineIconButton(icon, CollaborationToolsIcons.DeleteHovered, null, GithubBundle.message("pull.request.discard.pending.comments", new Object[0]), null, 20, null);
                    button.setActionListener(arg_0 -> createPopupComponent.1.lambda$5$lambda$4(button, $reviewDataProvider, (GHPullRequestPendingReview)review2, arg_0));
                    inlineIconButton = button;
                    v5 = var10_8;
                } else {
                    inlineIconButton = null;
                }
                v5.discardButton = inlineIconButton;
            }

            private final ActionListener createSubmitButtonActionListener(GHPullRequestReviewEvent event) {
                return arg_0 -> createPopupComponent.1.createSubmitButtonActionListener$lambda$3(this, this.$pendingReview, this.$reviewDataProvider, event, this.$cancelActionListener, this.$document, arg_0);
            }

            /*
             * WARNING - void declaration
             */
            @NotNull
            public JComponent getComponent() {
                void $this$getComponent_u24lambda_u2410_u24lambda_u249;
                Object object;
                JLabel jLabel;
                JLabel $this$getComponent_u24lambda_u246 = jLabel = new JLabel(GithubBundle.message("pull.request.review.submit.review", new Object[0]));
                boolean $i$a$-apply-GHPRReviewSubmitAction$createPopupComponent$1$getComponent$titleLabel$22 = false;
                $this$getComponent_u24lambda_u246.setFont($this$getComponent_u24lambda_u246.getFont().deriveFont($this$getComponent_u24lambda_u246.getFont().getStyle() | 1));
                JLabel titleLabel = jLabel;
                $this$getComponent_u24lambda_u246 = new HorizontalBox();
                Object $i$a$-apply-GHPRReviewSubmitAction$createPopupComponent$1$getComponent$titleLabel$22 = this.$pendingReview;
                Object object2 = this.$cancelActionListener;
                JLabel $this$getComponent_u24lambda_u2410 = $this$getComponent_u24lambda_u246;
                boolean bl = false;
                $this$getComponent_u24lambda_u2410.setBorder((Border)JBUI.Borders.empty((int)4, (int)4, (int)4, (int)4));
                $this$getComponent_u24lambda_u2410.add(titleLabel);
                if ($i$a$-apply-GHPRReviewSubmitAction$createPopupComponent$1$getComponent$titleLabel$22 != null) {
                    Integer n = ((GHPullRequestPendingReview)$i$a$-apply-GHPRReviewSubmitAction$createPopupComponent$1$getComponent$titleLabel$22).getComments().getTotalCount();
                    Intrinsics.checkNotNull((Object)n);
                    int commentsCount = n;
                    $this$getComponent_u24lambda_u2410.add(Box.createRigidArea((Dimension)new JBDimension(5, 0)));
                    object = new InlineIconButton[]{Integer.valueOf(commentsCount)};
                    Object $this$getComponent_u24lambda_u2410_u24lambda_u247 = object = $this$getComponent_u24lambda_u2410.add(new JLabel(GithubBundle.message("pull.request.review.pending.comments.count", (Object[])object)));
                    boolean bl2 = false;
                    ((Component)$this$getComponent_u24lambda_u2410_u24lambda_u247).setForeground(UIUtil.getContextHelpForeground());
                }
                $this$getComponent_u24lambda_u2410.add(Box.createHorizontalGlue());
                InlineIconButton inlineIconButton = this.discardButton;
                if (inlineIconButton != null) {
                    InlineIconButton it = inlineIconButton;
                    boolean bl3 = false;
                    $this$getComponent_u24lambda_u2410.add((Component)it);
                }
                Icon icon = AllIcons.Actions.Close;
                Intrinsics.checkNotNullExpressionValue((Object)icon, (String)"Close");
                InlineIconButton commentsCount = new InlineIconButton(icon, AllIcons.Actions.CloseHovered, null, null, null, 28, null);
                object = commentsCount;
                JLabel jLabel2 = $this$getComponent_u24lambda_u2410;
                boolean bl4 = false;
                $this$getComponent_u24lambda_u2410_u24lambda_u249.setActionListener((ActionListener)object2);
                jLabel2.add((Component)commentsCount);
                JLabel titlePanel2 = $this$getComponent_u24lambda_u246;
                Object $this$getComponent_u24lambda_u2411 = $i$a$-apply-GHPRReviewSubmitAction$createPopupComponent$1$getComponent$titleLabel$22 = GHHtmlErrorPanel.INSTANCE.create(this.errorModel, 2);
                boolean bl5 = false;
                ((JComponent)$this$getComponent_u24lambda_u2411).setBorder(JBUI.Borders.empty((int)4));
                Object errorPanel = $i$a$-apply-GHPRReviewSubmitAction$createPopupComponent$1$getComponent$titleLabel$22;
                object2 = new JPanel(new FlowLayout(0, 0, 0));
                bl5 = this.$viewerIsAuthor;
                Object $this$getComponent_u24lambda_u2412 = object2;
                boolean bl6 = false;
                ((JComponent)$this$getComponent_u24lambda_u2412).setBorder(JBUI.Borders.empty((int)4));
                if (!bl5) {
                    ((Container)$this$getComponent_u24lambda_u2412).add(this.approveButton);
                }
                if (!bl5) {
                    ((Container)$this$getComponent_u24lambda_u2412).add(this.rejectButton);
                }
                ((Container)$this$getComponent_u24lambda_u2412).add(this.commentButton);
                Object buttonsPanel = object2;
                Object $this$getComponent_u24lambda_u2413 = object2 = new JPanel((LayoutManager)new MigLayout(new LC().gridGap("0", "0").insets("0", "0", "0", "0").fill().flowY().noGrid()));
                boolean bl7 = false;
                ((JComponent)$this$getComponent_u24lambda_u2413).setOpaque(false);
                ((JComponent)$this$getComponent_u24lambda_u2413).setPreferredSize((Dimension)new JBDimension(450, 165));
                ((Container)$this$getComponent_u24lambda_u2413).add((Component)titlePanel2, new CC().growX());
                String[] stringArray = new String[]{"0", "0", "0", "0"};
                ((Container)$this$getComponent_u24lambda_u2413).add((Component)this.editor, new CC().growX().growY().gap(stringArray));
                stringArray = new String[]{"0", "0", "0", "0"};
                ((Container)$this$getComponent_u24lambda_u2413).add((Component)errorPanel, new CC().minHeight(String.valueOf(JBUIScale.scale((int)32))).growY().growPrioY(0).hideMode(3).gap(stringArray));
                ((Container)$this$getComponent_u24lambda_u2413).add((Component)buttonsPanel, new CC().alignX("right"));
                return (JComponent)object2;
            }

            private final EditorTextField createEditor(Document document) {
                EditorTextField editorTextField;
                EditorTextField $this$createEditor_u24lambda_u2415 = editorTextField = new EditorTextField(document, null, (FileType)FileTypes.PLAIN_TEXT);
                boolean bl = false;
                $this$createEditor_u24lambda_u2415.setOneLineMode(false);
                $this$createEditor_u24lambda_u2415.putClientProperty((Object)"AuxEditorComponent", (Object)true);
                $this$createEditor_u24lambda_u2415.setPlaceholder((CharSequence)GithubBundle.message("pull.request.review.comment.empty.text", new Object[0]));
                $this$createEditor_u24lambda_u2415.addSettingsProvider(createPopupComponent.1::createEditor$lambda$15$lambda$14);
                return editorTextField;
            }

            @NotNull
            public EditorTextField getPreferredFocusableComponent() {
                return this.editor;
            }

            public void dispose() {
            }

            private static final void createSubmitButtonActionListener$lambda$3(createPopupComponent.1 this$0, GHPullRequestPendingReview $pendingReview, GHPRReviewDataProvider $reviewDataProvider, GHPullRequestReviewEvent $event, ActionListener $cancelActionListener, Document $document, ActionEvent e) {
                Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                Intrinsics.checkNotNullParameter((Object)$reviewDataProvider, (String)"$reviewDataProvider");
                Intrinsics.checkNotNullParameter((Object)((Object)$event), (String)"$event");
                Intrinsics.checkNotNullParameter((Object)$cancelActionListener, (String)"$cancelActionListener");
                Intrinsics.checkNotNullParameter((Object)$document, (String)"$document");
                this$0.editor.setEnabled(false);
                JButton jButton = this$0.approveButton;
                if (jButton != null) {
                    jButton.setEnabled(false);
                }
                JButton jButton2 = this$0.rejectButton;
                if (jButton2 != null) {
                    jButton2.setEnabled(false);
                }
                this$0.commentButton.setEnabled(false);
                InlineIconButton inlineIconButton = this$0.discardButton;
                if (inlineIconButton != null) {
                    inlineIconButton.setEnabled(false);
                }
                GHPullRequestPendingReview gHPullRequestPendingReview = $pendingReview;
                String reviewId = gHPullRequestPendingReview != null ? gHPullRequestPendingReview.getId() : null;
                CompletableFutureUtil.errorOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)CompletableFutureUtil.successOnEdt$default((CompletableFutureUtil)CompletableFutureUtil.INSTANCE, (CompletableFuture)(reviewId == null ? GHPRReviewDataProvider.createReview$default($reviewDataProvider, (ProgressIndicator)new EmptyProgressIndicator(), $event, this$0.editor.getText(), null, null, null, 56, null) : $reviewDataProvider.submitReview((ProgressIndicator)new EmptyProgressIndicator(), reviewId, $event, this$0.editor.getText())), null, (Function1)((Function1)new Function1<?, Unit>($cancelActionListener, e, $document){
                    final /* synthetic */ ActionListener $cancelActionListener;
                    final /* synthetic */ ActionEvent $e;
                    final /* synthetic */ Document $document;
                    {
                        this.$cancelActionListener = $cancelActionListener;
                        this.$e = $e;
                        this.$document = $document;
                        super(1);
                    }

                    public final void invoke(@NotNull Object it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        this.$cancelActionListener.actionPerformed(this.$e);
                        Document document = this.$document;
                        boolean $i$f$runWriteAction = false;
                        ApplicationManager.getApplication().runWriteAction(new Computable(document){
                            final /* synthetic */ Document $document$inlined;
                            {
                                this.$document$inlined = document;
                            }

                            public final T compute() {
                                boolean bl = false;
                                this.$document$inlined.setText((CharSequence)"");
                                return (T)Unit.INSTANCE;
                            }
                        });
                    }
                }), (int)1, null), null, (Function1)((Function1)new Function1<Throwable, Unit>(this$0){
                    final /* synthetic */ createPopupComponent.1 this$0;
                    {
                        this.this$0 = $receiver;
                        super(1);
                    }

                    public final void invoke(@NotNull Throwable it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        createPopupComponent.1.access$getErrorModel$p(this.this$0).setError(it);
                        createPopupComponent.1.access$getEditor$p(this.this$0).setEnabled(true);
                        JButton jButton = createPopupComponent.1.access$getApproveButton$p(this.this$0);
                        if (jButton != null) {
                            jButton.setEnabled(true);
                        }
                        JButton jButton2 = createPopupComponent.1.access$getRejectButton$p(this.this$0);
                        if (jButton2 != null) {
                            jButton2.setEnabled(true);
                        }
                        createPopupComponent.1.access$getCommentButton$p(this.this$0).setEnabled(true);
                        InlineIconButton inlineIconButton = createPopupComponent.1.access$getDiscardButton$p(this.this$0);
                        if (inlineIconButton != null) {
                            inlineIconButton.setEnabled(true);
                        }
                    }
                }), (int)1, null);
            }

            private static final void lambda$5$lambda$4(InlineIconButton $button, GHPRReviewDataProvider $reviewDataProvider, GHPullRequestPendingReview $review, ActionEvent it) {
                Intrinsics.checkNotNullParameter((Object)$button, (String)"$button");
                Intrinsics.checkNotNullParameter((Object)$reviewDataProvider, (String)"$reviewDataProvider");
                Intrinsics.checkNotNullParameter((Object)$review, (String)"$review");
                String string = GithubBundle.message("pull.request.discard.pending.comments.dialog.title", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.di\u2026g.comments.dialog.title\")");
                String string2 = GithubBundle.message("pull.request.discard.pending.comments.dialog.msg", new Object[0]);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"pull.request.di\u2026ing.comments.dialog.msg\")");
                if (MessageDialogBuilder.Companion.yesNo(string, string2).ask((Component)$button)) {
                    $reviewDataProvider.deleteReview((ProgressIndicator)new EmptyProgressIndicator(), $review.getId());
                }
            }

            private static final void createEditor$lambda$15$lambda$14(EditorEx it) {
                it.getSettings().setUseSoftWraps(true);
                it.setVerticalScrollbarVisible(true);
                it.getScrollPane().setBorder(IdeBorderFactory.createBorder((int)10));
                it.getScrollPane().setViewportBorder((Border)JBUI.Borders.emptyLeft((int)4));
                it.putUserData(IncrementalFindAction.SEARCH_DISABLED, (Object)true);
            }

            public static final /* synthetic */ GHSimpleErrorPanelModel access$getErrorModel$p(createPopupComponent.1 $this) {
                return $this.errorModel;
            }

            public static final /* synthetic */ EditorTextField access$getEditor$p(createPopupComponent.1 $this) {
                return $this.editor;
            }

            public static final /* synthetic */ JButton access$getApproveButton$p(createPopupComponent.1 $this) {
                return $this.approveButton;
            }

            public static final /* synthetic */ JButton access$getRejectButton$p(createPopupComponent.1 $this) {
                return $this.rejectButton;
            }

            public static final /* synthetic */ JButton access$getCommentButton$p(createPopupComponent.1 $this) {
                return $this.commentButton;
            }

            public static final /* synthetic */ InlineIconButton access$getDiscardButton$p(createPopupComponent.1 $this) {
                return $this.discardButton;
            }
        };
    }

    protected void updateButtonFromPresentation(@NotNull JButton button, @NotNull Presentation presentation) {
        Intrinsics.checkNotNullParameter((Object)button, (String)"button");
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        super.updateButtonFromPresentation(button, presentation);
        Object object = presentation.getClientProperty(PROP_PREFIX);
        String string = object instanceof String ? (String)object : null;
        if (string == null) {
            String string2 = GithubBundle.message("pull.request.review.submit.review", new Object[0]);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(\"pull.request.review.submit.review\")");
        }
        String prefix = string;
        button.setText(prefix + presentation.getText());
        UIUtil.putClientProperty((JComponent)button, (Key)DarculaButtonUI.DEFAULT_STYLE_KEY, (Object)presentation.getClientProperty(DarculaButtonUI.DEFAULT_STYLE_KEY));
    }

    private static final void actionPerformed$lambda$0(Ref.ObjectRef $cancelRunnable, ActionEvent it) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)$cancelRunnable, (String)"$cancelRunnable");
            Function0 function0 = (Function0)$cancelRunnable.element;
            if (function0 == null) break block0;
            function0.invoke();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/action/GHPRReviewSubmitAction$Companion;", "", "()V", "PROP_PREFIX", "", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

