/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.collaboration.async.CompletableFutureUtil;
import com.intellij.collaboration.ui.icon.IconsProvider;
import com.intellij.diff.util.FileEditorBase;
import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.AnimatedIcon;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.SingleComponentCenteringLayout;
import com.intellij.util.ui.UIUtil;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequest;
import org.jetbrains.plugins.github.api.data.pullrequest.GHPullRequestShort;
import org.jetbrains.plugins.github.api.data.pullrequest.timeline.GHPRTimelineItem;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHRepoVirtualFile;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.data.GHListLoader;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRCommentsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDetailsDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRReviewDataProvider;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRRepositoryDataService;
import org.jetbrains.plugins.github.pullrequest.data.service.GHPRSecurityService;
import org.jetbrains.plugins.github.pullrequest.ui.timeline.GHPRFileEditorComponentFactory;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u00100\u001a\u00020\u0016H\u0002J\b\u00101\u001a\u00020\u0016H\u0002J\b\u00102\u001a\u00020\u0016H\u0016J\n\u00103\u001a\u0004\u0018\u000104H\u0002J\b\u00105\u001a\u00020\tH\u0016J\u0012\u00106\u001a\f0\r\u00a2\u0006\u0002\b7\u00a2\u0006\u0002\b8H\u0016J\n\u00109\u001a\u0004\u0018\u00010\u0016H\u0016J\b\u0010:\u001a\u00020;H\u0016R\u001b\u0010\u000b\u001a\f\u0012\u0004\u0012\u00020\r0\fj\u0002`\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0015\u001a\u00020\u00168BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u0017\u0010\u0018R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001b\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001eR\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020 \u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020$\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R\u0011\u0010'\u001a\u00020(\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0017\u0010+\u001a\b\u0012\u0004\u0012\u00020-0,\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006<"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRTimelineFileEditor;", "Lcom/intellij/diff/util/FileEditorBase;", "project", "Lcom/intellij/openapi/project/Project;", "dataContext", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "file", "Lorg/jetbrains/plugins/github/pullrequest/GHRepoVirtualFile;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRDataContext;Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;Lorg/jetbrains/plugins/github/pullrequest/GHRepoVirtualFile;)V", "avatarIconsProvider", "Lcom/intellij/collaboration/ui/icon/IconsProvider;", "", "Lorg/jetbrains/plugins/github/ui/avatars/GHAvatarIconsProvider;", "getAvatarIconsProvider", "()Lcom/intellij/collaboration/ui/icon/IconsProvider;", "commentsData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "getCommentsData", "()Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRCommentsDataProvider;", "content", "Ljavax/swing/JComponent;", "getContent", "()Ljavax/swing/JComponent;", "content$delegate", "Lkotlin/Lazy;", "detailsData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "getDetailsData", "()Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDetailsDataProvider;", "repositoryDataService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "getRepositoryDataService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRRepositoryDataService;", "reviewData", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "getReviewData", "()Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRReviewDataProvider;", "securityService", "Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "getSecurityService", "()Lorg/jetbrains/plugins/github/pullrequest/data/service/GHPRSecurityService;", "timelineLoader", "Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "Lorg/jetbrains/plugins/github/api/data/pullrequest/timeline/GHPRTimelineItem;", "getTimelineLoader", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHListLoader;", "createContent", "doCreateContent", "getComponent", "getCurrentDetails", "Lorg/jetbrains/plugins/github/api/data/pullrequest/GHPullRequestShort;", "getFile", "getName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPreferredFocusedComponent", "selectNotify", "", "intellij.vcs.github"})
public final class GHPRTimelineFileEditor
extends FileEditorBase {
    @NotNull
    private final Project project;
    @NotNull
    private final GHPRDataContext dataContext;
    @NotNull
    private final GHPRDataProvider dataProvider;
    @NotNull
    private final GHRepoVirtualFile file;
    @NotNull
    private final GHPRSecurityService securityService;
    @NotNull
    private final GHPRRepositoryDataService repositoryDataService;
    @NotNull
    private final IconsProvider<String> avatarIconsProvider;
    @NotNull
    private final GHPRDetailsDataProvider detailsData;
    @NotNull
    private final GHPRReviewDataProvider reviewData;
    @NotNull
    private final GHPRCommentsDataProvider commentsData;
    @NotNull
    private final GHListLoader<GHPRTimelineItem> timelineLoader;
    @NotNull
    private final Lazy content$delegate;

    public GHPRTimelineFileEditor(@NotNull Project project, @NotNull GHPRDataContext dataContext, @NotNull GHPRDataProvider dataProvider, @NotNull GHRepoVirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        Intrinsics.checkNotNullParameter((Object)dataProvider, (String)"dataProvider");
        Intrinsics.checkNotNullParameter((Object)((Object)file), (String)"file");
        this.project = project;
        this.dataContext = dataContext;
        this.dataProvider = dataProvider;
        this.file = file;
        this.securityService = this.dataContext.getSecurityService();
        this.repositoryDataService = this.dataContext.getRepositoryDataService();
        this.avatarIconsProvider = this.dataContext.getAvatarIconsProvider();
        this.detailsData = this.dataProvider.getDetailsData();
        this.reviewData = this.dataProvider.getReviewData();
        this.commentsData = this.dataProvider.getCommentsData();
        this.timelineLoader = this.dataProvider.acquireTimelineLoader((Disposable)this);
        this.content$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.NONE, (Function0)((Function0)new Function0<JComponent>((Object)this){

            @NotNull
            public final JComponent invoke() {
                return GHPRTimelineFileEditor.access$createContent((GHPRTimelineFileEditor)((Object)this.receiver));
            }
        }));
    }

    @NotNull
    public final GHPRSecurityService getSecurityService() {
        return this.securityService;
    }

    @NotNull
    public final GHPRRepositoryDataService getRepositoryDataService() {
        return this.repositoryDataService;
    }

    @NotNull
    public final IconsProvider<String> getAvatarIconsProvider() {
        return this.avatarIconsProvider;
    }

    @NotNull
    public final GHPRDetailsDataProvider getDetailsData() {
        return this.detailsData;
    }

    @NotNull
    public final GHPRReviewDataProvider getReviewData() {
        return this.reviewData;
    }

    @NotNull
    public final GHPRCommentsDataProvider getCommentsData() {
        return this.commentsData;
    }

    @NotNull
    public final GHListLoader<GHPRTimelineItem> getTimelineLoader() {
        return this.timelineLoader;
    }

    @NotNull
    public String getName() {
        String string = GithubBundle.message("pull.request.editor.timeline", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.editor.timeline\")");
        return string;
    }

    private final JComponent getContent() {
        Lazy lazy = this.content$delegate;
        return (JComponent)lazy.getValue();
    }

    @NotNull
    public JComponent getComponent() {
        return this.getContent();
    }

    private final JComponent createContent() {
        JComponent jComponent;
        JComponent $this$createContent_u24lambda_u240 = jComponent = this.doCreateContent();
        boolean bl = false;
        $this$createContent_u24lambda_u240.setOpaque(true);
        $this$createContent_u24lambda_u240.setBackground(EditorColorsManager.getInstance().getGlobalScheme().getDefaultBackground());
        JComponent it = jComponent;
        boolean bl2 = false;
        MessageBusConnection messageBusConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        Topic topic = EditorColorsManager.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> GHPRTimelineFileEditor.createContent$lambda$3$lambda$1(it, arg_0));
        DataProvider prevProvider = DataManager.getDataProvider((JComponent)it);
        DataManager.removeDataProvider((JComponent)it);
        DataManager.registerDataProvider((JComponent)it, arg_0 -> GHPRTimelineFileEditor.createContent$lambda$3$lambda$2(this, prevProvider, arg_0));
        return jComponent;
    }

    /*
     * WARNING - void declaration
     */
    private final JComponent doCreateContent() {
        void $this$doCreateContent_u24lambda_u245_u24lambda_u244;
        JLabel jLabel;
        JPanel jPanel;
        GHPullRequestShort details2 = this.getCurrentDetails();
        if (details2 != null) {
            return new GHPRFileEditorComponentFactory(this.project, this, details2).create();
        }
        JPanel $this$doCreateContent_u24lambda_u245 = jPanel = new JPanel((LayoutManager)new SingleComponentCenteringLayout());
        boolean bl = false;
        JLabel jLabel2 = jLabel = new JLabel();
        JPanel jPanel2 = $this$doCreateContent_u24lambda_u245;
        boolean bl2 = false;
        $this$doCreateContent_u24lambda_u245_u24lambda_u244.setForeground(UIUtil.getContextHelpForeground());
        $this$doCreateContent_u24lambda_u245_u24lambda_u244.setText(ApplicationBundle.message((String)"label.loading.page.please.wait", (Object[])new Object[0]));
        $this$doCreateContent_u24lambda_u245_u24lambda_u244.setIcon((Icon)new AnimatedIcon.Default());
        jPanel2.add(jLabel);
        JPanel panel = jPanel;
        CompletableFutureUtil.INSTANCE.handleOnEdt(this.detailsData.loadDetails(), (Disposable)this, (Function2)new Function2<GHPullRequest, Throwable, Unit>(panel, this){
            final /* synthetic */ JPanel $panel;
            final /* synthetic */ GHPRTimelineFileEditor this$0;
            {
                this.$panel = $panel;
                this.this$0 = $receiver;
                super(2);
            }

            public final void invoke(@Nullable GHPullRequest loadedDetails, @Nullable Throwable error) {
                if (loadedDetails != null) {
                    this.$panel.setLayout(new BorderLayout());
                    this.$panel.removeAll();
                    this.$panel.add(new GHPRFileEditorComponentFactory(GHPRTimelineFileEditor.access$getProject$p(this.this$0), this.this$0, loadedDetails).create());
                } else if (error != null) {
                    throw error;
                }
            }
        });
        return panel;
    }

    private final GHPullRequestShort getCurrentDetails() {
        GHPullRequestShort gHPullRequestShort;
        GHPullRequest gHPullRequest = this.detailsData.getLoadedDetails();
        if (gHPullRequest != null) {
            gHPullRequestShort = gHPullRequest;
        } else {
            Object v2;
            block3: {
                Iterable iterable = this.dataContext.getListLoader().getLoadedData();
                for (Object t : iterable) {
                    GHPullRequestShort it = (GHPullRequestShort)t;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getId(), (Object)this.dataProvider.getId().getId())) continue;
                    v2 = t;
                    break block3;
                }
                v2 = null;
            }
            gHPullRequestShort = v2;
        }
        return gHPullRequestShort;
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return null;
    }

    public void selectNotify() {
        if (!((Collection)this.timelineLoader.getLoadedData()).isEmpty()) {
            this.timelineLoader.loadMore(true);
        }
    }

    @NotNull
    public GHRepoVirtualFile getFile() {
        return this.file;
    }

    private static final void createContent$lambda$3$lambda$1(JComponent $it, EditorColorsScheme scheme) {
        Intrinsics.checkNotNullParameter((Object)$it, (String)"$it");
        EditorColorsScheme editorColorsScheme = scheme;
        $it.setBackground(editorColorsScheme != null ? editorColorsScheme.getDefaultBackground() : null);
    }

    private static final Object createContent$lambda$3$lambda$2(GHPRTimelineFileEditor this$0, DataProvider $prevProvider, String dataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
        if (GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER().is(dataId)) {
            object = this$0.dataProvider;
        } else {
            DataProvider dataProvider = $prevProvider;
            object = dataProvider != null ? dataProvider.getData(dataId) : null;
        }
        return object;
    }

    public static final /* synthetic */ Project access$getProject$p(GHPRTimelineFileEditor $this) {
        return $this.project;
    }

    public static final /* synthetic */ JComponent access$createContent(GHPRTimelineFileEditor $this) {
        return $this.createContent();
    }
}

