/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.eventLog.events.EnumEventField;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventId2;
import com.intellij.internal.statistic.eventLog.events.PrimitiveEventField;
import com.intellij.internal.statistic.service.fus.collectors.CounterUsagesCollector;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHEnterpriseServerMeta;
import org.jetbrains.plugins.github.api.data.GithubPullRequestMergeMethod;
import org.jetbrains.plugins.github.pullrequest.GHPRCombinedDiffPreviewVirtualFileBase;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFileBase;
import org.jetbrains.plugins.github.pullrequest.GHPRStatisticsCollector;
import org.jetbrains.plugins.github.pullrequest.GHPRTimelineVirtualFile;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Q\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005*\u0001\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019J\u000e\u0010\u001a\u001a\u00020\u00122\u0006\u0010\u001b\u001a\u00020\tJ\u000e\u0010\u001c\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0006\u0012\u0004\u0018\u00010\f0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u001e"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector;", "", "()V", "COUNTERS_GROUP", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "DIFF_OPENED_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId1;", "", "MERGED_EVENT", "Lorg/jetbrains/plugins/github/api/data/GithubPullRequestMergeMethod;", "SERVER_META_EVENT", "Lcom/intellij/internal/statistic/eventLog/events/EventId2;", "", "TIMELINE_OPENED_EVENT", "anonymizedId", "org/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector$anonymizedId$1", "Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector$anonymizedId$1;", "logDiffOpened", "", "project", "Lcom/intellij/openapi/project/Project;", "logEnterpriseServerMeta", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "meta", "Lorg/jetbrains/plugins/github/api/data/GHEnterpriseServerMeta;", "logMergedEvent", "method", "logTimelineOpened", "Counters", "intellij.vcs.github"})
public final class GHPRStatisticsCollector {
    @NotNull
    public static final GHPRStatisticsCollector INSTANCE;
    @NotNull
    private static final EventLogGroup COUNTERS_GROUP;
    @NotNull
    private static final EventId1<Integer> TIMELINE_OPENED_EVENT;
    @NotNull
    private static final EventId1<Integer> DIFF_OPENED_EVENT;
    @NotNull
    private static final EventId1<GithubPullRequestMergeMethod> MERGED_EVENT;
    @NotNull
    private static final anonymizedId.1 anonymizedId;
    @NotNull
    private static final EventId2<String, String> SERVER_META_EVENT;

    private GHPRStatisticsCollector() {
    }

    public final void logTimelineOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(project).openFiles");
        Object[] $this$count$iv = virtualFileArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            if (!(it instanceof GHPRTimelineVirtualFile)) continue;
            ++count$iv;
        }
        int count = count$iv;
        TIMELINE_OPENED_EVENT.log(project, (Object)count);
    }

    public final void logDiffOpened(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        VirtualFile[] virtualFileArray = FileEditorManager.getInstance((Project)project).getOpenFiles();
        Intrinsics.checkNotNullExpressionValue((Object)virtualFileArray, (String)"getInstance(project).openFiles");
        Object[] $this$count$iv = virtualFileArray;
        boolean $i$f$count = false;
        int count$iv = 0;
        for (Object element$iv : $this$count$iv) {
            VirtualFile it = (VirtualFile)element$iv;
            boolean bl = false;
            boolean bl2 = it instanceof GHPRDiffVirtualFileBase || it instanceof GHPRCombinedDiffPreviewVirtualFileBase;
            if (!bl2) continue;
            ++count$iv;
        }
        int count = count$iv;
        DIFF_OPENED_EVENT.log(project, (Object)count);
    }

    public final void logMergedEvent(@NotNull GithubPullRequestMergeMethod method) {
        Intrinsics.checkNotNullParameter((Object)((Object)method), (String)"method");
        MERGED_EVENT.log((Object)method);
    }

    public final void logEnterpriseServerMeta(@NotNull Project project, @NotNull GithubServerPath server, @NotNull GHEnterpriseServerMeta meta) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Intrinsics.checkNotNullParameter((Object)meta, (String)"meta");
        String string = server.toUrl();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server.toUrl()");
        SERVER_META_EVENT.log(project, (Object)string, (Object)meta.getInstalledVersion());
    }

    /*
     * WARNING - void declaration
     */
    static {
        void name$iv;
        INSTANCE = new GHPRStatisticsCollector();
        COUNTERS_GROUP = new EventLogGroup("vcs.github.pullrequest.counters", 2, null, 4, null);
        TIMELINE_OPENED_EVENT = COUNTERS_GROUP.registerEvent("timeline.opened", (EventField)EventFields.Int((String)"count"));
        DIFF_OPENED_EVENT = COUNTERS_GROUP.registerEvent("diff.opened", (EventField)EventFields.Int((String)"count"));
        EventFields eventFields = EventFields.INSTANCE;
        String string = "method";
        Function1 transform$iv = MERGED_EVENT.1.INSTANCE;
        boolean $i$f$Enum = false;
        MERGED_EVENT = COUNTERS_GROUP.registerEvent("merged", (EventField)new EnumEventField((String)name$iv, GithubPullRequestMergeMethod.class, transform$iv));
        anonymizedId = new PrimitiveEventField<String>(){
            @NotNull
            private final String name;
            {
                this.name = "anonymized_id";
            }

            @NotNull
            public String getName() {
                return this.name;
            }

            public void addData(@NotNull FeatureUsageData fuData, @NotNull String value) {
                Intrinsics.checkNotNullParameter((Object)fuData, (String)"fuData");
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                fuData.addAnonymizedId(value);
            }

            @NotNull
            public List<String> getValidationRule() {
                return CollectionsKt.listOf((Object)"{regexp#hash}");
            }
        };
        SERVER_META_EVENT = COUNTERS_GROUP.registerEvent("server.meta.collected", (EventField)anonymizedId, (EventField)EventFields.Version);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRStatisticsCollector$Counters;", "Lcom/intellij/internal/statistic/service/fus/collectors/CounterUsagesCollector;", "()V", "getGroup", "Lcom/intellij/internal/statistic/eventLog/EventLogGroup;", "intellij.vcs.github"})
    public static final class Counters
    extends CounterUsagesCollector {
        @NotNull
        public EventLogGroup getGroup() {
            return COUNTERS_GROUP;
        }
    }
}

