/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.diff.impl.DiffRequestProcessor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffRequestChainProcessor;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffRequestModel;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffVirtualFileBase;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContext;
import org.jetbrains.plugins.github.pullrequest.data.GHPRDataContextRepository;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0014\u001a\u00020\u0003H\u0016J\u0012\u0010\u0015\u001a\f0\u0003\u00a2\u0006\u0002\b\u0016\u00a2\u0006\u0002\b\u0017H\u0016J\b\u0010\u0018\u001a\u00020\u0003H\u0016R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFile;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRDiffVirtualFileBase;", "fileManagerId", "", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "(Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "getPullRequest", "()Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "createProcessor", "Lcom/intellij/diff/impl/DiffRequestProcessor;", "equals", "", "other", "", "getName", "getPath", "getPresentableName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPresentablePath", "intellij.vcs.github"})
public final class GHPRDiffVirtualFile
extends GHPRDiffVirtualFileBase {
    @NotNull
    private final GHPRIdentifier pullRequest;

    public GHPRDiffVirtualFile(@NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        super(fileManagerId, project, repository);
        this.pullRequest = pullRequest;
    }

    @NotNull
    public final GHPRIdentifier getPullRequest() {
        return this.pullRequest;
    }

    @NotNull
    public DiffRequestProcessor createProcessor(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable()");
        Disposable dataDisposable = disposable;
        GHPRDataContext gHPRDataContext = GHPRDataContextRepository.Companion.getInstance(project).findContext(this.getRepository());
        Intrinsics.checkNotNull((Object)gHPRDataContext);
        GHPRDataContext dataContext = gHPRDataContext;
        GHPRDataProvider dataProvider = dataContext.getDataProviderRepository().getDataProvider(this.pullRequest, dataDisposable);
        GHPRDiffRequestModel diffRequestModel = dataProvider.getDiffRequestModel();
        GHPRDiffRequestChainProcessor diffProcessor = new GHPRDiffRequestChainProcessor(project, diffRequestModel);
        Disposer.register((Disposable)((Disposable)diffProcessor), (Disposable)dataDisposable);
        return (DiffRequestProcessor)diffProcessor;
    }

    @NotNull
    public String getName() {
        return "#" + this.pullRequest.getNumber() + ".diff";
    }

    @NotNull
    public String getPresentableName() {
        Object[] objectArray = new Object[]{this.pullRequest.getNumber()};
        String string = GithubBundle.message("pull.request.diff.editor.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.di\u2026tle\", pullRequest.number)");
        return string;
    }

    @NotNull
    public String getPath() {
        VirtualFileSystem virtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return ((GHPRVirtualFileSystem)virtualFileSystem).getPath(this.getFileManagerId(), this.getProject(), this.getRepository(), this.pullRequest, null, true);
    }

    @NotNull
    public String getPresentablePath() {
        return this.getRepository().toUrl() + "/pulls/" + this.pullRequest.getNumber() + ".diff";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRDiffVirtualFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((GHPRDiffVirtualFile)((Object)other)).pullRequest, (Object)this.pullRequest)) {
            return false;
        }
        return super.equals(other);
    }
}

