/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFileSystem;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRCombinedDiffPreviewVirtualFileBase;
import org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0096\u0002J\b\u0010\u0010\u001a\u00020\u0003H\u0016J\b\u0010\u0011\u001a\u00020\u0003H\u0016J\u0012\u0010\u0012\u001a\f0\u0003\u00a2\u0006\u0002\b\u0013\u00a2\u0006\u0002\b\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRCombinedDiffPreviewVirtualFile;", "Lorg/jetbrains/plugins/github/pullrequest/GHPRCombinedDiffPreviewVirtualFileBase;", "sourceId", "", "fileManagerId", "project", "Lcom/intellij/openapi/project/Project;", "repository", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "pullRequest", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/openapi/project/Project;Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRIdentifier;)V", "equals", "", "other", "", "getName", "getPath", "getPresentableName", "Lorg/jetbrains/annotations/NotNull;", "Lorg/jetbrains/annotations/Nls;", "getPresentablePath", "intellij.vcs.github"})
public final class GHPRCombinedDiffPreviewVirtualFile
extends GHPRCombinedDiffPreviewVirtualFileBase {
    @NotNull
    private final GHPRIdentifier pullRequest;

    public GHPRCombinedDiffPreviewVirtualFile(@NotNull String sourceId, @NotNull String fileManagerId, @NotNull Project project, @NotNull GHRepositoryCoordinates repository, @NotNull GHPRIdentifier pullRequest) {
        Intrinsics.checkNotNullParameter((Object)sourceId, (String)"sourceId");
        Intrinsics.checkNotNullParameter((Object)fileManagerId, (String)"fileManagerId");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)pullRequest, (String)"pullRequest");
        super(sourceId, fileManagerId, project, repository);
        this.pullRequest = pullRequest;
    }

    @NotNull
    public String getName() {
        return "#" + this.pullRequest.getNumber() + ".diff";
    }

    @NotNull
    public String getPresentableName() {
        Object[] objectArray = new Object[]{this.pullRequest.getNumber()};
        String string = GithubBundle.message("pull.request.diff.editor.title", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.di\u2026tle\", pullRequest.number)");
        return string;
    }

    @NotNull
    public String getPath() {
        VirtualFileSystem virtualFileSystem = this.getFileSystem();
        Intrinsics.checkNotNull((Object)virtualFileSystem, (String)"null cannot be cast to non-null type org.jetbrains.plugins.github.pullrequest.GHPRVirtualFileSystem");
        return ((GHPRVirtualFileSystem)virtualFileSystem).getPath(this.getFileManagerId(), this.getProject(), this.getRepository(), this.pullRequest, this.getSourceId(), true);
    }

    @NotNull
    public String getPresentablePath() {
        return this.getRepository().toUrl() + "/pulls/" + this.pullRequest.getNumber() + ".diff";
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHPRCombinedDiffPreviewVirtualFile)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((GHPRCombinedDiffPreviewVirtualFile)((Object)other)).pullRequest, (Object)this.pullRequest)) {
            return false;
        }
        return super.equals(other);
    }
}

