/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.pullrequest;

import com.intellij.diff.DiffContext;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.diff.util.DiffUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.actions.NonEmptyActionGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vcs.changes.DiffPreviewController;
import com.intellij.openapi.vcs.changes.DiffPreviewControllerBase;
import com.intellij.openapi.vcs.changes.EditorTabPreviewBase;
import com.intellij.openapi.vcs.changes.actions.diff.CombinedDiffPreview;
import com.intellij.openapi.vcs.changes.actions.diff.CombinedDiffPreviewModel;
import com.intellij.openapi.vcs.changes.ui.ChangesTree;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.pullrequest.GHPRCombinedDiffPreview;
import org.jetbrains.plugins.github.pullrequest.GHPRCombinedDiffPreviewBase;
import org.jetbrains.plugins.github.pullrequest.GHPRCombinedDiffPreviewModel;
import org.jetbrains.plugins.github.pullrequest.GHPRDiffPreview;
import org.jetbrains.plugins.github.pullrequest.action.GHPRActionKeys;
import org.jetbrains.plugins.github.pullrequest.action.GHPRShowDiffActionProvider;
import org.jetbrains.plugins.github.pullrequest.comment.action.combined.GHPRCombinedDiffReviewResolvedThreadsToggleAction;
import org.jetbrains.plugins.github.pullrequest.comment.action.combined.GHPRCombinedDiffReviewThreadsReloadAction;
import org.jetbrains.plugins.github.pullrequest.comment.action.combined.GHPRCombinedDiffReviewThreadsToggleAction;
import org.jetbrains.plugins.github.pullrequest.data.GHPRFilesManager;
import org.jetbrains.plugins.github.pullrequest.data.GHPRIdentifier;
import org.jetbrains.plugins.github.pullrequest.data.provider.GHPRDataProvider;
import org.jetbrains.plugins.github.util.ChangeDiffRequestProducerFactory;
import org.jetbrains.plugins.github.util.GHToolbarLabelAction;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b \u0018\u0000 !2\u00020\u0001:\u0001!B/\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\u0011\u001a\u00020\u0012H\u0014J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H&J\b\u0010\u0016\u001a\u00020\u0014H\u0002J\b\u0010\u0017\u001a\u00020\u0018H\u0014J\u0010\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0014H\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0012H\u0002J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020 H\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8TX\u0094\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRCombinedDiffPreviewBase;", "Lcom/intellij/openapi/vcs/changes/actions/diff/CombinedDiffPreview;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "filesManager", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "producerFactory", "Lorg/jetbrains/plugins/github/util/ChangeDiffRequestProducerFactory;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;Lorg/jetbrains/plugins/github/util/ChangeDiffRequestProducerFactory;Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;Lcom/intellij/openapi/Disposable;)V", "previewFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "getPreviewFile", "()Lcom/intellij/openapi/vfs/VirtualFile;", "createModel", "Lcom/intellij/openapi/vcs/changes/actions/diff/CombinedDiffPreviewModel;", "doOpenPreview", "", "requestFocus", "ensureHasContent", "getCombinedDiffTabTitle", "", "openPreview", "openPreviewEditor", "setupReviewActions", "", "model", "updateDiffAction", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "Companion", "intellij.vcs.github"})
public abstract class GHPRCombinedDiffPreviewBase
extends CombinedDiffPreview {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final GHPRDataProvider dataProvider;
    @NotNull
    private final GHPRFilesManager filesManager;
    @NotNull
    private final ChangeDiffRequestProducerFactory producerFactory;

    public GHPRCombinedDiffPreviewBase(@Nullable GHPRDataProvider dataProvider, @NotNull GHPRFilesManager filesManager, @NotNull ChangeDiffRequestProducerFactory producerFactory, @NotNull ChangesTree tree2, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)filesManager, (String)"filesManager");
        Intrinsics.checkNotNullParameter((Object)producerFactory, (String)"producerFactory");
        Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        super(tree2, parentDisposable);
        this.dataProvider = dataProvider;
        this.filesManager = filesManager;
        this.producerFactory = producerFactory;
    }

    @NotNull
    protected VirtualFile getPreviewFile() {
        GHPRDataProvider gHPRDataProvider = this.dataProvider;
        GHPRIdentifier prId = gHPRDataProvider != null ? gHPRDataProvider.getId() : null;
        boolean bl = false;
        return (VirtualFile)(prId == null ? this.filesManager.createOrGetNewPRDiffFile(this.getId(this.getTree()), true) : this.filesManager.createOrGetDiffFile(prId, this.getId(this.getTree()), true));
    }

    @NotNull
    protected CombinedDiffPreviewModel createModel() {
        GHPRCombinedDiffPreviewModel gHPRCombinedDiffPreviewModel = new GHPRCombinedDiffPreviewModel(this.getTree(), this.producerFactory, this.getParentDisposable());
        CombinedDiffPreviewModel p0 = gHPRCombinedDiffPreviewModel;
        boolean bl = false;
        this.setupReviewActions(p0);
        return gHPRCombinedDiffPreviewModel;
    }

    private final void setupReviewActions(CombinedDiffPreviewModel model2) {
        Object[] objectArray;
        DiffContext context2 = model2.getContext();
        DiffUtil.putDataKey((UserDataHolder)((UserDataHolder)context2), GHPRActionKeys.getPULL_REQUEST_DATA_PROVIDER(), (Object)this.dataProvider);
        Object[] $this$setupReviewActions_u24lambda_u241 = objectArray = new NonEmptyActionGroup();
        boolean bl = false;
        $this$setupReviewActions_u24lambda_u241.setPopup(true);
        $this$setupReviewActions_u24lambda_u241.getTemplatePresentation().setText(GithubBundle.message("pull.request.diff.view.options", new Object[0]));
        $this$setupReviewActions_u24lambda_u241.getTemplatePresentation().setIcon(AllIcons.Actions.Show);
        $this$setupReviewActions_u24lambda_u241.add((AnAction)new GHPRCombinedDiffReviewThreadsToggleAction(model2));
        $this$setupReviewActions_u24lambda_u241.add((AnAction)new GHPRCombinedDiffReviewResolvedThreadsToggleAction(model2));
        Object[] viewOptionsGroup = objectArray;
        objectArray = new AnAction[4];
        String string = GithubBundle.message("pull.request.diff.review.label", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"pull.request.diff.review.label\")");
        objectArray[0] = (AnAction)new GHToolbarLabelAction(string);
        objectArray[1] = (AnAction)viewOptionsGroup;
        objectArray[2] = (AnAction)new GHPRCombinedDiffReviewThreadsReloadAction(model2);
        objectArray[3] = ActionManager.getInstance().getAction("Github.PullRequest.Review.Submit");
        context2.putUserData(DiffUserDataKeys.CONTEXT_ACTIONS, (Object)CollectionsKt.listOf((Object[])objectArray));
    }

    @NotNull
    protected String getCombinedDiffTabTitle() {
        String string = this.getPreviewFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"previewFile.name");
        return string;
    }

    public void updateDiffAction(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.updateDiffAction(event);
        GHPRShowDiffActionProvider.Companion.updateAvailability(event);
    }

    public boolean openPreview(boolean requestFocus) {
        if (!this.ensureHasContent()) {
            return false;
        }
        return this.openPreviewEditor(requestFocus);
    }

    private final boolean ensureHasContent() {
        this.getUpdatePreviewProcessor().refresh(false);
        return this.hasContent();
    }

    private final boolean openPreviewEditor(boolean requestFocus) {
        block0: {
            Runnable runnable = this.getEscapeHandler();
            if (runnable == null) break block0;
            Runnable handler = runnable;
            boolean bl = false;
            EditorTabPreviewBase.Companion.registerEscapeHandler(this.getPreviewFile(), handler);
        }
        return this.doOpenPreview(requestFocus);
    }

    public abstract boolean doOpenPreview(boolean var1);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J(\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/pullrequest/GHPRCombinedDiffPreviewBase$Companion;", "", "()V", "createAndSetupDiffPreview", "Lcom/intellij/openapi/vcs/changes/DiffPreviewController;", "tree", "Lcom/intellij/openapi/vcs/changes/ui/ChangesTree;", "producerFactory", "Lorg/jetbrains/plugins/github/util/ChangeDiffRequestProducerFactory;", "dataProvider", "Lorg/jetbrains/plugins/github/pullrequest/data/provider/GHPRDataProvider;", "filesManager", "Lorg/jetbrains/plugins/github/pullrequest/data/GHPRFilesManager;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DiffPreviewController createAndSetupDiffPreview(@NotNull ChangesTree tree2, @NotNull ChangeDiffRequestProducerFactory producerFactory, @Nullable GHPRDataProvider dataProvider, @NotNull GHPRFilesManager filesManager) {
            ChangesTree changesTree;
            Intrinsics.checkNotNullParameter((Object)tree2, (String)"tree");
            Intrinsics.checkNotNullParameter((Object)producerFactory, (String)"producerFactory");
            Intrinsics.checkNotNullParameter((Object)filesManager, (String)"filesManager");
            DiffPreviewControllerBase diffPreviewHolder2 = new DiffPreviewControllerBase(dataProvider, filesManager, producerFactory, tree2){
                @NotNull
                private final GHPRDiffPreview simplePreview;
                final /* synthetic */ GHPRDataProvider $dataProvider;
                final /* synthetic */ GHPRFilesManager $filesManager;
                final /* synthetic */ ChangeDiffRequestProducerFactory $producerFactory;
                final /* synthetic */ ChangesTree $tree;
                {
                    this.$dataProvider = $dataProvider;
                    this.$filesManager = $filesManager;
                    this.$producerFactory = $producerFactory;
                    this.$tree = $tree;
                    GHPRDataProvider gHPRDataProvider = $dataProvider;
                    this.simplePreview = new GHPRDiffPreview(gHPRDataProvider != null ? gHPRDataProvider.getId() : null, $filesManager);
                }

                @NotNull
                protected GHPRDiffPreview getSimplePreview() {
                    return this.simplePreview;
                }

                @NotNull
                protected GHPRCombinedDiffPreview createCombinedDiffPreview() {
                    return new GHPRCombinedDiffPreview(this.$dataProvider, this.$filesManager, this.$producerFactory, this.$tree);
                }
            };
            ChangesTree $this$createAndSetupDiffPreview_u24lambda_u242 = changesTree = tree2;
            boolean bl = false;
            $this$createAndSetupDiffPreview_u24lambda_u242.setDoubleClickHandler(arg_0 -> Companion.createAndSetupDiffPreview$lambda$2$lambda$0($this$createAndSetupDiffPreview_u24lambda_u242, diffPreviewHolder2, arg_0));
            $this$createAndSetupDiffPreview_u24lambda_u242.setEnterKeyHandler(arg_0 -> Companion.createAndSetupDiffPreview$lambda$2$lambda$1(diffPreviewHolder2, arg_0));
            return (DiffPreviewController)diffPreviewHolder2;
        }

        private static final boolean createAndSetupDiffPreview$lambda$2$lambda$0(ChangesTree $this_apply, createAndSetupDiffPreview.diffPreviewHolder.1 $diffPreviewHolder, MouseEvent e) {
            Intrinsics.checkNotNullParameter((Object)$this_apply, (String)"$this_apply");
            Intrinsics.checkNotNullParameter((Object)((Object)$diffPreviewHolder), (String)"$diffPreviewHolder");
            if (EditSourceOnDoubleClickHandler.isToggleEvent((JTree)((JTree)$this_apply), (MouseEvent)e)) {
                return false;
            }
            $diffPreviewHolder.getActivePreview().performDiffAction();
            return true;
        }

        private static final boolean createAndSetupDiffPreview$lambda$2$lambda$1(createAndSetupDiffPreview.diffPreviewHolder.1 $diffPreviewHolder, KeyEvent it) {
            Intrinsics.checkNotNullParameter((Object)((Object)$diffPreviewHolder), (String)"$diffPreviewHolder");
            $diffPreviewHolder.getActivePreview().performDiffAction();
            return true;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

