/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.FileIconProvider;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.jsonSchema.ide.JsonSchemaService;
import java.util.Collection;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/plugins/github/extensions/GithubYamlIconProvider;", "Lcom/intellij/ide/FileIconProvider;", "()V", "GITHUB_SCHEMA_NAMES", "", "", "getIcon", "Ljavax/swing/Icon;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "flags", "", "project", "Lcom/intellij/openapi/project/Project;", "intellij.vcs.github"})
public final class GithubYamlIconProvider
implements FileIconProvider {
    @NotNull
    private final Set<String> GITHUB_SCHEMA_NAMES;

    public GithubYamlIconProvider() {
        Object[] objectArray = new String[]{"github-workflow", "github-action"};
        this.GITHUB_SCHEMA_NAMES = SetsKt.setOf((Object[])objectArray);
    }

    @Nullable
    public Icon getIcon(@NotNull VirtualFile file, int flags, @Nullable Project project) {
        boolean bl;
        block7: {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (project == null) {
                return null;
            }
            String extension = file.getExtension();
            if (!Intrinsics.areEqual((Object)extension, (Object)"yml") && !Intrinsics.areEqual((Object)extension, (Object)"yaml")) {
                return null;
            }
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<JsonSchemaService> serviceClass$iv = JsonSchemaService.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            Collection collection = ((JsonSchemaService)object).getSchemaFilesForFile(file);
            Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"project.service<JsonSche\u2026tSchemaFilesForFile(file)");
            Collection schemaFiles = collection;
            Iterable $this$any$iv = schemaFiles;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    VirtualFile it = (VirtualFile)element$iv;
                    boolean bl2 = false;
                    if (!this.GITHUB_SCHEMA_NAMES.contains(it.getName())) continue;
                    bl = true;
                    break block7;
                }
                bl = false;
            }
        }
        if (bl) {
            return AllIcons.Vcs.Vendors.Github;
        }
        return null;
    }
}

