/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.extensions;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.api.dto.GraphQLPagedResponseDataDTO;
import com.intellij.collaboration.auth.Account;
import com.intellij.concurrency.SensitiveProgressWrapper;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.PatternUtil;
import git4idea.config.GitSharedSettings;
import git4idea.fetch.GitFetchHandler;
import git4idea.remote.hosting.HostedGitRepositoriesManager;
import git4idea.remote.hosting.HostedGitRepositoriesManagerKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHGQLRequests;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GHBranchProtectionRule;
import org.jetbrains.plugins.github.api.data.graphql.GHGQLRequestPagination;
import org.jetbrains.plugins.github.api.util.SimpleGHGQLPagesLoader;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubProjectDefaultAccountHolder;
import org.jetbrains.plugins.github.extensions.GHProtectedBranchRulesLoaderKt;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubProjectSettings;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J2\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\f\u001a\u00020\rH\u0016J2\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r2\u0018\u0010\u0007\u001a\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/plugins/github/extensions/GHProtectedBranchRulesLoader;", "Lgit4idea/fetch/GitFetchHandler;", "()V", "doAfterSuccessfulFetch", "", "project", "Lcom/intellij/openapi/project/Project;", "fetches", "", "Lgit4idea/repo/GitRepository;", "", "Lgit4idea/repo/GitRemote;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "loadProtectionRules", "intellij.vcs.github"})
public final class GHProtectedBranchRulesLoader
implements GitFetchHandler {
    public void doAfterSuccessfulFetch(@NotNull Project project, @NotNull Map<GitRepository, ? extends List<GitRemote>> fetches, @NotNull ProgressIndicator indicator) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(fetches, (String)"fetches");
        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
        try {
            this.loadProtectionRules(indicator, fetches, project);
        }
        catch (Exception e) {
            if (e instanceof ProcessCanceledException) {
                throw e;
            }
            GHProtectedBranchRulesLoaderKt.access$getLOG$p().info("Error occurred while trying to load branch protection rules", (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadProtectionRules(ProgressIndicator indicator, Map<GitRepository, ? extends List<GitRemote>> fetches, Project project) {
        Set accounts;
        GHAccountManager accountManager;
        block24: {
            block23: {
                boolean $i$f$service = false;
                Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
                Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
                if (object == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                accountManager = (GHAccountManager)((Object)object);
                accounts = (Set)accountManager.getAccountsState().getValue();
                if (!GitSharedSettings.getInstance((Project)project).isSynchronizeBranchProtectionRules()) break block23;
                if (accounts.isEmpty()) break block24;
            }
            Object modalityState$iv = null;
            boolean $i$f$runInEdt = false;
            Application app$iv = ApplicationManager.getApplication();
            if (app$iv.isDispatchThread()) {
                boolean bl = false;
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<GithubProjectSettings> serviceClass$iv = GithubProjectSettings.class;
                Object object = $this$service$iv.getService(serviceClass$iv);
                if (object == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                ((GithubProjectSettings)object).setBranchProtectionPatterns(new ArrayList());
            } else {
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(project){
                    final /* synthetic */ Project $project$inlined;
                    {
                        this.$project$inlined = project;
                    }

                    public final void run() {
                        boolean bl = false;
                        ComponentManager $this$service$iv = (ComponentManager)this.$project$inlined;
                        boolean $i$f$service = false;
                        Class<GithubProjectSettings> serviceClass$iv = GithubProjectSettings.class;
                        Object object = $this$service$iv.getService(serviceClass$iv);
                        if (object == null) {
                            throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                        }
                        ((GithubProjectSettings)object).setBranchProtectionPatterns((List<String>)new ArrayList<E>());
                    }
                }, ModalityState.defaultModalityState());
            }
            return;
        }
        indicator.setText(GithubBundle.message("progress.text.loading.protected.branches", new Object[0]));
        Set branchProtectionPatterns = new LinkedHashSet();
        for (Map.Entry<GitRepository, ? extends List<GitRemote>> app$iv : fetches.entrySet()) {
            GitRepository repository = app$iv.getKey();
            List<GitRemote> remotes = app$iv.getValue();
            indicator.checkCanceled();
            for (GitRemote remote : remotes) {
                void $this$forEach$iv;
                String token2;
                GithubAccount account;
                GithubAccount githubAccount;
                GHGitRepositoryMapping repositoryMapping;
                Object object;
                Object it;
                block21: {
                    indicator.checkCanceled();
                    ComponentManager $this$service$iv = (ComponentManager)project;
                    boolean $i$f$service22 = false;
                    Class<GHHostedRepositoriesManager> serviceClass$iv = GHHostedRepositoriesManager.class;
                    Object object22 = $this$service$iv.getService(serviceClass$iv);
                    if (object22 == null) {
                        throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                    }
                    Iterable $i$f$service22 = HostedGitRepositoriesManagerKt.findKnownRepositories((HostedGitRepositoriesManager)((HostedGitRepositoriesManager)object22), (GitRepository)repository);
                    for (Object object22 : $i$f$service22) {
                        it = (GHGitRepositoryMapping)object22;
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)((GHGitRepositoryMapping)it).getRemote().getRemote(), (Object)remote)) continue;
                        object = object22;
                        break block21;
                    }
                    object = null;
                }
                if ((GHGitRepositoryMapping)object == null) continue;
                GithubServerPath serverPath = repositoryMapping.getRepository().getServerPath();
                ComponentManager $this$service$iv = (ComponentManager)project;
                boolean $i$f$service = false;
                Class<GithubProjectDefaultAccountHolder> serviceClass$iv = GithubProjectDefaultAccountHolder.class;
                it = $this$service$iv.getService(serviceClass$iv);
                if (it == null) {
                    throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                }
                GithubAccount defaultAccount = (GithubAccount)((GithubProjectDefaultAccountHolder)((Object)it)).getAccount();
                if (defaultAccount != null && defaultAccount.getServer().equals(serverPath, true)) {
                    githubAccount = defaultAccount;
                } else {
                    Object v3;
                    block22: {
                        it = accounts;
                        Iterator bl = it.iterator();
                        while (bl.hasNext()) {
                            Object t = bl.next();
                            GithubAccount it2 = (GithubAccount)((Object)t);
                            boolean bl2 = false;
                            if (!it2.getServer().equals(serverPath, true)) continue;
                            v3 = t;
                            break block22;
                        }
                        v3 = null;
                    }
                    githubAccount = v3;
                }
                if (githubAccount == null || (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(accountManager, account = githubAccount, null){
                    int label;
                    final /* synthetic */ GHAccountManager $accountManager;
                    final /* synthetic */ GithubAccount $account;
                    {
                        this.$accountManager = $accountManager;
                        this.$account = $account;
                        super(2, $completion);
                    }

                    /*
                     * WARNING - void declaration
                     * Enabled force condition propagation
                     * Lifted jumps to return sites
                     */
                    @Nullable
                    public final Object invokeSuspend(@NotNull Object object) {
                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                this.label = 1;
                                Object object3 = this.$accountManager.findCredentials((Account)this.$account, (Continuation)this);
                                if (object3 != object2) return object3;
                                return object2;
                            }
                            case 1: {
                                void $result;
                                ResultKt.throwOnFailure((Object)$result);
                                Object object3 = $result;
                                return object3;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    @NotNull
                    public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                    }

                    @Nullable
                    public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)1, null) == null) continue;
                boolean $i$f$service32 = false;
                Class<GithubApiRequestExecutor.Factory> serviceClass$iv2 = GithubApiRequestExecutor.Factory.class;
                Object object3 = ApplicationManager.getApplication().getService(serviceClass$iv2);
                if (object3 == null) {
                    throw new RuntimeException("Cannot find service " + serviceClass$iv2.getName() + " (classloader=" + serviceClass$iv2.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                }
                GithubApiRequestExecutor requestExecutor = ((GithubApiRequestExecutor.Factory)object3).create(token2);
                Iterable $i$f$service32 = new SimpleGHGQLPagesLoader(requestExecutor, (Function1)new Function1<GHGQLRequestPagination, GithubApiRequest.Post<? extends GraphQLPagedResponseDataDTO<? extends GHBranchProtectionRule>>>(repositoryMapping){
                    final /* synthetic */ GHGitRepositoryMapping $repositoryMapping;
                    {
                        this.$repositoryMapping = $repositoryMapping;
                        super(1);
                    }

                    @NotNull
                    public final GithubApiRequest.Post<GraphQLPagedResponseDataDTO<GHBranchProtectionRule>> invoke(@NotNull GHGQLRequestPagination it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return GHGQLRequests.Repo.getProtectionRules$default(GHGQLRequests.Repo.INSTANCE, this.$repositoryMapping.getRepository(), null, 2, null);
                    }
                }, false, 0, 12, null).loadAll((ProgressIndicator)new SensitiveProgressWrapper(indicator));
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    GHBranchProtectionRule rule = (GHBranchProtectionRule)element$iv;
                    boolean bl = false;
                    String string = PatternUtil.convertToRegex((String)rule.getPattern());
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"convertToRegex(rule.pattern)");
                    branchProtectionPatterns.add(string);
                }
            }
        }
        Object modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application app$iv = ApplicationManager.getApplication();
        if (app$iv.isDispatchThread()) {
            boolean bl = false;
            ComponentManager $this$service$iv = (ComponentManager)project;
            boolean $i$f$service = false;
            Class<GithubProjectSettings> serviceClass$iv = GithubProjectSettings.class;
            Object object = $this$service$iv.getService(serviceClass$iv);
            if (object == null) {
                throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
            }
            ((GithubProjectSettings)object).setBranchProtectionPatterns(CollectionsKt.toMutableList((Collection)branchProtectionPatterns));
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(project, branchProtectionPatterns){
                final /* synthetic */ Project $project$inlined;
                final /* synthetic */ Set $branchProtectionPatterns$inlined;
                {
                    this.$project$inlined = project;
                    this.$branchProtectionPatterns$inlined = set;
                }

                public final void run() {
                    boolean bl = false;
                    ComponentManager $this$service$iv = (ComponentManager)this.$project$inlined;
                    boolean $i$f$service = false;
                    Class<GithubProjectSettings> serviceClass$iv = GithubProjectSettings.class;
                    Object object = $this$service$iv.getService(serviceClass$iv);
                    if (object == null) {
                        throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                    }
                    ((GithubProjectSettings)object).setBranchProtectionPatterns(CollectionsKt.toMutableList((Collection)this.$branchProtectionPatterns$inlined));
                }
            }, ModalityState.defaultModalityState());
        }
    }
}

