/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.util;

import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.api.GithubApiRequest;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubApiResponse;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\f\u001a\u00020\u00042\u0006\u0010\r\u001a\u00020\u000eH\u0000\u00a2\u0006\u0002\b\u000fJ\u0015\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0004H\u0001\u00a2\u0006\u0002\b\u0013J+\u0010\u0014\u001a\u0010\u0012\u0004\u0012\u00020\u0016\u0012\u0006\u0012\u0004\u0018\u00010\u00040\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\r\u001a\u00020\u000eH\u0001\u00a2\u0006\u0002\b\u0019J\u0014\u0010\u001a\u001a\u00020\u001b*\u00020\u000e2\u0006\u0010\u001c\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/plugins/github/authentication/util/GHSecurityUtil;", "", "()V", "GIST_SCOPE", "", "MASTER_SCOPES", "", "getMASTER_SCOPES", "()Ljava/util/List;", "READ_ORG_SCOPE", "REPO_SCOPE", "WORKFLOW_SCOPE", "buildNewTokenUrl", "server", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "buildNewTokenUrl$intellij_vcs_github", "isEnoughScopes", "", "grantedScopes", "isEnoughScopes$intellij_vcs_github", "loadCurrentUserWithScopes", "Lkotlin/Pair;", "Lorg/jetbrains/plugins/github/api/data/GithubAuthenticatedUser;", "executor", "Lorg/jetbrains/plugins/github/api/GithubApiRequestExecutor;", "loadCurrentUserWithScopes$intellij_vcs_github", "append", "Lcom/intellij/util/Url;", "path", "intellij.vcs.github"})
public final class GHSecurityUtil {
    @NotNull
    public static final GHSecurityUtil INSTANCE = new GHSecurityUtil();
    @NotNull
    private static final String REPO_SCOPE = "repo";
    @NotNull
    private static final String GIST_SCOPE = "gist";
    @NotNull
    private static final String READ_ORG_SCOPE = "read:org";
    @NotNull
    private static final String WORKFLOW_SCOPE = "workflow";
    @NotNull
    private static final List<String> MASTER_SCOPES;

    private GHSecurityUtil() {
    }

    @NotNull
    public final List<String> getMASTER_SCOPES() {
        return MASTER_SCOPES;
    }

    @JvmStatic
    @NotNull
    public static final Pair<GithubAuthenticatedUser, String> loadCurrentUserWithScopes$intellij_vcs_github(@NotNull GithubApiRequestExecutor executor, @NotNull GithubServerPath server) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Ref.ObjectRef scopes = new Ref.ObjectRef();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        Intrinsics.checkNotNullExpressionValue((Object)indicator, (String)"indicator");
        Object object = new String[]{GithubApiRequests.CurrentUser.INSTANCE.getUrlSuffix()};
        String string = GithubApiRequests.INSTANCE.getUrl(server, (String)object);
        object = GithubAuthenticatedUser.class;
        GithubAuthenticatedUser details2 = (GithubAuthenticatedUser)executor.execute(indicator, new GithubApiRequest.Get.Json<GithubAuthenticatedUser>((Ref.ObjectRef<String>)scopes, string, (Class<GithubAuthenticatedUser>)object){
            final /* synthetic */ Ref.ObjectRef<String> $scopes;
            {
                this.$scopes = $scopes;
                super($super_call_param$1, $super_call_param$2, null, 4, null);
            }

            @NotNull
            public GithubAuthenticatedUser extractResult(@NotNull GithubApiResponse response) {
                Intrinsics.checkNotNullParameter((Object)response, (String)"response");
                this.$scopes.element = response.findHeader("X-OAuth-Scopes");
                return (GithubAuthenticatedUser)super.extractResult(response);
            }
        }.withOperationName("get profile information"));
        return TuplesKt.to((Object)details2, (Object)scopes.element);
    }

    @JvmStatic
    public static final boolean isEnoughScopes$intellij_vcs_github(@NotNull String grantedScopes) {
        boolean bl;
        block6: {
            Intrinsics.checkNotNullParameter((Object)grantedScopes, (String)"grantedScopes");
            String[] stringArray = new String[]{", "};
            List scopesArray = StringsKt.split$default((CharSequence)grantedScopes, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (scopesArray.isEmpty()) {
                return false;
            }
            if (!scopesArray.contains(REPO_SCOPE)) {
                return false;
            }
            if (!scopesArray.contains(GIST_SCOPE)) {
                return false;
            }
            Iterable $this$none$iv = scopesArray;
            boolean $i$f$none = false;
            if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$none$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (!StringsKt.endsWith$default((String)it, (String)":org", (boolean)false, (int)2, null)) continue;
                    bl = false;
                    break block6;
                }
                bl = true;
            }
        }
        return !bl;
    }

    @NotNull
    public final String buildNewTokenUrl$intellij_vcs_github(@NotNull GithubServerPath server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        String productName = ApplicationNamesInfo.getInstance().getFullProductName();
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"description", (Object)(productName + " GitHub integration plugin")), TuplesKt.to((Object)"scopes", (Object)CollectionsKt.joinToString$default((Iterable)MASTER_SCOPES, (CharSequence)",", null, null, (int)0, null, null, (int)62, null))};
        String string = this.append(server, "settings/tokens/new").addParameters(MapsKt.mapOf((Pair[])pairArray)).toExternalForm();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"server\n      .append(\"se\u2026)\n      .toExternalForm()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Url append(GithubServerPath $this$append, String path) {
        String string;
        Object object;
        String string2 = $this$append.getSchema();
        String string3 = string2;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"schema");
        String string4 = $this$append.getHost();
        Integer n = $this$append.getPort();
        if (n != null) {
            void it;
            Integer n2 = n;
            String string5 = string4;
            String string6 = string3;
            boolean bl = false;
            String string7 = ":" + (Integer)it;
            string3 = string6;
            string4 = string5;
            object = string7;
        } else {
            object = string = null;
        }
        if (object == null) {
            string = "";
        }
        String string8 = string4 + string;
        String string9 = $this$append.getSuffix();
        if (string9 == null) {
            string9 = "";
        }
        return Urls.newUrl((String)string3, (String)string8, (String)(string9 + "/" + path));
    }

    static {
        Object[] objectArray = new String[]{REPO_SCOPE, GIST_SCOPE, READ_ORG_SCOPE, WORKFLOW_SCOPE};
        MASTER_SCOPES = CollectionsKt.listOf((Object[])objectArray);
    }
}

