/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication.accounts;

import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.PersistentDefaultAccountHolder;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsNotifier;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

@State(name="GithubDefaultAccount", storages={@Storage(value="$WORKSPACE_FILE$")}, reportStatistic=false)
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0014J\b\u0010\b\u001a\u00020\tH\u0014\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/authentication/accounts/GithubProjectDefaultAccountHolder;", "Lcom/intellij/collaboration/auth/PersistentDefaultAccountHolder;", "Lorg/jetbrains/plugins/github/authentication/accounts/GithubAccount;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "notifyDefaultAccountMissing", "", "intellij.vcs.github"})
public final class GithubProjectDefaultAccountHolder
extends PersistentDefaultAccountHolder<GithubAccount> {
    public GithubProjectDefaultAccountHolder(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }

    @NotNull
    protected GHAccountManager accountManager() {
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (GHAccountManager)((Object)object);
    }

    protected void notifyDefaultAccountMissing() {
        Object modalityState$iv = null;
        boolean $i$f$runInEdt = false;
        Application app$iv = ApplicationManager.getApplication();
        if (app$iv.isDispatchThread()) {
            boolean bl = false;
            String string = GithubBundle.message("accounts.default.missing", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"accounts.default.missing\")");
            String title = string;
            GithubUtil.LOG.info(title + "; ");
            VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, NotificationType.WARNING).setDisplayId("github.missing.default.account").addAction(GithubNotifications.getConfigureAction(this.getProject())).notify(this.getProject());
        } else {
            boolean $i$f$invokeLater = false;
            ApplicationManager.getApplication().invokeLater(new Runnable(this){
                final /* synthetic */ GithubProjectDefaultAccountHolder this$0;
                {
                    this.this$0 = githubProjectDefaultAccountHolder;
                }

                public final void run() {
                    boolean bl = false;
                    String string = GithubBundle.message("accounts.default.missing", new Object[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"accounts.default.missing\")");
                    String title = string;
                    GithubUtil.LOG.info(title + "; ");
                    VcsNotifier.IMPORTANT_ERROR_NOTIFICATION.createNotification(title, NotificationType.WARNING).setDisplayId("github.missing.default.account").addAction(GithubNotifications.getConfigureAction(GithubProjectDefaultAccountHolder.access$getProject(this.this$0))).notify(GithubProjectDefaultAccountHolder.access$getProject(this.this$0));
                }
            }, ModalityState.defaultModalityState());
        }
    }
}

