/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.authentication;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.Messages;
import git4idea.DialogManager;
import java.awt.Component;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.authentication.GHLoginRequest;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.ui.GHLoginDialog;
import org.jetbrains.plugins.github.authentication.ui.GHLoginModel;
import org.jetbrains.plugins.github.i18n.GithubBundle;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a(\u0010\u0010\u001a\u00020\r*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a(\u0010\u0013\u001a\u00020\r*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\u001a(\u0010\u0014\u001a\u00020\r*\u00020\u00072\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\b\u001a\u0004\u0018\u00010\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002\"\u0014\u0010\u0000\u001a\u00020\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006\u0015"}, d2={"accountManager", "Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "getAccountManager", "()Lorg/jetbrains/plugins/github/authentication/accounts/GHAccountManager;", "promptOAuthLogin", "", "request", "Lorg/jetbrains/plugins/github/authentication/GHLoginRequest;", "project", "Lcom/intellij/openapi/project/Project;", "parentComponent", "Ljava/awt/Component;", "configure", "", "dialog", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginDialog;", "loginWithOAuth", "model", "Lorg/jetbrains/plugins/github/authentication/ui/GHLoginModel;", "loginWithOAuthOrToken", "loginWithToken", "intellij.vcs.github"})
public final class GHAccountsUtilKt {
    private static final GHAccountManager getAccountManager() {
        boolean $i$f$service = false;
        Class<GHAccountManager> serviceClass$iv = GHAccountManager.class;
        Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
        if (object == null) {
            throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
        }
        return (GHAccountManager)((Object)object);
    }

    private static final void configure(GHLoginRequest $this$configure, GHLoginDialog dialog2) {
        block2: {
            Object it;
            Throwable throwable = $this$configure.getError();
            if (throwable != null) {
                it = throwable;
                boolean bl = false;
                dialog2.setError((Throwable)it);
            }
            GithubServerPath githubServerPath = $this$configure.getServer();
            if (githubServerPath != null) {
                it = githubServerPath;
                boolean bl = false;
                String string = ((GithubServerPath)it).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.toString()");
                dialog2.setServer(string, $this$configure.isServerEditable());
            }
            String string = $this$configure.getLogin();
            if (string == null) break block2;
            it = string;
            boolean bl = false;
            dialog2.setLogin((String)it, $this$configure.isLoginEditable());
        }
    }

    private static final void loginWithToken(GHLoginRequest $this$loginWithToken, GHLoginModel model2, Project project, Component parentComponent) {
        GHLoginDialog.Token dialog2 = new GHLoginDialog.Token(model2, project, parentComponent);
        GHAccountsUtilKt.configure($this$loginWithToken, dialog2);
        DialogManager.show((DialogWrapper)dialog2);
    }

    private static final void loginWithOAuth(GHLoginRequest $this$loginWithOAuth, GHLoginModel model2, Project project, Component parentComponent) {
        GHLoginDialog.OAuth dialog2 = new GHLoginDialog.OAuth(model2, project, parentComponent);
        GHAccountsUtilKt.configure($this$loginWithOAuth, dialog2);
        DialogManager.show((DialogWrapper)dialog2);
    }

    private static final void loginWithOAuthOrToken(GHLoginRequest $this$loginWithOAuthOrToken, GHLoginModel model2, Project project, Component parentComponent) {
        switch (GHAccountsUtilKt.promptOAuthLogin($this$loginWithOAuthOrToken, project, parentComponent)) {
            case 0: {
                GHAccountsUtilKt.loginWithOAuth($this$loginWithOAuthOrToken, model2, project, parentComponent);
                break;
            }
            case 1: {
                GHAccountsUtilKt.loginWithToken($this$loginWithOAuthOrToken, model2, project, parentComponent);
            }
        }
    }

    private static final int promptOAuthLogin(GHLoginRequest request, Project project, Component parentComponent) {
        String string = GithubBundle.message("login.to.github", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(\"login.to.github\")");
        String string2 = request.getText();
        if (string2 == null) {
            String string3 = GithubBundle.message("dialog.message.login.to.continue", new Object[0]);
            string2 = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(\"dialog.message.login.to.continue\")");
        }
        MessageDialogBuilder.YesNoCancel yesNoCancel = MessageDialogBuilder.Companion.yesNoCancel(string, string2);
        String string4 = GithubBundle.message("login.via.github.action", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(\"login.via.github.action\")");
        MessageDialogBuilder.YesNoCancel yesNoCancel2 = (MessageDialogBuilder.YesNoCancel)yesNoCancel.yesText(string4);
        String string5 = GithubBundle.message("button.use.token", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(\"button.use.token\")");
        MessageDialogBuilder.YesNoCancel builder = (MessageDialogBuilder.YesNoCancel)((MessageDialogBuilder.YesNoCancel)yesNoCancel2.noText(string5)).icon(Messages.getWarningIcon());
        if (parentComponent != null) {
            return builder.show(parentComponent);
        }
        return builder.show(project);
    }

    public static final /* synthetic */ GHAccountManager access$getAccountManager() {
        return GHAccountsUtilKt.getAccountManager();
    }

    public static final /* synthetic */ void access$loginWithToken(GHLoginRequest $receiver, GHLoginModel model2, Project project, Component parentComponent) {
        GHAccountsUtilKt.loginWithToken($receiver, model2, project, parentComponent);
    }

    public static final /* synthetic */ void access$loginWithOAuth(GHLoginRequest $receiver, GHLoginModel model2, Project project, Component parentComponent) {
        GHAccountsUtilKt.loginWithOAuth($receiver, model2, project, parentComponent);
    }

    public static final /* synthetic */ void access$loginWithOAuthOrToken(GHLoginRequest $receiver, GHLoginModel model2, Project project, Component parentComponent) {
        GHAccountsUtilKt.loginWithOAuthOrToken($receiver, model2, project, parentComponent);
    }
}

