/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data.request;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class GithubGistRequest {
    @NotNull
    private final String description;
    @NotNull
    private final Map<String, GistFile> files;
    @JsonProperty(value="public")
    private final boolean isPublic;

    public GithubGistRequest(@NotNull List<FileContent> files, @NotNull String description2, boolean isPublic) {
        this.description = description2;
        this.isPublic = isPublic;
        this.files = new HashMap<String, GistFile>();
        for (FileContent file : files) {
            this.files.put(file.getFileName(), new GistFile(file.getContent()));
        }
    }

    public static class FileContent {
        @NotNull
        private final String myFileName;
        @NotNull
        private final String myContent;

        public FileContent(@NotNull String fileName, @NotNull String content2) {
            this.myFileName = fileName;
            this.myContent = content2;
        }

        @NotNull
        public String getFileName() {
            return this.myFileName;
        }

        @NotNull
        public String getContent() {
            return this.myContent;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FileContent that = (FileContent)o;
            if (!this.myContent.equals(that.myContent)) {
                return false;
            }
            return this.myFileName.equals(that.myFileName);
        }

        public int hashCode() {
            int result = this.myFileName.hashCode();
            result = 31 * result + this.myContent.hashCode();
            return result;
        }
    }

    public static class GistFile {
        @NotNull
        private final String content;

        public GistFile(@NotNull String content2) {
            this.content = content2;
        }
    }
}

