/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api.data;

import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.data.GithubIssueLabel;
import org.jetbrains.plugins.github.api.data.GithubIssueState;
import org.jetbrains.plugins.github.api.data.GithubUser;

public abstract class GithubIssueBase {
    private String url;
    private String repositoryUrl;
    private String labelsUrl;
    private String commentsUrl;
    private String eventsUrl;
    private String htmlUrl;
    private Long id;
    private String nodeId;
    private Long number;
    private String title;
    private GithubUser user;
    private List<GithubIssueLabel> labels;
    private GithubIssueState state;
    private Boolean locked;
    private GithubUser assignee;
    private List<GithubUser> assignees;
    private Long comments;
    private Date createdAt;
    private Date updatedAt;
    private Date closedAt;
    private String authorAssociation;
    private String body;

    @NotNull
    public String getCommentsUrl() {
        return this.commentsUrl;
    }

    @NotNull
    public String getHtmlUrl() {
        return this.htmlUrl;
    }

    public long getNumber() {
        return this.number;
    }

    @NotNull
    public GithubIssueState getState() {
        return this.state;
    }

    @NlsSafe
    @NotNull
    public String getTitle() {
        return this.title;
    }

    @Nullable
    public List<GithubIssueLabel> getLabels() {
        return this.labels;
    }

    @NlsSafe
    @NotNull
    public String getBody() {
        return StringUtil.notNullize((String)this.body);
    }

    @NotNull
    public GithubUser getUser() {
        return this.user;
    }

    @Nullable
    public GithubUser getAssignee() {
        return this.assignee;
    }

    @NotNull
    public List<GithubUser> getAssignees() {
        return this.assignees;
    }

    @Nullable
    public Date getClosedAt() {
        return this.closedAt;
    }

    @NotNull
    public Date getCreatedAt() {
        return this.createdAt;
    }

    @NotNull
    public Date getUpdatedAt() {
        return this.updatedAt;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GithubIssueBase)) {
            return false;
        }
        GithubIssueBase base = (GithubIssueBase)o;
        return this.number.equals(base.number);
    }

    public int hashCode() {
        return Objects.hash(this.number);
    }
}

