/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github.api;

import com.intellij.openapi.util.NlsSafe;
import git4idea.remote.hosting.HostedRepositoryCoordinates;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubServerPath;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0096\u0002J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\b\u0010\u0014\u001a\u00020\u0015H\u0017J\u0006\u0010\u0016\u001a\u00020\u0015R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "Lgit4idea/remote/hosting/HostedRepositoryCoordinates;", "serverPath", "Lorg/jetbrains/plugins/github/api/GithubServerPath;", "repositoryPath", "Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "(Lorg/jetbrains/plugins/github/api/GithubServerPath;Lorg/jetbrains/plugins/github/api/GHRepositoryPath;)V", "getRepositoryPath", "()Lorg/jetbrains/plugins/github/api/GHRepositoryPath;", "getServerPath", "()Lorg/jetbrains/plugins/github/api/GithubServerPath;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "toUrl", "intellij.vcs.github"})
public final class GHRepositoryCoordinates
implements HostedRepositoryCoordinates {
    @NotNull
    private final GithubServerPath serverPath;
    @NotNull
    private final GHRepositoryPath repositoryPath;

    public GHRepositoryCoordinates(@NotNull GithubServerPath serverPath, @NotNull GHRepositoryPath repositoryPath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        this.serverPath = serverPath;
        this.repositoryPath = repositoryPath;
    }

    @NotNull
    public GithubServerPath getServerPath() {
        return this.serverPath;
    }

    @NotNull
    public final GHRepositoryPath getRepositoryPath() {
        return this.repositoryPath;
    }

    @NotNull
    public final String toUrl() {
        return this.getServerPath().toUrl() + "/" + this.repositoryPath;
    }

    @NlsSafe
    @NotNull
    public String toString() {
        return this.getServerPath() + "/" + this.repositoryPath;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GHRepositoryCoordinates)) {
            return false;
        }
        if (!this.getServerPath().equals(((GHRepositoryCoordinates)other).getServerPath(), true)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.repositoryPath, (Object)((GHRepositoryCoordinates)other).repositoryPath);
    }

    public int hashCode() {
        int result = this.getServerPath().hashCode();
        result = 31 * result + this.repositoryPath.hashCode();
        return result;
    }

    @NotNull
    public final GithubServerPath component1() {
        return this.getServerPath();
    }

    @NotNull
    public final GHRepositoryPath component2() {
        return this.repositoryPath;
    }

    @NotNull
    public final GHRepositoryCoordinates copy(@NotNull GithubServerPath serverPath, @NotNull GHRepositoryPath repositoryPath) {
        Intrinsics.checkNotNullParameter((Object)serverPath, (String)"serverPath");
        Intrinsics.checkNotNullParameter((Object)repositoryPath, (String)"repositoryPath");
        return new GHRepositoryCoordinates(serverPath, repositoryPath);
    }

    public static /* synthetic */ GHRepositoryCoordinates copy$default(GHRepositoryCoordinates gHRepositoryCoordinates, GithubServerPath githubServerPath, GHRepositoryPath gHRepositoryPath, int n, Object object) {
        if ((n & 1) != 0) {
            githubServerPath = gHRepositoryCoordinates.getServerPath();
        }
        if ((n & 2) != 0) {
            gHRepositoryPath = gHRepositoryCoordinates.repositoryPath;
        }
        return gHRepositoryCoordinates.copy(githubServerPath, gHRepositoryPath);
    }
}

