/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import git4idea.DialogManager;
import git4idea.GitUtil;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.commands.GitLocalChangesWouldBeOverwrittenDetector;
import git4idea.commands.GitMessageWithFilesDetector;
import git4idea.commands.GitStandardProgressAnalyzer;
import git4idea.commands.GitUntrackedFilesOverwrittenByOperationDetector;
import git4idea.config.GitSaveChangesPolicy;
import git4idea.config.GitVcsSettings;
import git4idea.fetch.GitFetchSupport;
import git4idea.i18n.GitBundle;
import git4idea.rebase.GitRebaseProblemDetector;
import git4idea.rebase.GitRebaser;
import git4idea.remote.hosting.GitHostingUrlUtil;
import git4idea.remote.hosting.HostedGitRepositoriesManager;
import git4idea.remote.hosting.HostedGitRepositoriesManagerKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.update.GitUpdateResult;
import git4idea.util.GitPreservingProcess;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryPath;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.GithubServerPath;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.GithubRepoDetailed;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.ui.GithubChooseAccountDialog;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.util.GHCompatibilityUtil;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUrlUtil;
import org.jetbrains.plugins.github.util.GithubUtil;

public class GithubSyncForkAction
extends DumbAwareAction {
    private static final Logger LOG = GithubUtil.LOG;
    private static final String UPSTREAM_REMOTE_NAME = "upstream";
    private static final String ORIGIN_REMOTE_NAME = "origin";

    public GithubSyncForkAction() {
        super(GithubBundle.messagePointer("rebase.action", new Object[0]), GithubBundle.messagePointer("rebase.action.description", new Object[0]), AllIcons.Vcs.Vendors.Github);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        e.getPresentation().setEnabledAndVisible(GithubSyncForkAction.isEnabledAndVisible(e));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        GithubAccount githubAccount;
        FileDocumentManager.getInstance().saveAllDocuments();
        Project project = Objects.requireNonNull((Project)e.getData(CommonDataKeys.PROJECT));
        GitRepositoryManager gitRepositoryManager = (GitRepositoryManager)project.getServiceIfCreated(GitRepositoryManager.class);
        if (gitRepositoryManager == null) {
            LOG.warn("Unable to get the GitRepositoryManager service");
            return;
        }
        if (gitRepositoryManager.getRepositories().size() > 1) {
            GithubNotifications.showError(project, "github.rebase.multi.repo.not.supported", GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("rebase.error.multi.repo.not.supported", new Object[0]));
            return;
        }
        GHHostedRepositoriesManager ghRepositoriesManager = (GHHostedRepositoriesManager)project.getServiceIfCreated(GHHostedRepositoriesManager.class);
        if (ghRepositoriesManager == null) {
            LOG.warn("Unable to get the GHProjectRepositoriesManager service");
            return;
        }
        Set repositories = HostedGitRepositoriesManagerKt.getKnownRepositories((HostedGitRepositoriesManager)ghRepositoriesManager);
        GHGitRepositoryMapping originMapping = (GHGitRepositoryMapping)ContainerUtil.find((Iterable)repositories, mapping -> mapping.getRemote().getRemote().getName().equals(ORIGIN_REMOTE_NAME));
        if (originMapping == null) {
            GithubNotifications.showError(project, "github.rebase.remote.origin.not.found", GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("rebase.error.remote.origin.not.found", new Object[0]));
            return;
        }
        GHAccountManager accountManager = (GHAccountManager)((Object)ApplicationManager.getApplication().getService(GHAccountManager.class));
        GithubServerPath serverPath = originMapping.getRepository().getServerPath();
        List accounts = ContainerUtil.filter((Collection)((Collection)accountManager.getAccountsState().getValue()), account -> serverPath.equals(account.getServer()));
        if (accounts.size() == 0) {
            githubAccount = GHCompatibilityUtil.requestNewAccountForServer(serverPath, project);
        } else if (accounts.size() == 1) {
            githubAccount = (GithubAccount)((Object)accounts.get(0));
        } else {
            GithubChooseAccountDialog chooseAccountDialog = new GithubChooseAccountDialog(project, null, accounts, GithubBundle.message("account.choose.for", serverPath), false, true);
            DialogManager.show((DialogWrapper)chooseAccountDialog);
            if (chooseAccountDialog.isOK()) {
                githubAccount = chooseAccountDialog.getAccount();
            } else {
                GithubNotifications.showError(project, "github.rebase.account.not.found", GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("rebase.error.no.suitable.account.found", new Object[0]));
                return;
            }
        }
        if (githubAccount == null) {
            GithubNotifications.showError(project, "github.rebase.account.not.found", GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("rebase.error.no.suitable.account.found", new Object[0]));
            return;
        }
        new SyncForkTask(project, Git.getInstance(), githubAccount, originMapping.getRemote().getRepository(), originMapping.getRepository().getRepositoryPath()).queue();
    }

    private static boolean isEnabledAndVisible(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null || project.isDefault()) {
            return false;
        }
        GHHostedRepositoriesManager repositoriesManager = (GHHostedRepositoriesManager)project.getServiceIfCreated(GHHostedRepositoriesManager.class);
        if (repositoriesManager == null) {
            return false;
        }
        Set repositories = HostedGitRepositoriesManagerKt.getKnownRepositories((HostedGitRepositoriesManager)repositoriesManager);
        return !repositories.isEmpty();
    }

    private static class SyncForkTask
    extends Task.Backgroundable {
        @NotNull
        private final Git myGit;
        @NotNull
        private final GithubAccount myAccount;
        @NotNull
        private final GitRepository myRepository;
        @NotNull
        private final GHRepositoryPath myRepoPath;

        SyncForkTask(@NotNull Project project, @NotNull Git git, @NotNull GithubAccount account, @NotNull GitRepository repository, @NotNull GHRepositoryPath repoPath) {
            super(project, GithubBundle.message("rebase.process", new Object[0]));
            this.myGit = git;
            this.myAccount = account;
            this.myRepository = repository;
            this.myRepoPath = repoPath;
        }

        public void run(@NotNull ProgressIndicator indicator) {
            String token2 = GHCompatibilityUtil.getOrRequestToken(this.myAccount, this.myProject);
            if (token2 == null) {
                return;
            }
            GithubApiRequestExecutor executor = GithubApiRequestExecutor.Factory.getInstance().create(token2);
            this.myRepository.update();
            GithubRepo parentRepo = this.validateRepoAndLoadParent(executor, indicator);
            if (parentRepo == null) {
                return;
            }
            GitRemote parentRemote = this.configureParentRemote(indicator, parentRepo.getFullPath());
            if (parentRemote == null) {
                return;
            }
            String branchName = parentRepo.getDefaultBranch();
            if (branchName == null) {
                GithubNotifications.showError(this.myProject, "github.rebase.repo.not.found", GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("rebase.error.no.default.branch", new Object[0]));
                return;
            }
            if (!this.fetchParent(indicator, parentRemote)) {
                return;
            }
            this.rebaseCurrentBranch(indicator, parentRemote, branchName);
        }

        @Nullable
        private GithubRepo validateRepoAndLoadParent(@NotNull GithubApiRequestExecutor executor, @NotNull ProgressIndicator indicator) {
            try {
                GithubRepoDetailed repositoryInfo = executor.execute(indicator, GithubApiRequests.Repos.get(this.myAccount.getServer(), this.myRepoPath.getOwner(), this.myRepoPath.getRepository()));
                if (repositoryInfo == null) {
                    GithubNotifications.showError(this.myProject, "github.rebase.repo.not.found", GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("rebase.error.repo.not.found", this.myRepoPath.toString()));
                    return null;
                }
                GithubRepo parentRepo = repositoryInfo.getParent();
                if (!repositoryInfo.isFork() || parentRepo == null) {
                    GithubNotifications.showWarningURL(this.myProject, "github.rebase.repo.is.not.a.fork", GithubBundle.message("rebase.error", new Object[0]), "GitHub repository ", "'" + repositoryInfo.getName() + "'", " is not a fork", repositoryInfo.getHtmlUrl());
                    return null;
                }
                return parentRepo;
            }
            catch (IOException e) {
                GithubNotifications.showError(this.myProject, "github.rebase.cannot.load.repo.info", GithubBundle.message("cannot.load.repo.info", new Object[0]), e);
                return null;
            }
        }

        @Nullable
        private GitRemote configureParentRemote(@NotNull ProgressIndicator indicator, @NotNull GHRepositoryPath parentRepoPath) {
            LOG.info("Configuring upstream remote");
            indicator.setText(GithubBundle.message("rebase.process.configuring.upstream.remote", new Object[0]));
            GitRemote upstreamRemote = this.findRemote(parentRepoPath);
            if (upstreamRemote != null) {
                LOG.info("Correct upstream remote already exists");
                return upstreamRemote;
            }
            LOG.info("Adding GitHub parent as a remote host");
            indicator.setText(GithubBundle.message("rebase.process.adding.github.parent.as.remote.host", new Object[0]));
            String parentRepoUrl = GithubGitHelper.getInstance().getRemoteUrl(this.myAccount.getServer(), parentRepoPath);
            try {
                this.myGit.addRemote(this.myRepository, GithubSyncForkAction.UPSTREAM_REMOTE_NAME, parentRepoUrl).throwOnError(new int[0]);
            }
            catch (VcsException e) {
                GithubNotifications.showError(this.myProject, "github.rebase.cannot.configure.upstream.remote", GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("cannot.configure.remote", GithubSyncForkAction.UPSTREAM_REMOTE_NAME, e.getMessage()));
                return null;
            }
            this.myRepository.update();
            upstreamRemote = this.findRemote(parentRepoPath);
            if (upstreamRemote == null) {
                GithubNotifications.showError(this.myProject, "github.rebase.cannot.configure.upstream.remote", GithubBundle.message("rebase.error", new Object[0]), GithubBundle.message("rebase.error.upstream.not.found", GithubSyncForkAction.UPSTREAM_REMOTE_NAME));
            }
            return upstreamRemote;
        }

        @Nullable
        private GitRemote findRemote(@NotNull GHRepositoryPath repoPath) {
            return (GitRemote)ContainerUtil.find((Iterable)this.myRepository.getRemotes(), remote -> {
                String url = remote.getFirstUrl();
                if (url == null || !GitHostingUrlUtil.match((URI)this.myAccount.getServer().toURI(), (String)url)) {
                    return false;
                }
                GHRepositoryPath remotePath = GithubUrlUtil.getUserAndRepositoryFromRemoteUrl(url);
                return repoPath.equals(remotePath);
            });
        }

        private boolean fetchParent(@NotNull ProgressIndicator indicator, @NotNull GitRemote remote) {
            LOG.info("Fetching upstream");
            indicator.setText(GithubBundle.message("rebase.process.fetching.upstream", new Object[0]));
            return GitFetchSupport.fetchSupport((Project)this.myProject).fetch(this.myRepository, remote).showNotificationIfFailed();
        }

        private void rebaseCurrentBranch(@NotNull ProgressIndicator indicator, @NotNull GitRemote parentRemote, @NotNull @NlsSafe String branch) {
            String onto = parentRemote.getName() + "/" + branch;
            LOG.info("Rebasing current branch");
            indicator.setText(GithubBundle.message("rebase.process.rebasing.branch.onto", onto));
            try (AccessToken ignore = DvcsUtil.workingTreeChangeStarted((Project)this.myProject, (String)GitBundle.message((String)"rebase.git.operation.name", (Object[])new Object[0]));){
                List<VirtualFile> rootsToSave = Collections.singletonList(this.myRepository.getRoot());
                GitSaveChangesPolicy saveMethod = GitVcsSettings.getInstance((Project)this.myProject).getSaveChangesPolicy();
                GitPreservingProcess process = new GitPreservingProcess(this.myProject, this.myGit, rootsToSave, GithubBundle.message("rebase.process.operation.title", new Object[0]), onto, saveMethod, indicator, () -> this.doRebaseCurrentBranch(indicator, onto));
                process.execute();
            }
        }

        private void doRebaseCurrentBranch(@NotNull ProgressIndicator indicator, @NotNull String onto) {
            GitRepositoryManager repositoryManager = GitUtil.getRepositoryManager((Project)this.myProject);
            GitRebaser rebaser = new GitRebaser(this.myProject, this.myGit, indicator);
            VirtualFile root = this.myRepository.getRoot();
            GitLineHandler handler = new GitLineHandler(this.myProject, root, GitCommand.REBASE);
            handler.setStdoutSuppressed(false);
            handler.addParameters(new String[]{onto});
            GitRebaseProblemDetector rebaseConflictDetector = new GitRebaseProblemDetector();
            handler.addLineListener((GitLineHandlerListener)rebaseConflictDetector);
            GitUntrackedFilesOverwrittenByOperationDetector untrackedFilesDetector = new GitUntrackedFilesOverwrittenByOperationDetector(root);
            GitLocalChangesWouldBeOverwrittenDetector localChangesDetector = new GitLocalChangesWouldBeOverwrittenDetector(root, GitLocalChangesWouldBeOverwrittenDetector.Operation.CHECKOUT);
            handler.addLineListener((GitLineHandlerListener)untrackedFilesDetector);
            handler.addLineListener((GitLineHandlerListener)localChangesDetector);
            handler.addLineListener(GitStandardProgressAnalyzer.createListener((ProgressIndicator)indicator));
            String oldText = indicator.getText();
            indicator.setText(GithubBundle.message("rebase.process.rebasing.onto", onto));
            GitCommandResult rebaseResult = this.myGit.runCommand(handler);
            indicator.setText(oldText);
            repositoryManager.updateRepository(root);
            if (rebaseResult.success()) {
                root.refresh(false, true);
                GithubNotifications.showInfo(this.myProject, "github.rebase.success", GithubBundle.message("rebase.process.success", new Object[0]), "");
            } else {
                GitUpdateResult result = rebaser.handleRebaseFailure(handler, root, rebaseResult, rebaseConflictDetector, (GitMessageWithFilesDetector)untrackedFilesDetector, localChangesDetector);
                if (result == GitUpdateResult.NOTHING_TO_UPDATE || result == GitUpdateResult.SUCCESS || result == GitUpdateResult.SUCCESS_WITH_RESOLVED_CONFLICTS) {
                    GithubNotifications.showInfo(this.myProject, "github.rebase.success", GithubBundle.message("rebase.process.success", new Object[0]), "");
                }
            }
        }
    }
}

