/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.CommonBundle;
import com.intellij.codeWithMe.ClientId;
import com.intellij.collaboration.auth.Account;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.TrustedProjects;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsNotifier;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ui.SelectFilesDialog;
import com.intellij.openapi.vcs.ui.CommitMessage;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.components.BrowserLink;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.components.BorderLayoutPanel;
import com.intellij.vcsUtil.VcsFileUtil;
import git4idea.DialogManager;
import git4idea.GitLocalBranch;
import git4idea.GitUtil;
import git4idea.actions.GitInit;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitLineHandler;
import git4idea.commands.GitLineHandlerListener;
import git4idea.i18n.GitBundle;
import git4idea.remote.hosting.HostedGitRepositoriesManager;
import git4idea.remote.hosting.HostedGitRepositoriesManagerKt;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitFileUtils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.ResultKt;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.plugins.github.GithubShareAction;
import org.jetbrains.plugins.github.api.GithubApiRequestExecutor;
import org.jetbrains.plugins.github.api.GithubApiRequests;
import org.jetbrains.plugins.github.api.data.GithubAuthenticatedUser;
import org.jetbrains.plugins.github.api.data.GithubRepo;
import org.jetbrains.plugins.github.api.data.request.Type;
import org.jetbrains.plugins.github.api.util.GithubApiPagesLoader;
import org.jetbrains.plugins.github.authentication.GHAccountsUtil;
import org.jetbrains.plugins.github.authentication.accounts.GHAccountManager;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccount;
import org.jetbrains.plugins.github.authentication.accounts.GithubAccountInformationProvider;
import org.jetbrains.plugins.github.exceptions.GithubMissingTokenException;
import org.jetbrains.plugins.github.i18n.GithubBundle;
import org.jetbrains.plugins.github.ui.GithubShareDialog;
import org.jetbrains.plugins.github.util.GHCompatibilityUtil;
import org.jetbrains.plugins.github.util.GHGitRepositoryMapping;
import org.jetbrains.plugins.github.util.GHHostedRepositoriesManager;
import org.jetbrains.plugins.github.util.GithubGitHelper;
import org.jetbrains.plugins.github.util.GithubNotifications;
import org.jetbrains.plugins.github.util.GithubUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \n2\u00020\u0001:\u0003\n\u000b\fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "Companion", "GithubExistingRemotesDialog", "GithubUntrackedFilesDialog", "intellij.vcs.github"})
public final class GithubShareAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Logger LOG = GithubUtil.LOG;

    public GithubShareAction() {
        super(GithubBundle.messagePointer("share.action", new Object[0]), GithubBundle.messagePointer("share.action.description", new Object[0]), AllIcons.Vcs.Vendors.Github);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabledAndVisible(project != null && !project.isDefault() && TrustedProjects.isTrusted((Project)project));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        VirtualFile file = (VirtualFile)e.getData(CommonDataKeys.VIRTUAL_FILE);
        if (project == null || project.isDisposed()) {
            return;
        }
        Companion.shareProjectOnGithub(project, file);
    }

    @JvmStatic
    public static final void shareProjectOnGithub(@NotNull Project project, @Nullable VirtualFile file) {
        Companion.shareProjectOnGithub(project, file);
    }

    public static final /* synthetic */ Logger access$getLOG$cp() {
        return LOG;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "shareProjectOnGithub", "", "project", "Lcom/intellij/openapi/project/Project;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.vcs.github"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Unable to fully structure code
         * Could not resolve type clashes
         */
        @JvmStatic
        public final void shareProjectOnGithub(@NotNull Project project, @Nullable VirtualFile file) {
            block17: {
                block16: {
                    Intrinsics.checkNotNullParameter((Object)project, (String)"project");
                    FileDocumentManager.getInstance().saveAllDocuments();
                    gitRepository = GithubGitHelper.Companion.findGitRepository(project, file);
                    if (gitRepository == null) ** GOTO lbl-1000
                    var6_4 /* !! */  = gitRepository;
                    $this$service$iv /* !! */  = (ComponentManager)project;
                    $i$f$service = false;
                    serviceClass$iv = GHHostedRepositoriesManager.class;
                    var10_22 = $this$service$iv /* !! */ .getService(serviceClass$iv);
                    if (var10_22 == null) {
                        throw new IllegalStateException(("Cannot find service " + serviceClass$iv.getName() + " in " + $this$service$iv /* !! */  + " (classloader=" + serviceClass$iv.getClassLoader()).toString());
                    }
                    $this$service$iv /* !! */  = (GHHostedRepositoriesManager)var10_22;
                    p0 = var6_4 /* !! */ ;
                    $i$a$-let-GithubShareAction$Companion$shareProjectOnGithub$possibleRemotes$1 = false;
                    var5_25 = HostedGitRepositoriesManagerKt.findKnownRepositories((HostedGitRepositoriesManager)((HostedGitRepositoriesManager)$this$service$iv /* !! */ ), (GitRepository)p0);
                    if (var5_25 != null) {
                        var6_4 /* !! */  = var5_25;
                        $i$f$map = false;
                        p0 = $this$map$iv;
                        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        $i$f$mapTo = false;
                        for (T item$iv$iv : $this$mapTo$iv$iv) {
                            var13_29 = (GHGitRepositoryMapping)item$iv$iv;
                            var22_32 = destination$iv$iv;
                            $i$a$-map-GithubShareAction$Companion$shareProjectOnGithub$possibleRemotes$2 = false;
                            var22_32.add(it.getRemote().getUrl());
                        }
                        v0 = (List)destination$iv$iv;
                    } else lbl-1000:
                    // 2 sources

                    {
                        v0 = v1 = null;
                    }
                    if (v0 == null) {
                        v1 = CollectionsKt.emptyList();
                    }
                    if (((Collection)(possibleRemotes = v1)).isEmpty() == false) {
                        existingRemotesDialog = new GithubExistingRemotesDialog(project, possibleRemotes);
                        DialogManager.show((DialogWrapper)existingRemotesDialog);
                        if (!existingRemotesDialog.isOK()) {
                            return;
                        }
                    }
                    $i$f$service = false;
                    serviceClass$iv = ProgressManager.class;
                    v2 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v2 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                    }
                    progressManager = (ProgressManager)v2;
                    $i$f$service = false;
                    serviceClass$iv = GithubAccountInformationProvider.class;
                    v3 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v3 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                    }
                    accountInformationProvider = (GithubAccountInformationProvider)v3;
                    $i$f$service = false;
                    serviceClass$iv = GithubGitHelper.class;
                    v4 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v4 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                    }
                    gitHelper = (GithubGitHelper)v4;
                    $i$f$service = false;
                    serviceClass$iv = Git.class;
                    v5 = ApplicationManager.getApplication().getService(serviceClass$iv);
                    if (v5 == null) {
                        throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                    }
                    git = (Git)v5;
                    accountInformationLoader = new Function2<GithubAccount, Component, Pair<? extends Boolean, ? extends Set<? extends String>>>(progressManager, project){
                        @NotNull
                        private final Map<GithubAccount, Pair<Boolean, Set<String>>> loadedInfo;
                        final /* synthetic */ ProgressManager $progressManager;
                        final /* synthetic */ Project $project;
                        {
                            this.$progressManager = $progressManager;
                            this.$project = $project;
                            this.loadedInfo = new LinkedHashMap<K, V>();
                        }

                        @NotNull
                        public Pair<Boolean, Set<String>> invoke(@NotNull GithubAccount account, @NotNull Component comp) throws IOException {
                            Pair<Boolean, Set<String>> pair;
                            Intrinsics.checkNotNullParameter((Object)((Object)account), (String)"account");
                            Intrinsics.checkNotNullParameter((Object)comp, (String)"comp");
                            Map<GithubAccount, Pair<Boolean, Set<String>>> $this$getOrPut$iv = this.loadedInfo;
                            boolean $i$f$getOrPut = false;
                            Pair<Boolean, Set<String>> value$iv = $this$getOrPut$iv.get((Object)((Object)account));
                            if (value$iv == null) {
                                boolean bl = false;
                                Pair<Boolean, Set<String>> answer$iv = this.loadEnsuringTokenExistsToken(account, comp);
                                $this$getOrPut$iv.put(account, answer$iv);
                                pair = answer$iv;
                            } else {
                                pair = value$iv;
                            }
                            return pair;
                        }

                        private final Pair<Boolean, Set<String>> loadEnsuringTokenExistsToken(GithubAccount account, Component comp) {
                            while (true) {
                                try {
                                    Object[] objectArray = new Object[]{account};
                                    Object object = this.$progressManager.runProcessWithProgressSynchronously(() -> shareProjectOnGithub.accountInformationLoader.1.loadEnsuringTokenExistsToken$lambda$2(this.$progressManager, account), GithubBundle.message("share.process.loading.account.info", objectArray), true, this.$project);
                                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"progressManager.runProce\u2026 account), true, project)");
                                    return (Pair)object;
                                }
                                catch (GithubMissingTokenException mte) {
                                    if (GHAccountsUtil.requestNewToken$intellij_vcs_github(account, this.$project, comp) != null) continue;
                                    throw mte;
                                    continue;
                                }
                                break;
                            }
                        }

                        /*
                         * WARNING - void declaration
                         */
                        private static final Pair loadEnsuringTokenExistsToken$lambda$2(ProgressManager $progressManager, GithubAccount $account) {
                            Set set;
                            void $this$mapSmartSet$iv;
                            Intrinsics.checkNotNullParameter((Object)$progressManager, (String)"$progressManager");
                            Intrinsics.checkNotNullParameter((Object)((Object)$account), (String)"$account");
                            String token2 = (String)BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>($account, null){
                                int label;
                                final /* synthetic */ GithubAccount $account;
                                {
                                    this.$account = $account;
                                    super(2, $completion);
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                @Nullable
                                public final Object invokeSuspend(@NotNull Object var1_1) {
                                    var4_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)var1_1);
                                            $i$f$service = false;
                                            serviceClass$iv = GHAccountManager.class;
                                            v0 = ApplicationManager.getApplication().getService(serviceClass$iv);
                                            if (v0 == null) {
                                                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ")");
                                            }
                                            this.label = 1;
                                            v1 = ((GHAccountManager)v0).findCredentials((Account)this.$account, (Continuation)this);
                                            if (v1 == var4_2) {
                                                return var4_2;
                                            }
                                            ** GOTO lbl18
                                        }
                                        case 1: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            v1 = $result;
lbl18:
                                            // 2 sources

                                            v2 = (String)v1;
                                            if (v2 == null) {
                                                throw new GithubMissingTokenException(this.$account);
                                            }
                                            return v2;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                }

                                @Nullable
                                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super String> p2) {
                                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)1, null);
                            GithubApiRequestExecutor requestExecutor = GithubApiRequestExecutor.Factory.Companion.getInstance().create(token2);
                            ProgressIndicator progressIndicator = $progressManager.getProgressIndicator();
                            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator, (String)"progressManager.progressIndicator");
                            GithubAuthenticatedUser user = requestExecutor.execute(progressIndicator, GithubApiRequests.CurrentUser.get($account.getServer()));
                            ProgressIndicator progressIndicator2 = $progressManager.getProgressIndicator();
                            Intrinsics.checkNotNullExpressionValue((Object)progressIndicator2, (String)"progressManager.progressIndicator");
                            Collection collection = GithubApiPagesLoader.loadAll(requestExecutor, progressIndicator2, GithubApiRequests.CurrentUser.Repos.pages$default($account.getServer(), Type.OWNER, null, null, null, 28, null));
                            boolean $i$f$mapSmartSet = false;
                            int size$iv = $this$mapSmartSet$iv.size();
                            switch (size$iv) {
                                case 1: {
                                    GithubRepo it = (GithubRepo)CollectionsKt.first((Iterable)((Iterable)$this$mapSmartSet$iv));
                                    boolean bl = false;
                                    set = Collections.singleton(it.getName());
                                    break;
                                }
                                case 0: {
                                    set = SetsKt.emptySet();
                                    break;
                                }
                                default: {
                                    void $this$mapTo$iv$iv;
                                    Iterable iterable = (Iterable)$this$mapSmartSet$iv;
                                    Collection destination$iv$iv = new HashSet<E>(size$iv);
                                    boolean $i$f$mapTo = false;
                                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                                        void it;
                                        GithubRepo githubRepo = (GithubRepo)item$iv$iv;
                                        Collection collection2 = destination$iv$iv;
                                        boolean bl = false;
                                        collection2.add(it.getName());
                                    }
                                    set = (Set)destination$iv$iv;
                                }
                            }
                            Set names = set;
                            return TuplesKt.to((Object)user.canCreatePrivateRepo(), (Object)names);
                        }
                    };
                    v6 = project;
                    v7 /* !! */  = gitRepository;
                    if (v7 /* !! */  == null || (v7 /* !! */  = v7 /* !! */ .getRemotes()) == null) break block16;
                    it = (Iterable)v7 /* !! */ ;
                    var23_34 = v6;
                    $i$f$map = false;
                    var15_35 = $this$map$iv;
                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    $i$f$mapTo = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        var20_40 = (GitRemote)item$iv$iv;
                        var24_42 = destination$iv$iv;
                        $i$a$-map-GithubShareAction$Companion$shareProjectOnGithub$shareDialog$1 = false;
                        var24_42.add(it.getName());
                    }
                    v6 = var23_34;
                    v7 /* !! */  = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                    if (v7 /* !! */  != null) break block17;
                }
                v7 /* !! */  = SetsKt.emptySet();
            }
            var25_43 = (Function2)accountInformationLoader;
            var26_44 /* !! */  = v7 /* !! */ ;
            var27_45 = v6;
            shareDialog = new GithubShareDialog(var27_45, (Set<String>)var26_44 /* !! */ , (Function2<? super GithubAccount, ? super Component, ? extends Pair<Boolean, ? extends Set<String>>>)var25_43);
            DialogManager.show((DialogWrapper)shareDialog);
            if (!shareDialog.isOK()) {
                return;
            }
            name = shareDialog.getRepositoryName();
            isPrivate = shareDialog.isPrivate();
            remoteName = shareDialog.getRemoteName();
            description = shareDialog.getDescription();
            v8 = shareDialog.getAccount();
            Intrinsics.checkNotNull((Object)v8);
            account = v8;
            var16_36 = GithubBundle.message("share.process", new Object[0]);
            new Task.Backgroundable(project, account, name, description, isPrivate, gitRepository, accountInformationProvider, gitHelper, git, remoteName, var16_36){
                private String url;
                final /* synthetic */ Project $project;
                final /* synthetic */ GithubAccount $account;
                final /* synthetic */ String $name;
                final /* synthetic */ String $description;
                final /* synthetic */ boolean $isPrivate;
                final /* synthetic */ GitRepository $gitRepository;
                final /* synthetic */ GithubAccountInformationProvider $accountInformationProvider;
                final /* synthetic */ GithubGitHelper $gitHelper;
                final /* synthetic */ Git $git;
                final /* synthetic */ String $remoteName;
                {
                    this.$project = $project;
                    this.$account = $account;
                    this.$name = $name;
                    this.$description = $description;
                    this.$isPrivate = $isPrivate;
                    this.$gitRepository = $gitRepository;
                    this.$accountInformationProvider = $accountInformationProvider;
                    this.$gitHelper = $gitHelper;
                    this.$git = $git;
                    this.$remoteName = $remoteName;
                    super($project, $super_call_param$1);
                }

                public void run(@NotNull ProgressIndicator indicator) {
                    Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                    String string = GHCompatibilityUtil.getOrRequestToken(this.$account, this.$project);
                    if (string == null) {
                        return;
                    }
                    String token2 = string;
                    GithubApiRequestExecutor requestExecutor = GithubApiRequestExecutor.Factory.Companion.getInstance().create(token2);
                    GithubShareAction.access$getLOG$cp().info("Creating GitHub repository");
                    indicator.setText(GithubBundle.message("share.process.creating.repository", new Object[0]));
                    String string2 = ((GithubRepo)requestExecutor.execute(indicator, GithubApiRequests.CurrentUser.Repos.create$default(this.$account.getServer(), this.$name, this.$description, this.$isPrivate, null, 16, null))).getHtmlUrl();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"requestExecutor\n        \u2026tion, isPrivate)).htmlUrl");
                    this.url = string2;
                    GithubShareAction.access$getLOG$cp().info("Successfully created GitHub repository");
                    GitRepository gitRepository = this.$gitRepository;
                    if (gitRepository == null || (gitRepository = gitRepository.getRoot()) == null) {
                        gitRepository = this.$project.getBaseDir();
                    }
                    GitRepository root = gitRepository;
                    GithubShareAction.access$getLOG$cp().info("Binding local project with GitHub");
                    if (this.$gitRepository == null) {
                        GithubShareAction.access$getLOG$cp().info("No git detected, creating empty git repo");
                        indicator.setText(GithubBundle.message("share.process.creating.git.repository", new Object[0]));
                        Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                        if (!this.createEmptyGitRepository(this.$project, (VirtualFile)root)) {
                            return;
                        }
                    }
                    GitRepositoryManager gitRepositoryManager = GitUtil.getRepositoryManager((Project)this.$project);
                    Intrinsics.checkNotNullExpressionValue((Object)gitRepositoryManager, (String)"getRepositoryManager(project)");
                    GitRepositoryManager repositoryManager = gitRepositoryManager;
                    GitRepository repository = (GitRepository)repositoryManager.getRepositoryForRoot((VirtualFile)root);
                    if (repository == null) {
                        GithubNotifications.showError(this.$project, "github.share.cannot.find.git.repo", GithubBundle.message("share.error.failed.to.create.repo", new Object[0]), GithubBundle.message("cannot.find.git.repo", new Object[0]));
                        return;
                    }
                    indicator.setText(GithubBundle.message("share.process.retrieving.username", new Object[0]));
                    String string3 = this.$accountInformationProvider.getInformation(requestExecutor, indicator, this.$account).getLogin();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"accountInformationProvid\u2026indicator, account).login");
                    String username = string3;
                    String remoteUrl = this.$gitHelper.getRemoteUrl(this.$account.getServer(), username, this.$name);
                    GithubShareAction.access$getLOG$cp().info("Adding GitHub as a remote host");
                    indicator.setText(GithubBundle.message("share.process.adding.gh.as.remote.host", new Object[0]));
                    this.$git.addRemote(repository, this.$remoteName, remoteUrl).throwOnError(new int[0]);
                    repository.update();
                    Intrinsics.checkNotNullExpressionValue((Object)root, (String)"root");
                    String string4 = this.url;
                    if (string4 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                        string4 = null;
                    }
                    if (!this.performFirstCommitIfRequired(this.$project, (VirtualFile)root, repository, indicator, this.$name, string4)) {
                        return;
                    }
                    GithubShareAction.access$getLOG$cp().info("Pushing to github master");
                    indicator.setText(GithubBundle.message("share.process.pushing.to.github.master", new Object[0]));
                    String string5 = this.url;
                    if (string5 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                        string5 = null;
                    }
                    if (!this.pushCurrentBranch(this.$project, repository, this.$remoteName, remoteUrl, this.$name, string5)) {
                        return;
                    }
                    String string6 = GithubBundle.message("share.process.successfully.shared", new Object[0]);
                    String string7 = this.url;
                    if (string7 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                        string7 = null;
                    }
                    GithubNotifications.showInfoURL(this.$project, "github.share.project.successfully.shared", string6, this.$name, string7);
                }

                private final boolean createEmptyGitRepository(Project project, VirtualFile root) {
                    GitCommandResult gitCommandResult = Git.getInstance().init(project, root, new GitLineHandlerListener[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"getInstance().init(project, root)");
                    GitCommandResult result = gitCommandResult;
                    if (!result.success()) {
                        VcsNotifier.getInstance((Project)project).notifyError("github.git.repo.init.error", GitBundle.message((String)"initializing.title", (Object[])new Object[0]), result.getErrorOutputAsHtmlString());
                        GithubShareAction.access$getLOG$cp().info("Failed to create empty git repo: " + result.getErrorOutputAsJoinedString());
                        return false;
                    }
                    GitInit.refreshAndConfigureVcsMappings((Project)project, (VirtualFile)root, (String)root.getPath());
                    GitUtil.generateGitignoreFileIfNeeded((Project)project, (VirtualFile)root);
                    return true;
                }

                /*
                 * WARNING - void declaration
                 */
                private final boolean performFirstCommitIfRequired(Project project, VirtualFile root, GitRepository repository, ProgressIndicator indicator, String name, String url) {
                    if (!repository.isFresh()) {
                        return true;
                    }
                    GithubShareAction.access$getLOG$cp().info("Trying to commit");
                    try {
                        void $this$mapNotNullTo$iv$iv;
                        void $this$mapNotNull$iv;
                        GithubShareAction.access$getLOG$cp().info("Adding files for commit");
                        indicator.setText(GithubBundle.message("share.process.adding.files", new Object[0]));
                        List list = ChangeListManager.getInstance((Project)project).getAffectedFiles();
                        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstance(project).affectedFiles");
                        List trackedFiles = list;
                        Collection collection = repository.getUntrackedFilesHolder().retrieveUntrackedFilePaths();
                        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"repository.untrackedFile\u2026rieveUntrackedFilePaths()");
                        Iterable iterable = collection;
                        Project project2 = project;
                        var var24_11 = this;
                        boolean $i$f$mapNotNull = false;
                        void var11_14 = $this$mapNotNull$iv;
                        Collection destination$iv$iv = new ArrayList<E>();
                        boolean $i$f$mapNotNullTo = false;
                        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                        boolean $i$f$forEach = false;
                        String[] stringArray = $this$forEach$iv$iv$iv.iterator();
                        while (stringArray.hasNext()) {
                            VirtualFile it$iv$iv;
                            T element$iv$iv$iv;
                            T element$iv$iv = element$iv$iv$iv = stringArray.next();
                            boolean bl = false;
                            FilePath p0 = (FilePath)element$iv$iv;
                            boolean bl2 = false;
                            if (p0.getVirtualFile() == null) continue;
                            boolean bl3 = false;
                            destination$iv$iv.add(it$iv$iv);
                        }
                        List list2 = (List)destination$iv$iv;
                        Collection<VirtualFile> untrackedFiles = var24_11.filterOutIgnored(project2, list2);
                        trackedFiles.removeAll(untrackedFiles);
                        ArrayList<VirtualFile> allFiles = new ArrayList<VirtualFile>();
                        allFiles.addAll(trackedFiles);
                        allFiles.addAll(untrackedFiles);
                        GithubUntrackedFilesDialog dialog2 = (GithubUntrackedFilesDialog)((Object)ActionsKt.invokeAndWaitIfNeeded((ModalityState)indicator.getModalityState(), (Function0)((Function0)new Function0<GithubUntrackedFilesDialog>(project, allFiles, (List<VirtualFile>)trackedFiles){
                            final /* synthetic */ Project $project;
                            final /* synthetic */ ArrayList<VirtualFile> $allFiles;
                            final /* synthetic */ List<VirtualFile> $trackedFiles;
                            {
                                this.$project = $project;
                                this.$allFiles = $allFiles;
                                this.$trackedFiles = $trackedFiles;
                                super(0);
                            }

                            @NotNull
                            public final GithubUntrackedFilesDialog invoke() {
                                GithubUntrackedFilesDialog githubUntrackedFilesDialog = new GithubUntrackedFilesDialog(this.$project, (List<? extends VirtualFile>)this.$allFiles);
                                List<VirtualFile> list = this.$trackedFiles;
                                GithubUntrackedFilesDialog $this$invoke_u24lambda_u240 = githubUntrackedFilesDialog;
                                boolean bl = false;
                                if (!list.isEmpty()) {
                                    $this$invoke_u24lambda_u240.setSelectedFiles(list);
                                }
                                DialogManager.show((DialogWrapper)((DialogWrapper)$this$invoke_u24lambda_u240));
                                return githubUntrackedFilesDialog;
                            }
                        })));
                        Collection files2commit = dialog2.getSelectedFiles();
                        if (!dialog2.isOK() || files2commit.isEmpty()) {
                            GithubNotifications.showInfoURL(project, "github.share.empty.repo.created", GithubBundle.message("share.process.empty.project.created", new Object[0]), name, url);
                            return false;
                        }
                        Collection collection2 = ContainerUtil.intersection(untrackedFiles, (Collection)files2commit);
                        Intrinsics.checkNotNullExpressionValue((Object)collection2, (String)"intersection(untrackedFiles, files2commit)");
                        Collection files2add = collection2;
                        Collection collection3 = ContainerUtil.subtract((Collection)trackedFiles, (Collection)files2commit);
                        Intrinsics.checkNotNullExpressionValue((Object)collection3, (String)"subtract(trackedFiles, files2commit)");
                        Collection files2rm = collection3;
                        HashSet<E> modified = new HashSet<E>(trackedFiles);
                        modified.addAll(files2commit);
                        GitFileUtils.addFiles((Project)project, (VirtualFile)root, (Collection)files2add);
                        GitFileUtils.deleteFilesFromCache((Project)project, (VirtualFile)root, (Collection)files2rm);
                        GithubShareAction.access$getLOG$cp().info("Performing commit");
                        indicator.setText(GithubBundle.message("share.process.performing.commit", new Object[0]));
                        GitLineHandler handler = new GitLineHandler(project, root, GitCommand.COMMIT);
                        handler.setStdoutSuppressed(false);
                        stringArray = new String[]{"-m", dialog2.getCommitMessage()};
                        handler.addParameters(stringArray);
                        handler.endOptions();
                        Git.getInstance().runCommand(handler).throwOnError(new int[0]);
                        VcsFileUtil.markFilesDirty((Project)project, (Collection)modified);
                    }
                    catch (VcsException e) {
                        GithubShareAction.access$getLOG$cp().warn((Throwable)e);
                        GithubNotifications.showErrorURL(project, "github.share.project.created.init.commit.failed", GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.init.commit.failed", new Object[0]) + GithubUtil.getErrorTextFromException(e), url);
                        return false;
                    }
                    GithubShareAction.access$getLOG$cp().info("Successfully created initial commit");
                    return true;
                }

                private final Collection<VirtualFile> filterOutIgnored(Project project, Collection<? extends VirtualFile> files) {
                    ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
                    Intrinsics.checkNotNullExpressionValue((Object)changeListManager, (String)"getInstance(project)");
                    ChangeListManager changeListManager2 = changeListManager;
                    ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
                    List list = ContainerUtil.filter(files, arg_0 -> shareProjectOnGithub.1.filterOutIgnored$lambda$0((Function1)new Function1<VirtualFile, Boolean>(changeListManager2, vcsManager){
                        final /* synthetic */ ChangeListManager $changeListManager;
                        final /* synthetic */ ProjectLevelVcsManager $vcsManager;
                        {
                            this.$changeListManager = $changeListManager;
                            this.$vcsManager = $vcsManager;
                            super(1);
                        }

                        @NotNull
                        public final Boolean invoke(VirtualFile file) {
                            return !this.$changeListManager.isIgnoredFile(file) && !this.$vcsManager.isIgnored(file);
                        }
                    }, arg_0));
                    Intrinsics.checkNotNullExpressionValue((Object)list, (String)"changeListManager = Chan\u2026Manager.isIgnored(file) }");
                    return list;
                }

                private final boolean pushCurrentBranch(Project project, GitRepository repository, String remoteName, String remoteUrl, String name, String url) {
                    GitLocalBranch currentBranch = repository.getCurrentBranch();
                    if (currentBranch == null) {
                        GithubNotifications.showErrorURL(project, "github.share.init.push.failed", GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.push.no.current.branch", new Object[0]), url);
                        return false;
                    }
                    GitCommandResult gitCommandResult = this.$git.push(repository, remoteName, remoteUrl, currentBranch.getName(), true, new GitLineHandlerListener[0]);
                    Intrinsics.checkNotNullExpressionValue((Object)gitCommandResult, (String)"git.push(repository, rem\u2026currentBranch.name, true)");
                    GitCommandResult result = gitCommandResult;
                    if (!result.success()) {
                        Object[] objectArray = new Object[]{result.getErrorOutputAsHtmlString()};
                        GithubNotifications.showErrorURL(project, "github.share.init.push.failed", GithubBundle.message("share.error.cannot.finish", new Object[0]), GithubBundle.message("share.error.created.project", new Object[0]), " '" + name + "' ", GithubBundle.message("share.error.push.failed", objectArray), url);
                        return false;
                    }
                    return true;
                }

                public void onThrowable(@NotNull Throwable error) {
                    Intrinsics.checkNotNullParameter((Object)error, (String)"error");
                    GithubNotifications.showError(this.$project, "github.share.cannot.create.repo", GithubBundle.message("share.error.failed.to.create.repo", new Object[0]), error);
                }

                private static final boolean filterOutIgnored$lambda$0(Function1 $tmp0, Object p0) {
                    Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
                    return (Boolean)$tmp0.invoke(p0);
                }
            }.queue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\b\u001a\u00020\tH\u0014R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$GithubExistingRemotesDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "remotes", "", "", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "createCenterPanel", "Ljavax/swing/JComponent;", "intellij.vcs.github"})
    @TestOnly
    public static final class GithubExistingRemotesDialog
    extends DialogWrapper {
        @NotNull
        private final List<String> remotes;

        public GithubExistingRemotesDialog(@NotNull Project project, @NotNull List<String> remotes) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter(remotes, (String)"remotes");
            super(project);
            this.remotes = remotes;
            this.setTitle(GithubBundle.message("share.error.project.is.on.github", new Object[0]));
            this.setOKButtonText(GithubBundle.message("share.anyway.button", new Object[0]));
            this.init();
        }

        @NotNull
        protected JComponent createCenterPanel() {
            BorderLayoutPanel borderLayoutPanel;
            Container container;
            JBLabel mainText = new JBLabel(this.remotes.size() == 1 ? GithubBundle.message("share.action.remote.is.on.github", new Object[0]) : GithubBundle.message("share.action.remotes.are.on.github", new Object[0]));
            JPanel jPanel = new JPanel();
            JPanel $this$createCenterPanel_u24lambda_u240 = jPanel;
            boolean bl = false;
            $this$createCenterPanel_u24lambda_u240.setLayout(new BoxLayout($this$createCenterPanel_u24lambda_u240, 1));
            JPanel remotesPanel = jPanel;
            for (String remote : this.remotes) {
                remotesPanel.add((Component)new BrowserLink(remote, remote));
            }
            BorderLayoutPanel borderLayoutPanel2 = JBUI.Panels.simplePanel((int)10, (int)4).addToTop((Component)mainText).addToCenter((Component)remotesPanel);
            Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel2, (String)"simplePanel(UIUtil.DEFAU\u2026addToCenter(remotesPanel)");
            BorderLayoutPanel messagesPanel = borderLayoutPanel2;
            Container $this$createCenterPanel_u24lambda_u241 = container = new Container();
            boolean bl2 = false;
            $this$createCenterPanel_u24lambda_u241.setLayout(new BorderLayout());
            $this$createCenterPanel_u24lambda_u241.add((Component)new JLabel(Messages.getQuestionIcon()), "North");
            Container iconContainer = container;
            BorderLayoutPanel $this$createCenterPanel_u24lambda_u242 = borderLayoutPanel = JBUI.Panels.simplePanel((int)10, (int)4).addToCenter((Component)messagesPanel).addToLeft((Component)iconContainer);
            boolean bl3 = false;
            $this$createCenterPanel_u24lambda_u242.setBorder((Border)JBUI.Borders.emptyBottom((int)12));
            BorderLayoutPanel borderLayoutPanel3 = borderLayoutPanel;
            Intrinsics.checkNotNullExpressionValue((Object)borderLayoutPanel3, (String)"simplePanel(UIUtil.DEFAU\u2026ttom(UIUtil.LARGE_VGAP) }");
            return (JComponent)borderLayoutPanel3;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002B\u001b\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0002\u0010\bJ\b\u0010\u000f\u001a\u00020\u0010H\u0014J\n\u0010\u0011\u001a\u0004\u0018\u00010\u0010H\u0014J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0001\u0010\u0014\u001a\u00020\nH\u0016J\b\u0010\u0015\u001a\u00020\nH\u0014R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/plugins/github/GithubShareAction$GithubUntrackedFilesDialog;", "Lcom/intellij/openapi/vcs/changes/ui/SelectFilesDialog;", "Lcom/intellij/openapi/actionSystem/DataProvider;", "myProject", "Lcom/intellij/openapi/project/Project;", "untrackedFiles", "", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "commitMessage", "", "getCommitMessage", "()Ljava/lang/String;", "myCommitMessagePanel", "Lcom/intellij/openapi/vcs/ui/CommitMessage;", "createCenterPanel", "Ljavax/swing/JComponent;", "createNorthPanel", "getData", "", "dataId", "getDimensionServiceKey", "intellij.vcs.github"})
    @TestOnly
    public static final class GithubUntrackedFilesDialog
    extends SelectFilesDialog
    implements DataProvider {
        @NotNull
        private final Project myProject;
        @Nullable
        private CommitMessage myCommitMessagePanel;

        public GithubUntrackedFilesDialog(@NotNull Project myProject, @NotNull List<? extends VirtualFile> untrackedFiles) {
            Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
            Intrinsics.checkNotNullParameter(untrackedFiles, (String)"untrackedFiles");
            super(myProject, untrackedFiles, null, null, true, false);
            this.myProject = myProject;
            this.setTitle(GithubBundle.message("untracked.files.dialog.title", new Object[0]));
            this.setOKButtonText(CommonBundle.getAddButtonText());
            this.setCancelButtonText(CommonBundle.getCancelButtonText());
            this.init();
        }

        @NotNull
        public final String getCommitMessage() {
            CommitMessage commitMessage = this.myCommitMessagePanel;
            Intrinsics.checkNotNull((Object)commitMessage);
            String string = commitMessage.getComment();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"myCommitMessagePanel!!.comment");
            return string;
        }

        @Nullable
        protected JComponent createNorthPanel() {
            return null;
        }

        @NotNull
        protected JComponent createCenterPanel() {
            JComponent tree2 = super.createCenterPanel();
            CommitMessage commitMessage = new CommitMessage(this.myProject);
            Disposer.register((Disposable)this.getDisposable(), (Disposable)((Disposable)commitMessage));
            commitMessage.setCommitMessage("Initial commit");
            this.myCommitMessagePanel = commitMessage;
            Splitter splitter = new Splitter(true);
            splitter.setHonorComponentsMinimumSize(true);
            splitter.setFirstComponent(tree2);
            splitter.setSecondComponent((JComponent)this.myCommitMessagePanel);
            splitter.setProportion(0.7f);
            return (JComponent)splitter;
        }

        @Nullable
        public Object getData(@NonNls @NotNull String dataId) {
            Intrinsics.checkNotNullParameter((Object)dataId, (String)"dataId");
            return VcsDataKeys.COMMIT_MESSAGE_CONTROL.is(dataId) ? this.myCommitMessagePanel : null;
        }

        @NotNull
        protected String getDimensionServiceKey() {
            return "Github.UntrackedFilesDialog";
        }
    }
}

