/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.github;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.io.URLUtil;
import git4idea.repo.GitRepository;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.github.api.GHRepositoryCoordinates;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ(\u0010\r\u001a\u00020\u00042\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/plugins/github/GHPathUtil;", "", "()V", "getFileURL", "", "repository", "Lgit4idea/repo/GitRepository;", "path", "Lorg/jetbrains/plugins/github/api/GHRepositoryCoordinates;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "editor", "Lcom/intellij/openapi/editor/Editor;", "makeUrlToOpen", "relativePath", "branch", "intellij.vcs.github"})
public final class GHPathUtil {
    @NotNull
    public static final GHPathUtil INSTANCE = new GHPathUtil();

    private GHPathUtil() {
    }

    @Nullable
    public final String getFileURL(@NotNull GitRepository repository, @NotNull GHRepositoryCoordinates path, @NotNull VirtualFile virtualFile, @Nullable Editor editor) {
        Intrinsics.checkNotNullParameter((Object)repository, (String)"repository");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)virtualFile, (String)"virtualFile");
        String relativePath = VfsUtilCore.getRelativePath((VirtualFile)virtualFile, (VirtualFile)repository.getRoot());
        if (relativePath == null) {
            return null;
        }
        String hash = repository.getCurrentRevision();
        if (hash == null) {
            return null;
        }
        return this.makeUrlToOpen(editor, relativePath, hash, path);
    }

    @NotNull
    public final String makeUrlToOpen(@Nullable Editor editor, @NotNull String relativePath, @NotNull String branch, @NotNull GHRepositoryCoordinates path) {
        Intrinsics.checkNotNullParameter((Object)relativePath, (String)"relativePath");
        Intrinsics.checkNotNullParameter((Object)branch, (String)"branch");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        StringBuilder builder = new StringBuilder();
        if (StringUtil.isEmptyOrSpaces((String)relativePath)) {
            builder.append(path.toUrl()).append("/tree/").append(branch);
        } else {
            builder.append(path.toUrl()).append("/blob/").append(branch).append('/').append(URLUtil.encodePath((String)relativePath));
        }
        if (editor != null && editor.getDocument().getLineCount() >= 1) {
            SelectionModel selectionModel = editor.getSelectionModel();
            Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
            SelectionModel selectionModel2 = selectionModel;
            int begin = editor.getDocument().getLineNumber(selectionModel2.getSelectionStart()) + 1;
            int selectionEnd = selectionModel2.getSelectionEnd();
            int end = editor.getDocument().getLineNumber(selectionEnd) + 1;
            if (editor.getDocument().getLineStartOffset(end - 1) == selectionEnd) {
                --end;
            }
            builder.append("#L").append(begin);
            if (begin != end) {
                builder.append("-L").append(end);
            }
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }
}

