/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.aether;

import java.util.EnumSet;
import org.jetbrains.annotations.NotNull;

public enum ArtifactKind {
    ARTIFACT("", "jar"),
    SOURCES("sources", "jar"),
    JAVADOC("javadoc", "jar"),
    ANNOTATIONS("annotations", "zip"),
    AAR_ARTIFACT("", "aar"),
    POM("", "pom"),
    ALL("all", "jar"),
    HTTP("http", "jar");

    private final String myClassifier;
    private final String myExtension;

    private ArtifactKind(String classifier, String extension) {
        this.myClassifier = classifier;
        this.myExtension = extension;
    }

    @NotNull
    public String getClassifier() {
        return this.myClassifier;
    }

    @NotNull
    public String getExtension() {
        return this.myExtension;
    }

    public static ArtifactKind find(String classifier, String extension) {
        for (ArtifactKind kind : ArtifactKind.values()) {
            if (!kind.getClassifier().equals(classifier) || !kind.getExtension().equals(extension)) continue;
            return kind;
        }
        return null;
    }

    public static EnumSet<ArtifactKind> kindsOf(boolean sources, boolean javadoc, String ... artifactPackaging) {
        EnumSet<ArtifactKind> result = EnumSet.noneOf(ArtifactKind.class);
        if (sources) {
            result.add(SOURCES);
        }
        if (javadoc) {
            result.add(JAVADOC);
        }
        if (artifactPackaging.length == 0 || artifactPackaging.length == 1 && artifactPackaging[0] == null) {
            result.add(ARTIFACT);
        } else {
            for (String packaging : artifactPackaging) {
                ArtifactKind artifact = ArtifactKind.find(ARTIFACT.getClassifier(), packaging);
                if (artifact == null) continue;
                result.add(artifact);
            }
        }
        return result;
    }
}

