/*
 * Decompiled with CFR 0.152.
 */
package com.google.appindexing.fetchasgoogle;

import com.android.tools.idea.gradle.project.build.invoker.AssembleInvocationResult;
import com.android.tools.idea.gradle.project.build.invoker.GradleBuildInvoker;
import com.android.tools.idea.gradle.project.build.invoker.TestCompileType;
import com.android.tools.idea.model.AndroidModel;
import com.android.tools.idea.projectsystem.gradle.GradleProjectSystemKt;
import com.android.tools.idea.run.ApkFileUnit;
import com.android.tools.idea.run.ApkInfo;
import com.google.api.services.fetchasgoogle_pa.model.ApkHolder;
import com.google.api.services.fetchasgoogle_pa.model.FetchResponse;
import com.google.appindexing.editor.AppIndexingVirtualFile;
import com.google.appindexing.fetchasgoogle.FetchAsGoogleClient;
import com.google.appindexing.fetchasgoogle.UploadedApkManager;
import com.google.appindexing.util.AppIndexingBundle;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FetchAsGoogleTask
implements Runnable {
    private static final Logger logger = Logger.getInstance(FetchAsGoogleTask.class);
    private final boolean myBuildApkToRun;
    private final RequestType myRequestType;
    private Status myStatus = Status.NOT_STARTED;
    private ErrorCode myErrorCode;
    private Project myProject;
    private String myDeepLink;
    private AppIndexingVirtualFile myVirtualFile;
    private FetchAsGoogleClient myFetchAsGoogleClient;
    private ApkHolder myApkHolder;
    private FetchResponse myFetchResponse;
    private Date myCreatedTime;
    private UploadedApkManager myUploadedApkManager;
    private Helper myHelper;
    private String myPackageId;

    @Nullable
    public String getPackageId() {
        return this.myPackageId;
    }

    @NotNull
    public RequestType getRequestType() {
        return this.myRequestType;
    }

    public static FetchAsGoogleTask createFetchAsGoogleTask(@NotNull Project project, @NotNull Module module, @NotNull String deepLink, boolean buildApk, @NotNull RequestType type) throws FetchAsGoogleClient.FetchAsGoogleException {
        return new FetchAsGoogleTask(project, deepLink, FetchAsGoogleClient.createInstance(), UploadedApkManager.INSTANCE, new Helper(project, module), buildApk, type);
    }

    FetchAsGoogleTask(@NotNull Project project, @NotNull String deepLink, @NotNull FetchAsGoogleClient fetchAsGoogleClient, @NotNull UploadedApkManager uploadedApkManager, @NotNull Helper helper, boolean buildApk, @NotNull RequestType type) {
        this.myProject = project;
        this.myDeepLink = deepLink;
        this.myCreatedTime = new Date();
        this.myFetchAsGoogleClient = fetchAsGoogleClient;
        this.myUploadedApkManager = uploadedApkManager;
        this.myHelper = helper;
        this.myBuildApkToRun = buildApk;
        this.myRequestType = type;
    }

    @NotNull
    public Status getStatus() {
        return this.myStatus;
    }

    @NotNull
    public Module getModule() {
        return this.myHelper.myModule;
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    @Nullable
    public ErrorCode getErrorCode() {
        return this.myErrorCode;
    }

    @NotNull
    public Date getCreatedTime() {
        return this.myCreatedTime;
    }

    @Nullable
    public FetchResponse getFetchResponse() {
        return this.myFetchResponse;
    }

    private void changeStatus(@NotNull Status newStatus) {
        this.changeStatus(newStatus, null);
    }

    private void changeStatus(@NotNull Status newStatus, @Nullable ErrorCode errorCode) {
        this.myStatus = newStatus;
        if (errorCode != null) {
            this.myErrorCode = errorCode;
        }
        Logger.getInstance(FetchAsGoogleTask.class).warn(newStatus.toString());
        ApplicationManager.getApplication().invokeAndWait(() -> this.myVirtualFile.fireContentChange(), ModalityState.any());
    }

    @Override
    public void run() {
        this.myVirtualFile = new AppIndexingVirtualFile(this.myDeepLink, this);
        ApplicationManager.getApplication().invokeAndWait(() -> {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myProject);
            fileEditorManager.openFile((VirtualFile)this.myVirtualFile, true);
        }, ModalityState.any());
        try {
            if (RequestType.PERSONAL_CONTENT_INDEXING_DEBUGGING == this.myRequestType || RequestType.USER_ACTION_LOGGING_DEBUGGING == this.myRequestType) {
                this.changeStatus(Status.FETCHING_RESULT);
                this.myPackageId = this.myHelper.getPackageId();
                if (this.myPackageId != null) {
                    this.myFetchResponse = this.myFetchAsGoogleClient.getAppIndexingErrorStats(this.myPackageId, this.myRequestType);
                    this.changeStatus(Status.SUCCESS, ErrorCode.valueOf(this.myFetchResponse.getStatus()));
                } else {
                    this.changeStatus(Status.FAIL, ErrorCode.EMPTY_PACKAGE_ID);
                }
                return;
            }
            if (this.myBuildApkToRun) {
                this.changeStatus(Status.BUILDING_APK);
                if (!this.myHelper.buildApk()) {
                    this.changeStatus(Status.FAIL, ErrorCode.BUILD_APK_FAILED);
                    return;
                }
                this.changeStatus(Status.UPLOADING_APK);
                if (!this.uploadApkIfNeeded()) {
                    this.changeStatus(Status.FAIL, ErrorCode.UPLOAD_APK_FAILED);
                    return;
                }
                this.changeStatus(Status.FETCHING_RESULT);
                this.myPackageId = this.myApkHolder.getApk().getPackageId();
                this.myFetchResponse = this.myFetchAsGoogleClient.fetchAsGoogle(this.myDeepLink, this.myPackageId, this.myApkHolder.getApk().getApkId(), RequestType.APP_INDEXING);
            } else {
                this.changeStatus(Status.FETCHING_RESULT);
                this.myPackageId = this.myHelper.getPackageId();
                if (StringUtil.isNotEmpty((String)this.myPackageId)) {
                    this.myFetchResponse = this.myFetchAsGoogleClient.fetchAsGoogle(this.myDeepLink, this.myPackageId, null, this.myRequestType);
                    Logger.getInstance(FetchAsGoogleTask.class).warn(this.myFetchResponse.getStatus());
                } else {
                    this.changeStatus(Status.FAIL, ErrorCode.FETCH_RESULT_FAILED);
                    return;
                }
            }
            this.changeStatus(Status.SUCCESS);
        }
        catch (FetchAsGoogleClient.FetchAsGoogleException e) {
            this.changeStatus(Status.FAIL, e.getErrorCode());
            logger.warn((Throwable)e);
        }
        catch (IOException ex) {
            this.changeStatus(Status.FAIL, ErrorCode.NETWORK_ERROR);
            logger.warn((Throwable)ex);
        }
        catch (Exception exx) {
            this.changeStatus(Status.FAIL, ErrorCode.UNKNOWN);
            logger.warn((Throwable)exx);
        }
    }

    private boolean uploadApkIfNeeded() throws FetchAsGoogleClient.FetchAsGoogleException, IOException {
        File apkFile = this.myHelper.getApkFile();
        if (apkFile == null || !apkFile.exists()) {
            return false;
        }
        String packageId = this.myHelper.getPackageId();
        if (packageId == null || packageId.isEmpty()) {
            return false;
        }
        byte[] apkHash = this.myUploadedApkManager.hashApk(apkFile);
        if (apkHash == null) {
            logger.warn("Couldn't get apk file hash");
            return false;
        }
        this.myApkHolder = this.myUploadedApkManager.getApkHolder(apkHash);
        if (this.myApkHolder == null) {
            this.myApkHolder = this.myFetchAsGoogleClient.uploadApk(packageId, apkFile);
            this.myUploadedApkManager.addUploadedApk(apkHash, this.myApkHolder);
        }
        return true;
    }

    public static enum RequestType {
        UNKNOWN_PREVIEW_FEATURE,
        APP_INDEXING,
        INSTANT_APP,
        USER_ACTION_LOGGING_DEBUGGING,
        PERSONAL_CONTENT_INDEXING_DEBUGGING;

    }

    static class Helper {
        private Project myProject;
        private Module myModule;
        private static final Logger logger = Logger.getInstance(Helper.class);
        private AssembleInvocationResult myAssembleResult;

        public Helper(@NotNull Project project, @NotNull Module module) {
            this.myProject = project;
            this.myModule = module;
        }

        public boolean buildApk() {
            try {
                AtomicReference errorMsgRef = new AtomicReference();
                GradleBuildInvoker gradleBuildInvoker = GradleBuildInvoker.getInstance((Project)this.myProject);
                ListenableFuture assembleResultFuture = (ListenableFuture)ActionsKt.invokeAndWaitIfNeeded((ModalityState)ModalityState.NON_MODAL, () -> gradleBuildInvoker.assemble(new Module[]{this.myModule}, TestCompileType.ALL));
                this.myAssembleResult = (AssembleInvocationResult)assembleResultFuture.get();
                return this.myAssembleResult.isBuildSuccessful();
            }
            catch (Throwable t) {
                return false;
            }
        }

        @Nullable
        public File getApkFile() {
            List apkInfos;
            AndroidFacet facet = AndroidFacet.getInstance((Module)this.myModule);
            if (facet != null && (apkInfos = GradleProjectSystemKt.getBuiltApksForSelectedVariant((AssembleInvocationResult)this.myAssembleResult, (AndroidFacet)facet, (boolean)false)) != null && apkInfos.size() == 1 && ((ApkInfo)apkInfos.get(0)).getFiles().size() == 1) {
                return ((ApkFileUnit)((ApkInfo)apkInfos.get(0)).getFiles().get(0)).getApkFile();
            }
            return null;
        }

        @Nullable
        public String getPackageId() {
            AtomicReference packageId = new AtomicReference();
            ApplicationManager.getApplication().invokeAndWait(() -> {
                AndroidModel androidModel;
                AndroidFacet androidFacet = AndroidFacet.getInstance((Module)this.myModule);
                if (androidFacet != null && (androidModel = AndroidModel.get((AndroidFacet)androidFacet)) != null) {
                    packageId.set(androidModel.getApplicationId());
                }
            }, ModalityState.any());
            return (String)packageId.get();
        }
    }

    public static enum Status {
        NOT_STARTED,
        BUILDING_APK,
        UPLOADING_APK,
        FETCHING_RESULT,
        SUCCESS,
        FAIL;

    }

    public static enum ErrorCode {
        UNKNOWN,
        BUILD_APK_FAILED,
        UPLOAD_APK_FAILED,
        FETCH_RESULT_FAILED,
        NEED_SIGNIN,
        NETWORK_ERROR,
        URI_NOT_SUPPORTED,
        UNKNOWN_URL,
        UNKNOWN_APP_URI,
        APK_NOT_FOUND,
        BLACKLISTED_URL,
        URL_INDEX_ERROR,
        EMPTY_PACKAGE_ID,
        USER_ACTION_LOGGING_ERROR,
        PERSONAL_CONTENT_INDEXING_ERROR,
        BACKEND_ERROR,
        RESOURCE_EXHAUSTED,
        NOT_FOUND,
        APP_OWNERSHIP_VERIFICATION_FAILED,
        OK;

        private final String message = AppIndexingBundle.message("app.indexing.fetch.as.google.test.error." + this.name(), new Object[0]);

        public String getName() {
            return super.name();
        }

        public String getMessage() {
            return this.message;
        }
    }
}

