/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.externalSystem.model;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExternalSystemException
extends RuntimeException {
    private static final long serialVersionUID = 1L;
    private final String myOriginalReason;
    @NotNull
    private final String[] myQuickFixes;
    private boolean myCauseInitialized;

    public ExternalSystemException() {
        this(null, (Throwable)null, new String[0]);
    }

    public ExternalSystemException(@Nullable String message) {
        this(message, (Throwable)null, new String[0]);
    }

    public ExternalSystemException(@Nullable Throwable cause) {
        this("", cause, new String[0]);
    }

    public ExternalSystemException(@Nullable String message, String ... quickFixes) {
        this(message, (Throwable)null, quickFixes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExternalSystemException(@Nullable String message, @Nullable Throwable cause, String ... quickFixes) {
        super(ExternalSystemException.extractMessage(message, cause));
        this.myQuickFixes = ExternalSystemException.mergeArrays(cause instanceof ExternalSystemException ? ((ExternalSystemException)cause).getQuickFixes() : new String[]{}, quickFixes);
        if (cause == null) {
            this.myOriginalReason = "";
            return;
        }
        StringWriter stringWriter = new StringWriter();
        try (PrintWriter printWriter = new PrintWriter(stringWriter);){
            cause.printStackTrace(printWriter);
        }
        this.myOriginalReason = stringWriter.toString();
    }

    @NotNull
    public String getOriginalReason() {
        return this.myOriginalReason;
    }

    @NotNull
    public String[] getQuickFixes() {
        return this.myQuickFixes;
    }

    @Override
    public void printStackTrace(PrintWriter s) {
        super.printStackTrace(s);
        s.println(this.myOriginalReason);
    }

    @Override
    public void printStackTrace(PrintStream s) {
        super.printStackTrace(s);
        s.println(this.myOriginalReason);
    }

    public synchronized boolean isCauseInitialized() {
        return this.myCauseInitialized;
    }

    @Override
    public synchronized Throwable initCause(Throwable cause) {
        this.myCauseInitialized = true;
        return super.initCause(cause);
    }

    @NotNull
    private static String extractMessage(@Nullable String message, @Nullable Throwable cause) {
        StringBuilder buffer = new StringBuilder();
        if (message != null) {
            buffer.append(message);
        }
        boolean first = true;
        for (Throwable t = cause; t != null; t = t.getCause()) {
            String m = t.getLocalizedMessage();
            if (m == null) continue;
            if (first) {
                first = false;
                if (m.equals(message)) {
                    continue;
                }
            } else if (buffer.length() > 0) {
                buffer.append("\n");
            }
            buffer.append(m);
        }
        return buffer.toString();
    }

    private static String[] mergeArrays(@NotNull String[] a1, @NotNull String[] a2) {
        if (a1.length == 0) {
            return a2;
        }
        if (a2.length == 0) {
            return a1;
        }
        String[] result = new String[a1.length + a2.length];
        System.arraycopy(a1, 0, result, 0, a1.length);
        System.arraycopy(a2, 0, result, a1.length, a2.length);
        return result;
    }
}

