/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.emojipicker.ui;

import com.intellij.ide.ui.AntialiasingType;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.paint.RectanglePainter2D;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ImageLoader;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.StartupUiUtil;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.TextLayout;
import java.io.InputStream;
import java.util.List;
import java.util.Objects;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.plugins.emojipicker.Emoji;
import org.jetbrains.plugins.emojipicker.EmojiCategory;
import org.jetbrains.plugins.emojipicker.EmojiSkinTone;
import org.jetbrains.plugins.emojipicker.messages.EmojiCategoriesBundle;
import org.jetbrains.plugins.emojipicker.messages.EmojipickerBundle;
import org.jetbrains.plugins.emojipicker.service.EmojiService;
import org.jetbrains.plugins.emojipicker.ui.EmojiPicker;
import org.jetbrains.plugins.emojipicker.ui.EmojiPickerStyle;

class EmojiListPanel
extends JBScrollPane {
    private static final Image NO_EMOJI_FOUND_IMAGE = ImageLoader.loadFromStream((InputStream)EmojiListPanel.class.getResourceAsStream("/icons/NoEmojiFound.png"));
    private static final int HORIZONTAL_PADDING = 8;
    private final Dimension myCellSize = new Dimension(JBUIScale.scale((int)40), JBUIScale.scale((int)40));
    private final Dimension myCellGaps = new Dimension(JBUIScale.scale((int)3), JBUIScale.scale((int)3));
    private final Image myNoEmojiFoundImage = ImageLoader.scaleImage((Image)Objects.requireNonNull(NO_EMOJI_FOUND_IMAGE), (int)JBUIScale.scale((int)40));
    private final EmojiPicker myEmojiPicker;
    private final EmojiPickerStyle myStyle;
    private final CategoriesListPanel myCategoriesPanel;
    private final Category mySearchCategoryPanel;
    private UpdatableLayoutPanel myCurrentPanel;
    private int myItemsPerRow = 0;
    private Category myCurrentItemCategory;
    private int myCurrentItemIndex = -1;
    private EmojiSkinTone myCurrentSkinTone = EmojiSkinTone.NO_TONE;

    EmojiListPanel(EmojiPicker emojiPicker, EmojiPickerStyle style, List<EmojiCategory> categories) {
        super(null, 22, 31);
        this.myEmojiPicker = emojiPicker;
        this.myStyle = style;
        this.myCategoriesPanel = new CategoriesListPanel(ContainerUtil.map(categories, x$0 -> new Category((EmojiCategory)x$0)));
        this.mySearchCategoryPanel = new Category(null);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                EmojiListPanel.this.myItemsPerRow = (EmojiListPanel.this.getWidth() - JBUIScale.scale((int)8) * 2 + EmojiListPanel.this.myCellGaps.width) / (EmojiListPanel.this.myCellSize.width + EmojiListPanel.this.myCellGaps.width);
                EmojiListPanel.this.myCurrentPanel.updateLayout(EmojiListPanel.this.getWidth());
                EmojiListPanel.this.setViewportView(EmojiListPanel.this.myCurrentPanel);
            }
        });
        this.getViewport().addChangeListener(e -> {
            if (this.myCurrentPanel == this.myCategoriesPanel) {
                Component topComponent = this.myCategoriesPanel.getComponentAt(this.getViewport().getViewPosition());
                if (topComponent instanceof Category) {
                    emojiPicker.selectCategory(((Category)topComponent).myCategory, false);
                } else {
                    emojiPicker.selectCategory(this.myCategoriesPanel.myCategories.get((int)0).myCategory, false);
                }
            }
        });
        this.setBorder(JBUI.Borders.customLine((Color)this.myStyle.myBorderColor, (int)1, (int)0, (int)0, (int)0));
    }

    void selectCategory(EmojiCategory category) {
        if (this.myCurrentPanel != this.myCategoriesPanel) {
            this.myCurrentPanel = this.myCategoriesPanel;
            this.setViewportView(this.myCurrentPanel);
        }
        if (category == null || category == this.myCategoriesPanel.myCategories.get((int)0).myCategory) {
            this.setCurrentItem(this.myCategoriesPanel.myCategories.get((int)0).myCategory.getEmoji().isEmpty() ? this.myCategoriesPanel.myCategories.get(1) : this.myCategoriesPanel.myCategories.get(0), 0);
            this.myCategoriesPanel.scrollRectToVisible(new Rectangle(0, 0, 1, this.getHeight()));
        } else {
            Category cat = null;
            for (Category c : this.myCategoriesPanel.myCategories) {
                if (c.myCategory != category) continue;
                cat = c;
            }
            if (cat == null) {
                return;
            }
            this.setCurrentItem(cat, 0);
            cat.scrollRectToVisible(new Rectangle(0, 0, 1, this.getHeight()));
        }
    }

    void updateSkinTone(EmojiSkinTone skinTone) {
        this.myCurrentSkinTone = skinTone;
        this.myCurrentPanel.repaint();
        if (this.myCurrentItemCategory != null && this.myCurrentItemIndex >= 0) {
            this.myEmojiPicker.updateEmojiInfo(this.myCurrentItemCategory.myCategory.getEmoji().get(this.myCurrentItemIndex), this.myCurrentSkinTone);
        }
    }

    void updateSearchFilter(@NonNls String text) {
        if (text.isEmpty()) {
            this.myEmojiPicker.selectCategory(this.myCategoriesPanel.myCategories.get((int)0).myCategory, true);
        } else {
            this.myEmojiPicker.selectCategory(null, false);
            this.mySearchCategoryPanel.myCategory = new EmojiCategory(null, EmojiService.getInstance().findEmojiByPrefix(text.strip()));
            this.mySearchCategoryPanel.updateLayout(this.getWidth());
            if (this.mySearchCategoryPanel.myCategory.getEmoji().isEmpty()) {
                this.setCurrentItem(null, -1);
            } else {
                this.setCurrentItem(this.mySearchCategoryPanel, 0);
            }
            this.myCurrentPanel = this.mySearchCategoryPanel;
            this.setViewportView(this.myCurrentPanel);
        }
    }

    void selectCurrentEmoji() {
        if (!this.hasCurrentItem()) {
            return;
        }
        Emoji emoji = this.myCurrentItemCategory.myCategory.getEmoji().get(this.myCurrentItemIndex);
        EmojiService.getInstance().saveRecentlyUsedEmoji(emoji);
        this.myEmojiPicker.selectEmoji(emoji.getTonedValue(this.myCurrentSkinTone));
    }

    void navigate(int dx, int dy) {
        if (this.myCurrentItemIndex < 0) {
            return;
        }
        int y = this.myCurrentItemIndex / this.myItemsPerRow + dy;
        int x = (this.myCurrentItemIndex % this.myItemsPerRow + dx + this.myItemsPerRow) % this.myItemsPerRow;
        int newIndex = this.myItemsPerRow * y + x;
        if (newIndex >= 0 && newIndex < this.myCurrentItemCategory.myCategory.getEmoji().size()) {
            this.setCurrentItem(this.myCurrentItemCategory, newIndex);
        } else {
            int cat = this.myCategoriesPanel.findCategoryIndex(this.myCurrentItemCategory);
            if (cat == -1) {
                return;
            }
            boolean up = newIndex < 0;
            if ((cat += up ? -1 : 1) < 0 || cat >= this.myCategoriesPanel.myCategories.size()) {
                return;
            }
            Category c = this.myCategoriesPanel.myCategories.get(cat);
            int rows = (c.myCategory.getEmoji().size() + this.myItemsPerRow - 1) / this.myItemsPerRow;
            int n = y = up ? rows - 1 : 0;
            if ((y < 0 || this.myItemsPerRow * y + x >= c.myCategory.getEmoji().size()) && --y < 0) {
                return;
            }
            this.setCurrentItem(c, this.myItemsPerRow * y + x);
        }
        int overscroll = (this.myCellSize.height + this.myCellGaps.height) * dy;
        int overscrollUp = Math.max(-overscroll, 0);
        int overscrollDown = Math.max(overscroll, 0);
        this.myCurrentItemCategory.scrollRectToVisible(new Rectangle(this.myCurrentItemCategory.xGridToVisible(x), this.myCurrentItemCategory.yGridToVisible(y) - JBUIScale.scale((int)32) - overscrollUp, this.myCellSize.width, this.myCellSize.height + JBUIScale.scale((int)32) + overscrollUp + overscrollDown));
    }

    boolean hasCurrentItem() {
        return this.myCurrentItemCategory != null && this.myCurrentItemIndex >= 0;
    }

    private void setCurrentItem(Category category, int item) {
        this.myCurrentItemCategory = category;
        this.myCurrentItemIndex = item;
        this.myCurrentPanel.repaint();
        this.myEmojiPicker.updateEmojiInfo(category == null ? null : category.myCategory.getEmoji().get(item), this.myCurrentSkinTone);
    }

    private class CategoriesListPanel
    extends UpdatableLayoutPanel {
        private final List<Category> myCategories;

        private CategoriesListPanel(List<Category> categories) {
            this.myCategories = categories;
            this.setLayout(new BoxLayout(this, 1));
            this.add(Box.createRigidArea(new Dimension(0, JBUIScale.scale((int)15))));
            for (Category c : categories) {
                this.add(c);
            }
        }

        @Override
        void updateLayout(int width) {
            for (Category c : this.myCategories) {
                c.updateLayout(width);
            }
        }

        private int findCategoryIndex(Category c) {
            for (int i = 0; i < this.myCategories.size(); ++i) {
                if (this.myCategories.get(i) != c) continue;
                return i;
            }
            return -1;
        }
    }

    private class Category
    extends UpdatableLayoutPanel {
        private static final int NO_LABEL_PADDING = 12;
        private static final int LABEL_HEIGHT = 32;
        private EmojiCategory myCategory;
        @Nls
        private final String myName;
        private final Insets myPadding;

        private Category(EmojiCategory category) {
            this.myCategory = category;
            this.myName = EmojiCategoriesBundle.findNameForCategory(category);
            this.myPadding = JBUI.insets((int)(this.myName == null ? 12 : 32), (int)8, (int)8, (int)8);
            MouseAdapter mouseAdapter = new MouseAdapter(){

                private int getItemIndexUnderCursor(Point point) {
                    if (point.x < Category.this.myPadding.left || point.y < Category.this.myPadding.top) {
                        return -1;
                    }
                    int x = Category.this.xVisibleToGrid(point.x);
                    int y = Category.this.yVisibleToGrid(point.y);
                    if (x >= EmojiListPanel.this.myItemsPerRow || point.x > Category.this.xGridToVisible(x) + EmojiListPanel.this.myCellSize.width || point.y > Category.this.yGridToVisible(y) + EmojiListPanel.this.myCellSize.height) {
                        return -1;
                    }
                    int index = EmojiListPanel.this.myItemsPerRow * y + x;
                    return index >= 0 && index < Category.this.myCategory.getEmoji().size() ? index : -1;
                }

                private boolean setCurrentItemUnderCursor(Point point) {
                    int item = this.getItemIndexUnderCursor(point);
                    if (item != -1) {
                        EmojiListPanel.this.setCurrentItem(Category.this, item);
                        return true;
                    }
                    return false;
                }

                @Override
                public void mouseClicked(MouseEvent e) {
                    if (this.setCurrentItemUnderCursor(e.getPoint())) {
                        EmojiListPanel.this.selectCurrentEmoji();
                    }
                }

                @Override
                public void mouseMoved(MouseEvent e) {
                    this.setCurrentItemUnderCursor(e.getPoint());
                }
            };
            this.addMouseMotionListener(mouseAdapter);
            this.addMouseListener(mouseAdapter);
        }

        private int xVisibleToGrid(int x) {
            return (x - this.myPadding.left) / (EmojiListPanel.this.myCellSize.width + EmojiListPanel.this.myCellGaps.width);
        }

        private int yVisibleToGrid(int y) {
            return (y - this.myPadding.top) / (EmojiListPanel.this.myCellSize.height + EmojiListPanel.this.myCellGaps.height);
        }

        private int xGridToVisible(int x) {
            return x * (EmojiListPanel.this.myCellSize.width + EmojiListPanel.this.myCellGaps.width) + this.myPadding.left;
        }

        private int yGridToVisible(int y) {
            return y * (EmojiListPanel.this.myCellSize.height + EmojiListPanel.this.myCellGaps.height) + this.myPadding.top;
        }

        @Override
        void updateLayout(int width) {
            int itemCount = this.myCategory.getEmoji().size();
            this.setPreferredSize(new Dimension(width, this.yGridToVisible((itemCount + EmojiListPanel.this.myItemsPerRow - 1) / EmojiListPanel.this.myItemsPerRow) + this.myPadding.bottom));
        }

        @Override
        public int getWidth() {
            return EmojiListPanel.this.getWidth();
        }

        @Override
        public void paint(Graphics g) {
            super.paint(g);
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, AntialiasingType.getKeyForCurrentScope((boolean)false));
            if (this.myName == null && this.myCategory.getEmoji().isEmpty()) {
                this.paintNoEmojiFound(g);
            } else {
                if (EmojiListPanel.this.myItemsPerRow <= 0) {
                    return;
                }
                this.paintSelection(g);
                this.paintItems(g);
                if (this.myName != null) {
                    this.paintCategoryLabel(g);
                }
            }
        }

        private void paintNoEmojiFound(Graphics g) {
            if (g instanceof Graphics2D) {
                int x = (this.getWidth() - EmojiListPanel.this.myNoEmojiFoundImage.getWidth(this)) / 2;
                int y = (this.getHeight() - EmojiListPanel.this.myNoEmojiFoundImage.getHeight(this)) / 2;
                Graphics2D g2 = (Graphics2D)g;
                Composite saveComposite = g2.getComposite();
                g2.setComposite(AlphaComposite.getInstance(10, 0.5f));
                StartupUiUtil.drawImage((Graphics)g, (Image)EmojiListPanel.this.myNoEmojiFoundImage, (int)x, (int)y, null);
                g2.setComposite(saveComposite);
            }
            g.setColor(EmojiListPanel.this.myStyle.myNoEmojiFoundTextColor);
            g.setFont(EmojiListPanel.this.myStyle.myFont);
            @Nls String message = EmojipickerBundle.message("message.EmojiPicker.NoEmojiFound", new Object[0]);
            int x = (this.getWidth() - g.getFontMetrics().stringWidth(message)) / 2;
            int y = (this.getHeight() + EmojiListPanel.this.myNoEmojiFoundImage.getHeight(this)) / 2 + JBUIScale.scale((int)25);
            g.drawString(message, x, y);
        }

        private void paintSelection(Graphics g) {
            if (EmojiListPanel.this.myCurrentItemCategory == this && EmojiListPanel.this.myCurrentItemIndex != -1) {
                int x = this.xGridToVisible(EmojiListPanel.this.myCurrentItemIndex % EmojiListPanel.this.myItemsPerRow);
                int y = this.yGridToVisible(EmojiListPanel.this.myCurrentItemIndex / EmojiListPanel.this.myItemsPerRow);
                g.setColor(EmojiListPanel.this.myStyle.myHoverBackgroundColor);
                RectanglePainter2D.FILL.paint((Graphics2D)g, (double)x, (double)y, (double)EmojiListPanel.this.myCellSize.width, (double)EmojiListPanel.this.myCellSize.height, (Object)6.0);
            }
        }

        private void paintItems(Graphics g) {
            int itemCount;
            Rectangle bounds = g.getClipBounds();
            int from = this.yVisibleToGrid(bounds.y) * EmojiListPanel.this.myItemsPerRow;
            int to = this.yVisibleToGrid(bounds.y + bounds.height) * EmojiListPanel.this.myItemsPerRow + EmojiListPanel.this.myItemsPerRow;
            if (from < 0) {
                from = 0;
            }
            if (to > (itemCount = this.myCategory.getEmoji().size())) {
                to = itemCount;
            }
            if (from > to) {
                from = to;
            }
            FontMetrics metrics = g.getFontMetrics(EmojiListPanel.this.myStyle.myEmojiFont);
            int verticalOffset = metrics.getHeight() / 2 - metrics.getDescent();
            for (int i = from; i < to; ++i) {
                int x = this.xGridToVisible(i % EmojiListPanel.this.myItemsPerRow);
                int y = this.yGridToVisible(i / EmojiListPanel.this.myItemsPerRow);
                @Nls String item = this.myCategory.getEmoji().get(i).getTonedValue(EmojiListPanel.this.myCurrentSkinTone);
                int width = metrics.stringWidth(item);
                new TextLayout(item, EmojiListPanel.this.myStyle.myEmojiFont, ((Graphics2D)g).getFontRenderContext()).draw((Graphics2D)g, (float)x + (float)(EmojiListPanel.this.myCellSize.width - width) / 2.0f, (float)y + (float)EmojiListPanel.this.myCellSize.height / 2.0f + (float)verticalOffset);
            }
        }

        private void paintCategoryLabel(Graphics g) {
            int offset = Math.min(g.getClipBounds().y, this.getHeight() - JBUIScale.scale((int)32));
            g.setColor(EmojiListPanel.this.myStyle.myBackgroundColor);
            RectanglePainter2D.FILL.paint((Graphics2D)g, 0.0, (double)offset, (double)this.getWidth(), (double)JBUIScale.scale((int)32));
            g.setFont(EmojiListPanel.this.myStyle.myFont);
            g.setColor(EmojiListPanel.this.myStyle.myTextColor);
            g.drawString(this.myName, JBUIScale.scale((int)16), offset + JBUIScale.scale((int)20));
        }
    }

    private abstract class UpdatableLayoutPanel
    extends JPanel {
        private UpdatableLayoutPanel() {
            this.setBackground(EmojiListPanel.this.myStyle.myBackgroundColor);
        }

        abstract void updateLayout(int var1);
    }
}

