/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.util;

import com.intellij.ide.highlighter.HtmlFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.Commenter;
import com.intellij.lang.LanguageCommenters;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.options.LanguageOptions;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileTypeUtil
implements Disposable {
    private final Set<FileType> noSeparators = new HashSet<FileType>();

    public static synchronized FileTypeUtil getInstance() {
        return (FileTypeUtil)ApplicationManager.getApplication().getService(FileTypeUtil.class);
    }

    public FileTypeUtil() {
        this.createMappings();
    }

    public static String buildComment(FileType type, String template, LanguageOptions options) {
        int i;
        String open;
        boolean allowLine;
        Commenter commenter = FileTypeUtil.getCommenter(type);
        if (commenter == null) {
            return "<No comments>";
        }
        String bs = commenter.getBlockCommentPrefix();
        String be = commenter.getBlockCommentSuffix();
        String ls = commenter.getLineCommentPrefix();
        if ((bs == null || be == null) && ls == null) {
            return "<No comments>";
        }
        boolean allowBlock = bs != null && be != null;
        boolean bl = allowLine = ls != null;
        if (allowLine && !allowBlock) {
            bs = ls;
            be = ls;
        }
        boolean allowSeparator = FileTypeUtil.getInstance().allowSeparators(type);
        String filler = options.getFiller();
        if (!allowSeparator && options.getFiller() == " ") {
            filler = "~";
        }
        boolean isBlock = options.isBlock();
        boolean isPrefix = options.isPrefixLines();
        if (isBlock && !allowBlock) {
            isPrefix = true;
        }
        boolean isBox = options.isBox() && options.isSeparateBefore() && options.isSeparateAfter() && options.getLenBefore() == options.getLenAfter();
        StringBuilder preview = new StringBuilder(80);
        String string = isBlock ? bs : (open = allowLine ? ls : bs);
        String close = isBlock ? be : (allowLine ? ls : be);
        StringBuilder pre = new StringBuilder(5);
        StringBuilder leader = new StringBuilder(5);
        StringBuilder post = new StringBuilder(5);
        if (filler == " ") {
            filler = open.substring(open.length() - 1);
        }
        int offset = 0;
        if (isBlock) {
            int pos = open.length() - 1;
            pre.append(allowBlock ? filler : Character.valueOf(open.charAt(pos)));
            while (pos > 0 && open.charAt(pos) == open.charAt(open.length() - 1)) {
                --pos;
                ++offset;
            }
            while (open.length() > 1 && pos >= 0) {
                leader.append(' ');
                --pos;
            }
            post.append(filler);
            if (!isPrefix) {
                pre = new StringBuilder(0);
            }
            if (!allowBlock) {
                close = filler;
            }
        } else {
            if (allowLine) {
                close = filler;
            }
            pre.append(open);
            post.append(close);
        }
        int diff = 0;
        if (options.isSeparateBefore()) {
            if (isBlock && isBox && allowBlock) {
                diff = close.length() - offset;
            }
            preview.append(open);
            for (i = open.length() + 1; i <= options.getLenBefore() - diff - post.length(); ++i) {
                preview.append(filler);
            }
            preview.append((CharSequence)post);
            preview.append('\n');
        } else if (isBlock) {
            preview.append(open).append('\n');
        }
        if (!template.isEmpty()) {
            String[] lines;
            for (String line : lines = template.split("\n", -1)) {
                if (options.isTrim()) {
                    line = line.trim();
                }
                line = StringUtil.trimStart((String)StringUtil.trimStart((String)line, (String)pre.toString()), (String)open);
                line = StringUtil.trimEnd((String)line, (String)close);
                preview.append((CharSequence)leader).append((CharSequence)pre);
                int len = 0;
                if (pre.length() > 0 && !line.isEmpty()) {
                    preview.append(' ');
                    ++len;
                }
                preview.append(line);
                if (isBox && (len += line.length() + leader.length() + pre.length()) < options.getLenBefore() - diff) {
                    while (len < options.getLenBefore() - diff - post.length()) {
                        preview.append(' ');
                        ++len;
                    }
                    if (isBlock || allowLine) {
                        preview.append(post.substring(0, options.getLenBefore() - diff - len));
                    }
                }
                if (!isBlock && !allowLine) {
                    if (preview.charAt(preview.length() - 1) != ' ') {
                        preview.append(' ');
                    }
                    preview.append(close);
                }
                preview.append('\n');
            }
        }
        preview.append((CharSequence)leader);
        if (options.isSeparateAfter()) {
            preview.append((CharSequence)pre);
            for (i = leader.length() + pre.length(); i < options.getLenAfter() - close.length(); ++i) {
                preview.append(filler);
            }
            preview.append(close);
            preview.append('\n');
        } else if (isBlock) {
            if (!allowBlock) {
                preview.append((CharSequence)pre).append('\n');
            } else {
                preview.append(close).append('\n');
            }
        }
        return preview.length() > 0 ? preview.substring(0, preview.length() - 1) : preview.toString();
    }

    public static boolean isSupportedFile(@NotNull VirtualFile file) {
        if (file.isDirectory()) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)file)) {
            return false;
        }
        return FileTypeUtil.isSupportedType(file.getFileType());
    }

    public static boolean isSupportedFile(@Nullable PsiFile file) {
        if (file == null || file instanceof PsiDirectory || file instanceof PsiCodeFragment) {
            return false;
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        if (ProjectUtil.isProjectOrWorkspaceFile((VirtualFile)virtualFile)) {
            return false;
        }
        return FileTypeUtil.isSupportedType(virtualFile.getFileType());
    }

    public static Set<FileType> getSupportedTypes() {
        return CopyrightUpdaters.INSTANCE.getAllRegisteredExtensions().keySet();
    }

    public static boolean hasBlockComment(FileType fileType) {
        Commenter commenter = FileTypeUtil.getCommenter(fileType);
        return commenter != null && commenter.getBlockCommentPrefix() != null;
    }

    public boolean allowSeparators(FileType fileType) {
        return !this.noSeparators.contains(fileType);
    }

    private static Commenter getCommenter(FileType fileType) {
        if (fileType instanceof LanguageFileType) {
            return (Commenter)LanguageCommenters.INSTANCE.forLanguage(((LanguageFileType)fileType).getLanguage());
        }
        return null;
    }

    private void createMappings() {
        this.noSeparators.add((FileType)XmlFileType.INSTANCE);
        this.noSeparators.add((FileType)HtmlFileType.INSTANCE);
        this.noSeparators.add((FileType)StdFileTypes.JSP);
        this.noSeparators.add((FileType)StdFileTypes.JSPX);
    }

    private static boolean isSupportedType(FileType type) {
        if (type.isBinary() || type.getName().contains("IDEA") || "GUI_DESIGNER_FORM".equals(type.getName())) {
            return false;
        }
        if (CopyrightUpdaters.INSTANCE.forFileType(type) == null) {
            return false;
        }
        Commenter commenter = FileTypeUtil.getCommenter(type);
        return commenter != null && (commenter.getLineCommentPrefix() != null || commenter.getBlockCommentPrefix() != null);
    }

    public void dispose() {
    }

    public static class SortByName
    implements Comparator<FileType> {
        @Override
        public int compare(FileType a, FileType b) {
            return a.getName().compareToIgnoreCase(b.getName());
        }
    }
}

