/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.ui;

import com.intellij.copyright.CopyrightBundle;
import com.intellij.openapi.extensions.BaseExtensionPointName;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.project.Project;
import com.maddyhome.idea.copyright.CopyrightUpdaters;
import com.maddyhome.idea.copyright.ui.FileTypeCopyrightConfigurableFactory;
import com.maddyhome.idea.copyright.ui.TemplateCommentPanel;
import com.maddyhome.idea.copyright.util.FileTypeUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class CopyrightFormattingConfigurable
extends SearchableConfigurable.Parent.Abstract
implements Configurable.NoScroll,
Configurable.WithEpDependencies {
    private final Project myProject;
    private TemplateCommentPanel myPanel;

    CopyrightFormattingConfigurable(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getId() {
        return "template.copyright.formatting";
    }

    @Nls
    public String getDisplayName() {
        return CopyrightBundle.message("configurable.CopyrightFormattingConfigurable.display.name", new Object[0]);
    }

    public String getHelpTopic() {
        return this.getId();
    }

    public JComponent createComponent() {
        this.getOrCreateMainPanel();
        return this.myPanel.createComponent();
    }

    private TemplateCommentPanel getOrCreateMainPanel() {
        if (this.myPanel == null) {
            this.myPanel = new TemplateCommentPanel(null, null, this.myProject, new String[0]);
        }
        return this.myPanel;
    }

    public boolean isModified() {
        return this.myPanel.isModified();
    }

    public void apply() throws ConfigurationException {
        this.myPanel.apply();
    }

    public void reset() {
        this.myPanel.reset();
    }

    public void disposeUIResources() {
        this.myPanel.disposeUIResources();
        this.myPanel = null;
    }

    public boolean hasOwnContent() {
        return true;
    }

    protected Configurable[] buildConfigurables() {
        FileType[] types = FileTypeUtil.getSupportedTypes().toArray(FileType.EMPTY_ARRAY);
        Configurable[] children = new Configurable[types.length];
        Arrays.sort(types, new FileTypeUtil.SortByName());
        for (int i = 0; i < types.length; ++i) {
            children[i] = FileTypeCopyrightConfigurableFactory.createFileTypeConfigurable(this.myProject, types[i], this.getOrCreateMainPanel());
        }
        return children;
    }

    @NotNull
    public Collection<BaseExtensionPointName<?>> getDependencies() {
        return Collections.singletonList(CopyrightUpdaters.EP_NAME);
    }
}

