/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.codeInsight.actions.onSave.ActionOnSaveInfoBase;
import com.intellij.copyright.CopyrightBundle;
import com.intellij.copyright.CopyrightManager;
import com.intellij.ide.actionsOnSave.ActionOnSaveComment;
import com.intellij.ide.actionsOnSave.ActionOnSaveContext;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfo;
import com.intellij.ide.actionsOnSave.ActionOnSaveInfoProvider;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.options.ex.ConfigurableWrapper;
import com.intellij.openapi.project.Project;
import com.intellij.ui.components.ActionLink;
import com.maddyhome.idea.copyright.ui.CopyrightProjectConfigurable;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class CopyrightOnSaveInfoProvider
extends ActionOnSaveInfoProvider {
    private static final String UPDATE_COPYRIGHT_ON_SAVE = "update.copyright.on.save";
    private static final boolean UPDATE_COPYRIGHT_BY_DEFAULT = false;

    public static boolean isUpdateCopyrightOnSaveEnabled(@NotNull Project project) {
        return PropertiesComponent.getInstance((Project)project).getBoolean(UPDATE_COPYRIGHT_ON_SAVE, false);
    }

    @NotNull
    protected Collection<? extends ActionOnSaveInfo> getActionOnSaveInfos(final @NotNull ActionOnSaveContext context) {
        return List.of(new ActionOnSaveInfoBase(context, CopyrightBundle.message("checkbox.update.copyright.notice", new Object[0]), UPDATE_COPYRIGHT_ON_SAVE, false){

            @NotNull
            public List<? extends ActionLink> getActionLinks() {
                return List.of(this.createGoToPageInSettingsLink(CopyrightBundle.message("link.label.configure.copyright.settings", new Object[0]), "copyright"));
            }

            private boolean hasCopyrights() {
                Configurable configurable = this.getSettings().getConfigurableWithInitializedUiComponent("copyright", false);
                CopyrightProjectConfigurable copyrightProjectConfigurable = (CopyrightProjectConfigurable)((Object)ConfigurableWrapper.cast(CopyrightProjectConfigurable.class, (UnnamedConfigurable)configurable));
                if (copyrightProjectConfigurable != null) {
                    return copyrightProjectConfigurable.hasAnyCopyrights();
                }
                return CopyrightManager.getInstance(context.getProject()).hasAnyCopyrights();
            }

            public boolean isSaveActionApplicable() {
                return this.hasCopyrights();
            }

            public ActionOnSaveComment getComment() {
                return ActionOnSaveComment.info((String)CopyrightBundle.message(this.hasCopyrights() ? "label.updates.existing.copyrights.e.g.changes.year.or.updated.notice" : "label.no.copyright.configured", new Object[0]));
            }
        });
    }

    public Collection<String> getSearchableOptions() {
        return List.of(CopyrightBundle.message("checkbox.update.copyright.notice", new Object[0]));
    }
}

