/*
 * Decompiled with CFR 0.152.
 */
package com.maddyhome.idea.copyright.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.ide.actionsOnSave.impl.ActionsOnSaveFileDocumentManagerListener;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.maddyhome.idea.copyright.actions.CopyrightOnSaveInfoProvider;
import com.maddyhome.idea.copyright.actions.UpdateCopyrightAction;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public final class CopyrightOnSaveAction
extends ActionsOnSaveFileDocumentManagerListener.ActionOnSave {
    public boolean isEnabledForProject(@NotNull Project project) {
        return CopyrightOnSaveInfoProvider.isUpdateCopyrightOnSaveEnabled(project);
    }

    public void processDocuments(@NotNull Project project, @NotNull @NotNull Document @NotNull [] documents) {
        if (DumbService.isDumb((Project)project)) {
            return;
        }
        FileDocumentManager manager = FileDocumentManager.getInstance();
        VirtualFile[] files = ContainerUtil.mapNotNull((Object[])documents, d -> manager.getFile(d)).toArray(VirtualFile.EMPTY_ARRAY);
        if (files.length == 0) {
            return;
        }
        AnalysisScope scope = new AnalysisScope(project, Arrays.asList(files));
        UpdateCopyrightAction.UpdateCopyrightTask task = new UpdateCopyrightAction.UpdateCopyrightTask(project, scope, true, PerformInBackgroundOption.DEAF);
        ProgressManager.getInstance().run((Task)task);
    }
}

