/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.instrumentation.threading.agent.callback;

import com.android.tools.instrumentation.threading.agent.callback.BaselineViolations;
import com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerHook;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import java.util.logging.Logger;

public final class ThreadingCheckerTrampoline {
    private static final Logger LOGGER = Logger.getLogger(ThreadingCheckerTrampoline.class.getName());
    private static final CopyOnWriteArrayList<ThreadingCheckerHook> hooks = new CopyOnWriteArrayList();
    static final AtomicLong skippedChecksCounter = new AtomicLong();
    private static final ThreadLocal<Integer> insideIgnoredCounter = ThreadLocal.withInitial(() -> 0);

    static BaselineViolations getBaselineViolations() {
        return BaselineViolationsHolder.baselineViolations;
    }

    public static void installHook(ThreadingCheckerHook newHook) {
        hooks.add(newHook);
        ThreadingCheckerTrampoline.warnIfSkippedChecksAndReset();
    }

    public static void removeHook(ThreadingCheckerHook hook) {
        hooks.remove(hook);
    }

    static void clearHooks() {
        hooks.clear();
    }

    static <T> T withChecksDisabledForCallable(Callable<T> callable) throws Exception {
        try {
            insideIgnoredCounter.set(insideIgnoredCounter.get() + 1);
            T t = callable.call();
            return t;
        }
        finally {
            insideIgnoredCounter.set(insideIgnoredCounter.get() - 1);
        }
    }

    static <T> T withChecksDisabledForSupplier(Supplier<T> supplier) {
        try {
            insideIgnoredCounter.set(insideIgnoredCounter.get() + 1);
            T t = supplier.get();
            return t;
        }
        finally {
            insideIgnoredCounter.set(insideIgnoredCounter.get() - 1);
        }
    }

    public static void verifyOnUiThread() {
        if (hooks.isEmpty()) {
            skippedChecksCounter.incrementAndGet();
            return;
        }
        if (insideIgnoredCounter.get() > 0) {
            return;
        }
        if (ThreadingCheckerTrampoline.getBaselineViolations().isIgnored(ThreadingCheckerTrampoline.getInstrumentedMethodStackTrace())) {
            return;
        }
        for (ThreadingCheckerHook hook : hooks) {
            hook.verifyOnUiThread();
        }
    }

    public static void verifyOnWorkerThread() {
        if (hooks.isEmpty()) {
            skippedChecksCounter.incrementAndGet();
            return;
        }
        if (insideIgnoredCounter.get() > 0) {
            return;
        }
        if (ThreadingCheckerTrampoline.getBaselineViolations().isIgnored(ThreadingCheckerTrampoline.getInstrumentedMethodStackTrace())) {
            return;
        }
        for (ThreadingCheckerHook hook : hooks) {
            hook.verifyOnWorkerThread();
        }
    }

    private static void warnIfSkippedChecksAndReset() {
        long skippedChecksCount = skippedChecksCounter.getAndSet(0L);
        if (skippedChecksCount > 0L) {
            LOGGER.warning("Threading annotation check was attempted " + skippedChecksCount + " times before the ThreadingCheckerHook was installed");
        }
    }

    private static List<StackTraceElement> getInstrumentedMethodStackTrace() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        return Arrays.asList(stackTrace).subList(3, stackTrace.length);
    }

    static class BaselineViolationsHolder {
        static BaselineViolations baselineViolations = BaselineViolations.fromResource();

        BaselineViolationsHolder() {
        }
    }
}

