/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.instrumentation.threading.agent.callback;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public class BaselineViolations {
    private static final Logger LOGGER = Logger.getLogger(BaselineViolations.class.getName());
    private final Set<String> violatingMethods;

    private BaselineViolations(Set<String> violatingMethods) {
        this.violatingMethods = violatingMethods;
    }

    public boolean isIgnored(List<StackTraceElement> stackTrace) {
        if (stackTrace.isEmpty()) {
            throw new IllegalArgumentException("stackTrace is empty");
        }
        return this.violatingMethods.contains(BaselineViolations.traceElementToMethodSignature(stackTrace.get(0)));
    }

    static BaselineViolations fromResource() {
        BaselineViolations baselineViolations;
        block8: {
            InputStream stream = BaselineViolations.class.getResourceAsStream("/baseline_violations.txt");
            try {
                baselineViolations = BaselineViolations.fromStream(stream);
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    LOGGER.severe("Couldn't read baseline violations file, " + e);
                    LOGGER.info("Will skip all baseline violation checks");
                    return new BaselineViolations(Collections.emptySet());
                }
            }
            stream.close();
        }
        return baselineViolations;
    }

    static BaselineViolations fromStream(InputStream stream) {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(stream));
        return new BaselineViolations(bufferedReader.lines().map(String::trim).filter(l -> !l.startsWith("#") && !l.isEmpty()).collect(Collectors.toSet()));
    }

    private static String traceElementToMethodSignature(StackTraceElement stackTraceElement) {
        return stackTraceElement.getClassName() + "#" + stackTraceElement.getMethodName();
    }
}

