/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.instrumentation.threading.agent;

import com.android.tools.instrumentation.threading.agent.AnnotationMappings;
import com.android.tools.instrumentation.threading.agent.InstrumentClassVisitor;
import com.android.tools.instrumentation.threading.org.objectweb.asm.ClassReader;
import com.android.tools.instrumentation.threading.org.objectweb.asm.ClassWriter;
import java.lang.instrument.ClassFileTransformer;
import java.security.ProtectionDomain;
import java.util.logging.Logger;

class Transformer
implements ClassFileTransformer {
    private static final Logger LOGGER = Logger.getLogger(Transformer.class.getName());
    private final AnnotationMappings annotationMappings;

    public Transformer(AnnotationMappings annotationMappings) {
        this.annotationMappings = annotationMappings;
    }

    @Override
    public byte[] transform(ClassLoader loader, String classJvmName, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classFileBuffer) {
        if (classJvmName == null) {
            LOGGER.fine("classJvmName is null");
            return null;
        }
        String className = classJvmName.replace('/', '.');
        if (!classJvmName.contains("/android/")) {
            return null;
        }
        try {
            ClassReader reader = new ClassReader(classFileBuffer);
            ClassWriter writer = new ClassWriter(reader, 1);
            InstrumentClassVisitor classVisitor = new InstrumentClassVisitor(this.annotationMappings, className, writer);
            reader.accept(classVisitor, 8);
            return writer.toByteArray();
        }
        catch (Throwable e) {
            LOGGER.warning(String.format("Threading agent: failed to instrument %s\n%s", className, e));
            return null;
        }
    }
}

