/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.instrumentation.threading.agent;

import com.android.tools.instrumentation.threading.agent.CheckerMethodRef;
import java.util.EnumSet;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

final class AnnotationMappings {
    private final Map<String, Optional<CheckerMethodRef>> annotationToCheckerMethodsMap;

    private AnnotationMappings(EnumSet<AnnotationMapping> annotationMappings) {
        this.annotationToCheckerMethodsMap = annotationMappings.stream().collect(Collectors.toMap(AnnotationMapping::getAnnotation, AnnotationMapping::getCheckerMethod));
    }

    public static AnnotationMappings create() {
        return new AnnotationMappings(EnumSet.allOf(AnnotationMapping.class));
    }

    public boolean isThreadingAnnotation(String annotation) {
        return this.annotationToCheckerMethodsMap.containsKey(annotation);
    }

    public Optional<CheckerMethodRef> getCheckerMethodForThreadingAnnotation(String annotation) {
        if (!this.annotationToCheckerMethodsMap.containsKey(annotation)) {
            throw new IllegalArgumentException("Annotation '" + annotation + "' is not a threading annotation.");
        }
        return this.annotationToCheckerMethodsMap.get(annotation);
    }

    private static enum AnnotationMapping {
        UI_THREAD("Lcom/android/annotations/concurrency/UiThread;", "com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerTrampoline", "verifyOnUiThread"),
        WORKER_THREAD("Lcom/android/annotations/concurrency/WorkerThread;", "com.android.tools.instrumentation.threading.agent.callback.ThreadingCheckerTrampoline", "verifyOnWorkerThread"),
        SLOW_THREAD("Lcom/android/annotations/concurrency/Slow;"),
        ANY_THREAD("Lcom/android/annotations/concurrency/AnyThread;");

        private final String annotation;
        private final CheckerMethodRef checkerMethod;

        private AnnotationMapping(String annotation) {
            this.annotation = annotation;
            this.checkerMethod = null;
        }

        private AnnotationMapping(String annotation, String checkMethodClassName, String checkerMethodName) {
            this.annotation = annotation;
            this.checkerMethod = new CheckerMethodRef(checkMethodClassName, checkerMethodName);
        }

        String getAnnotation() {
            return this.annotation;
        }

        Optional<CheckerMethodRef> getCheckerMethod() {
            return Optional.ofNullable(this.checkerMethod);
        }
    }
}

