/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.compose.code.completion;

import com.android.ide.common.vectordrawable.VdPreview;
import com.android.tools.compose.code.completion.ComposeMaterialIconService;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementDecorator;
import com.intellij.codeInsight.lookup.LookupElementPresentation;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.base.psi.JavaPsiUtils;
import org.jetbrains.kotlin.psi.KtProperty;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \t2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/android/tools/compose/code/completion/ComposeMaterialIconLookupElement;", "Lcom/intellij/codeInsight/lookup/LookupElementDecorator;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "original", "(Lcom/intellij/codeInsight/lookup/LookupElement;)V", "renderElement", "", "presentation", "Lcom/intellij/codeInsight/lookup/LookupElementPresentation;", "Companion", "intellij.android.compose-ide-plugin"})
@VisibleForTesting
@SourceDebugExtension(value={"SMAP\nComposeCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeCompletionContributor.kt\ncom/android/tools/compose/code/completion/ComposeMaterialIconLookupElement\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,457:1\n1#2:458\n*E\n"})
public final class ComposeMaterialIconLookupElement
extends LookupElementDecorator<LookupElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LookupElement original;
    @NotNull
    private static final Map<String, Pair<String, String>> themeNamingPatterns;

    public ComposeMaterialIconLookupElement(@NotNull LookupElement original) {
        Intrinsics.checkNotNullParameter((Object)original, (String)"original");
        super(original);
        this.original = original;
    }

    public void renderElement(@NotNull LookupElementPresentation presentation) {
        block1: {
            Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
            super.renderElement(presentation);
            Object object = this.original.getPsiElement();
            if (object == null || (object = JavaPsiUtils.getKotlinFqName((PsiElement)object)) == null || (object = object.asString()) == null) {
                return;
            }
            Object fqName = object;
            Icon icon = Companion.getIcon$intellij_android_compose_ide_plugin((String)fqName);
            if (icon == null) break block1;
            Icon it = icon;
            boolean bl = false;
            presentation.setIcon(it);
        }
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"androidx.compose.material.icons.filled", (Object)new Pair((Object)"materialicons", (Object)"baseline")), TuplesKt.to((Object)"androidx.compose.material.icons.rounded", (Object)new Pair((Object)"materialiconsround", (Object)"round")), TuplesKt.to((Object)"androidx.compose.material.icons.sharp", (Object)new Pair((Object)"materialiconssharp", (Object)"sharp")), TuplesKt.to((Object)"androidx.compose.material.icons.twotone", (Object)new Pair((Object)"materialiconstwotone", (Object)"twotone")), TuplesKt.to((Object)"androidx.compose.material.icons.outlined", (Object)new Pair((Object)"materialiconsoutlined", (Object)"outline"))};
        themeNamingPatterns = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u000eJ\u0012\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u0005H\u0002J\f\u0010\u0011\u001a\u00020\u0005*\u00020\u0005H\u0002J\u000e\u0010\u0012\u001a\u0004\u0018\u00010\u0005*\u00020\u0005H\u0002J\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0005*\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u0014R&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/android/tools/compose/code/completion/ComposeMaterialIconLookupElement$Companion;", "", "()V", "themeNamingPatterns", "", "", "Lkotlin/Pair;", "appliesTo", "", "lookupElement", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getIcon", "Ljavax/swing/Icon;", "fqName", "getIcon$intellij_android_compose_ide_plugin", "getIconFromMaterialIconsProvider", "getIconFromResources", "camelCaseToSnakeCase", "iconFileNameFromFqName", "resourcePathFromFqName", "resourcePathFromFqName$intellij_android_compose_ide_plugin", "intellij.android.compose-ide-plugin"})
    @SourceDebugExtension(value={"SMAP\nComposeCompletionContributor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComposeCompletionContributor.kt\ncom/android/tools/compose/code/completion/ComposeMaterialIconLookupElement$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,457:1\n1#2:458\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean appliesTo(@NotNull LookupElement lookupElement) {
            Object fqName;
            block7: {
                block6: {
                    Intrinsics.checkNotNullParameter((Object)lookupElement, (String)"lookupElement");
                    PsiElement psiElement = lookupElement.getPsiElement();
                    if (psiElement == null) {
                        return false;
                    }
                    PsiElement psiElement2 = psiElement;
                    if (!(psiElement2 instanceof KtProperty)) {
                        return false;
                    }
                    Object object = JavaPsiUtils.getKotlinFqName((PsiElement)psiElement2);
                    if (object == null || (object = object.asString()) == null) {
                        return false;
                    }
                    fqName = object;
                    if (!StringsKt.startsWith$default((String)fqName, (String)"androidx.compose.material.icons", (boolean)false, (int)2, null)) break block6;
                    Object object2 = ((KtProperty)psiElement2).getTypeReference();
                    if (object2 != null && (object2 = object2.getText()) != null ? StringsKt.endsWith$default((String)object2, (String)"ImageVector", (boolean)false, (int)2, null) : false) break block7;
                }
                return false;
            }
            return themeNamingPatterns.containsKey(StringsKt.substringBeforeLast$default((String)fqName, (char)'.', null, (int)2, null));
        }

        private final String camelCaseToSnakeCase(String $this$camelCaseToSnakeCase) {
            char[] cArray = new char[]{'_'};
            String camelName = StringsKt.trimStart((String)$this$camelCaseToSnakeCase, (char[])cArray);
            return CollectionsKt.joinToString$default((Iterable)StringsKt.withIndex((CharSequence)camelName), (CharSequence)"", null, null, (int)0, null, (Function1)((Function1)new Function1<IndexedValue<? extends Character>, CharSequence>(camelName){
                final /* synthetic */ String $camelName;
                {
                    this.$camelName = $camelName;
                    super(1);
                }

                @NotNull
                public final CharSequence invoke(@NotNull IndexedValue<Character> indexedValue) {
                    Intrinsics.checkNotNullParameter(indexedValue, (String)"<name for destructuring parameter 0>");
                    int i = indexedValue.component1();
                    char ch = ((Character)indexedValue.component2()).charValue();
                    return i == 0 ? (CharSequence)String.valueOf(Character.toLowerCase(ch)) : (Character.isUpperCase(ch) ? (CharSequence)("_" + Character.toLowerCase(ch)) : (Character.isDigit(ch) && !Character.isDigit(this.$camelName.charAt(i - 1)) ? (CharSequence)("_" + ch) : (CharSequence)String.valueOf(ch)));
                }
            }), (int)30, null);
        }

        @VisibleForTesting
        @Nullable
        public final String resourcePathFromFqName$intellij_android_compose_ide_plugin(@NotNull String $this$resourcePathFromFqName) {
            Intrinsics.checkNotNullParameter((Object)$this$resourcePathFromFqName, (String)"<this>");
            Pair pair = (Pair)themeNamingPatterns.get(StringsKt.substringBeforeLast$default((String)$this$resourcePathFromFqName, (char)'.', null, (int)2, null));
            if (pair == null) {
                return null;
            }
            Pair pair2 = pair;
            String directory = (String)pair2.component1();
            String filePrefix = (String)pair2.component2();
            String snakeCaseName = this.camelCaseToSnakeCase(StringsKt.substringAfterLast$default((String)$this$resourcePathFromFqName, (char)'.', null, (int)2, null));
            return "images/material/icons/" + directory + "/" + snakeCaseName + "/" + filePrefix + "_" + snakeCaseName + "_24.xml";
        }

        private final String iconFileNameFromFqName(String $this$iconFileNameFromFqName) {
            Pair pair = (Pair)themeNamingPatterns.get(StringsKt.substringBeforeLast$default((String)$this$iconFileNameFromFqName, (char)'.', null, (int)2, null));
            if (pair == null) {
                return null;
            }
            String filePrefix = (String)pair.component2();
            String snakeCaseName = this.camelCaseToSnakeCase(StringsKt.substringAfterLast$default((String)$this$iconFileNameFromFqName, (char)'.', null, (int)2, null));
            return filePrefix + "_" + snakeCaseName + "_24.xml";
        }

        @VisibleForTesting
        @Nullable
        public final Icon getIcon$intellij_android_compose_ide_plugin(@NotNull String fqName) {
            Intrinsics.checkNotNullParameter((Object)fqName, (String)"fqName");
            Icon icon = this.getIconFromMaterialIconsProvider(fqName);
            if (icon == null) {
                icon = this.getIconFromResources(fqName);
            }
            return icon;
        }

        private final Icon getIconFromMaterialIconsProvider(String fqName) {
            String string = this.iconFileNameFromFqName(fqName);
            if (string == null) {
                return null;
            }
            String iconFileName = string;
            Application application = ApplicationManager.getApplication();
            Intrinsics.checkNotNullExpressionValue((Object)application, (String)"getApplication()");
            return ComposeMaterialIconService.Companion.getInstance(application).getIcon(iconFileName);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final Icon getIconFromResources(String fqName) {
            ImageIcon imageIcon;
            String string = this.resourcePathFromFqName$intellij_android_compose_ide_plugin(fqName);
            if (string == null) {
                return null;
            }
            String resourcePath = string;
            InputStream inputStream = ComposeMaterialIconLookupElement.class.getClassLoader().getResourceAsStream(resourcePath);
            if (inputStream != null) {
                Closeable closeable = inputStream;
                Throwable throwable = null;
                try {
                    InputStream inputStream2 = (InputStream)closeable;
                    boolean bl = false;
                    Closeable closeable2 = inputStream2;
                    Object object = Charsets.UTF_8;
                    Object object2 = new InputStreamReader((InputStream)closeable2, (Charset)object);
                    int n = 8192;
                    closeable2 = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                    object = null;
                    try {
                        BufferedReader p0 = (BufferedReader)closeable2;
                        boolean bl2 = false;
                        object2 = TextStreamsKt.readText((Reader)p0);
                    }
                    catch (Throwable throwable2) {
                        object = throwable2;
                        throw throwable2;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object);
                    }
                    Object content = object2;
                    StringBuilder errorLog = new StringBuilder();
                    BufferedImage bufferedImage = VdPreview.getPreviewFromVectorXml((VdPreview.TargetSize)VdPreview.TargetSize.createFromMaxDimension((int)16), (String)content, (StringBuilder)errorLog);
                    if (((CharSequence)errorLog).length() > 0) {
                        Logger.getInstance(ComposeMaterialIconLookupElement.class).error(errorLog.toString());
                    }
                    ImageIcon imageIcon2 = new ImageIcon(bufferedImage);
                    imageIcon = imageIcon2;
                }
                catch (Throwable throwable3) {
                    throwable = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
            imageIcon = null;
            return imageIcon;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

