/*
 * Decompiled with CFR 0.152.
 */
package com.google.gct.testrecorder.ui;

import com.android.ide.common.repository.GradleCoordinate;
import com.android.tools.analytics.UsageTracker;
import com.android.tools.idea.execution.common.AndroidExecutionTarget;
import com.android.tools.idea.execution.common.UtilsKt;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.dsl.api.ext.GradlePropertyModel;
import com.android.tools.idea.projectsystem.AndroidModuleSystem;
import com.android.tools.idea.projectsystem.GoogleMavenArtifactId;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.run.deployment.DeviceAndSnapshotComboBoxAction;
import com.android.tools.idea.stats.UsageTrackerUtils;
import com.google.common.collect.Lists;
import com.google.gct.testrecorder.debugger.SessionInitializer;
import com.google.gct.testrecorder.run.TestRecorderRunConfigurationProxy;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunManager;
import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultDebugExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentBuilder;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.IconLoader;
import com.intellij.ui.popup.list.ListPopupImpl;
import icons.StudioIcons;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Icon;
import org.apache.commons.lang.StringUtils;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;

public class TestRecorderAction
extends AnAction {
    private static final String ENABLE_ROBO_SCRIPT_RECORDING_FLAG = "enable.robo.script.recording";
    private static final String RECORD_TEST_ACTION_TEXT = "Record Espresso Test";
    public static final Icon TEST_RECORDER_ICON = StudioIcons.Test.RECORD_ESPRESSO_TEST;
    public static final Icon SCRIPT_RECORDER_ICON = IconLoader.getIcon((String)"robo_dot.png", TestRecorderAction.class);

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        if (this.isRecordingTestAction(presentation)) {
            presentation.setIcon(TEST_RECORDER_ICON);
        } else {
            presentation.setIcon(SCRIPT_RECORDER_ICON);
            presentation.setVisible(Boolean.getBoolean(ENABLE_ROBO_SCRIPT_RECORDING_FLAG));
        }
        Project project = event.getProject();
        if (project == null || !project.isInitialized() || project.isDisposed() || DumbService.getInstance((Project)project).isDumb()) {
            presentation.setEnabled(false);
            return;
        }
        DeviceAndSnapshotComboBoxAction deviceAndSnapshotComboBoxAction = (DeviceAndSnapshotComboBoxAction)ActionManager.getInstance().getAction("DeviceAndSnapshotComboBox");
        if (deviceAndSnapshotComboBoxAction.isMultipleTargetsSelectedInComboBox(project) && deviceAndSnapshotComboBoxAction.getNumberOfSelectedDevices(project) > 1) {
            presentation.setEnabled(false);
            return;
        }
        presentation.setEnabled(true);
    }

    public void actionPerformed(AnActionEvent event) {
        Project project = event.getProject();
        if (project == null || project.isDisposed()) {
            return;
        }
        UsageTracker.log((AndroidStudioEvent.Builder)UsageTrackerUtils.withProjectId((AndroidStudioEvent.Builder)AndroidStudioEvent.newBuilder().setCategory(AndroidStudioEvent.EventCategory.TEST_RECORDER).setKind(AndroidStudioEvent.EventKind.TEST_RECORDER_LAUNCH), (Project)project));
        TestRecorderAction.launchTestRecorder(project, this.isRecordingTestAction(event.getPresentation()));
    }

    public static void launchTestRecorder(final Project project, final boolean isRecordingTest) {
        List<RunConfiguration> suitableRunConfigurations = TestRecorderAction.getSuitableRunConfigurations(project);
        if (suitableRunConfigurations.isEmpty()) {
            String message = "Please create an Android Application or Blaze Command Run configuration with a valid module and Default or Specified launch activity.";
            Messages.showDialog((Project)project, (String)message, (String)"No suitable run configuration found", (String[])new String[]{"OK"}, (int)0, null);
            return;
        }
        if (suitableRunConfigurations.size() == 1) {
            TestRecorderAction.launchTestRecorderOnConfiguration(project, suitableRunConfigurations.get(0), isRecordingTest);
        } else {
            RunnerAndConfigurationSettings selectedConfiguration = RunManagerEx.getInstanceEx((Project)project).getSelectedConfiguration();
            if (selectedConfiguration != null && suitableRunConfigurations.contains(selectedConfiguration.getConfiguration())) {
                TestRecorderAction.launchTestRecorderOnConfiguration(project, selectedConfiguration.getConfiguration(), isRecordingTest);
            } else {
                ListPopupImpl configurationPickerPopup = new ListPopupImpl((ListPopupStep)new BaseListPopupStep<RunConfiguration>("Pick configuration to launch", suitableRunConfigurations){

                    @NotNull
                    public String getTextFor(RunConfiguration runConfiguration) {
                        return runConfiguration.getName();
                    }

                    public PopupStep onChosen(RunConfiguration runConfiguration, boolean finalChoice) {
                        return this.doFinalStep(() -> TestRecorderAction.launchTestRecorderOnConfiguration(project, runConfiguration, isRecordingTest));
                    }
                });
                configurationPickerPopup.showCenteredInCurrentWindow(project);
            }
        }
    }

    private static void launchTestRecorderOnConfiguration(Project project, RunConfiguration configurationBase, boolean isRecordingTest) {
        try {
            TestRecorderAction.attemptLaunchTestRecorderOnConfiguration(project, configurationBase, isRecordingTest);
        }
        catch (ExecutionException e) {
            String message = StringUtils.isEmpty((String)e.getMessage()) ? "Unknown error" : e.getMessage();
            Messages.showDialog((Project)project, (String)message, (String)"Could not launch Espresso Test Recorder", (String[])new String[]{"OK"}, (int)0, null);
        }
    }

    private static void attemptLaunchTestRecorderOnConfiguration(Project project, RunConfiguration configurationBase, boolean isRecordingTest) throws ExecutionException {
        TestRecorderRunConfigurationProxy testRecorderConfigurationProxy = TestRecorderRunConfigurationProxy.getInstance(configurationBase);
        if (testRecorderConfigurationProxy == null) {
            throw new RuntimeException("Could not obtain an instance of TestRecorderRunConfigurationProxy");
        }
        Module module = testRecorderConfigurationProxy.getModule();
        if (GradleBuildModel.get((Module)module).android().externalNativeBuild().cmake().version().getValueType() != GradlePropertyModel.ValueType.NONE) {
            String message = "Espresso Test Recorder does not support projects with native C++ code.";
            Messages.showDialog((Project)project, (String)message, (String)"Espresso test cannot be recorded", (String[])new String[]{"OK"}, (int)0, null);
            return;
        }
        AndroidModuleSystem moduleSystem = ProjectSystemUtil.getModuleSystem((Module)module);
        for (GoogleMavenArtifactId artifactId : GoogleMavenArtifactId.values()) {
            GradleCoordinate coordinate;
            if (!artifactId.getMavenGroupId().startsWith("androidx.compose.") || (coordinate = moduleSystem.getResolvedDependency(artifactId.getCoordinate("+"))) == null) continue;
            String message = "Espresso Testing Framework does not support Compose projects.";
            Messages.showDialog((Project)project, (String)message, (String)"Espresso test cannot be recorded", (String[])new String[]{"OK"}, (int)0, null);
            return;
        }
        RunnerAndConfigurationSettings settings = RunManager.getInstance((Project)project).findSettings(configurationBase);
        if (settings == null) {
            throw new RuntimeException("Could not find runner and configuration settings");
        }
        ExecutionEnvironmentBuilder builder = ExecutionEnvironmentBuilder.createOrNull((Executor)DefaultDebugExecutor.getDebugExecutorInstance(), (RunnerAndConfigurationSettings)settings);
        if (builder == null) {
            throw new RuntimeException("Could not create execution environment builder");
        }
        ExecutionEnvironment environment = builder.build();
        AndroidFacet facet = AndroidFacet.getInstance((Module)module);
        if (facet == null) {
            throw new RuntimeException("Could not obtain Android facet for module: " + module.getName());
        }
        ExecutionTarget selectedExecutionTarget = ExecutionTargetManager.getActiveTarget((Project)project);
        if (selectedExecutionTarget instanceof AndroidExecutionTarget) {
            List runningDevices = ((AndroidExecutionTarget)selectedExecutionTarget).getRunningDevices().stream().toList();
            List runningProcessHandlers = UtilsKt.getProcessHandlersForDevices((RunnerAndConfigurationSettings)settings, (Project)project, runningDevices);
            runningProcessHandlers.forEach(ProcessHandler::destroyProcess);
        }
        SessionInitializer sessionInitializer = new SessionInitializer(facet, environment, testRecorderConfigurationProxy, configurationBase, isRecordingTest);
        environment.getRunner().execute(environment, descriptor -> ApplicationManager.getApplication().executeOnPooledThread((Runnable)sessionInitializer));
    }

    public static List<RunConfiguration> getSuitableRunConfigurations(Project project) {
        LinkedList suitableRunConfigurations = Lists.newLinkedList();
        for (RunConfiguration runConfiguration : RunManagerEx.getInstanceEx((Project)project).getAllConfigurationsList()) {
            TestRecorderRunConfigurationProxy runConfigurationProxy = TestRecorderRunConfigurationProxy.getInstance(runConfiguration);
            if (runConfigurationProxy == null || runConfigurationProxy.getModule() == null || !runConfigurationProxy.isLaunchActivitySupported()) continue;
            suitableRunConfigurations.add(runConfiguration);
        }
        return suitableRunConfigurations;
    }

    private boolean isRecordingTestAction(Presentation presentation) {
        return RECORD_TEST_ACTION_TEXT.equals(presentation.getText());
    }
}

