/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.tools.memory.usage.LightweightHeapTraverse;
import com.android.tools.memory.usage.LightweightHeapTraverseConfig;
import com.android.tools.memory.usage.LightweightTraverseResult;
import com.intellij.util.MemoryDumpHelper;
import java.io.File;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import kotlin.ExceptionsKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u0006\u001a\u0016\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0003\u001a\u0010\u0010\b\u001a\n \t*\u0004\u0018\u00010\u00030\u0003H\u0002\u00a8\u0006\n"}, d2={"analyzeCurrentProcessHeap", "", "outputPath", "", "name", "lightweightMode", "", "captureSnapshot", "getTimestamp", "kotlin.jvm.PlatformType", "intellij.android.projectSystem.gradle.sync"})
@SourceDebugExtension(value={"SMAP\nMemorySnapshotHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MemorySnapshotHelper.kt\ncom/android/tools/idea/gradle/project/sync/MemorySnapshotHelperKt\n+ 2 Timing.kt\nkotlin/system/TimingKt\n*L\n1#1,66:1\n17#2,6:67\n17#2,6:73\n*S KotlinDebug\n*F\n+ 1 MemorySnapshotHelper.kt\ncom/android/tools/idea/gradle/project/sync/MemorySnapshotHelperKt\n*L\n32#1:67,6\n45#1:73,6\n*E\n"})
public final class MemorySnapshotHelperKt {
    public static final void captureSnapshot(@NotNull String outputPath, @NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        try {
            File file = FilesKt.resolve((File)new File(outputPath), (String)(MemorySnapshotHelperKt.getTimestamp() + '-' + name + ".hprof"));
            System.out.println((Object)("Capturing memory snapshot at: " + file.getAbsolutePath()));
            boolean $i$f$measureTimeMillis = false;
            long start$iv = System.currentTimeMillis();
            boolean bl = false;
            MemoryDumpHelper.captureMemoryDump((String)file.getAbsolutePath());
            long elapsedTime = System.currentTimeMillis() - start$iv;
            System.out.println((Object)("Done in " + elapsedTime));
        }
        catch (Exception e) {
            System.out.println((Object)("Error capturing snapshot:  " + ExceptionsKt.stackTraceToString((Throwable)e)));
        }
    }

    public static final void analyzeCurrentProcessHeap(@NotNull String outputPath, @NotNull String name, boolean lightweightMode) {
        Intrinsics.checkNotNullParameter((Object)outputPath, (String)"outputPath");
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        boolean collectReachableObjectsInfo = !lightweightMode;
        System.out.println((Object)("Starting heap traversal for " + name));
        LightweightTraverseResult result = null;
        boolean $i$f$measureTimeMillis = false;
        long start$iv = System.currentTimeMillis();
        boolean bl = false;
        result = LightweightHeapTraverse.collectReport((LightweightHeapTraverseConfig)new LightweightHeapTraverseConfig(false, collectReachableObjectsInfo, true));
        long elapsedTime = System.currentTimeMillis() - start$iv;
        System.out.println((Object)("Heap traversal for " + name + " finished in " + elapsedTime + " milliseconds"));
        if (collectReachableObjectsInfo) {
            StringBuilder stringBuilder = new StringBuilder().append("Heap ").append(name).append(" total size MBs: ");
            LightweightTraverseResult lightweightTraverseResult = result;
            Intrinsics.checkNotNull((Object)lightweightTraverseResult);
            System.out.println((Object)stringBuilder.append(lightweightTraverseResult.getTotalReachableObjectsSizeBytes() >> 20).append(' ').toString());
            System.out.println((Object)("Heap " + name + " total object count: " + result.getTotalReachableObjectsNumber() + ' '));
            File fileTotal = FilesKt.resolve((File)new File(outputPath), (String)(MemorySnapshotHelperKt.getTimestamp() + '_' + name + "_total"));
            FilesKt.writeText$default((File)fileTotal, (String)String.valueOf(result.getTotalReachableObjectsSizeBytes()), null, (int)2, null);
        }
        StringBuilder stringBuilder = new StringBuilder().append("Heap ").append(name).append(" strong size MBs: ");
        LightweightTraverseResult lightweightTraverseResult = result;
        Intrinsics.checkNotNull((Object)lightweightTraverseResult);
        System.out.println((Object)stringBuilder.append(lightweightTraverseResult.getTotalStrongReferencedObjectsSizeBytes() >> 20).append(' ').toString());
        System.out.println((Object)("Heap " + name + " strong object count: " + result.getTotalStrongReferencedObjectsNumber() + ' '));
        File fileStrong = FilesKt.resolve((File)new File(outputPath), (String)(MemorySnapshotHelperKt.getTimestamp() + '_' + name + "_strong"));
        FilesKt.writeText$default((File)fileStrong, (String)String.valueOf(result.getTotalStrongReferencedObjectsSizeBytes()), null, (int)2, null);
    }

    private static final String getTimestamp() {
        return DateTimeFormatter.ofPattern("yyyy.MM.dd-HH:mm").withZone(ZoneOffset.UTC).format(Instant.now());
    }
}

