/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.project.sync;

import com.android.Version;
import com.android.ide.common.repository.AgpVersion;
import com.android.tools.idea.gradle.project.sync.AndroidSyncException;
import java.util.List;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00052\u00020\u0001:\u0001\u0005B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/gradle/project/sync/AgpVersionIncompatible;", "Lcom/android/tools/idea/gradle/project/sync/AndroidSyncException;", "agpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "(Lcom/android/ide/common/repository/AgpVersion;)V", "Companion", "intellij.android.projectSystem.gradle.sync"})
public final class AgpVersionIncompatible
extends AndroidSyncException {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String A = "The project is using an incompatible preview version (AGP ";
    @NotNull
    private static final String B = ") of the Android Gradle plugin. Current compatible ";
    @NotNull
    private static final String PREVIEW = "preview ";
    @NotNull
    private static final String C = "version is AGP " + Version.ANDROID_GRADLE_PLUGIN_VERSION + '.';
    @NotNull
    private static final Pattern PATTERN;
    @NotNull
    private static final List<String> ALWAYS_PRESENT_STRINGS;

    public AgpVersionIncompatible(@NotNull AgpVersion agpVersion) {
        Intrinsics.checkNotNullParameter((Object)agpVersion, (String)"agpVersion");
        super(AgpVersionIncompatible.Companion.generateMessage(agpVersion), null, null, null, 14, null);
    }

    static {
        String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
        AgpVersion latestKnown = AgpVersion.Companion.parse(string);
        boolean bl = false;
        Pattern pattern = Pattern.compile(Pattern.quote(A) + "(.+)" + Pattern.quote(B) + (latestKnown.isPreview() ? Pattern.quote(PREVIEW) : "") + Pattern.quote(C));
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"AgpVersion.parse(ANDROID\u2026Pattern.quote(C)}\")\n    }");
        PATTERN = pattern;
        Object[] objectArray = new String[]{A, B, C};
        ALWAYS_PRESENT_STRINGS = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/gradle/project/sync/AgpVersionIncompatible$Companion;", "", "()V", "A", "", "ALWAYS_PRESENT_STRINGS", "", "getALWAYS_PRESENT_STRINGS", "()Ljava/util/List;", "B", "C", "PATTERN", "Ljava/util/regex/Pattern;", "getPATTERN", "()Ljava/util/regex/Pattern;", "PREVIEW", "generateMessage", "agpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "intellij.android.projectSystem.gradle.sync"})
    public static final class Companion {
        private Companion() {
        }

        private final String generateMessage(AgpVersion agpVersion) {
            String string = Version.ANDROID_GRADLE_PLUGIN_VERSION;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ANDROID_GRADLE_PLUGIN_VERSION");
            AgpVersion latestKnown = AgpVersion.Companion.parse(string);
            return AgpVersionIncompatible.A + agpVersion + AgpVersionIncompatible.B + (latestKnown.isPreview() ? AgpVersionIncompatible.PREVIEW : "") + C;
        }

        @NotNull
        public final Pattern getPATTERN() {
            return PATTERN;
        }

        @NotNull
        public final List<String> getALWAYS_PRESENT_STRINGS() {
            return ALWAYS_PRESENT_STRINGS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

