/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.scripts.rml.ast.Expr;
import com.jetbrains.sourceglider.scripts.rml.ast.ExprConst;
import com.jetbrains.sourceglider.scripts.rml.ast.ExprRelSize;
import com.jetbrains.sourceglider.scripts.rml.ast.ExprUnary;
import com.jetbrains.sourceglider.scripts.rml.ast.ExprVar;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExpr;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprAttributeRegexp;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprComparison;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprIf;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprSingleAttribute;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprUnary;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Expression;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.RelCondition;
import com.jetbrains.sourceglider.scripts.rml.parser.RelConst;
import com.jetbrains.sourceglider.scripts.rml.parser.RelQuantify;
import com.jetbrains.sourceglider.scripts.rml.parser.RelVar;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;

public class Factor
extends Nonterm {
    public Expr expr;
    public RelExpr relExpr;
    public int type;
    public Expression ifExpr;
    public Expression thenExpr;
    public Expression elseExpr;
    public RelQuantify quantify;
    public RelConst relConst;
    public RelCondition cond;
    public RelVar relvar;
    public Expression subexpr;
    public RelCondition rel;
    public Factor factor;
    private String relvarName;
    private String leftDomain;
    private boolean equ;

    public Factor(Context context) {
        super(context);
    }

    public void relvarName(TokenInfo token) {
        this.relvarName = token.getString();
    }

    public void relvar() {
        this.relvar.setLeft(this, this.relvarName);
    }

    public void cond() {
        this.cond.setLeft(this.relvarName);
    }

    public void relvarFin() {
        this.relExpr = this.relvar.relExpr;
        this.type = 0;
    }

    public void condFin() {
        this.expr = this.cond.expr;
        this.type = 2;
    }

    public void brackets() {
        this.expr = this.subexpr.expr;
        this.relExpr = this.subexpr.relExpr;
        this.type = this.subexpr.type;
    }

    public void equ(TokenInfo token) {
        this.equ = true;
    }

    public void unequ(TokenInfo token) {
        this.equ = false;
    }

    public void leftEqu(TokenInfo token) {
        this.leftDomain = token.getString();
        this.context.variablesManager.useDomain(this.leftDomain);
    }

    public void domainEqu(TokenInfo token) throws ParseException {
        String rightDomain = token.getString();
        this.context.variablesManager.useDomain(rightDomain);
        DomainType leftType = this.context.variablesManager.getDomain(this.leftDomain);
        DomainType rightType = this.context.variablesManager.getDomain(rightDomain);
        if (leftType == null) {
            this.context.variablesManager.addDomain(this.leftDomain, rightType);
        } else if (rightType == null) {
            this.context.variablesManager.addDomain(rightDomain, leftType);
        } else if (leftType != rightType) {
            throw new ParseException(token.location, Messages.getString(Factor.class.getName() + "-0") + this.leftDomain + Messages.getString(Factor.class.getName() + "-1") + rightDomain + Messages.getString(Factor.class.getName() + "-2"));
        }
        this.type = 0;
        this.relExpr = new RelExprComparison(this.leftDomain, rightDomain, null, this.context.variablesManager.getDomain(this.leftDomain), this.context.variablesManager.getDomain(rightDomain), null, this.equ ? RelExprComparison.BinOp.EQ : RelExprComparison.BinOp.NEQ, this.context, this);
    }

    public void attrEqu(TokenInfo token) {
        this.type = 0;
        this.relExpr = new RelExprSingleAttribute(this.leftDomain, this.context.variablesManager.getDomain(this.leftDomain), token.getString(), this.equ ? RelExprComparison.BinOp.EQ : RelExprComparison.BinOp.NEQ, this.context);
    }

    public void regexpEqu(TokenInfo token) {
        this.type = 0;
        this.relExpr = new RelExprAttributeRegexp(this.leftDomain, this.context.variablesManager.getDomain(this.leftDomain), token.getString(), this.equ, this.context);
    }

    public void closure() throws ParseException {
        if (this.subexpr.type != 0) {
            throw new ParseException(this.subexpr.location, Messages.getString(Factor.class.getName() + "-3"));
        }
        this.relExpr = new RelExprUnary(this.subexpr.relExpr, 1, this.context, this);
        this.type = 0;
    }

    public void minus() throws ParseException {
        if (this.factor.type != 1) {
            throw new ParseException(this.factor.location, Messages.getString(Factor.class.getName() + "-4"));
        }
        this.expr = new ExprUnary(0, this.factor.expr, this.context);
        this.type = 1;
    }

    public void not() throws ParseException {
        if (this.factor.type == 0) {
            this.relExpr = new RelExprUnary(this.factor.relExpr, 0, this.context, this);
            this.type = 0;
        } else if (this.factor.type == 2) {
            this.expr = new ExprUnary(1, this.factor.expr, this.context);
            this.type = 2;
        } else {
            throw new ParseException(this.factor.location, Messages.getString(Factor.class.getName() + "-5"));
        }
    }

    public void size() throws ParseException {
        if (this.factor.type != 0) {
            throw new ParseException(this.factor.location, Messages.getString(Factor.class.getName() + "-6"));
        }
        this.type = 1;
        this.expr = new ExprRelSize(this.factor.relExpr, this.context);
    }

    public void ifExpr() throws ParseException {
        if (this.thenExpr.type != 0) {
            throw new ParseException(this.thenExpr.location, Messages.getString(Factor.class.getName() + "-7"));
        }
        if (this.elseExpr.type != 0) {
            throw new ParseException(this.elseExpr.location, Messages.getString(Factor.class.getName() + "-8"));
        }
        this.type = 0;
        if (this.ifExpr.type == 0) {
            this.relExpr = new RelExprIf(this.ifExpr.relExpr, this.thenExpr.relExpr, this.elseExpr.relExpr, this.context);
        } else if (this.ifExpr.type == 2) {
            this.relExpr = new RelExprIf(this.ifExpr.expr, this.thenExpr.relExpr, this.elseExpr.relExpr, this.context);
        } else {
            throw new ParseException(this.ifExpr.location, Messages.getString(Factor.class.getName() + "-9"));
        }
    }

    public void relConst() {
        this.relExpr = this.relConst.relExpr;
        this.type = 0;
    }

    public void quantify() {
        this.relExpr = this.quantify.relExpr;
        this.type = 0;
    }

    public void number(TokenInfo token) {
        this.expr = new ExprConst(token.getValue(), this.context);
        this.type = 1;
    }

    public void numvar(TokenInfo token) {
        this.expr = new ExprVar(token.getString(), this.context);
        this.type = this.context.variablesManager.getVariableType(token.getString());
    }
}

