/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.parser;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprBinary;
import com.jetbrains.sourceglider.scripts.rml.ast.RelExprVar;
import com.jetbrains.sourceglider.scripts.rml.ast.Stmt;
import com.jetbrains.sourceglider.scripts.rml.ast.StmtRelAssign;
import com.jetbrains.sourceglider.scripts.rml.parser.Context;
import com.jetbrains.sourceglider.scripts.rml.parser.Expression;
import com.jetbrains.sourceglider.scripts.rml.parser.Nonterm;
import com.jetbrains.sourceglider.scripts.rml.parser.ParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.TokenInfo;
import com.jetbrains.sourceglider.ui.Messages;
import com.jetbrains.sourceglider.utils.ArrayHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ConsoleStatementAssign
extends Nonterm {
    public static final int ASSIGNMENT = 0;
    public static final int UNITE = 1;
    public Stmt stmt;
    private boolean wasRelvar;
    public Expression expr;
    private String name;
    private DomainType[] types;
    private List<String> domNames = new ArrayList<String>();
    private List<int[]> domLocs = new ArrayList<int[]>();
    private int domainIndex;
    private int opCode;

    public ConsoleStatementAssign(Context context) {
        super(context);
    }

    public void id(TokenInfo token) {
        this.name = token.getString();
    }

    public void relvar(TokenInfo token) {
        this.wasRelvar = true;
        this.name = token.getString();
        this.types = this.context.variablesManager.getRelation(this.name);
        this.domainIndex = 0;
    }

    public void domain(TokenInfo token) throws ParseException {
        if (this.types != null && this.domainIndex >= this.types.length) {
            throw new ParseException(token.location, Messages.getString(ConsoleStatementAssign.class.getName() + "-0"));
        }
        this.domNames.add(token.getString());
        this.domLocs.add(token.location);
        if (this.context.variablesManager.containsDomain(token.getString())) {
            throw new ParseException(token.location, Messages.getString(ConsoleStatementAssign.class.getName() + "-1"));
        }
        if (this.types != null) {
            this.context.variablesManager.addDomain(token.getString(), this.types[this.domainIndex++]);
        } else {
            this.context.variablesManager.addDomain(token.getString(), null);
        }
    }

    public void finish(TokenInfo token) throws ParseException {
        if (this.types != null && this.domainIndex < this.types.length) {
            throw new ParseException(token.location, Messages.getString(ConsoleStatementAssign.class.getName() + "-2"));
        }
    }

    public void assign(TokenInfo token) {
        if (this.wasRelvar) {
            this.context.variablesManager.setRelationUnused(this.name);
        }
        this.opCode = 0;
    }

    public void unite(TokenInfo token) {
        this.opCode = 1;
    }

    public void expr() throws ParseException {
        DomainType[] types = new DomainType[this.domNames.size()];
        for (int i = 0; i < this.domNames.size(); ++i) {
            String name = this.domNames.get(i);
            if (!this.context.variablesManager.wasDomainUsed(name)) {
                throw new ParseException(this.domLocs.get(i), Messages.getString(ConsoleStatementAssign.class.getName() + "-3") + name + Messages.getString(ConsoleStatementAssign.class.getName() + "-4"));
            }
            types[i] = this.context.variablesManager.getDomain(name);
            if (types[i] == null) {
                throw new ParseException(this.expr.location, Messages.getString(ConsoleStatementAssign.class.getName() + "-5") + name + "\"");
            }
            this.context.variablesManager.removeDomain(name);
        }
        this.context.variablesManager.addOutputRelation(new RelationSignature(this.name, types), new HashMap<String, String>());
        String[] names = ArrayHelper.castStringArray(this.domNames.toArray());
        if (this.opCode == 0) {
            this.stmt = new StmtRelAssign(this.name, names, this.expr.relExpr, this.context, this);
        } else if (this.opCode == 1) {
            this.stmt = new StmtRelAssign(this.name, names, new RelExprBinary(0, new RelExprVar(this.name, names, this.context), this.expr.relExpr, this.context, this), this.context, this);
        }
    }
}

