/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.sourceglider.scripts.rml.dsl.translator;

import com.jetbrains.sourceglider.domains.DomainType;
import com.jetbrains.sourceglider.relations.RelationSignature;
import com.jetbrains.sourceglider.scripts.rml.DomainTypeReference;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlDeclaration;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlDeclarationType;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlOption;
import com.jetbrains.sourceglider.scripts.rml.dsl.ast.RmlProgram;
import com.jetbrains.sourceglider.scripts.rml.dsl.translator.RmlParseException;
import com.jetbrains.sourceglider.scripts.rml.parser.VariablesManager;
import com.jetbrains.sourceglider.symtable.SymbolTable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010\r\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0011\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J*\u0010\u0007\u001a\u00020\b*\u00020\u00032\u0006\u0010\u0012\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u0014H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/sourceglider/scripts/rml/dsl/translator/VariableManagerInitializer;", "", "manager", "Lcom/jetbrains/sourceglider/scripts/rml/parser/VariablesManager;", "symbolTable", "Lcom/jetbrains/sourceglider/symtable/SymbolTable;", "(Lcom/jetbrains/sourceglider/scripts/rml/parser/VariablesManager;Lcom/jetbrains/sourceglider/symtable/SymbolTable;)V", "addDeclaration", "", "tempDecl", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/ast/RmlDeclaration;", "type", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/ast/RmlDeclarationType;", "initialize", "program", "Lcom/jetbrains/sourceglider/scripts/rml/dsl/ast/RmlProgram;", "processDeclarations", "processOptions", "decl", "domainTypes", "", "Lcom/jetbrains/sourceglider/domains/DomainType;", "intellij.c.dfa"})
public final class VariableManagerInitializer {
    @NotNull
    private final VariablesManager manager;
    @NotNull
    private final SymbolTable symbolTable;

    public VariableManagerInitializer(@NotNull VariablesManager manager2, @NotNull SymbolTable symbolTable) {
        this.manager = manager2;
        this.symbolTable = symbolTable;
    }

    public final void initialize(@NotNull RmlProgram program) {
        this.processDeclarations(program);
        this.processOptions(program);
    }

    private final void processOptions(RmlProgram program) {
        for (RmlOption option : program.getOptions()) {
            int type = switch (WhenMappings.$EnumSwitchMapping$0[option.getType().ordinal()]) {
                case 1 -> 1;
                case 2 -> 2;
                default -> throw new NoWhenBranchMatchedException();
            };
            this.manager.addOption(option.getName(), option.getDefaultValue(), type);
        }
    }

    private final void processDeclarations(RmlProgram program) {
        Iterable $this$forEach$iv = program.getInputDeclarations();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RmlDeclaration inputDecl = (RmlDeclaration)element$iv;
            boolean bl = false;
            List domainTypes = new ArrayList();
            Iterable $this$forEach$iv2 = inputDecl.getDomainNames();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String domainName = (String)element$iv2;
                boolean bl2 = false;
                if (!this.manager.containsDomainType(domainName)) {
                    DomainType type = DomainType.createGenericDomainType(domainName, this.symbolTable);
                    this.manager.addDomainType(domainName, type, new DomainTypeReference(inputDecl.getRelationName(), domainTypes.size()));
                    domainTypes.add(type);
                    continue;
                }
                domainTypes.add(this.manager.getDomainType(domainName));
            }
            this.addDeclaration(this.manager, inputDecl, RmlDeclarationType.INPUT, domainTypes);
        }
        $this$forEach$iv = program.getOutputDeclarations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RmlDeclaration outputDecl = (RmlDeclaration)element$iv;
            boolean bl = false;
            this.addDeclaration(outputDecl, RmlDeclarationType.OUTPUT);
        }
        $this$forEach$iv = program.getTempDeclarations();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            RmlDeclaration tempDecl = (RmlDeclaration)element$iv;
            boolean bl = false;
            this.addDeclaration(tempDecl, RmlDeclarationType.TEMP);
        }
    }

    private final void addDeclaration(RmlDeclaration tempDecl, RmlDeclarationType type) {
        List domainTypes = new ArrayList();
        Iterable $this$forEach$iv = tempDecl.getDomainNames();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            DomainType domainType;
            String domainName = (String)element$iv;
            boolean bl = false;
            if (this.manager.getDomainType(domainName) == null) {
                throw new RmlParseException("Domain type " + domainName + " must be present in the input relations");
            }
            domainTypes.add(domainType);
        }
        this.addDeclaration(this.manager, tempDecl, type, domainTypes);
    }

    private final void addDeclaration(VariablesManager $this$addDeclaration, RmlDeclaration decl, RmlDeclarationType type, List<? extends DomainType> domainTypes) {
        if ($this$addDeclaration.containsRelation(decl.getRelationName())) {
            throw new RmlParseException("Redeclared " + type + " relation " + decl.getRelationName());
        }
        switch (WhenMappings.$EnumSwitchMapping$1[type.ordinal()]) {
            case 1: {
                Collection $this$toTypedArray$iv = domainTypes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$addDeclaration.addInputRelation(new RelationSignature(decl.getRelationName(), thisCollection$iv.toArray(new DomainType[0])));
                break;
            }
            case 2: {
                Pair[] $i$f$toTypedArray = new Pair[]{new Pair((Object)"location", (Object)"/Default")};
                HashMap metaInfo = MapsKt.hashMapOf((Pair[])$i$f$toTypedArray);
                Collection $this$toTypedArray$iv = domainTypes;
                boolean $i$f$toTypedArray2 = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$addDeclaration.addOutputRelation(new RelationSignature(decl.getRelationName(), thisCollection$iv.toArray(new DomainType[0])), metaInfo);
                break;
            }
            case 3: {
                Collection $this$toTypedArray$iv = domainTypes;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                $this$addDeclaration.addTempRelation(new RelationSignature(decl.getRelationName(), thisCollection$iv.toArray(new DomainType[0])));
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[RmlOption.Type.values().length];
            try {
                nArray[RmlOption.Type.INT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlOption.Type.BOOLEAN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[RmlDeclarationType.values().length];
            try {
                nArray[RmlDeclarationType.INPUT.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlDeclarationType.OUTPUT.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[RmlDeclarationType.TEMP.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

